/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util.convert;

import com.cedarsoftware.util.CaseInsensitiveSet;
import com.cedarsoftware.util.CompactSet;
import com.cedarsoftware.util.ConcurrentNavigableSetNullSafe;
import com.cedarsoftware.util.ConcurrentSet;
import com.cedarsoftware.util.convert.CollectionsWrappers;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Set;
import java.util.SortedSet;
import java.util.Stack;
import java.util.TreeSet;
import java.util.Vector;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.function.Function;

final class CollectionHandling {
    private static final Map<Class<?>, CollectionFactory> SPECIAL_HANDLERS = new LinkedHashMap();
    private static final Map<Class<?>, Function<Integer, Collection<?>>> BASE_FACTORIES = new LinkedHashMap();
    private static final Map<Class<?>, Function<Integer, Collection<?>>> FACTORY_CACHE = new ConcurrentHashMap();

    private CollectionHandling() {
    }

    private static void initializeSpecialHandlers() {
        SPECIAL_HANDLERS.put(CollectionsWrappers.getEmptyNavigableSetClass(), (size, source) -> Collections.emptyNavigableSet());
        SPECIAL_HANDLERS.put(CollectionsWrappers.getEmptySortedSetClass(), (size, source) -> Collections.emptySortedSet());
        SPECIAL_HANDLERS.put(CollectionsWrappers.getEmptySetClass(), (size, source) -> Collections.emptySet());
        SPECIAL_HANDLERS.put(CollectionsWrappers.getEmptyListClass(), (size, source) -> Collections.emptyList());
        SPECIAL_HANDLERS.put(CollectionsWrappers.getEmptyCollectionClass(), (size, source) -> Collections.emptyList());
        SPECIAL_HANDLERS.put(CollectionsWrappers.getUnmodifiableNavigableSetClass(), (size, source) -> CollectionHandling.createOptimalNavigableSet(source, size));
        SPECIAL_HANDLERS.put(CollectionsWrappers.getUnmodifiableSortedSetClass(), (size, source) -> CollectionHandling.createOptimalSortedSet(source, size));
        SPECIAL_HANDLERS.put(CollectionsWrappers.getUnmodifiableSetClass(), (size, source) -> CollectionHandling.createOptimalSet(source, size));
        SPECIAL_HANDLERS.put(CollectionsWrappers.getUnmodifiableListClass(), (size, source) -> CollectionHandling.createOptimalList(source, size));
        SPECIAL_HANDLERS.put(CollectionsWrappers.getUnmodifiableCollectionClass(), (size, source) -> CollectionHandling.createOptimalCollection(source, size));
        SPECIAL_HANDLERS.put(CollectionsWrappers.getSynchronizedNavigableSetClass(), (size, source) -> Collections.synchronizedNavigableSet(CollectionHandling.createOptimalNavigableSet(source, size)));
        SPECIAL_HANDLERS.put(CollectionsWrappers.getSynchronizedSortedSetClass(), (size, source) -> Collections.synchronizedSortedSet(CollectionHandling.createOptimalSortedSet(source, size)));
        SPECIAL_HANDLERS.put(CollectionsWrappers.getSynchronizedSetClass(), (size, source) -> Collections.synchronizedSet(CollectionHandling.createOptimalSet(source, size)));
        SPECIAL_HANDLERS.put(CollectionsWrappers.getSynchronizedListClass(), (size, source) -> Collections.synchronizedList(CollectionHandling.createOptimalList(source, size)));
        SPECIAL_HANDLERS.put(CollectionsWrappers.getSynchronizedCollectionClass(), (size, source) -> Collections.synchronizedCollection(CollectionHandling.createOptimalCollection(source, size)));
        SPECIAL_HANDLERS.put(CollectionsWrappers.getCheckedNavigableSetClass(), (size, source) -> {
            NavigableSet<?> navigableSet = CollectionHandling.createOptimalNavigableSet(source, size);
            Class<?> elementType = CollectionHandling.getElementTypeFromSource(source);
            return Collections.checkedNavigableSet(navigableSet, elementType);
        });
        SPECIAL_HANDLERS.put(CollectionsWrappers.getCheckedSortedSetClass(), (size, source) -> {
            SortedSet<?> sortedSet = CollectionHandling.createOptimalSortedSet(source, size);
            Class<?> elementType = CollectionHandling.getElementTypeFromSource(source);
            return Collections.checkedSortedSet(sortedSet, elementType);
        });
        SPECIAL_HANDLERS.put(CollectionsWrappers.getCheckedSetClass(), (size, source) -> {
            Set<?> set = CollectionHandling.createOptimalSet(source, size);
            Class<?> elementType = CollectionHandling.getElementTypeFromSource(source);
            return Collections.checkedSet(set, elementType);
        });
        SPECIAL_HANDLERS.put(CollectionsWrappers.getCheckedListClass(), (size, source) -> {
            List<?> list = CollectionHandling.createOptimalList(source, size);
            Class<?> elementType = CollectionHandling.getElementTypeFromSource(source);
            return Collections.checkedList(list, elementType);
        });
        SPECIAL_HANDLERS.put(CollectionsWrappers.getCheckedCollectionClass(), (size, source) -> {
            Collection<?> collection = CollectionHandling.createOptimalCollection(source, size);
            Class<?> elementType = CollectionHandling.getElementTypeFromSource(source);
            return Collections.checkedCollection(collection, elementType);
        });
    }

    private static void initializeBaseFactories() {
        BASE_FACTORIES.put(CaseInsensitiveSet.class, size -> new CaseInsensitiveSet());
        BASE_FACTORIES.put(ConcurrentNavigableSetNullSafe.class, size -> new ConcurrentNavigableSetNullSafe());
        BASE_FACTORIES.put(ConcurrentSet.class, size -> new ConcurrentSet());
        BASE_FACTORIES.put(CompactSet.class, size -> new CompactSet());
        BASE_FACTORIES.put(ConcurrentSkipListSet.class, size -> new ConcurrentSkipListSet());
        BASE_FACTORIES.put(CopyOnWriteArraySet.class, size -> new CopyOnWriteArraySet());
        BASE_FACTORIES.put(ConcurrentLinkedQueue.class, size -> new ConcurrentLinkedQueue());
        BASE_FACTORIES.put(ConcurrentLinkedDeque.class, size -> new ConcurrentLinkedDeque());
        BASE_FACTORIES.put(CopyOnWriteArrayList.class, size -> new CopyOnWriteArrayList());
        BASE_FACTORIES.put(LinkedBlockingDeque.class, size -> new LinkedBlockingDeque((int)size));
        BASE_FACTORIES.put(ArrayBlockingQueue.class, size -> new ArrayBlockingQueue((int)size));
        BASE_FACTORIES.put(LinkedBlockingQueue.class, size -> new LinkedBlockingQueue((int)size));
        BASE_FACTORIES.put(PriorityBlockingQueue.class, size -> new PriorityBlockingQueue((int)size));
        BASE_FACTORIES.put(LinkedTransferQueue.class, size -> new LinkedTransferQueue());
        BASE_FACTORIES.put(SynchronousQueue.class, size -> new SynchronousQueue());
        BASE_FACTORIES.put(DelayQueue.class, size -> new DelayQueue());
        BASE_FACTORIES.put(ArrayDeque.class, size -> new ArrayDeque((int)size));
        BASE_FACTORIES.put(LinkedList.class, size -> new LinkedList());
        BASE_FACTORIES.put(PriorityQueue.class, size -> new PriorityQueue((int)size));
        BASE_FACTORIES.put(TreeSet.class, size -> new TreeSet());
        BASE_FACTORIES.put(LinkedHashSet.class, size -> new LinkedHashSet((int)size));
        BASE_FACTORIES.put(HashSet.class, size -> new HashSet((int)size));
        BASE_FACTORIES.put(ArrayList.class, size -> new ArrayList((int)size));
        BASE_FACTORIES.put(Stack.class, size -> new Stack());
        BASE_FACTORIES.put(Vector.class, size -> new Vector((int)size));
        BASE_FACTORIES.put(BlockingDeque.class, size -> new LinkedBlockingDeque((int)size));
        BASE_FACTORIES.put(BlockingQueue.class, size -> new LinkedBlockingQueue((int)size));
        BASE_FACTORIES.put(Deque.class, size -> new ArrayDeque((int)size));
        BASE_FACTORIES.put(Queue.class, size -> new LinkedList());
        BASE_FACTORIES.put(NavigableSet.class, size -> new TreeSet());
        BASE_FACTORIES.put(SortedSet.class, size -> new TreeSet());
        BASE_FACTORIES.put(Set.class, size -> new LinkedHashSet(Math.max(size, 16)));
        BASE_FACTORIES.put(List.class, size -> new ArrayList((int)size));
        BASE_FACTORIES.put(Collection.class, size -> new ArrayList((int)size));
    }

    private static void validateMappings() {
        CollectionHandling.validateMapOrder(BASE_FACTORIES);
        CollectionHandling.validateMapOrder(SPECIAL_HANDLERS);
    }

    private static void validateMapOrder(Map<Class<?>, ?> map) {
        ArrayList interfaces = new ArrayList(map.keySet());
        int len = interfaces.size();
        for (int i = 0; i < len; ++i) {
            Class current = (Class)interfaces.get(i);
            for (int j = i + 1; j < len; ++j) {
                Class next = (Class)interfaces.get(j);
                if (current == next || !current.isAssignableFrom(next)) continue;
                throw new IllegalStateException("Mapping order error: " + next.getName() + " should come before " + current.getName());
            }
        }
    }

    static Collection<?> createCollection(Object source, Class<?> targetType) {
        CollectionFactory specialFactory = CollectionHandling.getSpecialCollectionFactory(targetType);
        if (specialFactory != null) {
            return specialFactory.create(CollectionHandling.sizeOrDefault(source), source);
        }
        Function<Integer, Collection<?>> baseFactory = CollectionHandling.getBaseCollectionFactory(targetType);
        return baseFactory.apply(CollectionHandling.sizeOrDefault(source));
    }

    private static CollectionFactory getSpecialCollectionFactory(Class<?> targetType) {
        for (Map.Entry<Class<?>, CollectionFactory> entry : SPECIAL_HANDLERS.entrySet()) {
            if (!entry.getKey().isAssignableFrom(targetType)) continue;
            return entry.getValue();
        }
        return null;
    }

    private static Function<Integer, Collection<?>> getBaseCollectionFactory(Class<?> targetType) {
        Function factory = FACTORY_CACHE.get(targetType);
        if (factory == null) {
            factory = FACTORY_CACHE.computeIfAbsent(targetType, type -> {
                for (Map.Entry<Class<?>, Function<Integer, Collection<?>>> entry : BASE_FACTORIES.entrySet()) {
                    if (!entry.getKey().isAssignableFrom((Class<?>)type)) continue;
                    return entry.getValue();
                }
                return ArrayList::new;
            });
        }
        return factory;
    }

    private static NavigableSet<?> createOptimalNavigableSet(Object source, int size) {
        if (source instanceof ConcurrentNavigableSetNullSafe) {
            return new ConcurrentNavigableSetNullSafe();
        }
        if (source instanceof ConcurrentSkipListSet) {
            return new ConcurrentSkipListSet();
        }
        return new TreeSet();
    }

    private static SortedSet<?> createOptimalSortedSet(Object source, int size) {
        if (source instanceof ConcurrentNavigableSetNullSafe) {
            return new ConcurrentNavigableSetNullSafe();
        }
        if (source instanceof ConcurrentSkipListSet) {
            return new ConcurrentSkipListSet();
        }
        return new TreeSet();
    }

    private static Set<?> createOptimalSet(Object source, int size) {
        if (source instanceof CaseInsensitiveSet) {
            return new CaseInsensitiveSet();
        }
        if (source instanceof CompactSet) {
            return new CompactSet();
        }
        if (source instanceof ConcurrentSet) {
            return new ConcurrentSet();
        }
        if (source instanceof LinkedHashSet) {
            return new LinkedHashSet(size);
        }
        return new LinkedHashSet(Math.max(size, 16));
    }

    private static List<?> createOptimalList(Object source, int size) {
        if (source instanceof CopyOnWriteArrayList) {
            return new CopyOnWriteArrayList();
        }
        if (source instanceof Vector) {
            return new Vector(size);
        }
        if (source instanceof LinkedList) {
            return new LinkedList();
        }
        return new ArrayList(size);
    }

    private static Collection<?> createOptimalCollection(Object source, int size) {
        if (source instanceof Set) {
            return CollectionHandling.createOptimalSet(source, size);
        }
        if (source instanceof List) {
            return CollectionHandling.createOptimalList(source, size);
        }
        return new ArrayList(size);
    }

    private static int sizeOrDefault(Object source) {
        return source instanceof Collection ? ((Collection)source).size() : 16;
    }

    private static Class<?> getElementTypeFromSource(Object source) {
        if (source instanceof Collection) {
            for (Object element : (Collection)source) {
                if (element == null) continue;
                return element.getClass();
            }
        }
        return Object.class;
    }

    static {
        CollectionHandling.initializeSpecialHandlers();
        CollectionHandling.initializeBaseFactories();
        CollectionHandling.validateMappings();
    }

    @FunctionalInterface
    static interface CollectionFactory {
        public Collection<?> create(int var1, Object var2);
    }
}

