/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.database.connector.core.metadata.database.enums;

import com.google.common.base.Strings;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;

public enum QuoteCharacter {
    BACK_QUOTE("`", "`"),
    SINGLE_QUOTE("'", "'"),
    QUOTE("\"", "\""),
    BRACKETS("[", "]"),
    PARENTHESES("(", ")"),
    NONE("", "");

    private static final Map<Character, QuoteCharacter> BY_FIRST_CHAR;
    private final String startDelimiter;
    private final String endDelimiter;

    public static QuoteCharacter getQuoteCharacter(String value) {
        return Strings.isNullOrEmpty((String)value) ? NONE : BY_FIRST_CHAR.getOrDefault(Character.valueOf(value.charAt(0)), NONE);
    }

    public String wrap(String value) {
        return this.startDelimiter + value + this.endDelimiter;
    }

    public String unwrap(String value) {
        return this.isWrapped(value) ? value.substring(this.startDelimiter.length(), value.length() - this.endDelimiter.length()) : value;
    }

    public boolean isWrapped(String value) {
        return value.startsWith(this.startDelimiter) && value.endsWith(this.endDelimiter);
    }

    public static String unwrapText(String text) {
        return QuoteCharacter.getQuoteCharacter(text).unwrap(text);
    }

    public static String unwrapAndTrimText(String text) {
        return QuoteCharacter.unwrapText(text).trim();
    }

    @Generated
    private QuoteCharacter(String startDelimiter, String endDelimiter) {
        this.startDelimiter = startDelimiter;
        this.endDelimiter = endDelimiter;
    }

    @Generated
    public String getStartDelimiter() {
        return this.startDelimiter;
    }

    @Generated
    public String getEndDelimiter() {
        return this.endDelimiter;
    }

    static {
        BY_FIRST_CHAR = new HashMap<Character, QuoteCharacter>(QuoteCharacter.values().length - 1, 1.0f);
        for (QuoteCharacter each : QuoteCharacter.values()) {
            if (NONE == each) continue;
            BY_FIRST_CHAR.put(Character.valueOf(each.startDelimiter.charAt(0)), each);
        }
    }
}

