/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.rewrite.parameter.builder.impl;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.infra.rewrite.parameter.builder.ParameterBuilder;
import org.apache.shardingsphere.infra.rewrite.parameter.builder.impl.StandardParameterBuilder;

public final class GroupedParameterBuilder
implements ParameterBuilder {
    private final List<StandardParameterBuilder> parameterBuilders;
    private final StandardParameterBuilder beforeGenericParameterBuilder;
    private final StandardParameterBuilder afterGenericParameterBuilder;
    private String derivedColumnName;
    private boolean containsGroupedParams;
    private int afterGenericParameterOffset;

    public GroupedParameterBuilder(List<List<Object>> groupedParams, List<Object> beforeGenericParams, List<Object> afterGenericParams) {
        this.parameterBuilders = new ArrayList<StandardParameterBuilder>(groupedParams.size());
        this.afterGenericParameterOffset += beforeGenericParams.size();
        for (List<Object> each : groupedParams) {
            this.parameterBuilders.add(new StandardParameterBuilder(each));
            this.containsGroupedParams = this.containsGroupedParams || !each.isEmpty();
            this.afterGenericParameterOffset += each.size();
        }
        this.beforeGenericParameterBuilder = new StandardParameterBuilder(beforeGenericParams);
        this.afterGenericParameterBuilder = new StandardParameterBuilder(afterGenericParams);
    }

    @Override
    public List<Object> getParameters() {
        LinkedList<Object> result = new LinkedList<Object>(this.beforeGenericParameterBuilder.getParameters());
        for (int i = 0; i < this.parameterBuilders.size(); ++i) {
            result.addAll(this.getParameters(i));
        }
        result.addAll(this.afterGenericParameterBuilder.getParameters());
        return result;
    }

    public List<Object> getParameters(int count) {
        return this.parameterBuilders.get(count).getParameters();
    }

    public Optional<String> getDerivedColumnName() {
        return Optional.ofNullable(this.derivedColumnName);
    }

    @Generated
    public List<StandardParameterBuilder> getParameterBuilders() {
        return this.parameterBuilders;
    }

    @Generated
    public StandardParameterBuilder getBeforeGenericParameterBuilder() {
        return this.beforeGenericParameterBuilder;
    }

    @Generated
    public StandardParameterBuilder getAfterGenericParameterBuilder() {
        return this.afterGenericParameterBuilder;
    }

    @Generated
    public void setDerivedColumnName(String derivedColumnName) {
        this.derivedColumnName = derivedColumnName;
    }

    @Generated
    public boolean isContainsGroupedParams() {
        return this.containsGroupedParams;
    }

    @Generated
    public int getAfterGenericParameterOffset() {
        return this.afterGenericParameterOffset;
    }
}

