/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.distsql.handler.executor.rdl.resource;

import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.database.connector.core.checker.PrivilegeCheckType;
import org.apache.shardingsphere.database.connector.core.jdbcurl.parser.ConnectionProperties;
import org.apache.shardingsphere.database.connector.core.jdbcurl.parser.ConnectionPropertiesParser;
import org.apache.shardingsphere.database.connector.core.spi.DatabaseTypedSPILoader;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.database.connector.core.type.DatabaseTypeFactory;
import org.apache.shardingsphere.distsql.handler.aware.DistSQLExecutorDatabaseAware;
import org.apache.shardingsphere.distsql.handler.engine.update.DistSQLUpdateExecutor;
import org.apache.shardingsphere.distsql.handler.validate.DistSQLDataSourcePoolPropertiesValidator;
import org.apache.shardingsphere.distsql.segment.DataSourceSegment;
import org.apache.shardingsphere.distsql.segment.HostnameAndPortBasedDataSourceSegment;
import org.apache.shardingsphere.distsql.segment.URLBasedDataSourceSegment;
import org.apache.shardingsphere.distsql.segment.converter.DataSourceSegmentsConverter;
import org.apache.shardingsphere.distsql.statement.type.rdl.resource.unit.type.AlterStorageUnitStatement;
import org.apache.shardingsphere.infra.exception.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.exception.external.ShardingSphereExternalException;
import org.apache.shardingsphere.infra.exception.kernel.metadata.resource.storageunit.AlterStorageUnitConnectionInfoException;
import org.apache.shardingsphere.infra.exception.kernel.metadata.resource.storageunit.DuplicateStorageUnitException;
import org.apache.shardingsphere.infra.exception.kernel.metadata.resource.storageunit.MissingRequiredStorageUnitsException;
import org.apache.shardingsphere.infra.exception.kernel.metadata.resource.storageunit.StorageUnitsOperateException;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.resource.unit.StorageUnit;
import org.apache.shardingsphere.mode.manager.ContextManager;

public final class AlterStorageUnitExecutor
implements DistSQLUpdateExecutor<AlterStorageUnitStatement>,
DistSQLExecutorDatabaseAware {
    private final DistSQLDataSourcePoolPropertiesValidator validateHandler = new DistSQLDataSourcePoolPropertiesValidator();
    private ShardingSphereDatabase database;

    @Override
    public void executeUpdate(AlterStorageUnitStatement sqlStatement, ContextManager contextManager) {
        this.checkBefore(sqlStatement);
        Map propsMap = DataSourceSegmentsConverter.convert((DatabaseType)this.database.getProtocolType(), (Collection)sqlStatement.getStorageUnits());
        this.validateHandler.validate(propsMap, this.getExpectedPrivileges(sqlStatement));
        try {
            contextManager.getPersistServiceFacade().getModeFacade().getMetaDataManagerService().alterStorageUnits(this.database, propsMap);
        }
        catch (ShardingSphereExternalException ex) {
            throw new StorageUnitsOperateException("alter", propsMap.keySet(), (Exception)((Object)ex));
        }
    }

    private void checkBefore(AlterStorageUnitStatement sqlStatement) {
        Collection toBeAlteredStorageUnitNames = sqlStatement.getStorageUnits().stream().map(DataSourceSegment::getName).collect(Collectors.toList());
        this.checkDuplicatedStorageUnitNames(toBeAlteredStorageUnitNames);
        this.checkStorageUnitNameExisted(toBeAlteredStorageUnitNames);
        this.checkDatabase(sqlStatement);
    }

    private void checkDuplicatedStorageUnitNames(Collection<String> storageUnitNames) {
        Collection duplicatedStorageUnitNames = storageUnitNames.stream().filter(each -> storageUnitNames.stream().filter(each::equals).count() > 1L).collect(Collectors.toList());
        ShardingSpherePreconditions.checkMustEmpty((Collection)duplicatedStorageUnitNames, () -> new DuplicateStorageUnitException(this.database.getName(), duplicatedStorageUnitNames));
    }

    private void checkStorageUnitNameExisted(Collection<String> storageUnitNames) {
        Collection notExistedStorageUnitNames = storageUnitNames.stream().filter(each -> !this.database.getResourceMetaData().getStorageUnits().containsKey(each)).collect(Collectors.toList());
        ShardingSpherePreconditions.checkMustEmpty((Collection)notExistedStorageUnitNames, () -> new MissingRequiredStorageUnitsException(this.database.getName(), notExistedStorageUnitNames));
    }

    private void checkDatabase(AlterStorageUnitStatement sqlStatement) {
        Collection invalidStorageUnitNames = sqlStatement.getStorageUnits().stream().collect(Collectors.toMap(DataSourceSegment::getName, each -> each)).entrySet().stream().filter(each -> !this.isSameDatabase((DataSourceSegment)each.getValue(), (StorageUnit)this.database.getResourceMetaData().getStorageUnits().get(each.getKey()))).map(Map.Entry::getKey).collect(Collectors.toSet());
        ShardingSpherePreconditions.checkMustEmpty((Collection)invalidStorageUnitNames, () -> new AlterStorageUnitConnectionInfoException(invalidStorageUnitNames));
    }

    private boolean isSameDatabase(DataSourceSegment segment, StorageUnit storageUnit) {
        String hostName = null;
        String port = null;
        String database = null;
        if (segment instanceof HostnameAndPortBasedDataSourceSegment) {
            hostName = ((HostnameAndPortBasedDataSourceSegment)segment).getHostname();
            port = ((HostnameAndPortBasedDataSourceSegment)segment).getPort();
            database = ((HostnameAndPortBasedDataSourceSegment)segment).getDatabase();
        } else if (segment instanceof URLBasedDataSourceSegment) {
            String url = ((URLBasedDataSourceSegment)segment).getUrl();
            ConnectionProperties connectionProps = ((ConnectionPropertiesParser)DatabaseTypedSPILoader.getService(ConnectionPropertiesParser.class, (DatabaseType)DatabaseTypeFactory.get((String)url))).parse(url, segment.getUser(), null);
            hostName = connectionProps.getHostname();
            port = String.valueOf(connectionProps.getPort());
            database = connectionProps.getCatalog();
        }
        ConnectionProperties connectionProps = storageUnit.getConnectionProperties();
        return Objects.equals(hostName, connectionProps.getHostname()) && Objects.equals(port, String.valueOf(connectionProps.getPort())) && Objects.equals(database, connectionProps.getCatalog());
    }

    private Collection<PrivilegeCheckType> getExpectedPrivileges(AlterStorageUnitStatement sqlStatement) {
        Collection result = sqlStatement.getExpectedPrivileges().stream().map(each -> PrivilegeCheckType.valueOf((String)each.toUpperCase())).collect(Collectors.toSet());
        if (result.isEmpty()) {
            result.add(PrivilegeCheckType.SELECT);
        }
        return result;
    }

    @Override
    public Class<AlterStorageUnitStatement> getType() {
        return AlterStorageUnitStatement.class;
    }

    @Override
    @Generated
    public void setDatabase(ShardingSphereDatabase database) {
        this.database = database;
    }
}

