/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.distsql.handler.engine.update.rdl.rule.engine.database;

import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.distsql.handler.engine.update.rdl.rule.engine.database.DatabaseRuleOperatorFactory;
import org.apache.shardingsphere.distsql.handler.engine.update.rdl.rule.spi.database.DatabaseRuleDefinitionExecutor;
import org.apache.shardingsphere.distsql.handler.engine.update.rdl.rule.spi.database.type.DatabaseRuleDropExecutor;
import org.apache.shardingsphere.distsql.handler.required.DistSQLExecutorRequiredChecker;
import org.apache.shardingsphere.distsql.statement.type.rdl.rule.database.DatabaseRuleDefinitionStatement;
import org.apache.shardingsphere.infra.config.rule.RuleConfiguration;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.sql.parser.statement.core.statement.SQLStatement;

public final class DatabaseRuleDefinitionExecuteEngine {
    private final DatabaseRuleDefinitionStatement sqlStatement;
    private final ContextManager contextManager;
    private final ShardingSphereDatabase database;
    private final DatabaseRuleDefinitionExecutor executor;

    public void executeUpdate() {
        this.checkBeforeUpdate();
        Optional rule = this.database.getRuleMetaData().findSingleRule(this.executor.getRuleClass());
        if (this.getRefreshStatus(rule.isPresent())) {
            RuleConfiguration currentRuleConfig = rule.map(ShardingSphereRule::getConfiguration).orElse(null);
            DatabaseRuleOperatorFactory.newInstance(this.contextManager, this.executor).operate(this.sqlStatement, this.database, currentRuleConfig);
        }
    }

    private void checkBeforeUpdate() {
        new DistSQLExecutorRequiredChecker(this.executor).check((SQLStatement)this.sqlStatement, this.contextManager, this.database);
        this.executor.checkBeforeUpdate(this.sqlStatement);
    }

    private boolean getRefreshStatus(boolean currentRuleExists) {
        return !(this.executor instanceof DatabaseRuleDropExecutor) || currentRuleExists && ((DatabaseRuleDropExecutor)this.executor).hasAnyOneToBeDropped(this.sqlStatement);
    }

    @Generated
    public DatabaseRuleDefinitionExecuteEngine(DatabaseRuleDefinitionStatement sqlStatement, ContextManager contextManager, ShardingSphereDatabase database, DatabaseRuleDefinitionExecutor executor) {
        this.sqlStatement = sqlStatement;
        this.contextManager = contextManager;
        this.database = database;
        this.executor = executor;
    }
}

