/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.frontend.firebird.authentication.authenticator.impl;

import org.apache.shardingsphere.database.protocol.firebird.constant.FirebirdAuthenticationMethod;
import org.apache.shardingsphere.database.protocol.firebird.packet.handshake.FirebirdSRPAuthenticationData;
import org.apache.shardingsphere.infra.metadata.user.ShardingSphereUser;
import org.apache.shardingsphere.proxy.frontend.firebird.authentication.authenticator.FirebirdAuthenticator;
import org.firebirdsql.util.ByteArrayHelper;

public final class FirebirdSRPAuthenticator
implements FirebirdAuthenticator {
    public boolean authenticate(ShardingSphereUser user, Object[] authInfo) {
        FirebirdSRPAuthenticationData authData = (FirebirdSRPAuthenticationData)authInfo[1];
        String serverProof = ByteArrayHelper.toHexString((byte[])authData.serverProof(user.getGrantee().getUsername()));
        String clientProof = (String)authInfo[2];
        return serverProof.equals(clientProof);
    }

    public String getAuthenticationMethodName() {
        return FirebirdAuthenticationMethod.SRP.getMethodName();
    }
}

