/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shade.io.opentelemetry.exporter.internal.otlp;

import java.io.IOException;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.internal.marshal.CodedOutputStream;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.internal.marshal.MarshalerWithSize;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.internal.marshal.Serializer;
import org.apache.shardingsphere.shade.io.opentelemetry.proto.common.v1.internal.AnyValue;

final class IntAnyValueMarshaler
extends MarshalerWithSize {
    private final long value;

    private IntAnyValueMarshaler(long value) {
        super(IntAnyValueMarshaler.calculateSize(value));
        this.value = value;
    }

    static MarshalerWithSize create(long value) {
        return new IntAnyValueMarshaler(value);
    }

    @Override
    public void writeTo(Serializer output) throws IOException {
        output.writeInt64(AnyValue.INT_VALUE, this.value);
    }

    private static int calculateSize(long value) {
        return AnyValue.INT_VALUE.getTagSize() + CodedOutputStream.computeInt64SizeNoTag(value);
    }
}

