/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.exception.kernel.metadata.rule;

import java.util.Collection;
import org.apache.shardingsphere.infra.exception.external.sql.sqlstate.SQLState;
import org.apache.shardingsphere.infra.exception.external.sql.sqlstate.XOpenSQLState;
import org.apache.shardingsphere.infra.exception.kernel.metadata.rule.RuleDefinitionException;

public final class MissingRequiredRuleException
extends RuleDefinitionException {
    private static final long serialVersionUID = -8464574460917965546L;

    public MissingRequiredRuleException(String ruleType) {
        super((SQLState)XOpenSQLState.NOT_FOUND, 2, "%s rule does not exist.", ruleType);
    }

    public MissingRequiredRuleException(String ruleType, String databaseName) {
        super((SQLState)XOpenSQLState.NOT_FOUND, 2, "%s rule does not exist in database '%s'.", ruleType, databaseName);
    }

    public MissingRequiredRuleException(String ruleType, Collection<String> ruleNames) {
        super((SQLState)XOpenSQLState.NOT_FOUND, 2, "%s rules '%s' do not exist.", ruleType, ruleNames);
    }

    public MissingRequiredRuleException(String ruleType, String databaseName, String ruleName) {
        super((SQLState)XOpenSQLState.NOT_FOUND, 2, "%s rule '%s' do not exist in database '%s'.", ruleType, ruleName, databaseName);
    }

    public MissingRequiredRuleException(String ruleType, String databaseName, Collection<String> ruleNames) {
        super((SQLState)XOpenSQLState.NOT_FOUND, 2, "%s rules '%s' do not exist in database '%s'.", ruleType, ruleNames, databaseName);
    }
}

