/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.config.props;

import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.infra.props.TypedPropertyKey;

public enum ConfigurationPropertyKey implements TypedPropertyKey
{
    SQL_SHOW("sql-show", String.valueOf(Boolean.FALSE), Boolean.TYPE, false),
    SQL_SIMPLE("sql-simple", String.valueOf(Boolean.FALSE), Boolean.TYPE, false),
    KERNEL_EXECUTOR_SIZE("kernel-executor-size", String.valueOf(0), Integer.TYPE, true),
    MAX_CONNECTIONS_SIZE_PER_QUERY("max-connections-size-per-query", String.valueOf(1), Integer.TYPE, false),
    MAX_UNION_SIZE_PER_DATASOURCE("max-union-size-per-datasource", String.valueOf(Integer.MAX_VALUE), Integer.TYPE, false),
    CHECK_TABLE_METADATA_ENABLED("check-table-metadata-enabled", String.valueOf(Boolean.FALSE), Boolean.TYPE, false),
    LOAD_TABLE_METADATA_BATCH_SIZE("load-table-metadata-batch-size", String.valueOf(1000), Integer.TYPE, false),
    PROXY_FRONTEND_DATABASE_PROTOCOL_TYPE("proxy-frontend-database-protocol-type", null, DatabaseType.class, false),
    PROXY_FRONTEND_FLUSH_THRESHOLD("proxy-frontend-flush-threshold", String.valueOf(128), Integer.TYPE, false),
    PROXY_BACKEND_QUERY_FETCH_SIZE("proxy-backend-query-fetch-size", String.valueOf(-1), Integer.TYPE, false),
    PROXY_FRONTEND_EXECUTOR_SIZE("proxy-frontend-executor-size", String.valueOf(0), Integer.TYPE, true),
    PROXY_FRONTEND_MAX_CONNECTIONS("proxy-frontend-max-connections", "0", Integer.TYPE, false),
    PROXY_FRONTEND_CONNECTION_IDLE_TIMEOUT("proxy-frontend-connection-idle-timeout", "28800", Long.TYPE, false),
    PROXY_DEFAULT_PORT("proxy-default-port", "3307", Integer.TYPE, true),
    PROXY_NETTY_BACKLOG("proxy-netty-backlog", "1024", Integer.TYPE, false),
    CDC_SERVER_PORT("cdc-server-port", "33071", Integer.TYPE, true),
    PROXY_FRONTEND_SSL_ENABLED("proxy-frontend-ssl-enabled", String.valueOf(Boolean.FALSE), Boolean.TYPE, true),
    PROXY_FRONTEND_SSL_VERSION("proxy-frontend-ssl-version", "TLSv1.2,TLSv1.3", String.class, true),
    PROXY_FRONTEND_SSL_CIPHER("proxy-frontend-ssl-cipher", "", String.class, true),
    AGENT_PLUGINS_ENABLED("agent-plugins-enabled", String.valueOf(Boolean.TRUE), Boolean.TYPE, false),
    PERSIST_SCHEMAS_TO_REPOSITORY_ENABLED("persist-schemas-to-repository-enabled", String.valueOf(Boolean.TRUE), Boolean.TYPE, true),
    GROOVY_INLINE_EXPRESSION_PARSING_CACHE_MAX_SIZE("groovy-inline-expression-parsing-cache-max-size", "1000", Long.TYPE, false);

    private final String key;
    private final String defaultValue;
    private final Class<?> type;
    private final boolean rebootRequired;

    public static Collection<String> getKeyNames() {
        return Arrays.stream(ConfigurationPropertyKey.values()).map(Enum::name).collect(Collectors.toList());
    }

    @Generated
    private ConfigurationPropertyKey(String key, String defaultValue, Class<?> type, boolean rebootRequired) {
        this.key = key;
        this.defaultValue = defaultValue;
        this.type = type;
        this.rebootRequired = rebootRequired;
    }

    @Override
    @Generated
    public String getKey() {
        return this.key;
    }

    @Override
    @Generated
    public String getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    @Generated
    public Class<?> getType() {
        return this.type;
    }

    @Generated
    public boolean isRebootRequired() {
        return this.rebootRequired;
    }
}

