/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.algorithm.loadbalancer.round.robin;

import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.shardingsphere.infra.algorithm.loadbalancer.spi.LoadBalanceAlgorithm;

public final class RoundRobinLoadBalanceAlgorithm
implements LoadBalanceAlgorithm {
    private final AtomicInteger count = new AtomicInteger(0);

    public String getTargetName(String groupName, List<String> availableTargetNames) {
        return availableTargetNames.get(Math.abs(this.count.getAndIncrement()) % availableTargetNames.size());
    }

    public String getType() {
        return "ROUND_ROBIN";
    }

    public boolean isDefault() {
        return true;
    }
}

