/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.icatch.imp;

import com.atomikos.icatch.HeurCommitException;
import com.atomikos.icatch.HeurHazardException;
import com.atomikos.icatch.HeurMixedException;
import com.atomikos.icatch.Participant;
import com.atomikos.icatch.imp.Reply;
import com.atomikos.icatch.imp.Result;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;

class PrepareResult
extends Result {
    private Set<Participant> readonlytable_ = new HashSet<Participant>();
    private Set<Participant> indoubts_ = new HashSet<Participant>();
    private boolean analyzed_ = false;

    public PrepareResult(int count) {
        super(count);
    }

    @Override
    protected synchronized void calculateResultFromAllReplies() throws IllegalStateException, InterruptedException {
        if (this.analyzed_) {
            return;
        }
        boolean allReadOnly = true;
        boolean allYes = true;
        boolean heurmixed = false;
        boolean heurhazards = false;
        boolean heurcommits = false;
        Stack<Reply> replies = this.getReplies();
        Enumeration enumm = replies.elements();
        while (enumm.hasMoreElements()) {
            boolean yes = false;
            boolean readonly = false;
            Reply reply = (Reply)enumm.nextElement();
            if (reply.hasFailed()) {
                yes = false;
                readonly = false;
                Exception err = reply.getException();
                if (err instanceof HeurMixedException) {
                    heurmixed = true;
                } else if (err instanceof HeurCommitException) {
                    heurcommits = true;
                    heurmixed = heurmixed || heurhazards;
                } else if (err instanceof HeurHazardException) {
                    heurhazards = true;
                    heurmixed = heurmixed || heurcommits;
                    this.indoubts_.add(reply.getParticipant());
                }
            } else {
                readonly = reply.getResponse() == null;
                Boolean answer = new Boolean(false);
                if (!readonly) {
                    answer = (Boolean)reply.getResponse();
                }
                boolean bl = yes = readonly || answer != false;
                if (readonly) {
                    this.readonlytable_.add(reply.getParticipant());
                } else {
                    this.indoubts_.add(reply.getParticipant());
                }
            }
            allYes = allYes && yes;
            allReadOnly = allReadOnly && readonly;
        }
        if (heurmixed) {
            this.result_ = 2;
        } else if (heurcommits) {
            this.result_ = 4;
        } else if (heurhazards) {
            this.result_ = 1;
        } else if (allReadOnly) {
            this.result_ = 5;
        } else if (allYes) {
            this.result_ = 0;
        }
        this.analyzed_ = true;
    }

    public boolean allYes() throws InterruptedException {
        this.calculateResultFromAllReplies();
        return this.result_ == 0 || this.result_ == 5;
    }

    public boolean allReadOnly() throws InterruptedException {
        this.calculateResultFromAllReplies();
        return this.result_ == 5;
    }

    public Set<Participant> getReadOnlyTable() throws InterruptedException {
        this.calculateResultFromAllReplies();
        return this.readonlytable_;
    }
}

