/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.distsql.handler.update;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.distsql.handler.engine.update.rdl.rule.spi.database.type.DatabaseRuleDropExecutor;
import org.apache.shardingsphere.distsql.handler.required.DistSQLExecutorCurrentRuleRequired;
import org.apache.shardingsphere.infra.algorithm.core.config.AlgorithmConfiguration;
import org.apache.shardingsphere.infra.algorithm.core.exception.InUsedAlgorithmException;
import org.apache.shardingsphere.infra.algorithm.core.exception.UnregisteredAlgorithmException;
import org.apache.shardingsphere.infra.exception.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.exception.external.sql.identifier.SQLExceptionIdentifier;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.sharding.api.config.ShardingRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.sharding.ShardingStrategyConfiguration;
import org.apache.shardingsphere.sharding.distsql.statement.DropShardingAlgorithmStatement;
import org.apache.shardingsphere.sharding.rule.ShardingRule;

@DistSQLExecutorCurrentRuleRequired(value=ShardingRule.class)
public final class DropShardingAlgorithmExecutor
implements DatabaseRuleDropExecutor<DropShardingAlgorithmStatement, ShardingRule, ShardingRuleConfiguration> {
    private ShardingSphereDatabase database;
    private ShardingRule rule;

    public void checkBeforeUpdate(DropShardingAlgorithmStatement sqlStatement) {
        if (!sqlStatement.isIfExists()) {
            this.checkToBeDroppedShardingAlgorithms(sqlStatement);
        }
        if (null != this.rule) {
            this.checkShardingAlgorithmsInUsed(sqlStatement);
        }
    }

    private void checkToBeDroppedShardingAlgorithms(DropShardingAlgorithmStatement sqlStatement) {
        Collection<String> currentShardingAlgorithms = this.getCurrentShardingAlgorithms();
        Collection notExistedAlgorithms = sqlStatement.getNames().stream().filter(each -> !currentShardingAlgorithms.contains(each)).collect(Collectors.toList());
        ShardingSpherePreconditions.checkMustEmpty((Collection)notExistedAlgorithms, () -> new UnregisteredAlgorithmException("Sharding", notExistedAlgorithms, new SQLExceptionIdentifier(this.database.getName())));
    }

    private void checkShardingAlgorithmsInUsed(DropShardingAlgorithmStatement sqlStatement) {
        Collection<String> allInUsed = this.getAllOfAlgorithmsInUsed();
        Collection usedAlgorithms = sqlStatement.getNames().stream().filter(allInUsed::contains).collect(Collectors.toList());
        ShardingSpherePreconditions.checkMustEmpty((Collection)usedAlgorithms, () -> new InUsedAlgorithmException("Sharding", this.database.getName(), usedAlgorithms));
    }

    private Collection<String> getAllOfAlgorithmsInUsed() {
        ShardingStrategyConfiguration databaseShardingStrategy;
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        this.rule.getConfiguration().getTables().forEach(each -> {
            if (null != each.getDatabaseShardingStrategy()) {
                result.add(each.getDatabaseShardingStrategy().getShardingAlgorithmName());
            }
            if (null != each.getTableShardingStrategy()) {
                result.add(each.getTableShardingStrategy().getShardingAlgorithmName());
            }
        });
        this.rule.getConfiguration().getAutoTables().stream().filter(each -> null != each.getShardingStrategy()).forEach(each -> result.add(each.getShardingStrategy().getShardingAlgorithmName()));
        ShardingStrategyConfiguration tableShardingStrategy = this.rule.getConfiguration().getDefaultTableShardingStrategy();
        if (null != tableShardingStrategy && !tableShardingStrategy.getShardingAlgorithmName().isEmpty()) {
            result.add(tableShardingStrategy.getShardingAlgorithmName());
        }
        if (null != (databaseShardingStrategy = this.rule.getConfiguration().getDefaultDatabaseShardingStrategy()) && !databaseShardingStrategy.getShardingAlgorithmName().isEmpty()) {
            result.add(databaseShardingStrategy.getShardingAlgorithmName());
        }
        return result;
    }

    private Collection<String> getCurrentShardingAlgorithms() {
        return this.rule.getConfiguration().getShardingAlgorithms().keySet();
    }

    public ShardingRuleConfiguration buildToBeDroppedRuleConfiguration(DropShardingAlgorithmStatement sqlStatement) {
        ShardingRuleConfiguration result = new ShardingRuleConfiguration();
        for (String each : sqlStatement.getNames()) {
            result.getShardingAlgorithms().put(each, (AlgorithmConfiguration)this.rule.getConfiguration().getShardingAlgorithms().get(each));
        }
        return result;
    }

    public boolean hasAnyOneToBeDropped(DropShardingAlgorithmStatement sqlStatement) {
        return !Collections.disjoint(this.getCurrentShardingAlgorithms(), sqlStatement.getNames());
    }

    public Class<ShardingRule> getRuleClass() {
        return ShardingRule.class;
    }

    public Class<DropShardingAlgorithmStatement> getType() {
        return DropShardingAlgorithmStatement.class;
    }

    @Generated
    public void setDatabase(ShardingSphereDatabase database) {
        this.database = database;
    }

    @Generated
    public void setRule(ShardingRule rule) {
        this.rule = rule;
    }
}

