/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.distsql.handler.query;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.distsql.handler.aware.DistSQLExecutorDatabaseAware;
import org.apache.shardingsphere.distsql.handler.aware.DistSQLExecutorRuleAware;
import org.apache.shardingsphere.distsql.handler.engine.query.DistSQLQueryExecutor;
import org.apache.shardingsphere.infra.merge.result.impl.local.LocalDataQueryResultRow;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.sharding.distsql.statement.ShowShardingTableNodesStatement;
import org.apache.shardingsphere.sharding.rule.ShardingRule;
import org.apache.shardingsphere.sharding.rule.ShardingTable;

public final class ShowShardingTableNodesExecutor
implements DistSQLQueryExecutor<ShowShardingTableNodesStatement>,
DistSQLExecutorRuleAware<ShardingRule>,
DistSQLExecutorDatabaseAware {
    private ShardingRule rule;
    private ShardingSphereDatabase database;

    public Collection<String> getColumnNames(ShowShardingTableNodesStatement sqlStatement) {
        return Arrays.asList("name", "nodes");
    }

    public Collection<LocalDataQueryResultRow> getRows(ShowShardingTableNodesStatement sqlStatement, ContextManager contextManager) {
        String tableName = sqlStatement.getTableName();
        return null == tableName ? (Set<LocalDataQueryResultRow>)((Object)this.rule.getShardingTables().entrySet().stream().map(entry -> new LocalDataQueryResultRow(new Object[]{entry.getKey(), this.getTableNodes((ShardingTable)entry.getValue())})).collect(Collectors.toList())) : Collections.singleton(new LocalDataQueryResultRow(new Object[]{tableName, this.getTableNodes(this.rule.getShardingTable(tableName))}));
    }

    private String getTableNodes(ShardingTable shardingTable) {
        return shardingTable.getActualDataNodes().stream().map(each -> each.format(this.database.getProtocolType())).collect(Collectors.joining(", "));
    }

    public Class<ShardingRule> getRuleClass() {
        return ShardingRule.class;
    }

    public Class<ShowShardingTableNodesStatement> getType() {
        return ShowShardingTableNodesStatement.class;
    }

    @Generated
    public void setRule(ShardingRule rule) {
        this.rule = rule;
    }

    @Generated
    public void setDatabase(ShardingSphereDatabase database) {
        this.database = database;
    }
}

