/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.metadata.generator;

import com.google.common.base.Strings;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import lombok.Generated;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.infra.binder.context.SQLStatementContextFactory;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.metadata.database.schema.util.IndexMetaDataUtils;
import org.apache.shardingsphere.infra.parser.SQLParserEngine;
import org.apache.shardingsphere.sql.parser.statement.core.extractor.TableExtractor;
import org.apache.shardingsphere.sql.parser.statement.core.segment.SQLSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.index.IndexSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.TableNameSegment;
import org.apache.shardingsphere.sql.parser.statement.core.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.attribute.SQLStatementAttributes;
import org.apache.shardingsphere.sql.parser.statement.core.statement.attribute.type.ConstraintSQLStatementAttribute;
import org.apache.shardingsphere.sql.parser.statement.core.statement.attribute.type.IndexSQLStatementAttribute;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.CommentStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.index.CreateIndexStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.table.AlterTableStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.table.CreateTableStatement;

public final class PipelineDDLDecorator {
    private static final String SET_SEARCH_PATH_PREFIX = "set search_path";
    private final ShardingSphereMetaData metaData;

    public Optional<String> decorate(DatabaseType databaseType, String targetDatabaseName, String schemaName, String targetTableName, SQLParserEngine parserEngine, String sql) {
        if (Strings.isNullOrEmpty((String)sql)) {
            return Optional.empty();
        }
        String result = this.decorateActualSQL(targetDatabaseName, targetTableName, parserEngine, sql.trim());
        if ("openGauss".equals(databaseType.getType())) {
            return this.decorateOpenGauss(schemaName, result, parserEngine);
        }
        return Optional.of(result);
    }

    private String decorateActualSQL(String databaseName, String targetTableName, SQLParserEngine parserEngine, String sql) {
        SQLStatementContext sqlStatementContext = this.parseSQL(databaseName, parserEngine, sql);
        TreeMap<SQLSegment, String> replaceMap = new TreeMap<SQLSegment, String>(Comparator.comparing(SQLSegment::getStartIndex));
        if (sqlStatementContext.getSqlStatement() instanceof CreateTableStatement) {
            this.appendFromIndexAndConstraint(replaceMap, targetTableName, sqlStatementContext);
            this.appendFromTable(replaceMap, targetTableName, sqlStatementContext);
        }
        if (sqlStatementContext.getSqlStatement() instanceof CommentStatement) {
            this.appendFromTable(replaceMap, targetTableName, sqlStatementContext);
        }
        if (sqlStatementContext.getSqlStatement() instanceof CreateIndexStatement) {
            this.appendFromTable(replaceMap, targetTableName, sqlStatementContext);
            this.appendFromIndexAndConstraint(replaceMap, targetTableName, sqlStatementContext);
        }
        if (sqlStatementContext.getSqlStatement() instanceof AlterTableStatement) {
            this.appendFromIndexAndConstraint(replaceMap, targetTableName, sqlStatementContext);
            this.appendFromTable(replaceMap, targetTableName, sqlStatementContext);
        }
        return this.doDecorateActualTable(replaceMap, sql);
    }

    private SQLStatementContext parseSQL(String currentDatabaseName, SQLParserEngine parserEngine, String sql) {
        return SQLStatementContextFactory.newInstance((ShardingSphereMetaData)this.metaData, (SQLStatement)parserEngine.parse(sql, true), (String)currentDatabaseName);
    }

    private void appendFromIndexAndConstraint(Map<SQLSegment, String> replaceMap, String targetTableName, SQLStatementContext sqlStatementContext) {
        if (sqlStatementContext.getTablesContext().getSimpleTables().isEmpty()) {
            return;
        }
        TableNameSegment tableNameSegment = ((SimpleTableSegment)sqlStatementContext.getTablesContext().getSimpleTables().iterator().next()).getTableName();
        if (!tableNameSegment.getIdentifier().getValue().equals(targetTableName)) {
            SQLStatementAttributes attributes = sqlStatementContext.getSqlStatement().getAttributes();
            for (IndexSegment each : (Collection)attributes.findAttribute(IndexSQLStatementAttribute.class).map(IndexSQLStatementAttribute::getIndexes).orElse(Collections.emptyList())) {
                String logicIndexName = IndexMetaDataUtils.getLogicIndexName((String)each.getIndexName().getIdentifier().getValue(), (String)tableNameSegment.getIdentifier().getValue());
                replaceMap.put((SQLSegment)each.getIndexName(), logicIndexName);
            }
            for (IndexSegment each : (Collection)attributes.findAttribute(ConstraintSQLStatementAttribute.class).map(ConstraintSQLStatementAttribute::getConstraints).orElse(Collections.emptyList())) {
                String logicConstraint = IndexMetaDataUtils.getLogicIndexName((String)each.getIdentifier().getValue(), (String)tableNameSegment.getIdentifier().getValue());
                replaceMap.put((SQLSegment)each, logicConstraint);
            }
        }
    }

    private void appendFromTable(Map<SQLSegment, String> replaceMap, String targetTableName, SQLStatementContext sqlStatementContext) {
        for (SimpleTableSegment each : sqlStatementContext.getTablesContext().getSimpleTables()) {
            if (targetTableName.equals(each.getTableName().getIdentifier().getValue())) continue;
            replaceMap.put((SQLSegment)each.getTableName(), targetTableName);
        }
    }

    private String doDecorateActualTable(Map<SQLSegment, String> replaceMap, String sql) {
        StringBuilder result = new StringBuilder();
        int lastStopIndex = 0;
        for (Map.Entry<SQLSegment, String> entry : replaceMap.entrySet()) {
            result.append(sql, lastStopIndex, entry.getKey().getStartIndex());
            result.append(entry.getValue());
            lastStopIndex = entry.getKey().getStopIndex() + 1;
        }
        if (lastStopIndex < sql.length()) {
            result.append(sql, lastStopIndex, sql.length());
        }
        return result.toString();
    }

    private Optional<String> decorateOpenGauss(String schemaName, String queryContext, SQLParserEngine parserEngine) {
        if (queryContext.toLowerCase().startsWith(SET_SEARCH_PATH_PREFIX)) {
            return Optional.empty();
        }
        return Optional.of(this.replaceTableNameWithPrefix(queryContext, schemaName, parserEngine));
    }

    private String replaceTableNameWithPrefix(String sql, String schemaName, SQLParserEngine parserEngine) {
        SQLStatement sqlStatement = parserEngine.parse(sql, true);
        if (sqlStatement instanceof CreateTableStatement || sqlStatement instanceof CreateIndexStatement || sqlStatement instanceof AlterTableStatement || sqlStatement instanceof CommentStatement) {
            TableExtractor tableExtractor = new TableExtractor();
            tableExtractor.extractTablesFromSQLStatement(sqlStatement);
            Optional<SimpleTableSegment> simpleTableSegment = tableExtractor.getTableContext().stream().filter(each -> each instanceof SimpleTableSegment).map(each -> (SimpleTableSegment)each).findFirst();
            if (!simpleTableSegment.isPresent()) {
                return sql;
            }
            Optional<String> sqlSchemaName = simpleTableSegment.get().getOwner().map(optional -> optional.getIdentifier().getValue());
            if (sqlSchemaName.isPresent() && sqlSchemaName.get().equals(schemaName)) {
                return sql;
            }
            TreeMap<SQLSegment, String> replaceMap = new TreeMap<SQLSegment, String>(Comparator.comparing(SQLSegment::getStartIndex));
            replaceMap.put((SQLSegment)simpleTableSegment.get(), schemaName + "." + simpleTableSegment.get().getTableName().getIdentifier().getValue());
            return this.doDecorateActualTable(replaceMap, sql);
        }
        return sql;
    }

    @Generated
    public PipelineDDLDecorator(ShardingSphereMetaData metaData) {
        this.metaData = metaData;
    }
}

