/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.job.progress;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.core.consistencycheck.ConsistencyCheckJobItemProgressContext;
import org.apache.shardingsphere.data.pipeline.core.consistencycheck.position.TableCheckRangePosition;
import org.apache.shardingsphere.data.pipeline.core.job.JobStatus;
import org.apache.shardingsphere.data.pipeline.core.job.progress.PipelineJobItemProgress;

public final class ConsistencyCheckJobItemProgress
implements PipelineJobItemProgress {
    private final String tableNames;
    private final String ignoredTableNames;
    private final Long checkedRecordsCount;
    private final Long recordsCount;
    private final Long checkBeginTimeMillis;
    private final Long checkEndTimeMillis;
    private final List<TableCheckRangePosition> tableCheckRangePositions = new ArrayList<TableCheckRangePosition>();
    private final String sourceDatabaseType;
    private JobStatus status = JobStatus.RUNNING;

    public ConsistencyCheckJobItemProgress(ConsistencyCheckJobItemProgressContext context) {
        this.tableNames = String.join((CharSequence)",", context.getTableNames());
        this.ignoredTableNames = String.join((CharSequence)",", context.getIgnoredTableNames());
        this.checkedRecordsCount = context.getCheckedRecordsCount().get();
        this.recordsCount = context.getRecordsCount();
        this.checkBeginTimeMillis = context.getCheckBeginTimeMillis();
        this.checkEndTimeMillis = context.getCheckEndTimeMillis();
        this.tableCheckRangePositions.addAll(context.getTableCheckRangePositions());
        this.sourceDatabaseType = context.getSourceDatabaseType();
    }

    @Generated
    public ConsistencyCheckJobItemProgress(String tableNames, String ignoredTableNames, Long checkedRecordsCount, Long recordsCount, Long checkBeginTimeMillis, Long checkEndTimeMillis, String sourceDatabaseType) {
        this.tableNames = tableNames;
        this.ignoredTableNames = ignoredTableNames;
        this.checkedRecordsCount = checkedRecordsCount;
        this.recordsCount = recordsCount;
        this.checkBeginTimeMillis = checkBeginTimeMillis;
        this.checkEndTimeMillis = checkEndTimeMillis;
        this.sourceDatabaseType = sourceDatabaseType;
    }

    @Generated
    public String getTableNames() {
        return this.tableNames;
    }

    @Generated
    public String getIgnoredTableNames() {
        return this.ignoredTableNames;
    }

    @Generated
    public Long getCheckedRecordsCount() {
        return this.checkedRecordsCount;
    }

    @Generated
    public Long getRecordsCount() {
        return this.recordsCount;
    }

    @Generated
    public Long getCheckBeginTimeMillis() {
        return this.checkBeginTimeMillis;
    }

    @Generated
    public Long getCheckEndTimeMillis() {
        return this.checkEndTimeMillis;
    }

    @Generated
    public List<TableCheckRangePosition> getTableCheckRangePositions() {
        return this.tableCheckRangePositions;
    }

    @Generated
    public String getSourceDatabaseType() {
        return this.sourceDatabaseType;
    }

    @Override
    @Generated
    public JobStatus getStatus() {
        return this.status;
    }

    @Generated
    public String toString() {
        return "ConsistencyCheckJobItemProgress(tableNames=" + this.getTableNames() + ", ignoredTableNames=" + this.getIgnoredTableNames() + ", checkedRecordsCount=" + this.getCheckedRecordsCount() + ", recordsCount=" + this.getRecordsCount() + ", checkBeginTimeMillis=" + this.getCheckBeginTimeMillis() + ", checkEndTimeMillis=" + this.getCheckEndTimeMillis() + ", tableCheckRangePositions=" + this.getTableCheckRangePositions() + ", sourceDatabaseType=" + this.getSourceDatabaseType() + ", status=" + (Object)((Object)this.getStatus()) + ")";
    }

    @Override
    @Generated
    public void setStatus(JobStatus status) {
        this.status = status;
    }
}

