/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.ingest.dumper.inventory;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.core.channel.PipelineChannel;
import org.apache.shardingsphere.data.pipeline.core.constant.PipelineSQLOperationType;
import org.apache.shardingsphere.data.pipeline.core.datasource.PipelineDataSource;
import org.apache.shardingsphere.data.pipeline.core.exception.IngestException;
import org.apache.shardingsphere.data.pipeline.core.exception.param.PipelineInvalidParameterException;
import org.apache.shardingsphere.data.pipeline.core.execute.AbstractPipelineLifecycleRunnable;
import org.apache.shardingsphere.data.pipeline.core.ingest.dumper.Dumper;
import org.apache.shardingsphere.data.pipeline.core.ingest.dumper.inventory.InventoryDumperContext;
import org.apache.shardingsphere.data.pipeline.core.ingest.dumper.inventory.column.InventoryColumnValueReaderEngine;
import org.apache.shardingsphere.data.pipeline.core.ingest.dumper.inventory.position.InventoryDataRecordPositionCreator;
import org.apache.shardingsphere.data.pipeline.core.ingest.dumper.inventory.query.QueryType;
import org.apache.shardingsphere.data.pipeline.core.ingest.dumper.inventory.query.Range;
import org.apache.shardingsphere.data.pipeline.core.ingest.dumper.inventory.query.StreamingRangeType;
import org.apache.shardingsphere.data.pipeline.core.ingest.dumper.inventory.query.calculator.AbstractRecordTableInventoryCalculator;
import org.apache.shardingsphere.data.pipeline.core.ingest.dumper.inventory.query.calculator.TableInventoryCalculateParameter;
import org.apache.shardingsphere.data.pipeline.core.ingest.position.IngestPosition;
import org.apache.shardingsphere.data.pipeline.core.ingest.position.type.finished.IngestFinishedPosition;
import org.apache.shardingsphere.data.pipeline.core.ingest.position.type.pk.UniqueKeyIngestPosition;
import org.apache.shardingsphere.data.pipeline.core.ingest.record.Column;
import org.apache.shardingsphere.data.pipeline.core.ingest.record.DataRecord;
import org.apache.shardingsphere.data.pipeline.core.ingest.record.FinishedRecord;
import org.apache.shardingsphere.data.pipeline.core.ingest.record.NormalColumn;
import org.apache.shardingsphere.data.pipeline.core.ingest.record.Record;
import org.apache.shardingsphere.data.pipeline.core.query.JDBCStreamQueryBuilder;
import org.apache.shardingsphere.data.pipeline.core.ratelimit.JobRateLimitAlgorithm;
import org.apache.shardingsphere.data.pipeline.core.sqlbuilder.sql.PipelineInventoryDumpSQLBuilder;
import org.apache.shardingsphere.data.pipeline.core.util.PipelineJdbcUtils;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.infra.exception.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.metadata.database.schema.QualifiedTable;
import org.apache.shardingsphere.infra.metadata.identifier.ShardingSphereIdentifier;
import org.apache.shardingsphere.infra.util.close.QuietlyCloser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class InventoryDumper
extends AbstractPipelineLifecycleRunnable
implements Dumper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InventoryDumper.class);
    private final InventoryDumperContext dumperContext;
    private final PipelineChannel channel;
    private final PipelineDataSource dataSource;
    private final InventoryDataRecordPositionCreator positionCreator;
    private final PipelineInventoryDumpSQLBuilder sqlBuilder;
    private final InventoryColumnValueReaderEngine columnValueReaderEngine;
    private final AtomicReference<Statement> runningStatement = new AtomicReference();

    public InventoryDumper(InventoryDumperContext dumperContext, PipelineChannel channel, PipelineDataSource dataSource, InventoryDataRecordPositionCreator positionCreator) {
        this.dumperContext = dumperContext;
        this.channel = channel;
        this.dataSource = dataSource;
        this.positionCreator = positionCreator;
        DatabaseType databaseType = dumperContext.getCommonContext().getDataSourceConfig().getDatabaseType();
        this.sqlBuilder = new PipelineInventoryDumpSQLBuilder(databaseType);
        this.columnValueReaderEngine = new InventoryColumnValueReaderEngine(databaseType);
    }

    @Override
    protected void runBlocking() {
        IngestPosition position = this.dumperContext.getCommonContext().getPosition();
        if (position instanceof IngestFinishedPosition) {
            log.info("Ignored because of already finished.");
            return;
        }
        try {
            if (this.dumperContext.hasUniqueKey()) {
                this.dumpByCalculator();
            } else {
                this.dumpWithStreamingQuery();
            }
        }
        catch (RuntimeException | SQLException ex) {
            log.error("Inventory dump failed on {}", (Object)this.dumperContext.getActualTableName(), (Object)ex);
            throw new IngestException("Inventory dump failed on " + this.dumperContext.getActualTableName(), ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpByCalculator() {
        String schemaName = this.dumperContext.getCommonContext().getTableAndSchemaNameMapper().getSchemaName(this.dumperContext.getLogicTableName());
        QualifiedTable table = new QualifiedTable(schemaName, this.dumperContext.getActualTableName());
        IngestPosition initialPosition = this.dumperContext.getCommonContext().getPosition();
        log.info("Dump by calculator start, dataSource={}, table={}, initialPosition={}", new Object[]{this.dumperContext.getCommonContext().getDataSourceName(), table, initialPosition});
        List<String> columnNames = this.dumperContext.getQueryColumnNames();
        TableInventoryCalculateParameter calculateParam = new TableInventoryCalculateParameter(this.dataSource, table, columnNames, this.dumperContext.getUniqueKeyColumns(), QueryType.RANGE_QUERY, null);
        Range range = Range.closed(((UniqueKeyIngestPosition)initialPosition).getLowerBound(), ((UniqueKeyIngestPosition)initialPosition).getUpperBound());
        calculateParam.setRange(range);
        RecordTableInventoryDumpCalculator dumpCalculator = new RecordTableInventoryDumpCalculator(this.dumperContext.getBatchSize());
        long rowCount = 0L;
        try {
            JobRateLimitAlgorithm rateLimitAlgorithm = this.dumperContext.getRateLimitAlgorithm();
            String firstUniqueKey = calculateParam.getFirstUniqueKey().getName();
            for (List each : dumpCalculator.calculate(calculateParam)) {
                if (null != rateLimitAlgorithm) {
                    rateLimitAlgorithm.intercept(PipelineSQLOperationType.SELECT, 1);
                }
                this.channel.push(Collections.unmodifiableList(each));
                UniqueKeyIngestPosition<?> position = UniqueKeyIngestPosition.newInstance(Range.closed(dumpCalculator.getFirstUniqueKeyValue((DataRecord)each.get(each.size() - 1), firstUniqueKey), range.getUpperBound()));
                this.dumperContext.getCommonContext().setPosition(position);
                rowCount += (long)each.size();
            }
        }
        finally {
            QuietlyCloser.close((AutoCloseable)calculateParam.getCalculationContext());
        }
        IngestFinishedPosition position = new IngestFinishedPosition();
        this.channel.push(Collections.singletonList(new FinishedRecord(position)));
        this.dumperContext.getCommonContext().setPosition(position);
        log.info("Dump by calculator done, rowCount={}, dataSource={}, table={}, initialPosition={}", new Object[]{rowCount, this.dumperContext.getCommonContext().getDataSourceName(), table, initialPosition});
    }

    private void dumpWithStreamingQuery() throws SQLException {
        DatabaseType databaseType = this.dumperContext.getCommonContext().getDataSourceConfig().getDatabaseType();
        try (Connection connection = this.dataSource.getConnection();){
            this.fetchAllNoUniqueKeyQuery(connection, databaseType, this.dumperContext.getBatchSize());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fetchAllNoUniqueKeyQuery(Connection connection, DatabaseType databaseType, int batchSize) throws SQLException {
        log.info("Start to fetch all no unique key query, dataSource={}, actualTable={}", (Object)this.dumperContext.getCommonContext().getDataSourceName(), (Object)this.dumperContext.getActualTableName());
        try (PreparedStatement statement = JDBCStreamQueryBuilder.build(databaseType, connection, this.buildFetchAllNoUniqueKeySQL(), batchSize);){
            this.runningStatement.set(statement);
            try (ResultSet resultSet = statement.executeQuery();){
                this.consumeResultSetToChannel(resultSet, batchSize);
            }
            finally {
                this.runningStatement.set(null);
            }
        }
        log.info("End to fetch all no unique key query, dataSource={}, actualTable={}", (Object)this.dumperContext.getCommonContext().getDataSourceName(), (Object)this.dumperContext.getActualTableName());
    }

    private String buildFetchAllNoUniqueKeySQL() {
        String schemaName = this.dumperContext.getCommonContext().getTableAndSchemaNameMapper().getSchemaName(this.dumperContext.getLogicTableName());
        List<String> columnNames = this.dumperContext.getQueryColumnNames();
        return this.sqlBuilder.buildFetchAllSQL(schemaName, this.dumperContext.getActualTableName(), columnNames);
    }

    private void consumeResultSetToChannel(ResultSet resultSet, int batchSize) throws SQLException {
        long rowCount = 0L;
        JobRateLimitAlgorithm rateLimitAlgorithm = this.dumperContext.getRateLimitAlgorithm();
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        LinkedList<Record> dataRecords = new LinkedList<Record>();
        while (resultSet.next()) {
            if (dataRecords.size() >= batchSize) {
                this.channel.push(dataRecords);
                dataRecords = new LinkedList();
            }
            dataRecords.add(this.loadDataRecord(resultSet, resultSetMetaData));
            ++rowCount;
            if (!this.isRunning()) {
                log.info("Broke because of inventory dump is not running.");
                break;
            }
            if (null == rateLimitAlgorithm || 0L != rowCount % (long)batchSize) continue;
            rateLimitAlgorithm.intercept(PipelineSQLOperationType.SELECT, 1);
        }
        dataRecords.add(new FinishedRecord(new IngestFinishedPosition()));
        this.channel.push(dataRecords);
        log.info("Inventory dump with streaming query done, rowCount={}, dataSource={}, actualTable={}", new Object[]{rowCount, this.dumperContext.getCommonContext().getDataSourceName(), this.dumperContext.getActualTableName()});
    }

    private DataRecord loadDataRecord(ResultSet resultSet, ResultSetMetaData resultSetMetaData) throws SQLException {
        int columnCount = resultSetMetaData.getColumnCount();
        String tableName = this.dumperContext.getLogicTableName();
        DataRecord result = new DataRecord(PipelineSQLOperationType.INSERT, tableName, this.positionCreator.create(this.dumperContext, resultSet), columnCount);
        List insertColumnNames = Optional.ofNullable(this.dumperContext.getInsertColumnNames()).orElse(Collections.emptyList());
        ShardingSpherePreconditions.checkState((insertColumnNames.isEmpty() || insertColumnNames.size() == resultSetMetaData.getColumnCount() ? 1 : 0) != 0, () -> new PipelineInvalidParameterException("Insert column names count not equals ResultSet column count"));
        for (int i = 1; i <= columnCount; ++i) {
            String columnName = insertColumnNames.isEmpty() ? resultSetMetaData.getColumnName(i) : (String)insertColumnNames.get(i - 1);
            Column column = this.getColumn(resultSet, resultSetMetaData, columnName, i, this.dumperContext.getTargetUniqueKeysNames().contains(new ShardingSphereIdentifier(columnName)));
            result.addColumn(column);
        }
        result.setActualTableName(this.dumperContext.getActualTableName());
        return result;
    }

    private Column getColumn(ResultSet resultSet, ResultSetMetaData resultSetMetaData, String columnName, int columnIndex, boolean isUniqueKey) throws SQLException {
        return new NormalColumn(columnName, this.columnValueReaderEngine.read(resultSet, resultSetMetaData, columnIndex), true, isUniqueKey);
    }

    @Override
    protected void doStop() {
        Optional.ofNullable(this.runningStatement.get()).ifPresent(PipelineJdbcUtils::cancelStatement);
    }

    private class RecordTableInventoryDumpCalculator
    extends AbstractRecordTableInventoryCalculator<List<DataRecord>, DataRecord> {
        RecordTableInventoryDumpCalculator(int chunkSize) {
            super(chunkSize, StreamingRangeType.SMALL);
        }

        @Override
        protected DataRecord readRecord(ResultSet resultSet, ResultSetMetaData resultSetMetaData, InventoryColumnValueReaderEngine columnValueReaderEngine) throws SQLException {
            return InventoryDumper.this.loadDataRecord(resultSet, resultSetMetaData);
        }

        @Override
        protected Object getFirstUniqueKeyValue(DataRecord record, String firstUniqueKey) {
            return record.getColumn(firstUniqueKey).getValue();
        }

        @Override
        protected List<DataRecord> convertRecordsToResult(List<DataRecord> records, Object maxUniqueKeyValue) {
            return records;
        }
    }
}

