/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.importer;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.api.PipelineDataSourceConfiguration;
import org.apache.shardingsphere.data.pipeline.core.ingest.dumper.mapper.TableAndSchemaNameMapper;
import org.apache.shardingsphere.data.pipeline.core.ratelimit.JobRateLimitAlgorithm;
import org.apache.shardingsphere.database.connector.core.metadata.database.metadata.DialectDatabaseMetaData;
import org.apache.shardingsphere.database.connector.core.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.infra.metadata.identifier.ShardingSphereIdentifier;

public final class ImporterConfiguration {
    private final PipelineDataSourceConfiguration dataSourceConfig;
    private final Map<ShardingSphereIdentifier, Collection<String>> tableAndRequiredColumnsMap;
    private final TableAndSchemaNameMapper tableAndSchemaNameMapper;
    private final int batchSize;
    private final JobRateLimitAlgorithm rateLimitAlgorithm;
    private final int retryTimes;
    private final int concurrency;

    public Collection<String> getShardingColumns(String logicTableName) {
        return this.tableAndRequiredColumnsMap.getOrDefault(new ShardingSphereIdentifier(logicTableName), Collections.emptyList());
    }

    public Optional<String> findSchemaName(String logicTableName) {
        DialectDatabaseMetaData dialectDatabaseMetaData = new DatabaseTypeRegistry(this.dataSourceConfig.getDatabaseType()).getDialectDatabaseMetaData();
        return dialectDatabaseMetaData.getSchemaOption().isSchemaAvailable() ? Optional.ofNullable(this.tableAndSchemaNameMapper.getSchemaName(logicTableName)) : Optional.empty();
    }

    @Generated
    public ImporterConfiguration(PipelineDataSourceConfiguration dataSourceConfig, Map<ShardingSphereIdentifier, Collection<String>> tableAndRequiredColumnsMap, TableAndSchemaNameMapper tableAndSchemaNameMapper, int batchSize, JobRateLimitAlgorithm rateLimitAlgorithm, int retryTimes, int concurrency) {
        this.dataSourceConfig = dataSourceConfig;
        this.tableAndRequiredColumnsMap = tableAndRequiredColumnsMap;
        this.tableAndSchemaNameMapper = tableAndSchemaNameMapper;
        this.batchSize = batchSize;
        this.rateLimitAlgorithm = rateLimitAlgorithm;
        this.retryTimes = retryTimes;
        this.concurrency = concurrency;
    }

    @Generated
    public PipelineDataSourceConfiguration getDataSourceConfig() {
        return this.dataSourceConfig;
    }

    @Generated
    public TableAndSchemaNameMapper getTableAndSchemaNameMapper() {
        return this.tableAndSchemaNameMapper;
    }

    @Generated
    public int getBatchSize() {
        return this.batchSize;
    }

    @Generated
    public JobRateLimitAlgorithm getRateLimitAlgorithm() {
        return this.rateLimitAlgorithm;
    }

    @Generated
    public int getRetryTimes() {
        return this.retryTimes;
    }

    @Generated
    public int getConcurrency() {
        return this.concurrency;
    }

    @Generated
    public String toString() {
        return "ImporterConfiguration(tableAndRequiredColumnsMap=" + this.tableAndRequiredColumnsMap + ", batchSize=" + this.getBatchSize() + ", rateLimitAlgorithm=" + this.getRateLimitAlgorithm() + ", retryTimes=" + this.getRetryTimes() + ", concurrency=" + this.getConcurrency() + ")";
    }
}

