/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.metadata.database.schema.builder;

import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.database.connector.core.metadata.data.loader.MetaDataLoader;
import org.apache.shardingsphere.database.connector.core.metadata.data.loader.MetaDataLoaderMaterial;
import org.apache.shardingsphere.database.connector.core.metadata.data.model.SchemaMetaData;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.database.connector.core.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.infra.metadata.database.resource.unit.StorageUnit;
import org.apache.shardingsphere.infra.metadata.database.schema.builder.GenericSchemaBuilderMaterial;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereSchema;
import org.apache.shardingsphere.infra.metadata.database.schema.reviser.MetaDataReviseEngine;
import org.apache.shardingsphere.infra.metadata.database.schema.util.SchemaMetaDataUtils;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.infra.rule.attribute.table.TableMapperRuleAttribute;

public final class GenericSchemaBuilder {
    public static Map<String, ShardingSphereSchema> build(DatabaseType protocolType, GenericSchemaBuilderMaterial material) throws SQLException {
        return GenericSchemaBuilder.build(GenericSchemaBuilder.getAllTableNames(material.getRules()), protocolType, material);
    }

    public static Map<String, ShardingSphereSchema> build(Collection<String> tableNames, DatabaseType protocolType, GenericSchemaBuilderMaterial material) throws SQLException {
        Map<String, SchemaMetaData> result = GenericSchemaBuilder.loadSchemas(tableNames, material);
        if (!GenericSchemaBuilder.isSameProtocolAndStorageTypes(protocolType, material.getStorageUnits())) {
            result = GenericSchemaBuilder.translate(result, protocolType, material);
        }
        return GenericSchemaBuilder.revise(result, material, protocolType);
    }

    private static Collection<String> getAllTableNames(Collection<ShardingSphereRule> rules) {
        HashSet<String> result = new HashSet<String>();
        for (ShardingSphereRule each : rules) {
            each.getAttributes().findAttribute(TableMapperRuleAttribute.class).ifPresent(optional -> result.addAll(optional.getLogicTableNames()));
        }
        return result;
    }

    private static Map<String, SchemaMetaData> loadSchemas(Collection<String> tableNames, GenericSchemaBuilderMaterial material) throws SQLException {
        Collection<MetaDataLoaderMaterial> materials = SchemaMetaDataUtils.getMetaDataLoaderMaterials(tableNames, material);
        return materials.isEmpty() ? Collections.emptyMap() : MetaDataLoader.load(materials);
    }

    private static boolean isSameProtocolAndStorageTypes(DatabaseType protocolType, Map<String, StorageUnit> storageUnits) {
        return storageUnits.values().stream().map(StorageUnit::getStorageType).allMatch(protocolType::equals);
    }

    private static Map<String, SchemaMetaData> translate(Map<String, SchemaMetaData> schemaMetaDataMap, DatabaseType protocolType, GenericSchemaBuilderMaterial material) {
        LinkedList tableMetaDataList = new LinkedList();
        for (StorageUnit each : material.getStorageUnits().values()) {
            DatabaseTypeRegistry databaseTypeRegistry = new DatabaseTypeRegistry(each.getStorageType());
            String defaultSchemaName = databaseTypeRegistry.getDefaultSchemaName(material.getDefaultSchemaName());
            tableMetaDataList.addAll(Optional.ofNullable(schemaMetaDataMap.get(defaultSchemaName)).map(SchemaMetaData::getTables).orElseGet(Collections::emptyList));
        }
        String frontendSchemaName = new DatabaseTypeRegistry(protocolType).getDefaultSchemaName(material.getDefaultSchemaName());
        return Collections.singletonMap(frontendSchemaName, new SchemaMetaData(frontendSchemaName, tableMetaDataList));
    }

    private static Map<String, ShardingSphereSchema> revise(Map<String, SchemaMetaData> schemaMetaDataMap, GenericSchemaBuilderMaterial material, DatabaseType protocolType) {
        Collection rules = material.getRules().stream().filter(each -> each.getAttributes().findAttribute(TableMapperRuleAttribute.class).isPresent()).collect(Collectors.toList());
        return new MetaDataReviseEngine(rules, protocolType).revise(schemaMetaDataMap, material);
    }

    @Generated
    private GenericSchemaBuilder() {
    }
}

