/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.index;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.index.IndexSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.table.AlgorithmTypeSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.table.LockTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.statement.attribute.SQLStatementAttributes;
import org.apache.shardingsphere.sql.parser.statement.core.statement.attribute.type.IndexSQLStatementAttribute;
import org.apache.shardingsphere.sql.parser.statement.core.statement.attribute.type.TableSQLStatementAttribute;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.DDLStatement;

public final class DropIndexStatement
extends DDLStatement {
    private final Collection<IndexSegment> indexes = new LinkedList<IndexSegment>();
    private boolean ifExists;
    private SimpleTableSegment simpleTable;
    private AlgorithmTypeSegment algorithmType;
    private LockTableSegment lockTable;
    private SQLStatementAttributes attributes;

    public DropIndexStatement(DatabaseType databaseType) {
        super(databaseType);
    }

    public Optional<SimpleTableSegment> getSimpleTable() {
        return Optional.ofNullable(this.simpleTable);
    }

    public Optional<AlgorithmTypeSegment> getAlgorithmType() {
        return Optional.ofNullable(this.algorithmType);
    }

    public Optional<LockTableSegment> getLockTable() {
        return Optional.ofNullable(this.lockTable);
    }

    @Override
    public void buildAttributes() {
        this.attributes = new SQLStatementAttributes(new TableSQLStatementAttribute(this.simpleTable), new DropIndexIndexSQLStatementAttribute());
    }

    @Generated
    public Collection<IndexSegment> getIndexes() {
        return this.indexes;
    }

    @Generated
    public boolean isIfExists() {
        return this.ifExists;
    }

    @Override
    @Generated
    public SQLStatementAttributes getAttributes() {
        return this.attributes;
    }

    @Generated
    public void setIfExists(boolean ifExists) {
        this.ifExists = ifExists;
    }

    @Generated
    public void setSimpleTable(SimpleTableSegment simpleTable) {
        this.simpleTable = simpleTable;
    }

    @Generated
    public void setAlgorithmType(AlgorithmTypeSegment algorithmType) {
        this.algorithmType = algorithmType;
    }

    @Generated
    public void setLockTable(LockTableSegment lockTable) {
        this.lockTable = lockTable;
    }

    @Generated
    public void setAttributes(SQLStatementAttributes attributes) {
        this.attributes = attributes;
    }

    private class DropIndexIndexSQLStatementAttribute
    implements IndexSQLStatementAttribute {
        private DropIndexIndexSQLStatementAttribute() {
        }

        @Override
        public Collection<IndexSegment> getIndexes() {
            return DropIndexStatement.this.indexes;
        }

        @Override
        public Collection<ColumnSegment> getIndexColumns() {
            return Collections.emptyList();
        }
    }
}

