/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.node.path.engine.searcher;

import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.shardingsphere.mode.node.path.NodePath;
import org.apache.shardingsphere.mode.node.path.engine.generator.NodePathGenerator;
import org.apache.shardingsphere.mode.node.path.engine.searcher.NodePathSearchCriteria;

public final class NodePathSearcher {
    private static final String START_PATTERN = "^";

    public static Optional<String> find(String path, NodePathSearchCriteria criteria) {
        Matcher matcher = NodePathSearcher.createPattern(criteria.getSearchExample(), criteria.isContainsChildPath()).matcher(path);
        return matcher.find() ? Optional.of(matcher.group(criteria.getGroupIndex())) : Optional.empty();
    }

    public static String get(String path, NodePathSearchCriteria criteria) {
        return NodePathSearcher.find(path, criteria).orElseThrow(() -> new IllegalArgumentException(String.format("Can not find node segment in path: %s", path)));
    }

    public static boolean isMatchedPath(String path, NodePathSearchCriteria criteria) {
        return NodePathSearcher.createPattern(criteria.getSearchExample(), criteria.isContainsChildPath()).matcher(path).find();
    }

    private static Pattern createPattern(NodePath searchExample, boolean containsChildPath) {
        String endPattern = containsChildPath ? "?" : "$";
        return Pattern.compile(START_PATTERN + NodePathGenerator.toPath(searchExample) + endPattern, 2);
    }

    @Generated
    private NodePathSearcher() {
    }
}

