/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sqlfederation.compiler.sql.ast.converter.segment.projection.impl;

import com.cedarsoftware.util.CaseInsensitiveMap;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlBasicCall;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSelectKeyword;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.AggregationDistinctProjectionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.AggregationProjectionSegment;
import org.apache.shardingsphere.sqlfederation.compiler.sql.ast.converter.segment.expression.ExpressionConverter;

public final class AggregationProjectionConverter {
    private static final Map<String, SqlAggFunction> REGISTRY = new CaseInsensitiveMap();

    private static void register(SqlAggFunction sqlAggFunction) {
        REGISTRY.put(sqlAggFunction.getName(), sqlAggFunction);
    }

    private static void register(SqlAggFunction sqlAggFunction, String alias) {
        REGISTRY.put(alias, sqlAggFunction);
    }

    public static Optional<SqlNode> convert(AggregationProjectionSegment segment) {
        if (null == segment) {
            return Optional.empty();
        }
        SqlLiteral functionQuantifier = segment instanceof AggregationDistinctProjectionSegment ? SqlLiteral.createSymbol((Enum)SqlSelectKeyword.DISTINCT, (SqlParserPos)SqlParserPos.ZERO) : null;
        SqlAggFunction operator = AggregationProjectionConverter.convertOperator(segment.getType().name());
        List<SqlNode> params = AggregationProjectionConverter.convertParameters(segment.getParameters(), segment.getExpression(), segment.getSeparator().orElse(null));
        SqlBasicCall sqlBasicCall = new SqlBasicCall((SqlOperator)operator, params, SqlParserPos.ZERO, functionQuantifier);
        if (segment.getAliasName().isPresent()) {
            return Optional.of(new SqlBasicCall((SqlOperator)SqlStdOperatorTable.AS, Arrays.asList(sqlBasicCall, SqlIdentifier.star(Collections.singletonList((String)segment.getAliasName().get()), (SqlParserPos)SqlParserPos.ZERO, Collections.singletonList(SqlParserPos.ZERO))), SqlParserPos.ZERO));
        }
        return Optional.of(sqlBasicCall);
    }

    private static SqlAggFunction convertOperator(String operator) {
        Preconditions.checkState((boolean)REGISTRY.containsKey(operator), (String)"Unsupported SQL operator: `%s`", (Object)operator);
        return REGISTRY.get(operator);
    }

    private static List<SqlNode> convertParameters(Collection<ExpressionSegment> params, String expression, String separator) {
        if (expression.contains("*")) {
            return Collections.singletonList(SqlIdentifier.star((SqlParserPos)SqlParserPos.ZERO));
        }
        LinkedList<SqlNode> result = new LinkedList<SqlNode>();
        for (ExpressionSegment each : params) {
            ExpressionConverter.convert(each).ifPresent(result::add);
        }
        if (null != separator) {
            result.add((SqlNode)SqlLiteral.createCharString((String)separator, (SqlParserPos)SqlParserPos.ZERO));
        }
        return result;
    }

    @Generated
    private AggregationProjectionConverter() {
    }

    static {
        AggregationProjectionConverter.register(SqlStdOperatorTable.MAX);
        AggregationProjectionConverter.register(SqlStdOperatorTable.MIN);
        AggregationProjectionConverter.register(SqlStdOperatorTable.SUM);
        AggregationProjectionConverter.register(SqlStdOperatorTable.COUNT);
        AggregationProjectionConverter.register(SqlStdOperatorTable.AVG);
        AggregationProjectionConverter.register(SqlStdOperatorTable.BIT_XOR);
        AggregationProjectionConverter.register(SqlStdOperatorTable.LISTAGG, "GROUP_CONCAT");
    }
}

