/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.rewrite.token;

import java.util.Collection;
import java.util.LinkedList;
import lombok.Generated;
import org.apache.shardingsphere.encrypt.rewrite.condition.EncryptCondition;
import org.apache.shardingsphere.encrypt.rewrite.token.generator.assignment.EncryptInsertAssignmentTokenGenerator;
import org.apache.shardingsphere.encrypt.rewrite.token.generator.assignment.EncryptUpdateAssignmentTokenGenerator;
import org.apache.shardingsphere.encrypt.rewrite.token.generator.ddl.EncryptAlterTableTokenGenerator;
import org.apache.shardingsphere.encrypt.rewrite.token.generator.ddl.EncryptCreateTableTokenGenerator;
import org.apache.shardingsphere.encrypt.rewrite.token.generator.insert.EncryptInsertCipherNameTokenGenerator;
import org.apache.shardingsphere.encrypt.rewrite.token.generator.insert.EncryptInsertDefaultColumnsTokenGenerator;
import org.apache.shardingsphere.encrypt.rewrite.token.generator.insert.EncryptInsertDerivedColumnsTokenGenerator;
import org.apache.shardingsphere.encrypt.rewrite.token.generator.insert.EncryptInsertOnUpdateTokenGenerator;
import org.apache.shardingsphere.encrypt.rewrite.token.generator.insert.EncryptInsertValuesTokenGenerator;
import org.apache.shardingsphere.encrypt.rewrite.token.generator.predicate.EncryptInsertPredicateColumnTokenGenerator;
import org.apache.shardingsphere.encrypt.rewrite.token.generator.predicate.EncryptInsertPredicateValueTokenGenerator;
import org.apache.shardingsphere.encrypt.rewrite.token.generator.predicate.EncryptPredicateColumnTokenGenerator;
import org.apache.shardingsphere.encrypt.rewrite.token.generator.predicate.EncryptPredicateValueTokenGenerator;
import org.apache.shardingsphere.encrypt.rewrite.token.generator.projection.EncryptInsertSelectProjectionTokenGenerator;
import org.apache.shardingsphere.encrypt.rewrite.token.generator.projection.EncryptSelectProjectionTokenGenerator;
import org.apache.shardingsphere.encrypt.rewrite.token.generator.select.EncryptGroupByItemTokenGenerator;
import org.apache.shardingsphere.encrypt.rewrite.token.generator.select.EncryptIndexColumnTokenGenerator;
import org.apache.shardingsphere.encrypt.rule.EncryptRule;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.rewrite.context.SQLRewriteContext;
import org.apache.shardingsphere.infra.rewrite.sql.token.common.generator.SQLTokenGenerator;
import org.apache.shardingsphere.infra.rewrite.sql.token.common.generator.builder.SQLTokenGeneratorBuilder;

public final class EncryptTokenGenerateBuilder
implements SQLTokenGeneratorBuilder {
    private final SQLStatementContext sqlStatementContext;
    private final Collection<EncryptCondition> encryptConditions;
    private final EncryptRule rule;
    private final SQLRewriteContext sqlRewriteContext;

    public Collection<SQLTokenGenerator> getSQLTokenGenerators() {
        LinkedList<SQLTokenGenerator> result = new LinkedList<SQLTokenGenerator>();
        ShardingSphereDatabase database = this.sqlRewriteContext.getDatabase();
        this.addSQLTokenGenerator(result, (SQLTokenGenerator)new EncryptSelectProjectionTokenGenerator(this.rule));
        this.addSQLTokenGenerator(result, (SQLTokenGenerator)new EncryptInsertSelectProjectionTokenGenerator(this.rule));
        this.addSQLTokenGenerator(result, (SQLTokenGenerator)new EncryptInsertAssignmentTokenGenerator(this.rule, database));
        this.addSQLTokenGenerator(result, (SQLTokenGenerator)new EncryptUpdateAssignmentTokenGenerator(this.rule, database));
        this.addSQLTokenGenerator(result, (SQLTokenGenerator)new EncryptPredicateColumnTokenGenerator(this.rule));
        this.addSQLTokenGenerator(result, (SQLTokenGenerator)new EncryptInsertPredicateColumnTokenGenerator(this.rule));
        this.addSQLTokenGenerator(result, (SQLTokenGenerator)new EncryptPredicateValueTokenGenerator(this.rule, database, this.encryptConditions));
        this.addSQLTokenGenerator(result, (SQLTokenGenerator)new EncryptInsertPredicateValueTokenGenerator(this.rule, database, this.encryptConditions));
        this.addSQLTokenGenerator(result, (SQLTokenGenerator)new EncryptInsertValuesTokenGenerator(this.rule, database));
        this.addSQLTokenGenerator(result, (SQLTokenGenerator)new EncryptInsertDefaultColumnsTokenGenerator(this.rule));
        this.addSQLTokenGenerator(result, (SQLTokenGenerator)new EncryptInsertCipherNameTokenGenerator(this.rule));
        this.addSQLTokenGenerator(result, (SQLTokenGenerator)new EncryptInsertDerivedColumnsTokenGenerator(this.rule));
        this.addSQLTokenGenerator(result, (SQLTokenGenerator)new EncryptInsertOnUpdateTokenGenerator(this.rule, database));
        this.addSQLTokenGenerator(result, (SQLTokenGenerator)new EncryptGroupByItemTokenGenerator(this.rule));
        this.addSQLTokenGenerator(result, (SQLTokenGenerator)new EncryptIndexColumnTokenGenerator(this.rule));
        this.addSQLTokenGenerator(result, (SQLTokenGenerator)new EncryptCreateTableTokenGenerator(this.rule));
        this.addSQLTokenGenerator(result, (SQLTokenGenerator)new EncryptAlterTableTokenGenerator(this.rule));
        return result;
    }

    private void addSQLTokenGenerator(Collection<SQLTokenGenerator> sqlTokenGenerators, SQLTokenGenerator toBeAddedSQLTokenGenerator) {
        if (toBeAddedSQLTokenGenerator.isGenerateSQLToken(this.sqlStatementContext)) {
            sqlTokenGenerators.add(toBeAddedSQLTokenGenerator);
        }
    }

    @Generated
    public EncryptTokenGenerateBuilder(SQLStatementContext sqlStatementContext, Collection<EncryptCondition> encryptConditions, EncryptRule rule, SQLRewriteContext sqlRewriteContext) {
        this.sqlStatementContext = sqlStatementContext;
        this.encryptConditions = encryptConditions;
        this.rule = rule;
        this.sqlRewriteContext = sqlRewriteContext;
    }
}

