/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.engine.doris.visitor.statement.type;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.misc.Interval;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.sql.parser.api.ASTNode;
import org.apache.shardingsphere.sql.parser.api.visitor.statement.type.DDLStatementVisitor;
import org.apache.shardingsphere.sql.parser.autogen.DorisStatementParser;
import org.apache.shardingsphere.sql.parser.engine.doris.visitor.statement.DorisStatementVisitor;
import org.apache.shardingsphere.sql.parser.statement.core.enums.AlgorithmOption;
import org.apache.shardingsphere.sql.parser.statement.core.enums.LockTableOption;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dal.PartitionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.AlterDefinitionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.CreateDefinitionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.charset.CharsetNameSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.column.ColumnDefinitionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.column.alter.AddColumnDefinitionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.column.alter.ChangeColumnDefinitionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.column.alter.DropColumnDefinitionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.column.alter.ModifyColumnDefinitionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.column.alter.RenameColumnSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.column.position.ColumnAfterPositionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.column.position.ColumnFirstPositionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.column.position.ColumnPositionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.constraint.ConstraintDefinitionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.constraint.ConstraintSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.constraint.alter.AddConstraintDefinitionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.constraint.alter.DropConstraintDefinitionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.constraint.alter.ModifyConstraintDefinitionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.engine.EngineSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.index.DropIndexDefinitionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.index.IndexNameSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.index.IndexSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.index.RenameIndexDefinitionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.job.BinlogDescriptionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.job.ChannelDescriptionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.job.JobNameSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.partition.RenamePartitionDefinitionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.policy.PolicyNameSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.property.PropertiesSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.property.PropertySegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.rollup.RenameRollupDefinitionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.rollup.RollupSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.routine.FunctionNameSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.routine.RoutineBodySegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.routine.ValidStatementSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.table.AlgorithmTypeSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.table.ConvertTableDefinitionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.table.CreateTableOptionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.table.LockTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.table.RenameTableDefinitionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.table.ReplaceTableDefinitionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.tablespace.TablespaceSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.view.ViewColumnSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.simple.SimpleExpressionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.CommentSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.DataTypeSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.OwnerSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.ddl.CreateEncryptKeyStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.ddl.CreateFileStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.ddl.DropEncryptKeyStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.ddl.DropFileStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.DeallocateStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.ExecuteStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.PrepareStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.TruncateStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.alter.CancelAlterTableStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.catalog.AlterCatalogStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.database.AlterDatabaseStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.database.CreateDatabaseStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.database.DropDatabaseStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.function.AlterFunctionStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.index.BuildIndexStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.index.CancelBuildIndexStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.index.CreateIndexStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.index.DropIndexStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.procedure.AlterProcedureStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.procedure.CreateProcedureStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.procedure.DropProcedureStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.server.AlterServerStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.server.CreateServerStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.server.DropServerStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.table.AlterTableStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.table.CreateTableStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.table.DropTableStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.table.RenameTableStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.tablespace.AlterTablespaceStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.tablespace.CreateTablespaceStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.tablespace.DropTablespaceStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.trigger.CreateTriggerStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.trigger.DropTriggerStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.view.AlterViewStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.view.CreateMaterializedViewStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.view.CreateViewStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.view.DropViewStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dml.DeleteStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dml.InsertStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dml.SelectStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dml.UpdateStatement;
import org.apache.shardingsphere.sql.parser.statement.core.util.SQLUtils;
import org.apache.shardingsphere.sql.parser.statement.core.value.collection.CollectionValue;
import org.apache.shardingsphere.sql.parser.statement.core.value.identifier.IdentifierValue;
import org.apache.shardingsphere.sql.parser.statement.doris.ddl.DorisAlterStoragePolicyStatement;
import org.apache.shardingsphere.sql.parser.statement.doris.ddl.DorisCreateFunctionStatement;
import org.apache.shardingsphere.sql.parser.statement.doris.ddl.DorisCreateSyncJobStatement;
import org.apache.shardingsphere.sql.parser.statement.doris.ddl.DorisDropFunctionStatement;
import org.apache.shardingsphere.sql.parser.statement.doris.ddl.DorisPauseSyncJobStatement;
import org.apache.shardingsphere.sql.parser.statement.doris.ddl.DorisResumeJobStatement;
import org.apache.shardingsphere.sql.parser.statement.doris.ddl.DorisResumeSyncJobStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.ddl.event.MySQLAlterEventStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.ddl.event.MySQLCreateEventStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.ddl.event.MySQLDropEventStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.ddl.instance.MySQLAlterInstanceStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.ddl.logfile.MySQLAlterLogfileGroupStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.ddl.logfile.MySQLCreateLogfileGroupStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.ddl.logfile.MySQLDropLogfileGroupStatement;

public final class DorisDDLStatementVisitor
extends DorisStatementVisitor
implements DDLStatementVisitor {
    public DorisDDLStatementVisitor(DatabaseType databaseType) {
        super(databaseType);
    }

    @Override
    public ASTNode visitCreateView(DorisStatementParser.CreateViewContext ctx) {
        CreateViewStatement result = new CreateViewStatement(this.getDatabaseType());
        result.setReplaceView(null != ctx.REPLACE());
        result.setView((SimpleTableSegment)this.visit((ParseTree)ctx.viewName()));
        result.setViewDefinition(this.getOriginalText(ctx.select()));
        result.setSelect((SelectStatement)this.visit((ParseTree)ctx.select()));
        return result;
    }

    @Override
    public ASTNode visitAlterView(DorisStatementParser.AlterViewContext ctx) {
        CollectionValue columns;
        AlterViewStatement result = new AlterViewStatement(this.getDatabaseType());
        result.setView((SimpleTableSegment)this.visit((ParseTree)ctx.viewName()));
        if (null != ctx.columnNames()) {
            columns = (CollectionValue)this.visit((ParseTree)ctx.columnNames());
            for (ColumnSegment each : columns.getValue()) {
                result.getColumns().add(new ViewColumnSegment(each.getStartIndex(), each.getStopIndex(), each, null));
            }
        }
        if (null != ctx.viewColumnDefinitions()) {
            columns = (CollectionValue)this.visit((ParseTree)ctx.viewColumnDefinitions());
            result.getColumns().addAll(columns.getValue());
        }
        result.setViewDefinition(this.getOriginalText(ctx.select()));
        result.setSelect((SelectStatement)this.visit((ParseTree)ctx.select()));
        return result;
    }

    @Override
    public ASTNode visitDropView(DorisStatementParser.DropViewContext ctx) {
        DropViewStatement result = new DropViewStatement(this.getDatabaseType());
        result.setIfExists(null != ctx.ifExists());
        result.getViews().addAll(((CollectionValue)this.visit((ParseTree)ctx.viewNames())).getValue());
        return result;
    }

    @Override
    public ASTNode visitCreateDatabase(DorisStatementParser.CreateDatabaseContext ctx) {
        return new CreateDatabaseStatement(this.getDatabaseType(), new IdentifierValue(ctx.databaseName().getText()).getValue(), null != ctx.ifNotExists());
    }

    @Override
    public ASTNode visitAlterDatabase(DorisStatementParser.AlterDatabaseContext ctx) {
        AlterDatabaseStatement result = new AlterDatabaseStatement(this.getDatabaseType());
        if (null != ctx.databaseName()) {
            result.setDatabaseName(new IdentifierValue(ctx.databaseName().getText()).getValue());
        }
        if (null != ctx.RENAME() && null != ctx.identifier()) {
            result.setRenameDatabaseName(new IdentifierValue(ctx.identifier().getText()).getValue());
        }
        if (null != ctx.QUOTA() && null != ctx.NUMBER_()) {
            if (null != ctx.DATA()) {
                result.setQuotaType("DATA");
            } else if (null != ctx.REPLICA()) {
                result.setQuotaType("REPLICA");
            } else if (null != ctx.TRANSACTION()) {
                result.setQuotaType("TRANSACTION");
            }
            result.setQuotaValue(Long.valueOf(Long.parseLong(ctx.NUMBER_().getText())));
        }
        if (null != ctx.PROPERTIES() && null != ctx.properties()) {
            PropertiesSegment propertiesSegment = new PropertiesSegment(ctx.properties().getStart().getStartIndex(), ctx.properties().getStop().getStopIndex());
            for (int i = 0; i < ctx.properties().property().size(); ++i) {
                String key = this.getPropertyKey(ctx.properties().property(i));
                String value = SQLUtils.getExactlyValue((String)ctx.properties().property(i).literals().getText());
                PropertySegment propertySegment = new PropertySegment(ctx.properties().property(i).getStart().getStartIndex(), ctx.properties().property(i).getStop().getStopIndex(), key, value);
                propertiesSegment.getProperties().add(propertySegment);
            }
            result.setProperties(propertiesSegment);
        }
        return result;
    }

    @Override
    public ASTNode visitDropDatabase(DorisStatementParser.DropDatabaseContext ctx) {
        return new DropDatabaseStatement(this.getDatabaseType(), new IdentifierValue(ctx.databaseName().getText()).getValue(), null != ctx.ifExists());
    }

    @Override
    public ASTNode visitAlterCatalog(DorisStatementParser.AlterCatalogContext ctx) {
        AlterCatalogStatement result = new AlterCatalogStatement(this.getDatabaseType());
        result.setCatalogName(new IdentifierValue(ctx.catalogName().getText()).getValue());
        if (null != ctx.RENAME()) {
            result.setNewCatalogName(new IdentifierValue(ctx.identifier().getText()).getValue());
        }
        if (null != ctx.PROPERTIES()) {
            for (int i = 0; i < ctx.properties().property().size(); ++i) {
                String key = null != ctx.properties().property(i).SINGLE_QUOTED_TEXT() ? SQLUtils.getExactlyValue((String)ctx.properties().property(i).SINGLE_QUOTED_TEXT().getText()) : SQLUtils.getExactlyValue((String)ctx.properties().property(i).identifier().getText());
                String value = SQLUtils.getExactlyValue((String)ctx.properties().property(i).literals().getText());
                result.getProperties().put(key, value);
            }
        }
        if (null != ctx.COMMENT()) {
            result.setComment(SQLUtils.getExactlyValue((String)ctx.string_().getText()));
        }
        return result;
    }

    @Override
    public ASTNode visitResumeJob(DorisStatementParser.ResumeJobContext ctx) {
        String jobName = SQLUtils.getExactlyValue((String)ctx.stringLiterals().getText());
        return new DorisResumeJobStatement(this.getDatabaseType(), jobName);
    }

    @Override
    public ASTNode visitResumeSyncJob(DorisStatementParser.ResumeSyncJobContext ctx) {
        DorisResumeSyncJobStatement result = new DorisResumeSyncJobStatement(this.getDatabaseType());
        JobNameSegment jobName = new JobNameSegment(ctx.identifier().start.getStartIndex(), ctx.identifier().stop.getStopIndex(), (IdentifierValue)this.visit((ParseTree)ctx.identifier()));
        if (null != ctx.owner()) {
            jobName.setOwner((OwnerSegment)this.visit((ParseTree)ctx.owner()));
        }
        result.setJobName(jobName);
        return result;
    }

    @Override
    public ASTNode visitPauseSyncJob(DorisStatementParser.PauseSyncJobContext ctx) {
        DorisPauseSyncJobStatement result = new DorisPauseSyncJobStatement(this.getDatabaseType());
        JobNameSegment jobName = new JobNameSegment(ctx.identifier().start.getStartIndex(), ctx.identifier().stop.getStopIndex(), (IdentifierValue)this.visit((ParseTree)ctx.identifier()));
        if (null != ctx.owner()) {
            jobName.setOwner((OwnerSegment)this.visit((ParseTree)ctx.owner()));
        }
        result.setJobName(jobName);
        return result;
    }

    @Override
    public ASTNode visitCreateSyncJob(DorisStatementParser.CreateSyncJobContext ctx) {
        DorisCreateSyncJobStatement result = new DorisCreateSyncJobStatement(this.getDatabaseType());
        JobNameSegment jobName = new JobNameSegment(ctx.identifier().start.getStartIndex(), ctx.identifier().stop.getStopIndex(), (IdentifierValue)this.visit((ParseTree)ctx.identifier()));
        if (null != ctx.owner()) {
            jobName.setOwner((OwnerSegment)this.visit((ParseTree)ctx.owner()));
        }
        result.setJobName(jobName);
        for (DorisStatementParser.ChannelDescriptionContext each : ctx.channelDescription()) {
            result.getChannelDescriptions().add((ChannelDescriptionSegment)this.visit((ParseTree)each));
        }
        result.setBinlogDescription((BinlogDescriptionSegment)this.visit((ParseTree)ctx.binlogDescription()));
        return result;
    }

    @Override
    public ASTNode visitChannelDescription(DorisStatementParser.ChannelDescriptionContext ctx) {
        SimpleTableSegment sourceTable = (SimpleTableSegment)this.visit((ParseTree)ctx.tableName(0));
        SimpleTableSegment targetTable = (SimpleTableSegment)this.visit((ParseTree)ctx.tableName(1));
        ChannelDescriptionSegment result = new ChannelDescriptionSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), sourceTable, targetTable);
        if (null != ctx.columnNames()) {
            for (DorisStatementParser.ColumnNameContext each : ctx.columnNames().columnName()) {
                result.getColumnNames().add(((ColumnSegment)this.visit((ParseTree)each)).getIdentifier().getValue());
            }
        }
        return result;
    }

    @Override
    public ASTNode visitBinlogDescription(DorisStatementParser.BinlogDescriptionContext ctx) {
        BinlogDescriptionSegment result = new BinlogDescriptionSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex());
        PropertiesSegment propertiesSegment = new PropertiesSegment(ctx.properties().start.getStartIndex(), ctx.properties().stop.getStopIndex());
        for (DorisStatementParser.PropertyContext each : ctx.properties().property()) {
            propertiesSegment.getProperties().add(this.createPropertySegment(each));
        }
        result.setProperties(propertiesSegment);
        return result;
    }

    private PropertySegment createPropertySegment(DorisStatementParser.PropertyContext ctx) {
        String key = this.getPropertyKey(ctx);
        String value = SQLUtils.getExactlyValue((String)ctx.literals().getText());
        return new PropertySegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), key, value);
    }

    @Override
    public ASTNode visitCreateTable(DorisStatementParser.CreateTableContext ctx) {
        CreateTableStatement result = new CreateTableStatement(this.getDatabaseType());
        result.setTable((SimpleTableSegment)this.visit((ParseTree)ctx.tableName()));
        result.setIfNotExists(null != ctx.ifNotExists());
        if (null != ctx.createDefinitionClause()) {
            CollectionValue createDefinitions = (CollectionValue)this.visit((ParseTree)ctx.createDefinitionClause());
            for (CreateDefinitionSegment each : createDefinitions.getValue()) {
                if (each instanceof ColumnDefinitionSegment) {
                    result.getColumnDefinitions().add((ColumnDefinitionSegment)each);
                    continue;
                }
                if (!(each instanceof ConstraintDefinitionSegment)) continue;
                result.getConstraintDefinitions().add((ConstraintDefinitionSegment)each);
            }
        }
        if (null != ctx.createLikeClause()) {
            result.setLikeTable((SimpleTableSegment)this.visit((ParseTree)ctx.createLikeClause()));
        }
        if (null != ctx.createTableOptions()) {
            result.setCreateTableOption((CreateTableOptionSegment)this.visit((ParseTree)ctx.createTableOptions()));
        }
        if (null != ctx.duplicateAsQueryExpression()) {
            result.setSelectStatement((SelectStatement)this.visit((ParseTree)ctx.duplicateAsQueryExpression().select()));
        }
        return result;
    }

    @Override
    public ASTNode visitCreateTableOptions(DorisStatementParser.CreateTableOptionsContext ctx) {
        CreateTableOptionSegment result = new CreateTableOptionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex());
        for (DorisStatementParser.CreateTableOptionContext each : ctx.createTableOption()) {
            if (null != each.engineRef()) {
                result.setEngine((EngineSegment)this.visit((ParseTree)each.engineRef()));
                continue;
            }
            if (null == each.COMMENT()) continue;
            result.setCommentSegment(new CommentSegment(each.string_().getText(), each.string_().getStart().getStartIndex(), each.string_().getStop().getStopIndex()));
        }
        return result;
    }

    @Override
    public ASTNode visitCreateDefinitionClause(DorisStatementParser.CreateDefinitionClauseContext ctx) {
        CollectionValue result = new CollectionValue();
        for (DorisStatementParser.TableElementContext each : ctx.tableElementList().tableElement()) {
            if (null != each.columnDefinition()) {
                result.getValue().add((ColumnDefinitionSegment)this.visit((ParseTree)each.columnDefinition()));
            }
            if (null == each.tableConstraintDef()) continue;
            result.getValue().add((ConstraintDefinitionSegment)this.visit((ParseTree)each.tableConstraintDef()));
        }
        return result;
    }

    @Override
    public ASTNode visitCreateLikeClause(DorisStatementParser.CreateLikeClauseContext ctx) {
        return (ASTNode)this.visit((ParseTree)ctx.tableName());
    }

    @Override
    public ASTNode visitCreateFile(DorisStatementParser.CreateFileContext ctx) {
        CreateFileStatement result = new CreateFileStatement(this.getDatabaseType());
        result.setFileName(this.getFileName(ctx.fileName()));
        if (null != ctx.databaseName()) {
            result.setDatabaseName(new IdentifierValue(ctx.databaseName().getText()).getValue());
        }
        if (null != ctx.propertiesClause()) {
            result.setProperties(this.extractPropertiesSegment(ctx.propertiesClause()));
        }
        return result;
    }

    @Override
    public ASTNode visitDropFile(DorisStatementParser.DropFileContext ctx) {
        DropFileStatement result = new DropFileStatement(this.getDatabaseType());
        result.setFileName(this.getFileName(ctx.fileName()));
        if (null != ctx.databaseName()) {
            result.setDatabaseName(new IdentifierValue(ctx.databaseName().getText()).getValue());
        }
        if (null != ctx.propertiesClause()) {
            result.setProperties(this.extractPropertiesSegment(ctx.propertiesClause()));
        }
        return result;
    }

    private String getFileName(DorisStatementParser.FileNameContext ctx) {
        if (null != ctx.identifier()) {
            return new IdentifierValue(ctx.identifier().getText()).getValue();
        }
        if (null != ctx.SINGLE_QUOTED_TEXT()) {
            return SQLUtils.getExactlyValue((String)ctx.SINGLE_QUOTED_TEXT().getText());
        }
        return SQLUtils.getExactlyValue((String)ctx.DOUBLE_QUOTED_TEXT().getText());
    }

    @Override
    public ASTNode visitAlterTable(DorisStatementParser.AlterTableContext ctx) {
        AlterTableStatement result = new AlterTableStatement(this.getDatabaseType());
        result.setTable((SimpleTableSegment)this.visit((ParseTree)ctx.tableName()));
        if (null == ctx.alterTableActions() || null == ctx.alterTableActions().alterCommandList() || null == ctx.alterTableActions().alterCommandList().alterList()) {
            return result;
        }
        for (AlterDefinitionSegment each : ((CollectionValue)this.visit((ParseTree)ctx.alterTableActions().alterCommandList().alterList())).getValue()) {
            this.setAlterDefinition(result, each);
        }
        return result;
    }

    private void setAlterDefinition(AlterTableStatement alterTableStatement, AlterDefinitionSegment alterDefinitionSegment) {
        if (alterDefinitionSegment instanceof AddColumnDefinitionSegment) {
            alterTableStatement.getAddColumnDefinitions().add((AddColumnDefinitionSegment)alterDefinitionSegment);
        } else if (alterDefinitionSegment instanceof ModifyColumnDefinitionSegment) {
            alterTableStatement.getModifyColumnDefinitions().add((ModifyColumnDefinitionSegment)alterDefinitionSegment);
        } else if (alterDefinitionSegment instanceof ChangeColumnDefinitionSegment) {
            alterTableStatement.getChangeColumnDefinitions().add((ChangeColumnDefinitionSegment)alterDefinitionSegment);
        } else if (alterDefinitionSegment instanceof DropColumnDefinitionSegment) {
            alterTableStatement.getDropColumnDefinitions().add((DropColumnDefinitionSegment)alterDefinitionSegment);
        } else if (alterDefinitionSegment instanceof AddConstraintDefinitionSegment) {
            alterTableStatement.getAddConstraintDefinitions().add((AddConstraintDefinitionSegment)alterDefinitionSegment);
        } else if (alterDefinitionSegment instanceof DropConstraintDefinitionSegment) {
            alterTableStatement.getDropConstraintDefinitions().add((DropConstraintDefinitionSegment)alterDefinitionSegment);
        } else if (alterDefinitionSegment instanceof RenameTableDefinitionSegment) {
            alterTableStatement.setRenameTable(((RenameTableDefinitionSegment)alterDefinitionSegment).getRenameTable());
        } else if (alterDefinitionSegment instanceof ReplaceTableDefinitionSegment) {
            alterTableStatement.setReplaceTable((ReplaceTableDefinitionSegment)alterDefinitionSegment);
        } else if (alterDefinitionSegment instanceof ConvertTableDefinitionSegment) {
            alterTableStatement.setConvertTableDefinition((ConvertTableDefinitionSegment)alterDefinitionSegment);
        } else if (alterDefinitionSegment instanceof DropIndexDefinitionSegment) {
            alterTableStatement.getDropIndexDefinitions().add((DropIndexDefinitionSegment)alterDefinitionSegment);
        } else if (alterDefinitionSegment instanceof RenameIndexDefinitionSegment) {
            alterTableStatement.getRenameIndexDefinitions().add((RenameIndexDefinitionSegment)alterDefinitionSegment);
        } else if (alterDefinitionSegment instanceof RenameColumnSegment) {
            alterTableStatement.getRenameColumnDefinitions().add((RenameColumnSegment)alterDefinitionSegment);
        } else if (alterDefinitionSegment instanceof RenameRollupDefinitionSegment) {
            alterTableStatement.getRenameRollupDefinitions().add((RenameRollupDefinitionSegment)alterDefinitionSegment);
        } else if (alterDefinitionSegment instanceof RenamePartitionDefinitionSegment) {
            alterTableStatement.getRenamePartitionDefinitions().add((RenamePartitionDefinitionSegment)alterDefinitionSegment);
        } else if (alterDefinitionSegment instanceof AlgorithmTypeSegment) {
            alterTableStatement.setAlgorithmSegment((AlgorithmTypeSegment)alterDefinitionSegment);
        } else if (alterDefinitionSegment instanceof LockTableSegment) {
            alterTableStatement.setLockTableSegment((LockTableSegment)alterDefinitionSegment);
        }
    }

    private ColumnDefinitionSegment generateColumnDefinitionSegment(ColumnSegment column, DorisStatementParser.FieldDefinitionContext ctx) {
        DataTypeSegment dataTypeSegment = (DataTypeSegment)this.visit((ParseTree)ctx.dataType());
        boolean isPrimaryKey = ctx.columnAttribute().stream().anyMatch(each -> null != each.KEY() && null == each.UNIQUE());
        boolean isAutoIncrement = ctx.columnAttribute().stream().anyMatch(each -> null != each.AUTO_INCREMENT());
        ColumnDefinitionSegment result = new ColumnDefinitionSegment(column.getStartIndex(), ctx.getStop().getStopIndex(), column, dataTypeSegment, isPrimaryKey, false, this.getText(ctx));
        result.setAutoIncrement(isAutoIncrement);
        return result;
    }

    private String getText(ParserRuleContext ctx) {
        return ctx.start.getInputStream().getText(new Interval(ctx.start.getStartIndex(), ctx.stop.getStopIndex()));
    }

    @Override
    public ASTNode visitAlterConstraint(DorisStatementParser.AlterConstraintContext ctx) {
        return new ModifyConstraintDefinitionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), (ConstraintSegment)this.visit((ParseTree)ctx.constraintName()));
    }

    @Override
    public ASTNode visitAlterList(DorisStatementParser.AlterListContext ctx) {
        CollectionValue result = new CollectionValue();
        if (ctx.alterListItem().isEmpty()) {
            return result;
        }
        result.getValue().addAll(this.getAlterDefinitionSegments(ctx));
        for (DorisStatementParser.AlterCommandsModifierContext each : ctx.alterCommandsModifier()) {
            if (null != each.alterAlgorithmOption()) {
                result.getValue().add((AlgorithmTypeSegment)this.visit((ParseTree)each));
                continue;
            }
            if (null == each.alterLockOption()) continue;
            result.getValue().add((LockTableSegment)this.visit((ParseTree)each));
        }
        return result;
    }

    private Collection<AlterDefinitionSegment> getAlterDefinitionSegments(DorisStatementParser.AlterListContext ctx) {
        LinkedList<AlterDefinitionSegment> result = new LinkedList<AlterDefinitionSegment>();
        for (DorisStatementParser.AlterListItemContext each : ctx.alterListItem()) {
            this.getAlterDefinitionSegment(ctx, each).ifPresent(result::add);
        }
        return result;
    }

    private Optional<AlterDefinitionSegment> getAlterDefinitionSegment(DorisStatementParser.AlterListContext alterListContext, DorisStatementParser.AlterListItemContext alterListItemContext) {
        if (alterListItemContext instanceof DorisStatementParser.AddColumnContext) {
            return Optional.of((AddColumnDefinitionSegment)this.visit((ParseTree)alterListItemContext));
        }
        if (alterListItemContext instanceof DorisStatementParser.AlterConstraintContext || alterListItemContext instanceof DorisStatementParser.AlterCheckContext) {
            return Optional.of((AlterDefinitionSegment)this.visit((ParseTree)alterListItemContext));
        }
        if (alterListItemContext instanceof DorisStatementParser.ChangeColumnContext) {
            return Optional.of(this.generateModifyColumnDefinitionSegment((DorisStatementParser.ChangeColumnContext)alterListItemContext));
        }
        if (alterListItemContext instanceof DorisStatementParser.ModifyColumnContext) {
            return Optional.of(this.generateModifyColumnDefinitionSegment((DorisStatementParser.ModifyColumnContext)alterListItemContext));
        }
        if (alterListItemContext instanceof DorisStatementParser.AlterTableDropContext) {
            return this.getDropItemDefinitionSegment(alterListContext, (DorisStatementParser.AlterTableDropContext)alterListItemContext);
        }
        if (alterListItemContext instanceof DorisStatementParser.AddTableConstraintContext) {
            return Optional.of((AddConstraintDefinitionSegment)this.visit((ParseTree)alterListItemContext));
        }
        if (alterListItemContext instanceof DorisStatementParser.AlterRenameTableContext) {
            return Optional.of((RenameTableDefinitionSegment)this.visit((ParseTree)alterListItemContext));
        }
        if (alterListItemContext instanceof DorisStatementParser.ReplaceTableContext) {
            return Optional.of((ReplaceTableDefinitionSegment)this.visit((ParseTree)alterListItemContext));
        }
        if (alterListItemContext instanceof DorisStatementParser.AlterConvertContext) {
            return Optional.of((ConvertTableDefinitionSegment)this.visit((ParseTree)alterListItemContext));
        }
        if (alterListItemContext instanceof DorisStatementParser.RenameColumnContext) {
            return Optional.of((RenameColumnSegment)this.visit((ParseTree)alterListItemContext));
        }
        if (alterListItemContext instanceof DorisStatementParser.RenameIndexContext) {
            return Optional.of((RenameIndexDefinitionSegment)this.visit((ParseTree)alterListItemContext));
        }
        if (alterListItemContext instanceof DorisStatementParser.RenameRollupContext) {
            return Optional.of((RenameRollupDefinitionSegment)this.visit((ParseTree)alterListItemContext));
        }
        if (alterListItemContext instanceof DorisStatementParser.RenamePartitionContext) {
            return Optional.of((RenamePartitionDefinitionSegment)this.visit((ParseTree)alterListItemContext));
        }
        return Optional.empty();
    }

    private Optional<AlterDefinitionSegment> getDropItemDefinitionSegment(DorisStatementParser.AlterListContext alterListContext, DorisStatementParser.AlterTableDropContext alterTableDrop) {
        if (null != alterTableDrop.CHECK() || null != alterTableDrop.CONSTRAINT()) {
            ConstraintSegment constraint = new ConstraintSegment(alterTableDrop.identifier().getStart().getStartIndex(), alterTableDrop.identifier().getStop().getStopIndex(), (IdentifierValue)this.visit((ParseTree)alterTableDrop.identifier()));
            return Optional.of(new DropConstraintDefinitionSegment(alterListContext.getStart().getStartIndex(), alterListContext.getStop().getStopIndex(), constraint));
        }
        if (null == alterTableDrop.KEY() && null == alterTableDrop.keyOrIndex()) {
            ColumnSegment column = new ColumnSegment(alterTableDrop.columnInternalRef.start.getStartIndex(), alterTableDrop.columnInternalRef.stop.getStopIndex(), (IdentifierValue)this.visit((ParseTree)alterTableDrop.columnInternalRef));
            return Optional.of(new DropColumnDefinitionSegment(alterTableDrop.getStart().getStartIndex(), alterTableDrop.getStop().getStopIndex(), Collections.singleton(column)));
        }
        if (null != alterTableDrop.keyOrIndex()) {
            return Optional.of(new DropIndexDefinitionSegment(alterListContext.getStart().getStartIndex(), alterListContext.getStop().getStopIndex(), (IndexSegment)this.visit((ParseTree)alterTableDrop.indexName())));
        }
        return Optional.empty();
    }

    @Override
    public ASTNode visitAlterAlgorithmOption(DorisStatementParser.AlterAlgorithmOptionContext ctx) {
        AlgorithmOption algorithmOption = null;
        if (null != ctx.INSTANT()) {
            algorithmOption = AlgorithmOption.INSTANT;
        } else if (null != ctx.DEFAULT()) {
            algorithmOption = AlgorithmOption.DEFAULT;
        } else if (null != ctx.INPLACE()) {
            algorithmOption = AlgorithmOption.INPLACE;
        } else if (null != ctx.COPY()) {
            algorithmOption = AlgorithmOption.COPY;
        }
        return new AlgorithmTypeSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), algorithmOption);
    }

    @Override
    public ASTNode visitAlterLockOption(DorisStatementParser.AlterLockOptionContext ctx) {
        LockTableOption lockOption = null;
        if (null != ctx.DEFAULT()) {
            lockOption = LockTableOption.DEFAULT;
        } else if (null != ctx.NONE()) {
            lockOption = LockTableOption.NONE;
        } else if (null != ctx.SHARED()) {
            lockOption = LockTableOption.SHARED;
        } else if (null != ctx.EXCLUSIVE()) {
            lockOption = LockTableOption.EXCLUSIVE;
        }
        return new LockTableSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), lockOption);
    }

    @Override
    public ASTNode visitAlterConvert(DorisStatementParser.AlterConvertContext ctx) {
        ConvertTableDefinitionSegment result = new ConvertTableDefinitionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), (CharsetNameSegment)this.visit((ParseTree)ctx.charsetName()));
        if (null != ctx.collateClause()) {
            result.setCollateValue((SimpleExpressionSegment)this.visit((ParseTree)ctx.collateClause()));
        }
        return result;
    }

    @Override
    public ASTNode visitCharsetName(DorisStatementParser.CharsetNameContext ctx) {
        return new CharsetNameSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), ctx.getText());
    }

    @Override
    public ASTNode visitAddTableConstraint(DorisStatementParser.AddTableConstraintContext ctx) {
        return new AddConstraintDefinitionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), (ConstraintDefinitionSegment)this.visit((ParseTree)ctx.tableConstraintDef()));
    }

    @Override
    public ASTNode visitAlterCheck(DorisStatementParser.AlterCheckContext ctx) {
        return new ModifyConstraintDefinitionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), (ConstraintSegment)this.visit((ParseTree)ctx.constraintName()));
    }

    @Override
    public ASTNode visitAlterRenameTable(DorisStatementParser.AlterRenameTableContext ctx) {
        RenameTableDefinitionSegment result = new RenameTableDefinitionSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex());
        result.setRenameTable((SimpleTableSegment)this.visit((ParseTree)ctx.tableName()));
        return result;
    }

    @Override
    public ASTNode visitReplaceTable(DorisStatementParser.ReplaceTableContext ctx) {
        ReplaceTableDefinitionSegment result = new ReplaceTableDefinitionSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex());
        result.setReplaceTable((SimpleTableSegment)this.visit((ParseTree)ctx.tableName()));
        if (null != ctx.propertiesClause()) {
            result.setProperties(this.extractPropertiesSegment(ctx.propertiesClause()));
        }
        return result;
    }

    @Override
    public ASTNode visitRenameTable(DorisStatementParser.RenameTableContext ctx) {
        LinkedList<RenameTableDefinitionSegment> renameTables = new LinkedList<RenameTableDefinitionSegment>();
        int len = ctx.tableName().size();
        for (int i = 0; i < len; i += 2) {
            DorisStatementParser.TableNameContext tableName = ctx.tableName(i);
            DorisStatementParser.TableNameContext renameTableName = ctx.tableName(i + 1);
            renameTables.add(this.createRenameTableDefinitionSegment(tableName, renameTableName));
        }
        return new RenameTableStatement(this.getDatabaseType(), renameTables);
    }

    private RenameTableDefinitionSegment createRenameTableDefinitionSegment(DorisStatementParser.TableNameContext tableName, DorisStatementParser.TableNameContext renameTableName) {
        RenameTableDefinitionSegment result = new RenameTableDefinitionSegment(tableName.start.getStartIndex(), renameTableName.stop.getStopIndex());
        result.setTable((SimpleTableSegment)this.visit((ParseTree)tableName));
        result.setRenameTable((SimpleTableSegment)this.visit((ParseTree)renameTableName));
        return result;
    }

    private ModifyColumnDefinitionSegment generateModifyColumnDefinitionSegment(DorisStatementParser.ModifyColumnContext ctx) {
        ColumnSegment column = new ColumnSegment(ctx.columnInternalRef.start.getStartIndex(), ctx.columnInternalRef.stop.getStopIndex(), (IdentifierValue)this.visit((ParseTree)ctx.columnInternalRef));
        ModifyColumnDefinitionSegment result = new ModifyColumnDefinitionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), this.generateColumnDefinitionSegment(column, ctx.fieldDefinition()));
        if (null != ctx.place()) {
            result.setColumnPosition((ColumnPositionSegment)this.visit((ParseTree)ctx.place()));
        }
        return result;
    }

    private ChangeColumnDefinitionSegment generateModifyColumnDefinitionSegment(DorisStatementParser.ChangeColumnContext ctx) {
        ChangeColumnDefinitionSegment result = new ChangeColumnDefinitionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), (ColumnDefinitionSegment)this.visit((ParseTree)ctx.columnDefinition()));
        result.setPreviousColumn(new ColumnSegment(ctx.columnInternalRef.getStart().getStartIndex(), ctx.columnInternalRef.getStop().getStopIndex(), new IdentifierValue(ctx.columnInternalRef.getText())));
        if (null != ctx.place()) {
            result.setColumnPosition((ColumnPositionSegment)this.visit((ParseTree)ctx.place()));
        }
        return result;
    }

    @Override
    public ASTNode visitAddColumn(DorisStatementParser.AddColumnContext ctx) {
        LinkedList<ColumnDefinitionSegment> columnDefinitions = new LinkedList<ColumnDefinitionSegment>();
        if (null != ctx.columnDefinition()) {
            columnDefinitions.add((ColumnDefinitionSegment)this.visit((ParseTree)ctx.columnDefinition()));
        }
        if (null != ctx.tableElementList()) {
            for (DorisStatementParser.TableElementContext each : ctx.tableElementList().tableElement()) {
                if (null == each.columnDefinition()) continue;
                columnDefinitions.add((ColumnDefinitionSegment)this.visit((ParseTree)each.columnDefinition()));
            }
        }
        AddColumnDefinitionSegment result = new AddColumnDefinitionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), columnDefinitions);
        if (null != ctx.place()) {
            Preconditions.checkState((1 == columnDefinitions.size() ? 1 : 0) != 0);
            result.setColumnPosition((ColumnPositionSegment)this.visit((ParseTree)ctx.place()));
        }
        return result;
    }

    @Override
    public ASTNode visitRenameColumn(DorisStatementParser.RenameColumnContext ctx) {
        ColumnSegment oldColumnSegment = (ColumnSegment)this.visit((ParseTree)ctx.oldColumn());
        ColumnSegment newColumnSegment = (ColumnSegment)this.visit((ParseTree)ctx.newColumn());
        return new RenameColumnSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), oldColumnSegment, newColumnSegment);
    }

    @Override
    public ASTNode visitColumnDefinition(DorisStatementParser.ColumnDefinitionContext ctx) {
        ColumnSegment column = new ColumnSegment(ctx.column_name.start.getStartIndex(), ctx.column_name.stop.getStopIndex(), (IdentifierValue)this.visit((ParseTree)ctx.column_name));
        DataTypeSegment dataTypeSegment = (DataTypeSegment)this.visit((ParseTree)ctx.fieldDefinition().dataType());
        boolean isPrimaryKey = ctx.fieldDefinition().columnAttribute().stream().anyMatch(each -> null != each.KEY() && null == each.UNIQUE());
        boolean isAutoIncrement = ctx.fieldDefinition().columnAttribute().stream().anyMatch(each -> null != each.AUTO_INCREMENT());
        boolean isNotNull = ctx.fieldDefinition().columnAttribute().stream().anyMatch(each -> null != each.NOT() && null != each.NULL());
        ColumnDefinitionSegment result = new ColumnDefinitionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), column, dataTypeSegment, isPrimaryKey, isNotNull, this.getText(ctx));
        result.getReferencedTables().addAll(this.getReferencedTables(ctx));
        result.setAutoIncrement(isAutoIncrement);
        return result;
    }

    private Collection<SimpleTableSegment> getReferencedTables(DorisStatementParser.ColumnDefinitionContext ctx) {
        LinkedList<SimpleTableSegment> result = new LinkedList<SimpleTableSegment>();
        if (null != ctx.referenceDefinition()) {
            result.add((SimpleTableSegment)this.visit((ParseTree)ctx.referenceDefinition()));
        }
        return result;
    }

    @Override
    public ASTNode visitTableConstraintDef(DorisStatementParser.TableConstraintDefContext ctx) {
        ConstraintDefinitionSegment result = new ConstraintDefinitionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex());
        if (null != ctx.constraintClause() && null != ctx.constraintClause().constraintName()) {
            result.setConstraintName((ConstraintSegment)this.visit((ParseTree)ctx.constraintClause().constraintName()));
        }
        if (null != ctx.KEY() && null != ctx.PRIMARY()) {
            result.setPrimaryKey(true);
            result.getPrimaryKeyColumns().addAll(((CollectionValue)this.visit((ParseTree)ctx.keyListWithExpression())).getValue());
            return result;
        }
        if (null != ctx.FOREIGN()) {
            result.setReferencedTable((SimpleTableSegment)this.visit((ParseTree)ctx.referenceDefinition()));
            return result;
        }
        if (null != ctx.UNIQUE()) {
            result.setUniqueKey(true);
            result.getIndexColumns().addAll(((CollectionValue)this.visit((ParseTree)ctx.keyListWithExpression())).getValue());
            if (null != ctx.indexName()) {
                result.setIndexName((IndexSegment)this.visit((ParseTree)ctx.indexName()));
            }
            return result;
        }
        if (null != ctx.checkConstraint()) {
            return result;
        }
        result.getIndexColumns().addAll(((CollectionValue)this.visit((ParseTree)ctx.keyListWithExpression())).getValue());
        if (null != ctx.indexName()) {
            result.setIndexName((IndexSegment)this.visit((ParseTree)ctx.indexName()));
        }
        return result;
    }

    @Override
    public ASTNode visitKeyListWithExpression(DorisStatementParser.KeyListWithExpressionContext ctx) {
        CollectionValue result = new CollectionValue();
        for (DorisStatementParser.KeyPartWithExpressionContext each : ctx.keyPartWithExpression()) {
            if (null == each.keyPart()) continue;
            result.getValue().add((ColumnSegment)this.visit((ParseTree)each.keyPart().columnName()));
        }
        return result;
    }

    @Override
    public ASTNode visitReferenceDefinition(DorisStatementParser.ReferenceDefinitionContext ctx) {
        return (ASTNode)this.visit((ParseTree)ctx.tableName());
    }

    @Override
    public ASTNode visitPlace(DorisStatementParser.PlaceContext ctx) {
        ColumnSegment columnName = null;
        if (null != ctx.columnName()) {
            columnName = (ColumnSegment)this.visit((ParseTree)ctx.columnName());
        }
        return null == ctx.columnName() ? new ColumnFirstPositionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), columnName) : new ColumnAfterPositionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), columnName);
    }

    @Override
    public ASTNode visitDropTable(DorisStatementParser.DropTableContext ctx) {
        DropTableStatement result = new DropTableStatement(this.getDatabaseType());
        result.setIfExists(null != ctx.ifExists());
        result.getTables().addAll(((CollectionValue)this.visit((ParseTree)ctx.tableList())).getValue());
        return result;
    }

    @Override
    public ASTNode visitTruncateTable(DorisStatementParser.TruncateTableContext ctx) {
        return new TruncateStatement(this.getDatabaseType(), Collections.singleton((SimpleTableSegment)this.visit((ParseTree)ctx.tableName())));
    }

    @Override
    public ASTNode visitCreateIndex(DorisStatementParser.CreateIndexContext ctx) {
        CreateIndexStatement result = new CreateIndexStatement(this.getDatabaseType());
        result.setTable((SimpleTableSegment)this.visit((ParseTree)ctx.tableName()));
        result.setIfNotExists(null != ctx.ifNotExists());
        IndexNameSegment indexName = new IndexNameSegment(ctx.indexName().start.getStartIndex(), ctx.indexName().stop.getStopIndex(), new IdentifierValue(ctx.indexName().getText()));
        result.setIndex(new IndexSegment(ctx.indexName().start.getStartIndex(), ctx.indexName().stop.getStopIndex(), indexName));
        result.getColumns().addAll(((CollectionValue)this.visit((ParseTree)ctx.keyListWithExpression())).getValue());
        if (null != ctx.dorisIndexTypeClause()) {
            result.setIndexType(ctx.dorisIndexTypeClause().getStop().getText());
        }
        if (null != ctx.propertiesClause()) {
            result.setProperties(this.extractPropertiesSegment(ctx.propertiesClause()));
        }
        if (null != ctx.commentClause() && null != ctx.commentClause().literals()) {
            String commentText = SQLUtils.getExactlyValue((String)ctx.commentClause().literals().getText());
            result.setComment(commentText);
            CommentSegment commentSegment = new CommentSegment(commentText, ctx.commentClause().literals().getStart().getStartIndex(), ctx.commentClause().literals().getStop().getStopIndex());
            result.getComments().add(commentSegment);
        }
        if (null != ctx.algorithmOptionAndLockOption()) {
            if (null != ctx.algorithmOptionAndLockOption().alterAlgorithmOption()) {
                result.setAlgorithmType((AlgorithmTypeSegment)this.visit((ParseTree)ctx.algorithmOptionAndLockOption().alterAlgorithmOption()));
            }
            if (null != ctx.algorithmOptionAndLockOption().alterLockOption()) {
                result.setLockTable((LockTableSegment)this.visit((ParseTree)ctx.algorithmOptionAndLockOption().alterLockOption()));
            }
        }
        return result;
    }

    @Override
    public ASTNode visitDropIndex(DorisStatementParser.DropIndexContext ctx) {
        DropIndexStatement result = new DropIndexStatement(this.getDatabaseType());
        result.setIfExists(null != ctx.ifExists());
        result.setSimpleTable((SimpleTableSegment)this.visit((ParseTree)ctx.tableName()));
        IndexNameSegment indexName = new IndexNameSegment(ctx.indexName().start.getStartIndex(), ctx.indexName().stop.getStopIndex(), new IdentifierValue(ctx.indexName().getText()));
        result.getIndexes().add(new IndexSegment(ctx.indexName().start.getStartIndex(), ctx.indexName().stop.getStopIndex(), indexName));
        if (null != ctx.algorithmOptionAndLockOption()) {
            if (null != ctx.algorithmOptionAndLockOption().alterAlgorithmOption()) {
                result.setAlgorithmType((AlgorithmTypeSegment)this.visit((ParseTree)ctx.algorithmOptionAndLockOption().alterAlgorithmOption()));
            }
            if (null != ctx.algorithmOptionAndLockOption().alterLockOption()) {
                result.setLockTable((LockTableSegment)this.visit((ParseTree)ctx.algorithmOptionAndLockOption().alterLockOption()));
            }
        }
        return result;
    }

    @Override
    public ASTNode visitRenameIndex(DorisStatementParser.RenameIndexContext ctx) {
        IndexSegment indexNameSegment = (IndexSegment)this.visitIndexName(ctx.indexName(0));
        IndexSegment renameIndexName = (IndexSegment)this.visitIndexName(ctx.indexName(1));
        return new RenameIndexDefinitionSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), indexNameSegment, renameIndexName);
    }

    @Override
    public ASTNode visitBuildIndex(DorisStatementParser.BuildIndexContext ctx) {
        BuildIndexStatement result = new BuildIndexStatement(this.getDatabaseType());
        result.setTable((SimpleTableSegment)this.visit((ParseTree)ctx.tableName()));
        IndexNameSegment indexName = new IndexNameSegment(ctx.indexName().start.getStartIndex(), ctx.indexName().stop.getStopIndex(), new IdentifierValue(ctx.indexName().getText()));
        result.setIndex(new IndexSegment(ctx.indexName().start.getStartIndex(), ctx.indexName().stop.getStopIndex(), indexName));
        if (null != ctx.partitionNames()) {
            for (DorisStatementParser.IdentifierContext each : ctx.partitionNames().identifier()) {
                PartitionSegment partitionSegment = new PartitionSegment(each.getStart().getStartIndex(), each.getStop().getStopIndex(), (IdentifierValue)this.visit((ParseTree)each));
                result.getPartitions().add(partitionSegment);
            }
        }
        return result;
    }

    @Override
    public ASTNode visitCancelBuildIndex(DorisStatementParser.CancelBuildIndexContext ctx) {
        CancelBuildIndexStatement result = new CancelBuildIndexStatement(this.getDatabaseType());
        result.setTable((SimpleTableSegment)this.visit((ParseTree)ctx.tableName()));
        if (null != ctx.jobIdList()) {
            for (DorisStatementParser.JobIdContext each : ctx.jobIdList().jobId()) {
                result.getJobIds().add(each.getText());
            }
        }
        return result;
    }

    @Override
    public ASTNode visitCancelAlterTable(DorisStatementParser.CancelAlterTableContext ctx) {
        CancelAlterTableStatement result = new CancelAlterTableStatement(this.getDatabaseType());
        result.setTable((SimpleTableSegment)this.visit((ParseTree)ctx.tableName()));
        if (null != ctx.COLUMN()) {
            result.setAlterType("COLUMN");
        } else if (null != ctx.MATERIALIZED()) {
            result.setAlterType("MATERIALIZED VIEW");
        } else if (null != ctx.ROLLUP()) {
            result.setAlterType("ROLLUP");
        }
        if (null != ctx.jobIdList()) {
            for (DorisStatementParser.JobIdContext each : ctx.jobIdList().jobId()) {
                result.getJobIds().add(each.getText());
            }
        }
        return result;
    }

    @Override
    public ASTNode visitRenameRollup(DorisStatementParser.RenameRollupContext ctx) {
        RollupSegment oldRollupSegment = new RollupSegment(ctx.oldRollupName.getStart().getStartIndex(), ctx.oldRollupName.getStop().getStopIndex(), (IdentifierValue)this.visit((ParseTree)ctx.oldRollupName));
        RollupSegment newRollupSegment = new RollupSegment(ctx.newRollupName.getStart().getStartIndex(), ctx.newRollupName.getStop().getStopIndex(), (IdentifierValue)this.visit((ParseTree)ctx.newRollupName));
        return new RenameRollupDefinitionSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), oldRollupSegment, newRollupSegment);
    }

    @Override
    public ASTNode visitRenamePartition(DorisStatementParser.RenamePartitionContext ctx) {
        PartitionSegment oldPartitionSegment = new PartitionSegment(ctx.oldPartitionName.getStart().getStartIndex(), ctx.oldPartitionName.getStop().getStopIndex(), (IdentifierValue)this.visit((ParseTree)ctx.oldPartitionName));
        PartitionSegment newPartitionSegment = new PartitionSegment(ctx.newPartitionName.getStart().getStartIndex(), ctx.newPartitionName.getStop().getStopIndex(), (IdentifierValue)this.visit((ParseTree)ctx.newPartitionName));
        return new RenamePartitionDefinitionSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), oldPartitionSegment, newPartitionSegment);
    }

    @Override
    public ASTNode visitAlterStoragePolicy(DorisStatementParser.AlterStoragePolicyContext ctx) {
        IdentifierValue identifier = (IdentifierValue)this.visit((ParseTree)ctx.identifier());
        PolicyNameSegment policyNameSegment = new PolicyNameSegment(ctx.identifier().getStart().getStartIndex(), ctx.identifier().getStop().getStopIndex(), identifier);
        PropertiesSegment propertiesSegment = this.extractPropertiesSegment(ctx.propertiesClause());
        return new DorisAlterStoragePolicyStatement(this.getDatabaseType(), policyNameSegment, propertiesSegment);
    }

    private PropertiesSegment extractPropertiesSegment(DorisStatementParser.PropertiesClauseContext ctx) {
        PropertiesSegment result = new PropertiesSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex());
        for (DorisStatementParser.PropertyContext each : ctx.properties().property()) {
            String key = this.getPropertyKey(each);
            String value = this.getPropertyValue(each);
            PropertySegment propertySegment = new PropertySegment(each.getStart().getStartIndex(), each.getStop().getStopIndex(), key, value);
            result.getProperties().add(propertySegment);
        }
        return result;
    }

    private String getPropertyValue(DorisStatementParser.PropertyContext ctx) {
        return SQLUtils.getExactlyValue((String)ctx.literals().getText());
    }

    @Override
    public ASTNode visitKeyParts(DorisStatementParser.KeyPartsContext ctx) {
        CollectionValue result = new CollectionValue();
        List<DorisStatementParser.KeyPartContext> keyParts = ctx.keyPart();
        for (DorisStatementParser.KeyPartContext each : keyParts) {
            if (null == each.columnName()) continue;
            result.getValue().add((ColumnSegment)this.visit((ParseTree)each.columnName()));
        }
        return result;
    }

    @Override
    public ASTNode visitCreateProcedure(DorisStatementParser.CreateProcedureContext ctx) {
        CreateProcedureStatement result = new CreateProcedureStatement(this.getDatabaseType());
        result.setProcedureName((FunctionNameSegment)this.visit((ParseTree)ctx.functionName()));
        result.setRoutineBody((RoutineBodySegment)this.visit((ParseTree)ctx.routineBody()));
        return result;
    }

    @Override
    public ASTNode visitFunctionName(DorisStatementParser.FunctionNameContext ctx) {
        FunctionNameSegment result = new FunctionNameSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), (IdentifierValue)this.visit((ParseTree)ctx.identifier()));
        if (null != ctx.owner()) {
            result.setOwner((OwnerSegment)this.visit((ParseTree)ctx.owner()));
        }
        return result;
    }

    @Override
    public ASTNode visitAlterProcedure(DorisStatementParser.AlterProcedureContext ctx) {
        return new AlterProcedureStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitDropProcedure(DorisStatementParser.DropProcedureContext ctx) {
        return new DropProcedureStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitCreateFunction(DorisStatementParser.CreateFunctionContext ctx) {
        DorisCreateFunctionStatement result = new DorisCreateFunctionStatement(this.getDatabaseType());
        result.setFunctionName((FunctionNameSegment)this.visit((ParseTree)ctx.functionName()));
        if (null != ctx.routineBody()) {
            int paramIndex = 0;
            for (int i = 0; i < ctx.dataType().size(); ++i) {
                DataTypeSegment dataType = (DataTypeSegment)this.visit((ParseTree)ctx.dataType(i));
                if (i == ctx.dataType().size() - 1 && null != ctx.RETURNS()) {
                    result.setReturnType(dataType);
                    continue;
                }
                if (paramIndex >= ctx.identifier().size()) continue;
                IdentifierValue paramName = (IdentifierValue)this.visit((ParseTree)ctx.identifier(paramIndex));
                result.getNamedParameters().put(paramName, dataType);
                ++paramIndex;
            }
            result.setRoutineBody((RoutineBodySegment)this.visit((ParseTree)ctx.routineBody()));
        } else {
            int i;
            int dataTypeCount;
            if (null != ctx.GLOBAL()) {
                result.setGlobal(true);
            }
            if (null != ctx.AGGREGATE()) {
                result.setFunctionType(DorisCreateFunctionStatement.FunctionType.AGGREGATE);
            } else if (null != ctx.TABLES()) {
                result.setFunctionType(DorisCreateFunctionStatement.FunctionType.TABLES);
            } else if (null != ctx.ALIAS()) {
                result.setFunctionType(DorisCreateFunctionStatement.FunctionType.ALIAS);
            }
            int parameterCount = dataTypeCount = ctx.dataType().size();
            if (null != ctx.INTERMEDIATE()) {
                --parameterCount;
            }
            if (null != ctx.RETURNS()) {
                --parameterCount;
            }
            for (i = 0; i < parameterCount; ++i) {
                result.getParameterDataTypes().add((DataTypeSegment)this.visit((ParseTree)ctx.dataType(i)));
            }
            if (null != ctx.RETURNS()) {
                result.setReturnType((DataTypeSegment)this.visit((ParseTree)ctx.dataType(parameterCount)));
            }
            if (null != ctx.INTERMEDIATE()) {
                int intermediateTypeIndex = dataTypeCount - 1;
                result.setIntermediateType((DataTypeSegment)this.visit((ParseTree)ctx.dataType(intermediateTypeIndex)));
            }
            if (null != ctx.PARAMETER()) {
                for (i = 0; i < ctx.identifier().size(); ++i) {
                    result.getWithParameters().add((IdentifierValue)this.visit((ParseTree)ctx.identifier(i)));
                }
            }
            if (null != ctx.expr()) {
                result.setAliasExpression((ExpressionSegment)this.visit((ParseTree)ctx.expr()));
            }
            if (null != ctx.PROPERTIES()) {
                this.fillCreateFunctionProperties(ctx, result);
            }
        }
        return result;
    }

    private void fillCreateFunctionProperties(DorisStatementParser.CreateFunctionContext ctx, DorisCreateFunctionStatement statement) {
        for (int i = 0; i < ctx.properties().property().size(); ++i) {
            String key = this.getPropertyKey(ctx.properties().property(i));
            String value = SQLUtils.getExactlyValue((String)ctx.properties().property(i).literals().getText());
            statement.getProperties().put(key, value);
        }
    }

    private String getPropertyKey(DorisStatementParser.PropertyContext property) {
        if (null != property.SINGLE_QUOTED_TEXT()) {
            return SQLUtils.getExactlyValue((String)property.SINGLE_QUOTED_TEXT().getText());
        }
        if (null != property.DOUBLE_QUOTED_TEXT()) {
            return SQLUtils.getExactlyValue((String)property.DOUBLE_QUOTED_TEXT().getText());
        }
        return SQLUtils.getExactlyValue((String)property.identifier().getText());
    }

    @Override
    public ASTNode visitRoutineBody(DorisStatementParser.RoutineBodyContext ctx) {
        RoutineBodySegment result = new RoutineBodySegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex());
        CollectionValue validStatements = null == ctx.simpleStatement() ? (CollectionValue)this.visit((ParseTree)ctx.compoundStatement()) : (CollectionValue)this.visit((ParseTree)ctx.simpleStatement());
        result.getValidStatements().addAll(validStatements.getValue());
        return result;
    }

    @Override
    public ASTNode visitSimpleStatement(DorisStatementParser.SimpleStatementContext ctx) {
        return (ASTNode)this.visit((ParseTree)ctx.validStatement());
    }

    @Override
    public ASTNode visitCompoundStatement(DorisStatementParser.CompoundStatementContext ctx) {
        return (ASTNode)this.visit((ParseTree)ctx.beginStatement());
    }

    @Override
    public ASTNode visitBeginStatement(DorisStatementParser.BeginStatementContext ctx) {
        CollectionValue result = new CollectionValue();
        for (DorisStatementParser.ValidStatementContext each : ctx.validStatement()) {
            result.combine((CollectionValue)this.visit((ParseTree)each));
        }
        return result;
    }

    @Override
    public ASTNode visitValidStatement(DorisStatementParser.ValidStatementContext ctx) {
        CollectionValue result = new CollectionValue();
        ValidStatementSegment validStatement = this.createValidStatementSegment(ctx);
        if (null != validStatement.getSqlStatement()) {
            result.getValue().add(validStatement);
        }
        if (null != ctx.beginStatement()) {
            result.combine((CollectionValue)this.visit((ParseTree)ctx.beginStatement()));
        }
        if (null != ctx.flowControlStatement()) {
            result.combine((CollectionValue)this.visit((ParseTree)ctx.flowControlStatement()));
        }
        return result;
    }

    private ValidStatementSegment createValidStatementSegment(DorisStatementParser.ValidStatementContext ctx) {
        ValidStatementSegment result = new ValidStatementSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex());
        CreateTableStatement sqlStatement = null;
        if (null != ctx.createTable()) {
            sqlStatement = (CreateTableStatement)this.visit((ParseTree)ctx.createTable());
        } else if (null != ctx.alterTable()) {
            sqlStatement = (AlterTableStatement)this.visit((ParseTree)ctx.alterTable());
        } else if (null != ctx.dropTable()) {
            sqlStatement = (DropTableStatement)this.visit((ParseTree)ctx.dropTable());
        } else if (null != ctx.truncateTable()) {
            sqlStatement = (TruncateStatement)this.visit((ParseTree)ctx.truncateTable());
        } else if (null != ctx.insert()) {
            sqlStatement = (InsertStatement)this.visit((ParseTree)ctx.insert());
        } else if (null != ctx.replace()) {
            sqlStatement = (InsertStatement)this.visit((ParseTree)ctx.replace());
        } else if (null != ctx.update()) {
            sqlStatement = (UpdateStatement)this.visit((ParseTree)ctx.update());
        } else if (null != ctx.delete()) {
            sqlStatement = (DeleteStatement)this.visit((ParseTree)ctx.delete());
        } else if (null != ctx.select()) {
            sqlStatement = (SelectStatement)this.visit((ParseTree)ctx.select());
        }
        result.setSqlStatement((SQLStatement)sqlStatement);
        return result;
    }

    @Override
    public ASTNode visitFlowControlStatement(DorisStatementParser.FlowControlStatementContext ctx) {
        CollectionValue result = new CollectionValue();
        if (null != ctx.caseStatement()) {
            result.combine((CollectionValue)this.visit((ParseTree)ctx.caseStatement()));
        }
        if (null != ctx.ifStatement()) {
            result.combine((CollectionValue)this.visit((ParseTree)ctx.ifStatement()));
        }
        if (null != ctx.loopStatement()) {
            result.combine((CollectionValue)this.visit((ParseTree)ctx.loopStatement()));
        }
        if (null != ctx.repeatStatement()) {
            result.combine((CollectionValue)this.visit((ParseTree)ctx.repeatStatement()));
        }
        if (null != ctx.whileStatement()) {
            result.combine((CollectionValue)this.visit((ParseTree)ctx.whileStatement()));
        }
        return result;
    }

    @Override
    public ASTNode visitCaseStatement(DorisStatementParser.CaseStatementContext ctx) {
        CollectionValue result = new CollectionValue();
        for (DorisStatementParser.ValidStatementContext each : ctx.validStatement()) {
            result.combine((CollectionValue)this.visit((ParseTree)each));
        }
        return result;
    }

    @Override
    public ASTNode visitIfStatement(DorisStatementParser.IfStatementContext ctx) {
        CollectionValue result = new CollectionValue();
        for (DorisStatementParser.ValidStatementContext each : ctx.validStatement()) {
            result.combine((CollectionValue)this.visit((ParseTree)each));
        }
        return result;
    }

    @Override
    public ASTNode visitLoopStatement(DorisStatementParser.LoopStatementContext ctx) {
        CollectionValue result = new CollectionValue();
        for (DorisStatementParser.ValidStatementContext each : ctx.validStatement()) {
            result.combine((CollectionValue)this.visit((ParseTree)each));
        }
        return result;
    }

    @Override
    public ASTNode visitRepeatStatement(DorisStatementParser.RepeatStatementContext ctx) {
        CollectionValue result = new CollectionValue();
        for (DorisStatementParser.ValidStatementContext each : ctx.validStatement()) {
            result.combine((CollectionValue)this.visit((ParseTree)each));
        }
        return result;
    }

    @Override
    public ASTNode visitWhileStatement(DorisStatementParser.WhileStatementContext ctx) {
        CollectionValue result = new CollectionValue();
        for (DorisStatementParser.ValidStatementContext each : ctx.validStatement()) {
            result.combine((CollectionValue)this.visit((ParseTree)each));
        }
        return result;
    }

    @Override
    public ASTNode visitAlterFunction(DorisStatementParser.AlterFunctionContext ctx) {
        return new AlterFunctionStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitDorisDropFunction(DorisStatementParser.DorisDropFunctionContext ctx) {
        DorisDropFunctionStatement result = new DorisDropFunctionStatement(this.getDatabaseType());
        result.setGlobal(null != ctx.GLOBAL());
        result.setFunctionName((FunctionNameSegment)this.visit((ParseTree)ctx.functionName()));
        for (int i = 0; i < ctx.dataType().size(); ++i) {
            result.getParameterDataTypes().add((DataTypeSegment)this.visit((ParseTree)ctx.dataType(i)));
        }
        return result;
    }

    @Override
    public ASTNode visitCreateEvent(DorisStatementParser.CreateEventContext ctx) {
        return new MySQLCreateEventStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitAlterEvent(DorisStatementParser.AlterEventContext ctx) {
        return new MySQLAlterEventStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitDropEvent(DorisStatementParser.DropEventContext ctx) {
        return new MySQLDropEventStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitAlterInstance(DorisStatementParser.AlterInstanceContext ctx) {
        return new MySQLAlterInstanceStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitCreateLogfileGroup(DorisStatementParser.CreateLogfileGroupContext ctx) {
        return new MySQLCreateLogfileGroupStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitAlterLogfileGroup(DorisStatementParser.AlterLogfileGroupContext ctx) {
        return new MySQLAlterLogfileGroupStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitDropLogfileGroup(DorisStatementParser.DropLogfileGroupContext ctx) {
        return new MySQLDropLogfileGroupStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitCreateServer(DorisStatementParser.CreateServerContext ctx) {
        return new CreateServerStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitAlterServer(DorisStatementParser.AlterServerContext ctx) {
        return new AlterServerStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitDropServer(DorisStatementParser.DropServerContext ctx) {
        return new DropServerStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitCreateTrigger(DorisStatementParser.CreateTriggerContext ctx) {
        return new CreateTriggerStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitDropTrigger(DorisStatementParser.DropTriggerContext ctx) {
        return new DropTriggerStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitCreateTablespace(DorisStatementParser.CreateTablespaceContext ctx) {
        return new CreateTablespaceStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitAlterTablespace(DorisStatementParser.AlterTablespaceContext ctx) {
        if (null != ctx.alterTablespaceInnodb()) {
            return (ASTNode)this.visit((ParseTree)ctx.alterTablespaceInnodb());
        }
        return (ASTNode)this.visit((ParseTree)ctx.alterTablespaceNdb());
    }

    @Override
    public ASTNode visitAlterTablespaceInnodb(DorisStatementParser.AlterTablespaceInnodbContext ctx) {
        return new AlterTablespaceStatement(this.getDatabaseType(), null == ctx.tablespace ? null : this.createTablespaceSegment(ctx.tablespace), null == ctx.renameTablespace ? null : this.createTablespaceSegment(ctx.renameTablespace));
    }

    @Override
    public ASTNode visitAlterTablespaceNdb(DorisStatementParser.AlterTablespaceNdbContext ctx) {
        return new AlterTablespaceStatement(this.getDatabaseType(), null == ctx.tablespace ? null : this.createTablespaceSegment(ctx.tablespace), null == ctx.renameTableSpace ? null : this.createTablespaceSegment(ctx.renameTableSpace));
    }

    private TablespaceSegment createTablespaceSegment(DorisStatementParser.IdentifierContext ctx) {
        return new TablespaceSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), (IdentifierValue)this.visit((ParseTree)ctx));
    }

    @Override
    public ASTNode visitDropTablespace(DorisStatementParser.DropTablespaceContext ctx) {
        return new DropTablespaceStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitPrepare(DorisStatementParser.PrepareContext ctx) {
        return new PrepareStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitExecuteStmt(DorisStatementParser.ExecuteStmtContext ctx) {
        return new ExecuteStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitDeallocate(DorisStatementParser.DeallocateContext ctx) {
        return new DeallocateStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitCreateMaterializedView(DorisStatementParser.CreateMaterializedViewContext ctx) {
        return new CreateMaterializedViewStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitCreateEncryptKey(DorisStatementParser.CreateEncryptKeyContext ctx) {
        return new CreateEncryptKeyStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitDropEncryptKey(DorisStatementParser.DropEncryptKeyContext ctx) {
        return new DropEncryptKeyStatement(this.getDatabaseType());
    }
}

