/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.engine.doris.visitor.statement.type;

import java.util.Collection;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.RuleContext;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.sql.parser.api.ASTNode;
import org.apache.shardingsphere.sql.parser.api.visitor.statement.type.DCLStatementVisitor;
import org.apache.shardingsphere.sql.parser.autogen.DorisStatementParser;
import org.apache.shardingsphere.sql.parser.engine.doris.visitor.statement.DorisStatementVisitor;
import org.apache.shardingsphere.sql.parser.statement.core.enums.ACLAttributeType;
import org.apache.shardingsphere.sql.parser.statement.core.enums.SSLType;
import org.apache.shardingsphere.sql.parser.statement.core.enums.UserResourceSpecifiedLimitType;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dcl.PasswordOrLockOptionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dcl.PrivilegeSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dcl.RoleOrPrivilegeSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dcl.TLSOptionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dcl.UserResourceSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dcl.UserSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.GrantLevelSegment;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dcl.role.CreateRoleStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dcl.role.DropRoleStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dcl.role.SetRoleStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dcl.user.AlterUserStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dcl.user.DropUserStatement;
import org.apache.shardingsphere.sql.parser.statement.core.value.identifier.IdentifierValue;
import org.apache.shardingsphere.sql.parser.statement.core.value.literal.impl.NumberLiteralValue;
import org.apache.shardingsphere.sql.parser.statement.core.value.literal.impl.StringLiteralValue;
import org.apache.shardingsphere.sql.parser.statement.mysql.dcl.MySQLGrantStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dcl.MySQLRevokeStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dcl.role.MySQLSetDefaultRoleStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dcl.user.MySQLCreateUserStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dcl.user.MySQLRenameUserStatement;
import org.apache.shardingsphere.sql.parser.statement.mysql.dcl.user.MySQLSetPasswordStatement;

public final class DorisDCLStatementVisitor
extends DorisStatementVisitor
implements DCLStatementVisitor {
    public DorisDCLStatementVisitor(DatabaseType databaseType) {
        super(databaseType);
    }

    @Override
    public ASTNode visitGrantRoleOrPrivilegeTo(DorisStatementParser.GrantRoleOrPrivilegeToContext ctx) {
        MySQLGrantStatement result = new MySQLGrantStatement(this.getDatabaseType());
        this.fillRoleOrPrivileges(result, ctx.roleOrPrivileges());
        for (DorisStatementParser.UsernameContext each : ctx.userList().username()) {
            result.getUsers().add((UserSegment)this.visit((ParseTree)each));
        }
        return result;
    }

    @Override
    public ASTNode visitGrantRoleOrPrivilegeOnTo(DorisStatementParser.GrantRoleOrPrivilegeOnToContext ctx) {
        MySQLGrantStatement result = new MySQLGrantStatement(this.getDatabaseType());
        if (null == ctx.roleOrPrivileges()) {
            result.setAllPrivileges(true);
        } else {
            this.fillRoleOrPrivileges(result, ctx.roleOrPrivileges());
        }
        result.setLevel(this.generateGrantLevel(ctx.grantIdentifier()));
        for (DorisStatementParser.UsernameContext each : ctx.userList().username()) {
            result.getUsers().add((UserSegment)this.visit((ParseTree)each));
        }
        if (null != ctx.aclType()) {
            result.setAclObject(ctx.aclType().getText().toUpperCase());
        }
        return result;
    }

    @Override
    public ASTNode visitGrantProxy(DorisStatementParser.GrantProxyContext ctx) {
        MySQLGrantStatement result = new MySQLGrantStatement(this.getDatabaseType());
        PrivilegeSegment privilege = new PrivilegeSegment(ctx.PROXY().getSymbol().getStartIndex(), ctx.PROXY().getSymbol().getStopIndex(), "GRANT");
        result.getRoleOrPrivileges().add(new RoleOrPrivilegeSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), null, null, privilege));
        for (DorisStatementParser.UsernameContext each : ctx.userList().username()) {
            result.getUsers().add((UserSegment)this.visit((ParseTree)each));
        }
        return result;
    }

    private void fillRoleOrPrivileges(MySQLGrantStatement statement, DorisStatementParser.RoleOrPrivilegesContext ctx) {
        for (DorisStatementParser.RoleOrPrivilegeContext each : ctx.roleOrPrivilege()) {
            statement.getRoleOrPrivileges().add((RoleOrPrivilegeSegment)this.visit((ParseTree)each));
        }
    }

    private void fillRoleOrPrivileges(MySQLRevokeStatement statement, DorisStatementParser.RoleOrPrivilegesContext ctx) {
        for (DorisStatementParser.RoleOrPrivilegeContext each : ctx.roleOrPrivilege()) {
            statement.getRoleOrPrivileges().add((RoleOrPrivilegeSegment)this.visit((ParseTree)each));
        }
    }

    private GrantLevelSegment generateGrantLevel(DorisStatementParser.GrantIdentifierContext ctx) {
        if (ctx instanceof DorisStatementParser.GrantLevelGlobalContext) {
            return new GrantLevelSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), "*", "*");
        }
        if (ctx instanceof DorisStatementParser.GrantLevelDatabaseGlobalContext) {
            String databaseName = new IdentifierValue(((DorisStatementParser.GrantLevelDatabaseGlobalContext)ctx).databaseName().getText()).getValue();
            return new GrantLevelSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), databaseName, "*");
        }
        String databaseName = null;
        if (null != ((DorisStatementParser.GrantLevelTableContext)ctx).tableName().owner()) {
            databaseName = new IdentifierValue(((DorisStatementParser.GrantLevelTableContext)ctx).tableName().owner().getText()).getValue();
        }
        String tableName = new IdentifierValue(((DorisStatementParser.GrantLevelTableContext)ctx).tableName().name().getText()).getValue();
        return new GrantLevelSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), databaseName, tableName);
    }

    @Override
    public ASTNode visitRoleOrDynamicPrivilege(DorisStatementParser.RoleOrDynamicPrivilegeContext ctx) {
        String role = new IdentifierValue(ctx.roleIdentifierOrText().getText()).getValue();
        return new RoleOrPrivilegeSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), role, null, null);
    }

    @Override
    public ASTNode visitRoleAtHost(DorisStatementParser.RoleAtHostContext ctx) {
        String role = new IdentifierValue(ctx.roleIdentifierOrText().getText()).getValue();
        String host = new IdentifierValue(ctx.textOrIdentifier().getText()).getValue();
        return new RoleOrPrivilegeSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), role, host, null);
    }

    @Override
    public ASTNode visitStaticPrivilegeSelect(DorisStatementParser.StaticPrivilegeSelectContext ctx) {
        PrivilegeSegment privilege = new PrivilegeSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), "SELECT");
        if (null != ctx.columnNames()) {
            for (DorisStatementParser.ColumnNameContext each : ctx.columnNames().columnName()) {
                privilege.getColumns().add(new IdentifierValue(each.getText()).getValue());
            }
        }
        return new RoleOrPrivilegeSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), null, null, privilege);
    }

    @Override
    public ASTNode visitStaticPrivilegeInsert(DorisStatementParser.StaticPrivilegeInsertContext ctx) {
        PrivilegeSegment privilege = new PrivilegeSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), "INSERT");
        if (null != ctx.columnNames()) {
            for (DorisStatementParser.ColumnNameContext each : ctx.columnNames().columnName()) {
                privilege.getColumns().add(new IdentifierValue(each.getText()).getValue());
            }
        }
        return new RoleOrPrivilegeSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), null, null, privilege);
    }

    @Override
    public ASTNode visitStaticPrivilegeUpdate(DorisStatementParser.StaticPrivilegeUpdateContext ctx) {
        PrivilegeSegment privilege = new PrivilegeSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), "UPDATE");
        if (null != ctx.columnNames()) {
            for (DorisStatementParser.ColumnNameContext each : ctx.columnNames().columnName()) {
                privilege.getColumns().add(new IdentifierValue(each.getText()).getValue());
            }
        }
        return new RoleOrPrivilegeSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), null, null, privilege);
    }

    @Override
    public ASTNode visitStaticPrivilegeReferences(DorisStatementParser.StaticPrivilegeReferencesContext ctx) {
        PrivilegeSegment privilege = new PrivilegeSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), "REFERENCES");
        if (null != ctx.columnNames()) {
            for (DorisStatementParser.ColumnNameContext each : ctx.columnNames().columnName()) {
                privilege.getColumns().add(new IdentifierValue(each.getText()).getValue());
            }
        }
        return new RoleOrPrivilegeSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), null, null, privilege);
    }

    @Override
    public ASTNode visitStaticPrivilegeDelete(DorisStatementParser.StaticPrivilegeDeleteContext ctx) {
        PrivilegeSegment privilege = new PrivilegeSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), "DELETE");
        return new RoleOrPrivilegeSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), null, null, privilege);
    }

    @Override
    public ASTNode visitStaticPrivilegeUsage(DorisStatementParser.StaticPrivilegeUsageContext ctx) {
        PrivilegeSegment privilege = new PrivilegeSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), "USAGE");
        return new RoleOrPrivilegeSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), null, null, privilege);
    }

    @Override
    public ASTNode visitStaticPrivilegeIndex(DorisStatementParser.StaticPrivilegeIndexContext ctx) {
        PrivilegeSegment privilege = new PrivilegeSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), "INDEX");
        return new RoleOrPrivilegeSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), null, null, privilege);
    }

    @Override
    public ASTNode visitStaticPrivilegeAlter(DorisStatementParser.StaticPrivilegeAlterContext ctx) {
        PrivilegeSegment privilege = new PrivilegeSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), "ALTER");
        return new RoleOrPrivilegeSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), null, null, privilege);
    }

    @Override
    public ASTNode visitStaticPrivilegeCreate(DorisStatementParser.StaticPrivilegeCreateContext ctx) {
        PrivilegeSegment privilege = new PrivilegeSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), "CREATE");
        return new RoleOrPrivilegeSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), null, null, privilege);
    }

    @Override
    public ASTNode visitStaticPrivilegeDrop(DorisStatementParser.StaticPrivilegeDropContext ctx) {
        PrivilegeSegment privilege = new PrivilegeSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), "DROP");
        return new RoleOrPrivilegeSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), null, null, privilege);
    }

    @Override
    public ASTNode visitStaticPrivilegeExecute(DorisStatementParser.StaticPrivilegeExecuteContext ctx) {
        PrivilegeSegment privilege = new PrivilegeSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), "EXECUTE");
        return new RoleOrPrivilegeSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), null, null, privilege);
    }

    @Override
    public ASTNode visitStaticPrivilegeReload(DorisStatementParser.StaticPrivilegeReloadContext ctx) {
        PrivilegeSegment privilege = new PrivilegeSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), "RELOAD");
        return new RoleOrPrivilegeSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), null, null, privilege);
    }

    @Override
    public ASTNode visitStaticPrivilegeShutdown(DorisStatementParser.StaticPrivilegeShutdownContext ctx) {
        PrivilegeSegment privilege = new PrivilegeSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), "SHUTDOWN");
        return new RoleOrPrivilegeSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), null, null, privilege);
    }

    @Override
    public ASTNode visitStaticPrivilegeProcess(DorisStatementParser.StaticPrivilegeProcessContext ctx) {
        PrivilegeSegment privilege = new PrivilegeSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), "PROCESS");
        return new RoleOrPrivilegeSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), null, null, privilege);
    }

    @Override
    public ASTNode visitStaticPrivilegeFile(DorisStatementParser.StaticPrivilegeFileContext ctx) {
        PrivilegeSegment privilege = new PrivilegeSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), "FILE");
        return new RoleOrPrivilegeSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), null, null, privilege);
    }

    @Override
    public ASTNode visitStaticPrivilegeGrant(DorisStatementParser.StaticPrivilegeGrantContext ctx) {
        PrivilegeSegment privilege = new PrivilegeSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), "GRANT");
        return new RoleOrPrivilegeSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), null, null, privilege);
    }

    @Override
    public ASTNode visitStaticPrivilegeShowDatabases(DorisStatementParser.StaticPrivilegeShowDatabasesContext ctx) {
        PrivilegeSegment privilege = new PrivilegeSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), "SHOW_DB");
        return new RoleOrPrivilegeSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), null, null, privilege);
    }

    @Override
    public ASTNode visitStaticPrivilegeSuper(DorisStatementParser.StaticPrivilegeSuperContext ctx) {
        PrivilegeSegment privilege = new PrivilegeSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), "SUPER");
        return new RoleOrPrivilegeSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), null, null, privilege);
    }

    @Override
    public ASTNode visitStaticPrivilegeCreateTemporaryTables(DorisStatementParser.StaticPrivilegeCreateTemporaryTablesContext ctx) {
        PrivilegeSegment privilege = new PrivilegeSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), "CREATE_TMP");
        return new RoleOrPrivilegeSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), null, null, privilege);
    }

    @Override
    public ASTNode visitStaticPrivilegeLockTables(DorisStatementParser.StaticPrivilegeLockTablesContext ctx) {
        PrivilegeSegment privilege = new PrivilegeSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), "LOCK_TABLES");
        return new RoleOrPrivilegeSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), null, null, privilege);
    }

    @Override
    public ASTNode visitStaticPrivilegeReplicationSlave(DorisStatementParser.StaticPrivilegeReplicationSlaveContext ctx) {
        PrivilegeSegment privilege = new PrivilegeSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), "REPL_SLAVE");
        return new RoleOrPrivilegeSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), null, null, privilege);
    }

    @Override
    public ASTNode visitStaticPrivilegeReplicationClient(DorisStatementParser.StaticPrivilegeReplicationClientContext ctx) {
        PrivilegeSegment privilege = new PrivilegeSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), "REPL_CLIENT");
        return new RoleOrPrivilegeSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), null, null, privilege);
    }

    @Override
    public ASTNode visitStaticPrivilegeCreateView(DorisStatementParser.StaticPrivilegeCreateViewContext ctx) {
        PrivilegeSegment privilege = new PrivilegeSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), "CREATE_VIEW");
        return new RoleOrPrivilegeSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), null, null, privilege);
    }

    @Override
    public ASTNode visitStaticPrivilegeShowView(DorisStatementParser.StaticPrivilegeShowViewContext ctx) {
        PrivilegeSegment privilege = new PrivilegeSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), "SHOW_VIEW");
        return new RoleOrPrivilegeSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), null, null, privilege);
    }

    @Override
    public ASTNode visitStaticPrivilegeCreateRoutine(DorisStatementParser.StaticPrivilegeCreateRoutineContext ctx) {
        PrivilegeSegment privilege = new PrivilegeSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), "CREATE_PROC");
        return new RoleOrPrivilegeSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), null, null, privilege);
    }

    @Override
    public ASTNode visitStaticPrivilegeAlterRoutine(DorisStatementParser.StaticPrivilegeAlterRoutineContext ctx) {
        PrivilegeSegment privilege = new PrivilegeSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), "ALTER_PROC");
        return new RoleOrPrivilegeSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), null, null, privilege);
    }

    @Override
    public ASTNode visitStaticPrivilegeCreateUser(DorisStatementParser.StaticPrivilegeCreateUserContext ctx) {
        PrivilegeSegment privilege = new PrivilegeSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), "CREATE_USER");
        return new RoleOrPrivilegeSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), null, null, privilege);
    }

    @Override
    public ASTNode visitStaticPrivilegeEvent(DorisStatementParser.StaticPrivilegeEventContext ctx) {
        PrivilegeSegment privilege = new PrivilegeSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), "EVENT");
        return new RoleOrPrivilegeSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), null, null, privilege);
    }

    @Override
    public ASTNode visitStaticPrivilegeTrigger(DorisStatementParser.StaticPrivilegeTriggerContext ctx) {
        PrivilegeSegment privilege = new PrivilegeSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), "TRIGGER");
        return new RoleOrPrivilegeSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), null, null, privilege);
    }

    @Override
    public ASTNode visitStaticPrivilegeCreateTablespace(DorisStatementParser.StaticPrivilegeCreateTablespaceContext ctx) {
        PrivilegeSegment privilege = new PrivilegeSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), "CREATE_TABLESPACE");
        return new RoleOrPrivilegeSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), null, null, privilege);
    }

    @Override
    public ASTNode visitStaticPrivilegeCreateRole(DorisStatementParser.StaticPrivilegeCreateRoleContext ctx) {
        PrivilegeSegment privilege = new PrivilegeSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), "CREATE_ROLE");
        return new RoleOrPrivilegeSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), null, null, privilege);
    }

    @Override
    public ASTNode visitStaticPrivilegeDropRole(DorisStatementParser.StaticPrivilegeDropRoleContext ctx) {
        PrivilegeSegment privilege = new PrivilegeSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), "DROP_ROLE");
        return new RoleOrPrivilegeSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), null, null, privilege);
    }

    @Override
    public ASTNode visitRevokeFrom(DorisStatementParser.RevokeFromContext ctx) {
        MySQLRevokeStatement result = new MySQLRevokeStatement(this.getDatabaseType());
        if (null != ctx.roleOrPrivileges()) {
            this.fillRoleOrPrivileges(result, ctx.roleOrPrivileges());
        } else if (null != ctx.ALL()) {
            result.setAllPrivileges(true);
        }
        for (DorisStatementParser.UsernameContext each : ctx.userList().username()) {
            result.getFromUsers().add((UserSegment)this.visit((ParseTree)each));
        }
        return result;
    }

    @Override
    public ASTNode visitRevokeOnFrom(DorisStatementParser.RevokeOnFromContext ctx) {
        MySQLRevokeStatement result = new MySQLRevokeStatement(this.getDatabaseType());
        if (null != ctx.roleOrPrivileges()) {
            this.fillRoleOrPrivileges(result, ctx.roleOrPrivileges());
        } else if (null != ctx.ALL()) {
            result.setAllPrivileges(true);
        } else if (null != ctx.PROXY()) {
            PrivilegeSegment privilege = new PrivilegeSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), "DROP_ROLE");
            result.getRoleOrPrivileges().add(new RoleOrPrivilegeSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), null, null, privilege));
            result.setOnUser((UserSegment)this.visit((ParseTree)ctx.username()));
        }
        if (null != ctx.grantIdentifier()) {
            result.setLevel(this.generateGrantLevel(ctx.grantIdentifier()));
        }
        for (DorisStatementParser.UsernameContext each : ctx.userList().username()) {
            result.getFromUsers().add((UserSegment)this.visit((ParseTree)each));
        }
        return result;
    }

    @Override
    public ASTNode visitCreateUser(DorisStatementParser.CreateUserContext ctx) {
        MySQLCreateUserStatement result = new MySQLCreateUserStatement(this.getDatabaseType());
        for (DorisStatementParser.CreateUserEntryContext createUserEntryContext : ctx.createUserList().createUserEntry()) {
            result.getUsers().add((UserSegment)this.visit((ParseTree)createUserEntryContext));
        }
        if (null != ctx.defaultRoleClause()) {
            for (DorisStatementParser.RoleNameContext roleNameContext : ctx.defaultRoleClause().roleName()) {
                result.getDefaultRoles().add(roleNameContext.getText());
            }
        }
        if (null != ctx.requireClause()) {
            result.setTlsOptionSegment((TLSOptionSegment)this.visit((ParseTree)ctx.requireClause()));
        }
        if (null != ctx.connectOptions()) {
            result.setUserResource((UserResourceSegment)this.visit((ParseTree)ctx.connectOptions()));
        }
        if (null != ctx.accountLockPasswordExpireOptions()) {
            result.setPasswordOrLockOption((PasswordOrLockOptionSegment)this.visit((ParseTree)ctx.accountLockPasswordExpireOptions()));
        }
        return result;
    }

    @Override
    public ASTNode visitRequireClause(DorisStatementParser.RequireClauseContext ctx) {
        TLSOptionSegment result = new TLSOptionSegment();
        if (null != ctx.NONE()) {
            result.setType(SSLType.NONE);
        } else if (null != ctx.X509()) {
            result.setType(SSLType.X509);
        } else if (null != ctx.SSL()) {
            result.setType(SSLType.ANY);
        } else {
            result.setType(SSLType.SPECIFIED);
            for (DorisStatementParser.TlsOptionContext each : ctx.tlsOption()) {
                if (null != each.SUBJECT()) {
                    result.setX509Subject(each.string_().getText());
                    continue;
                }
                if (null != each.ISSUER()) {
                    result.setX509Issuer(each.string_().getText());
                    continue;
                }
                if (null == each.CIPHER()) continue;
                result.setX509Cipher(each.string_().getText());
            }
        }
        return result;
    }

    @Override
    public ASTNode visitConnectOptions(DorisStatementParser.ConnectOptionsContext ctx) {
        UserResourceSegment result = new UserResourceSegment();
        result.setStartIndex(ctx.start.getStartIndex());
        result.setStopIndex(ctx.stop.getStopIndex());
        for (DorisStatementParser.ConnectOptionContext each : ctx.connectOption()) {
            if (null != each.MAX_QUERIES_PER_HOUR()) {
                result.setSpecifiedLimits(UserResourceSpecifiedLimitType.QUERIES_PER_HOUR);
                result.setQuestions(new NumberLiteralValue(each.NUMBER_().getText()).getValue().intValue());
            }
            if (null != each.MAX_UPDATES_PER_HOUR()) {
                result.setSpecifiedLimits(UserResourceSpecifiedLimitType.UPDATES_PER_HOUR);
                result.setUpdates(new NumberLiteralValue(each.NUMBER_().getText()).getValue().intValue());
            }
            if (null != each.MAX_CONNECTIONS_PER_HOUR()) {
                result.setSpecifiedLimits(UserResourceSpecifiedLimitType.CONNECTIONS_PER_HOUR);
                result.setConnPerHour(new NumberLiteralValue(each.NUMBER_().getText()).getValue().intValue());
            }
            if (null == each.MAX_USER_CONNECTIONS()) continue;
            result.setSpecifiedLimits(UserResourceSpecifiedLimitType.USER_CONNECTIONS);
            result.setUserConn(new NumberLiteralValue(each.NUMBER_().getText()).getValue().intValue());
        }
        return result;
    }

    @Override
    public ASTNode visitCreateUserEntryNoOption(DorisStatementParser.CreateUserEntryNoOptionContext ctx) {
        UserSegment result = (UserSegment)this.visit((ParseTree)ctx.username());
        result.setStartIndex(ctx.start.getStartIndex());
        result.setStopIndex(ctx.stop.getStopIndex());
        return result;
    }

    @Override
    public ASTNode visitCreateUserEntryIdentifiedBy(DorisStatementParser.CreateUserEntryIdentifiedByContext ctx) {
        UserSegment result = (UserSegment)this.visit((ParseTree)ctx.username());
        result.setStartIndex(ctx.start.getStartIndex());
        result.setStopIndex(ctx.stop.getStopIndex());
        if (null != ctx.string_()) {
            result.setAuth(((StringLiteralValue)this.visit((ParseTree)ctx.string_())).getValue());
            result.setHasPasswordGenerator(false);
            result.setUsesIdentifiedByClause(true);
            result.setDiscardOldPassword(false);
        } else {
            result.setHasPasswordGenerator(true);
            result.setUsesIdentifiedByClause(true);
            result.setDiscardOldPassword(false);
            result.setUsesIdentifiedWithClause(false);
        }
        result.setRetainCurrentPassword(false);
        return result;
    }

    @Override
    public ASTNode visitCreateUserEntryIdentifiedWith(DorisStatementParser.CreateUserEntryIdentifiedWithContext ctx) {
        UserSegment result = (UserSegment)this.visit((ParseTree)ctx.username());
        result.setStartIndex(ctx.start.getStartIndex());
        result.setStopIndex(ctx.stop.getStopIndex());
        if (null != ctx.textOrIdentifier()) {
            result.setPlugin(ctx.textOrIdentifier().getText());
            result.setHasPasswordGenerator(false);
            result.setUsesIdentifiedByClause(true);
            result.setDiscardOldPassword(false);
            result.setRetainCurrentPassword(false);
        } else if (null != ctx.AS()) {
            result.setPlugin(ctx.textOrIdentifier().getText());
            result.setAuth(((StringLiteralValue)this.visit((ParseTree)ctx.string_())).getValue());
            result.setHasPasswordGenerator(false);
            result.setUsesIdentifiedByClause(true);
            result.setDiscardOldPassword(false);
            result.setRetainCurrentPassword(false);
        } else if (null != ctx.BY() && null != ctx.string_()) {
            result.setPlugin(ctx.textOrIdentifier().getText());
            result.setAuth(((StringLiteralValue)this.visit((ParseTree)ctx.string_())).getValue());
            result.setHasPasswordGenerator(false);
            result.setUsesIdentifiedByClause(true);
            result.setUsesIdentifiedWithClause(true);
            result.setDiscardOldPassword(false);
            result.setRetainCurrentPassword(false);
        } else {
            result.setPlugin(ctx.textOrIdentifier().getText());
            result.setAuth(((StringLiteralValue)this.visit((ParseTree)ctx.string_())).getValue());
            result.setHasPasswordGenerator(true);
            result.setUsesIdentifiedByClause(true);
            result.setUsesIdentifiedWithClause(true);
            result.setDiscardOldPassword(false);
            result.setRetainCurrentPassword(false);
        }
        return result;
    }

    @Override
    public ASTNode visitAccountLockPasswordExpireOptions(DorisStatementParser.AccountLockPasswordExpireOptionsContext ctx) {
        PasswordOrLockOptionSegment result = new PasswordOrLockOptionSegment();
        for (DorisStatementParser.AccountLockPasswordExpireOptionContext each : ctx.accountLockPasswordExpireOption()) {
            this.fillAccountLockPasswordExpireOption(result, each);
        }
        return result;
    }

    private void fillAccountLockPasswordExpireOption(PasswordOrLockOptionSegment segment, DorisStatementParser.AccountLockPasswordExpireOptionContext ctx) {
        if (null != ctx.ACCOUNT()) {
            this.fillAccountLock(segment, ctx);
        } else if (null != ctx.PASSWORD() && null != ctx.EXPIRE()) {
            this.fillPasswordExpire(segment, ctx);
        } else if (null != ctx.PASSWORD() && null != ctx.HISTORY()) {
            this.fillPasswordHistory(segment, ctx);
        } else if (null != ctx.PASSWORD() && null != ctx.REUSE()) {
            this.fillPasswordReuse(segment, ctx);
        } else if (null != ctx.PASSWORD() && null != ctx.REQUIRE()) {
            this.fillPasswordRequire(segment, ctx);
        } else if (null != ctx.FAILED_LOGIN_ATTEMPTS()) {
            segment.setUpdateFailedLoginAttempts(true);
            segment.setFailedLoginAttempts(new NumberLiteralValue(ctx.NUMBER_().getText()).getValue().intValue());
        } else if (null == ctx.UNBOUNDED()) {
            segment.setUpdatePasswordLockTime(true);
            segment.setPasswordLockTime(new NumberLiteralValue(ctx.NUMBER_().getText()).getValue().intValue());
        } else {
            segment.setUpdatePasswordLockTime(true);
            segment.setPasswordLockTime(-1);
        }
    }

    private void fillAccountLock(PasswordOrLockOptionSegment segment, DorisStatementParser.AccountLockPasswordExpireOptionContext ctx) {
        if (null == ctx.LOCK()) {
            segment.setUpdateAccountLockedColumn(true);
            segment.setAccountLocked(false);
        } else {
            segment.setUpdateAccountLockedColumn(true);
            segment.setAccountLocked(true);
        }
    }

    private void fillPasswordExpire(PasswordOrLockOptionSegment segment, DorisStatementParser.AccountLockPasswordExpireOptionContext ctx) {
        if (null != ctx.INTERVAL()) {
            segment.setExpireAfterDays(new NumberLiteralValue(ctx.NUMBER_().getText()).getValue().intValue());
            segment.setUpdatePasswordExpiredColumn(false);
            segment.setUpdatePasswordExpiredFields(true);
            segment.setUseDefaultPasswordLifeTime(false);
        } else if (null != ctx.NEVER()) {
            segment.setExpireAfterDays(0);
            segment.setUpdatePasswordExpiredColumn(false);
            segment.setUpdatePasswordExpiredFields(true);
            segment.setUseDefaultPasswordLifeTime(false);
        } else if (null != ctx.DEFAULT()) {
            segment.setExpireAfterDays(0);
            segment.setUpdatePasswordExpiredColumn(false);
            segment.setUpdatePasswordExpiredFields(true);
            segment.setUseDefaultPasswordLifeTime(true);
        } else {
            segment.setExpireAfterDays(0);
            segment.setUpdatePasswordExpiredColumn(true);
            segment.setUpdatePasswordExpiredFields(true);
            segment.setUseDefaultPasswordLifeTime(true);
        }
    }

    private void fillPasswordHistory(PasswordOrLockOptionSegment segment, DorisStatementParser.AccountLockPasswordExpireOptionContext ctx) {
        if (null == ctx.DEFAULT()) {
            segment.setPasswordHistoryLength(new NumberLiteralValue(ctx.NUMBER_().getText()).getValue().intValue());
            segment.setUpdatePasswordHistory(true);
            segment.setUseDefaultPasswordHistory(false);
        } else {
            segment.setPasswordHistoryLength(0);
            segment.setUpdatePasswordHistory(true);
            segment.setUseDefaultPasswordHistory(true);
        }
    }

    private void fillPasswordReuse(PasswordOrLockOptionSegment segment, DorisStatementParser.AccountLockPasswordExpireOptionContext ctx) {
        if (null == ctx.DEFAULT()) {
            segment.setPasswordReuseInterval(new NumberLiteralValue(ctx.NUMBER_().getText()).getValue().intValue());
            segment.setUpdatePasswordReuseInterval(true);
            segment.setUseDefaultPasswordReuseInterval(false);
        } else {
            segment.setPasswordReuseInterval(0);
            segment.setUpdatePasswordReuseInterval(true);
            segment.setUseDefaultPasswordReuseInterval(true);
        }
    }

    private void fillPasswordRequire(PasswordOrLockOptionSegment segment, DorisStatementParser.AccountLockPasswordExpireOptionContext ctx) {
        ACLAttributeType aclAttributeType = null != ctx.DEFAULT() ? ACLAttributeType.DEFAULT : (null != ctx.OPTIONAL() ? ACLAttributeType.NO : ACLAttributeType.YES);
        segment.setUpdatePasswordRequireCurrent(aclAttributeType);
    }

    @Override
    public ASTNode visitUsername(DorisStatementParser.UsernameContext ctx) {
        UserSegment result = new UserSegment();
        if (null != ctx.userIdentifierOrText()) {
            result.setUser(new IdentifierValue(ctx.userIdentifierOrText().textOrIdentifier(0).getText()).getValue());
            if (null != ctx.userIdentifierOrText().AT_()) {
                result.setHost(new IdentifierValue(ctx.userIdentifierOrText().textOrIdentifier(1).getText()).getValue());
            }
        }
        return result;
    }

    @Override
    public ASTNode visitDropUser(DorisStatementParser.DropUserContext ctx) {
        return new DropUserStatement(this.getDatabaseType(), (Collection)ctx.username().stream().map(RuleContext::getText).collect(Collectors.toList()));
    }

    @Override
    public ASTNode visitAlterUser(DorisStatementParser.AlterUserContext ctx) {
        return new AlterUserStatement(this.getDatabaseType(), null);
    }

    @Override
    public ASTNode visitRenameUser(DorisStatementParser.RenameUserContext ctx) {
        return new MySQLRenameUserStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitCreateRole(DorisStatementParser.CreateRoleContext ctx) {
        return new CreateRoleStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitDropRole(DorisStatementParser.DropRoleContext ctx) {
        return new DropRoleStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitSetDefaultRole(DorisStatementParser.SetDefaultRoleContext ctx) {
        return new MySQLSetDefaultRoleStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitSetRole(DorisStatementParser.SetRoleContext ctx) {
        return new SetRoleStatement(this.getDatabaseType());
    }

    @Override
    public ASTNode visitSetPassword(DorisStatementParser.SetPasswordContext ctx) {
        return new MySQLSetPasswordStatement(this.getDatabaseType());
    }
}

