/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.binder.engine.segment.util;

import java.util.Collection;
import lombok.Generated;
import org.apache.shardingsphere.infra.exception.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.exception.kernel.metadata.ColumnNotFoundException;
import org.apache.shardingsphere.infra.exception.kernel.metadata.DuplicateColumnException;
import org.apache.shardingsphere.infra.exception.kernel.metadata.DuplicateIndexException;
import org.apache.shardingsphere.infra.exception.kernel.metadata.IndexNotFoundException;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereTable;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.column.ColumnDefinitionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.column.alter.AddColumnDefinitionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.column.alter.ChangeColumnDefinitionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.column.alter.DropColumnDefinitionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.column.alter.ModifyColumnDefinitionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.column.alter.RenameColumnSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.constraint.alter.AddConstraintDefinitionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.index.DropIndexDefinitionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.index.RenameIndexDefinitionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.table.AlterTableStatement;

public final class AlterTableMetadataCheckUtils {
    public static void checkAlterTable(AlterTableStatement alterTableStatement, ShardingSphereTable table) {
        AlterTableMetadataCheckUtils.validateAddColumns(table, alterTableStatement.getAddColumnDefinitions());
        AlterTableMetadataCheckUtils.validateModifyColumns(table, alterTableStatement.getModifyColumnDefinitions());
        AlterTableMetadataCheckUtils.validateChangeColumns(table, alterTableStatement.getChangeColumnDefinitions());
        AlterTableMetadataCheckUtils.validateRenameColumns(table, alterTableStatement.getRenameColumnDefinitions());
        AlterTableMetadataCheckUtils.validateDropColumns(table, alterTableStatement.getDropColumnDefinitions());
        AlterTableMetadataCheckUtils.validateAddIndexes(table, alterTableStatement.getAddConstraintDefinitions());
        AlterTableMetadataCheckUtils.validateDropIndexes(table, alterTableStatement.getDropIndexDefinitions());
        AlterTableMetadataCheckUtils.validateRenameIndexes(table, alterTableStatement.getRenameIndexDefinitions());
    }

    private static void validateAddColumns(ShardingSphereTable table, Collection<AddColumnDefinitionSegment> addColumns) {
        for (AddColumnDefinitionSegment each : addColumns) {
            for (ColumnDefinitionSegment columnDefinition : each.getColumnDefinitions()) {
                String addColumnName = columnDefinition.getColumnName().getIdentifier().getValue();
                ShardingSpherePreconditions.checkState((!AlterTableMetadataCheckUtils.containsColumn(table, addColumnName) ? 1 : 0) != 0, () -> new DuplicateColumnException(addColumnName));
            }
        }
    }

    private static void validateModifyColumns(ShardingSphereTable table, Collection<ModifyColumnDefinitionSegment> modifyColumns) {
        for (ModifyColumnDefinitionSegment each : modifyColumns) {
            String columnName = each.getColumnDefinition().getColumnName().getIdentifier().getValue();
            ShardingSpherePreconditions.checkState((boolean)AlterTableMetadataCheckUtils.containsColumn(table, columnName), () -> new ColumnNotFoundException(columnName, table.getName()));
        }
    }

    private static void validateChangeColumns(ShardingSphereTable table, Collection<ChangeColumnDefinitionSegment> changeColumnDefinitions) {
        for (ChangeColumnDefinitionSegment each : changeColumnDefinitions) {
            String newColumnName = each.getColumnDefinition().getColumnName().getIdentifier().getValue();
            ShardingSpherePreconditions.checkState((!AlterTableMetadataCheckUtils.containsColumn(table, newColumnName) ? 1 : 0) != 0, () -> new DuplicateColumnException(newColumnName));
            String oldColumnName = each.getPreviousColumn().getIdentifier().getValue();
            ShardingSpherePreconditions.checkState((boolean)AlterTableMetadataCheckUtils.containsColumn(table, oldColumnName), () -> new ColumnNotFoundException(oldColumnName, table.getName()));
        }
    }

    private static void validateRenameColumns(ShardingSphereTable table, Collection<RenameColumnSegment> renameColumns) {
        for (RenameColumnSegment each : renameColumns) {
            String newColumnName = each.getColumnName().getIdentifier().getValue();
            ShardingSpherePreconditions.checkState((!AlterTableMetadataCheckUtils.containsColumn(table, newColumnName) ? 1 : 0) != 0, () -> new DuplicateColumnException(newColumnName));
            String oldColumnName = each.getOldColumnName().getIdentifier().getValue();
            ShardingSpherePreconditions.checkState((boolean)AlterTableMetadataCheckUtils.containsColumn(table, oldColumnName), () -> new ColumnNotFoundException(oldColumnName, table.getName()));
        }
    }

    private static void validateDropColumns(ShardingSphereTable table, Collection<DropColumnDefinitionSegment> dropColumns) {
        for (DropColumnDefinitionSegment each : dropColumns) {
            for (ColumnSegment column : each.getColumns()) {
                String columnName = column.getIdentifier().getValue();
                ShardingSpherePreconditions.checkState((boolean)AlterTableMetadataCheckUtils.containsColumn(table, columnName), () -> new ColumnNotFoundException(columnName, table.getName()));
            }
        }
    }

    private static void validateAddIndexes(ShardingSphereTable table, Collection<AddConstraintDefinitionSegment> addConstraints) {
        for (AddConstraintDefinitionSegment each : addConstraints) {
            String indexName = each.getConstraintDefinition().getIndexName().map(optional -> optional.getIndexName().getIdentifier().getValue()).orElse("");
            if (indexName.isEmpty()) continue;
            ShardingSpherePreconditions.checkState((!AlterTableMetadataCheckUtils.containsIndex(table, indexName) ? 1 : 0) != 0, () -> new DuplicateIndexException(indexName));
        }
    }

    private static void validateDropIndexes(ShardingSphereTable table, Collection<DropIndexDefinitionSegment> dropIndexes) {
        for (DropIndexDefinitionSegment each : dropIndexes) {
            String indexName = each.getIndexSegment().getIndexName().getIdentifier().getValue();
            ShardingSpherePreconditions.checkState((boolean)AlterTableMetadataCheckUtils.containsIndex(table, indexName), () -> new IndexNotFoundException(indexName));
        }
    }

    private static void validateRenameIndexes(ShardingSphereTable table, Collection<RenameIndexDefinitionSegment> renameIndexes) {
        for (RenameIndexDefinitionSegment each : renameIndexes) {
            String oldIndexName = each.getIndexSegment().getIndexName().getIdentifier().getValue();
            ShardingSpherePreconditions.checkState((boolean)AlterTableMetadataCheckUtils.containsIndex(table, oldIndexName), () -> new IndexNotFoundException(oldIndexName));
            String newIndexName = each.getRenameIndexSegment().getIndexName().getIdentifier().getValue();
            ShardingSpherePreconditions.checkState((!AlterTableMetadataCheckUtils.containsIndex(table, newIndexName) ? 1 : 0) != 0, () -> new DuplicateIndexException(newIndexName));
        }
    }

    private static boolean containsColumn(ShardingSphereTable table, String columnName) {
        return table.containsColumn(columnName);
    }

    private static boolean containsIndex(ShardingSphereTable table, String indexName) {
        return table.containsIndex(indexName);
    }

    @Generated
    private AlterTableMetadataCheckUtils() {
    }
}

