/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.binder.engine.segment.dml.expression.type;

import com.cedarsoftware.util.CaseInsensitiveMap;
import com.cedarsoftware.util.CaseInsensitiveSet;
import com.google.common.base.Strings;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.groovy.util.Maps;
import org.apache.shardingsphere.infra.binder.engine.segment.SegmentType;
import org.apache.shardingsphere.infra.binder.engine.segment.dml.from.context.TableSegmentBinderContext;
import org.apache.shardingsphere.infra.binder.engine.segment.dml.from.context.type.FunctionTableSegmentBinderContext;
import org.apache.shardingsphere.infra.binder.engine.segment.dml.from.context.type.SimpleTableSegmentBinderContext;
import org.apache.shardingsphere.infra.binder.engine.statement.SQLStatementBinderContext;
import org.apache.shardingsphere.infra.exception.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.exception.kernel.metadata.ColumnNotFoundException;
import org.apache.shardingsphere.infra.exception.kernel.syntax.AmbiguousColumnException;
import org.apache.shardingsphere.sql.parser.statement.core.enums.TableSourceType;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.ColumnProjectionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.ProjectionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.OwnerSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.bound.ColumnSegmentBoundInfo;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.bound.TableSegmentBoundInfo;
import org.apache.shardingsphere.sql.parser.statement.core.value.identifier.IdentifierValue;

public final class ColumnSegmentBinder {
    private static final Collection<String> EXCLUDE_BIND_COLUMNS = new CaseInsensitiveSet(Arrays.asList("ROWNUM", "ROW_NUMBER", "ROWNUM_", "ROWID", "SYSDATE", "SYSTIMESTAMP", "CURRENT_TIMESTAMP", "LOCALTIMESTAMP", "UID", "USER", "NEXTVAL", "LEVEL", "DAY"));
    private static final Map<SegmentType, String> SEGMENT_TYPE_MESSAGES = Maps.of((Object)((Object)SegmentType.PROJECTION), (Object)"field list", (Object)((Object)SegmentType.JOIN_ON), (Object)"on clause", (Object)((Object)SegmentType.JOIN_USING), (Object)"from clause", (Object)((Object)SegmentType.PREDICATE), (Object)"where clause", (Object)((Object)SegmentType.HAVING), (Object)"having clause", (Object)((Object)SegmentType.ORDER_BY), (Object)"order clause", (Object)((Object)SegmentType.GROUP_BY), (Object)"group statement", (Object)((Object)SegmentType.INSERT_COLUMNS), (Object)"field list");
    private static final String UNKNOWN_SEGMENT_TYPE_MESSAGE = "unknown clause";

    public static ColumnSegment bind(ColumnSegment segment, SegmentType parentSegmentType, SQLStatementBinderContext binderContext, Multimap<CaseInsensitiveMap.CaseInsensitiveString, TableSegmentBinderContext> tableBinderContexts, Multimap<CaseInsensitiveMap.CaseInsensitiveString, TableSegmentBinderContext> outerTableBinderContexts) {
        if (EXCLUDE_BIND_COLUMNS.contains(segment.getIdentifier().getValue())) {
            return segment;
        }
        ColumnSegment result = ColumnSegmentBinder.copy(segment);
        Collection<TableSegmentBinderContext> tableSegmentBinderContexts = ColumnSegmentBinder.getTableSegmentBinderContexts(segment, parentSegmentType, binderContext, tableBinderContexts, outerTableBinderContexts);
        ColumnSegmentInfo columnSegmentInfo = ColumnSegmentBinder.getColumnSegmentInfo(segment, parentSegmentType, tableSegmentBinderContexts, outerTableBinderContexts, binderContext);
        Optional<ColumnSegment> inputColumnSegment = columnSegmentInfo.getInputColumnSegment();
        inputColumnSegment.ifPresent(optional -> result.setVariable(optional.isVariable()));
        segment.getOwner().ifPresent(optional -> result.setOwner(ColumnSegmentBinder.bindOwnerTableContext(optional, inputColumnSegment.orElse(null))));
        result.setColumnBoundInfo(ColumnSegmentBinder.createColumnSegmentBoundInfo(segment, inputColumnSegment.orElse(null), columnSegmentInfo.getTableSourceType()));
        return result;
    }

    private static ColumnSegment copy(ColumnSegment segment) {
        ColumnSegment result = new ColumnSegment(segment.getStartIndex(), segment.getStopIndex(), segment.getIdentifier());
        result.setNestedObjectAttributes(segment.getNestedObjectAttributes());
        result.setVariable(segment.isVariable());
        segment.getLeftParentheses().ifPresent(arg_0 -> ((ColumnSegment)result).setLeftParentheses(arg_0));
        segment.getRightParentheses().ifPresent(arg_0 -> ((ColumnSegment)result).setRightParentheses(arg_0));
        return result;
    }

    private static OwnerSegment bindOwnerTableContext(OwnerSegment owner, ColumnSegment inputColumnSegment) {
        IdentifierValue originalSchema;
        IdentifierValue originalDatabase = null == inputColumnSegment ? null : inputColumnSegment.getColumnBoundInfo().getOriginalDatabase();
        IdentifierValue identifierValue = originalSchema = null == inputColumnSegment ? null : inputColumnSegment.getColumnBoundInfo().getOriginalSchema();
        if (null != originalDatabase && null != originalSchema) {
            owner.setTableBoundInfo(new TableSegmentBoundInfo(originalDatabase, originalSchema));
        }
        return owner;
    }

    private static Collection<TableSegmentBinderContext> getTableSegmentBinderContexts(ColumnSegment segment, SegmentType parentSegmentType, SQLStatementBinderContext binderContext, Multimap<CaseInsensitiveMap.CaseInsensitiveString, TableSegmentBinderContext> tableBinderContexts, Multimap<CaseInsensitiveMap.CaseInsensitiveString, TableSegmentBinderContext> outerTableBinderContexts) {
        if (segment.getOwner().isPresent()) {
            String owner = ((OwnerSegment)segment.getOwner().get()).getIdentifier().getValue();
            return ColumnSegmentBinder.getTableBinderContextByOwner(owner, tableBinderContexts, outerTableBinderContexts, binderContext.getExternalTableBinderContexts());
        }
        if (!binderContext.getJoinTableProjectionSegments().isEmpty() && ColumnSegmentBinder.isNeedUseJoinTableProjectionBind(segment, parentSegmentType, binderContext)) {
            return Collections.singleton(new SimpleTableSegmentBinderContext(binderContext.getJoinTableProjectionSegments(), TableSourceType.TEMPORARY_TABLE));
        }
        return tableBinderContexts.values();
    }

    private static Collection<TableSegmentBinderContext> getTableBinderContextByOwner(String owner, Multimap<CaseInsensitiveMap.CaseInsensitiveString, TableSegmentBinderContext> tableBinderContexts, Multimap<CaseInsensitiveMap.CaseInsensitiveString, TableSegmentBinderContext> outerTableBinderContexts, Multimap<CaseInsensitiveMap.CaseInsensitiveString, TableSegmentBinderContext> externalTableBinderContexts) {
        if (null == owner) {
            return Collections.emptyList();
        }
        CaseInsensitiveMap.CaseInsensitiveString caseInsensitiveOwner = CaseInsensitiveMap.CaseInsensitiveString.of((String)owner);
        if (tableBinderContexts.containsKey((Object)caseInsensitiveOwner)) {
            return tableBinderContexts.get((Object)caseInsensitiveOwner);
        }
        if (outerTableBinderContexts.containsKey((Object)caseInsensitiveOwner)) {
            return outerTableBinderContexts.get((Object)caseInsensitiveOwner);
        }
        if (externalTableBinderContexts.containsKey((Object)caseInsensitiveOwner)) {
            return externalTableBinderContexts.get((Object)caseInsensitiveOwner);
        }
        return Collections.emptyList();
    }

    private static boolean isNeedUseJoinTableProjectionBind(ColumnSegment segment, SegmentType parentSegmentType, SQLStatementBinderContext binderContext) {
        return SegmentType.PROJECTION == parentSegmentType || SegmentType.PREDICATE == parentSegmentType && binderContext.getUsingColumnNames().contains(segment.getIdentifier().getValue());
    }

    private static ColumnSegmentInfo getColumnSegmentInfo(ColumnSegment segment, SegmentType parentSegmentType, Collection<TableSegmentBinderContext> tableBinderContexts, Multimap<CaseInsensitiveMap.CaseInsensitiveString, TableSegmentBinderContext> outerTableBinderContexts, SQLStatementBinderContext binderContext) {
        ColumnSegmentInfo result = ColumnSegmentBinder.getInputInfoFromTableBinderContexts(tableBinderContexts, segment, parentSegmentType);
        if (!result.getInputColumnSegment().isPresent()) {
            result = new ColumnSegmentInfo(ColumnSegmentBinder.findInputColumnSegmentFromOuterTable(segment, outerTableBinderContexts).orElse(null), TableSourceType.TEMPORARY_TABLE);
        }
        if (!result.getInputColumnSegment().isPresent()) {
            result = new ColumnSegmentInfo(ColumnSegmentBinder.findInputColumnSegmentFromExternalTables(segment, binderContext.getExternalTableBinderContexts()).orElse(null), TableSourceType.TEMPORARY_TABLE);
        }
        if (!result.getInputColumnSegment().isPresent()) {
            result = new ColumnSegmentInfo(ColumnSegmentBinder.findInputColumnSegmentByVariables(segment, binderContext.getSqlStatement().getVariableNames()).orElse(null), TableSourceType.TEMPORARY_TABLE);
        }
        if (!result.getInputColumnSegment().isPresent()) {
            result = new ColumnSegmentInfo(ColumnSegmentBinder.findInputColumnSegmentByPivotColumns(segment, binderContext.getPivotColumnNames()).orElse(null), TableSourceType.TEMPORARY_TABLE);
        }
        ShardingSpherePreconditions.checkState((result.getInputColumnSegment().isPresent() || ColumnSegmentBinder.isSkipColumnBind(tableBinderContexts, outerTableBinderContexts.values()) ? 1 : 0) != 0, () -> new ColumnNotFoundException(segment.getExpression(), SEGMENT_TYPE_MESSAGES.getOrDefault((Object)parentSegmentType, UNKNOWN_SEGMENT_TYPE_MESSAGE)));
        return result;
    }

    private static ColumnSegmentInfo getInputInfoFromTableBinderContexts(Collection<TableSegmentBinderContext> tableBinderContexts, ColumnSegment segment, SegmentType parentSegmentType) {
        ColumnSegment inputColumnSegment = null;
        TableSourceType tableSourceType = TableSourceType.TEMPORARY_TABLE;
        for (TableSegmentBinderContext each : tableBinderContexts) {
            Optional<ProjectionSegment> projectionSegment = each.findProjectionSegmentByColumnLabel(segment.getIdentifier().getValue());
            if (!projectionSegment.isPresent()) continue;
            if (projectionSegment.get() instanceof ColumnProjectionSegment) {
                ShardingSpherePreconditions.checkState((null == inputColumnSegment ? 1 : 0) != 0, () -> new AmbiguousColumnException(segment.getExpression(), SEGMENT_TYPE_MESSAGES.getOrDefault((Object)parentSegmentType, UNKNOWN_SEGMENT_TYPE_MESSAGE)));
            }
            inputColumnSegment = ColumnSegmentBinder.getColumnSegment(projectionSegment.get());
            TableSourceType tableSourceType2 = tableSourceType = TableSourceType.MIXED_TABLE == each.getTableSourceType() ? ColumnSegmentBinder.getTableSourceTypeFromInputColumn(inputColumnSegment) : each.getTableSourceType();
            if (!(each instanceof SimpleTableSegmentBinderContext) || !((SimpleTableSegmentBinderContext)each).isFromWithSegment()) continue;
            break;
        }
        return new ColumnSegmentInfo(inputColumnSegment, tableSourceType);
    }

    private static TableSourceType getTableSourceTypeFromInputColumn(ColumnSegment inputColumnSegment) {
        return null == inputColumnSegment ? TableSourceType.TEMPORARY_TABLE : inputColumnSegment.getColumnBoundInfo().getTableSourceType();
    }

    private static ColumnSegment getColumnSegment(ProjectionSegment projectionSegment) {
        if (projectionSegment instanceof ColumnProjectionSegment) {
            return ((ColumnProjectionSegment)projectionSegment).getColumn();
        }
        return new ColumnSegment(0, 0, new IdentifierValue(projectionSegment.getColumnLabel()));
    }

    private static Optional<ColumnSegment> findInputColumnSegmentByPivotColumns(ColumnSegment segment, Collection<String> pivotColumnNames) {
        return pivotColumnNames.isEmpty() || !pivotColumnNames.contains(segment.getIdentifier().getValue()) ? Optional.empty() : Optional.of(new ColumnSegment(0, 0, segment.getIdentifier()));
    }

    private static Optional<ColumnSegment> findInputColumnSegmentFromOuterTable(ColumnSegment segment, Multimap<CaseInsensitiveMap.CaseInsensitiveString, TableSegmentBinderContext> outerTableBinderContexts) {
        ListIterator listIterator = new ArrayList(outerTableBinderContexts.values()).listIterator(outerTableBinderContexts.size());
        while (listIterator.hasPrevious()) {
            TableSegmentBinderContext each = (TableSegmentBinderContext)listIterator.previous();
            Optional<ProjectionSegment> result = each.findProjectionSegmentByColumnLabel(segment.getIdentifier().getValue());
            if (!result.isPresent()) continue;
            return Optional.of(ColumnSegmentBinder.createColumnSegment(result.get()));
        }
        return Optional.empty();
    }

    private static ColumnSegment createColumnSegment(ProjectionSegment projectionSegment) {
        return projectionSegment instanceof ColumnProjectionSegment ? ((ColumnProjectionSegment)projectionSegment).getColumn() : new ColumnSegment(0, 0, new IdentifierValue(projectionSegment.getColumnLabel()));
    }

    private static Optional<ColumnSegment> findInputColumnSegmentFromExternalTables(ColumnSegment segment, Multimap<CaseInsensitiveMap.CaseInsensitiveString, TableSegmentBinderContext> externalTableBinderContexts) {
        for (TableSegmentBinderContext each : externalTableBinderContexts.values()) {
            Optional<ProjectionSegment> result = each.findProjectionSegmentByColumnLabel(segment.getIdentifier().getValue());
            if (!result.isPresent()) continue;
            return Optional.of(ColumnSegmentBinder.createColumnSegment(result.get()));
        }
        return Optional.empty();
    }

    private static Optional<ColumnSegment> findInputColumnSegmentByVariables(ColumnSegment segment, Collection<String> variableNames) {
        if (variableNames.isEmpty()) {
            return Optional.empty();
        }
        if (variableNames.contains(segment.getIdentifier().getValue())) {
            ColumnSegment result = new ColumnSegment(0, 0, segment.getIdentifier());
            result.setVariable(true);
            return Optional.of(result);
        }
        return Optional.empty();
    }

    private static boolean isSkipColumnBind(Collection<TableSegmentBinderContext> tableBinderContexts, Collection<TableSegmentBinderContext> outerBinderContexts) {
        for (TableSegmentBinderContext each : tableBinderContexts) {
            if (!(each instanceof FunctionTableSegmentBinderContext)) continue;
            return true;
        }
        for (TableSegmentBinderContext each : outerBinderContexts) {
            if (!(each instanceof FunctionTableSegmentBinderContext)) continue;
            return true;
        }
        return false;
    }

    public static ColumnSegment bindUsingColumn(ColumnSegment segment, SegmentType parentSegmentType, Multimap<CaseInsensitiveMap.CaseInsensitiveString, TableSegmentBinderContext> tableBinderContexts) {
        ColumnSegment result = ColumnSegmentBinder.copy(segment);
        List<ColumnSegmentInfo> usingColumnSegmentInfos = ColumnSegmentBinder.findUsingColumnSegmentInfos(tableBinderContexts.values(), segment.getIdentifier().getValue());
        ShardingSpherePreconditions.checkState((usingColumnSegmentInfos.size() >= 2 ? 1 : 0) != 0, () -> new ColumnNotFoundException(segment.getExpression(), SEGMENT_TYPE_MESSAGES.getOrDefault((Object)parentSegmentType, UNKNOWN_SEGMENT_TYPE_MESSAGE)));
        ColumnSegmentInfo usingColumnInputInfo = usingColumnSegmentInfos.get(0);
        ColumnSegmentInfo otherUsingColumnInputInfo = usingColumnSegmentInfos.get(1);
        result.setColumnBoundInfo(ColumnSegmentBinder.createColumnSegmentBoundInfo(segment, usingColumnInputInfo.getInputColumnSegment().orElse(null), usingColumnInputInfo.getTableSourceType()));
        result.setOtherUsingColumnBoundInfo(ColumnSegmentBinder.createColumnSegmentBoundInfo(segment, otherUsingColumnInputInfo.getInputColumnSegment().orElse(null), otherUsingColumnInputInfo.getTableSourceType()));
        return result;
    }

    private static List<ColumnSegmentInfo> findUsingColumnSegmentInfos(Collection<TableSegmentBinderContext> tableBinderContexts, String columnName) {
        ArrayList<ColumnSegmentInfo> result = new ArrayList<ColumnSegmentInfo>(tableBinderContexts.size());
        for (TableSegmentBinderContext each : tableBinderContexts) {
            Optional<ProjectionSegment> projectionSegment = each.findProjectionSegmentByColumnLabel(columnName);
            if (!projectionSegment.isPresent()) continue;
            ColumnSegment columnSegment = projectionSegment.get() instanceof ColumnProjectionSegment ? ((ColumnProjectionSegment)projectionSegment.get()).getColumn() : null;
            result.add(new ColumnSegmentInfo(columnSegment, each.getTableSourceType()));
        }
        return result;
    }

    public static ColumnSegmentBoundInfo createColumnSegmentBoundInfo(ColumnSegment segment, ColumnSegment inputColumnSegment, TableSourceType tableSourceType) {
        IdentifierValue originalDatabase = null == inputColumnSegment ? null : inputColumnSegment.getColumnBoundInfo().getOriginalDatabase();
        IdentifierValue originalSchema = null == inputColumnSegment ? null : inputColumnSegment.getColumnBoundInfo().getOriginalSchema();
        IdentifierValue segmentOriginalTable = segment.getColumnBoundInfo().getOriginalTable();
        IdentifierValue originalTable = Strings.isNullOrEmpty((String)segmentOriginalTable.getValue()) ? Optional.ofNullable(inputColumnSegment).map(optional -> optional.getColumnBoundInfo().getOriginalTable()).orElse(segmentOriginalTable) : segmentOriginalTable;
        IdentifierValue segmentOriginalColumn = segment.getColumnBoundInfo().getOriginalColumn();
        IdentifierValue originalColumn = Optional.ofNullable(inputColumnSegment).map(optional -> optional.getColumnBoundInfo().getOriginalColumn()).orElse(segmentOriginalColumn);
        return new ColumnSegmentBoundInfo(new TableSegmentBoundInfo(originalDatabase, originalSchema), originalTable, originalColumn, tableSourceType);
    }

    @Generated
    private ColumnSegmentBinder() {
    }

    private static class ColumnSegmentInfo {
        private final ColumnSegment inputColumnSegment;
        private final TableSourceType tableSourceType;

        Optional<ColumnSegment> getInputColumnSegment() {
            return Optional.ofNullable(this.inputColumnSegment);
        }

        @Generated
        public ColumnSegmentInfo(ColumnSegment inputColumnSegment, TableSourceType tableSourceType) {
            this.inputColumnSegment = inputColumnSegment;
            this.tableSourceType = tableSourceType;
        }

        @Generated
        public TableSourceType getTableSourceType() {
            return this.tableSourceType;
        }
    }
}

