/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.agent.plugin.metrics.prometheus.collector;

import org.apache.shardingsphere.agent.plugin.metrics.core.collector.MetricsCollector;
import org.apache.shardingsphere.agent.plugin.metrics.core.collector.MetricsCollectorFactory;
import org.apache.shardingsphere.agent.plugin.metrics.core.config.MetricConfiguration;
import org.apache.shardingsphere.agent.plugin.metrics.prometheus.collector.type.PrometheusMetricsCounterCollector;
import org.apache.shardingsphere.agent.plugin.metrics.prometheus.collector.type.PrometheusMetricsGaugeCollector;
import org.apache.shardingsphere.agent.plugin.metrics.prometheus.collector.type.PrometheusMetricsGaugeMetricFamilyCollector;
import org.apache.shardingsphere.agent.plugin.metrics.prometheus.collector.type.PrometheusMetricsHistogramCollector;
import org.apache.shardingsphere.agent.plugin.metrics.prometheus.collector.type.PrometheusMetricsSummaryCollector;

public final class PrometheusMetricsCollectorFactory
implements MetricsCollectorFactory {
    @Override
    public MetricsCollector create(MetricConfiguration metricConfig) {
        switch (metricConfig.getType()) {
            case COUNTER: {
                return new PrometheusMetricsCounterCollector(metricConfig);
            }
            case GAUGE: {
                return new PrometheusMetricsGaugeCollector(metricConfig);
            }
            case HISTOGRAM: {
                return new PrometheusMetricsHistogramCollector(metricConfig);
            }
            case SUMMARY: {
                return new PrometheusMetricsSummaryCollector(metricConfig);
            }
            case GAUGE_METRIC_FAMILY: {
                return new PrometheusMetricsGaugeMetricFamilyCollector(metricConfig);
            }
        }
        throw new UnsupportedOperationException(String.format("Can not support type `%s`.", new Object[]{metricConfig.getType()}));
    }

    public String getType() {
        return "Prometheus";
    }
}

