/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.swagger.generator.core.processor.parameter;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import io.swagger.models.Response;
import io.swagger.models.parameters.AbstractSerializableParameter;
import jakarta.ws.rs.core.Response;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import org.apache.servicecomb.foundation.common.base.DynamicEnum;
import org.apache.servicecomb.swagger.extend.SwaggerEnum;
import org.apache.servicecomb.swagger.generator.OperationPostProcessor;
import org.apache.servicecomb.swagger.generator.ParameterGenerator;
import org.apache.servicecomb.swagger.generator.core.AbstractOperationGenerator;
import org.apache.servicecomb.swagger.generator.core.AbstractSwaggerGenerator;

public class EnumPostProcessor
implements OperationPostProcessor {
    @Override
    public boolean shouldProcess(AbstractSwaggerGenerator swaggerGenerator, AbstractOperationGenerator operationGenerator) {
        return true;
    }

    @Override
    public void process(AbstractSwaggerGenerator swaggerGenerator, AbstractOperationGenerator operationGenerator) {
        for (ParameterGenerator parameterGenerator : operationGenerator.getParameterGenerators()) {
            if (!(parameterGenerator.getGeneratedParameter() instanceof AbstractSerializableParameter)) continue;
            this.processParameterDescription(parameterGenerator);
        }
        this.processResponseModelDescription(operationGenerator);
    }

    private void processParameterDescription(ParameterGenerator parameterGenerator) {
        Annotation[] annotations;
        JavaType genericType = parameterGenerator.getGenericType();
        String description = this.generateDescription((Type)genericType, annotations = parameterGenerator.getAnnotations().toArray(new Annotation[0]));
        if (description != null) {
            AbstractSerializableParameter parameter = (AbstractSerializableParameter)parameterGenerator.getGeneratedParameter();
            parameter.setDescription(description);
        }
    }

    private String generateDescription(Type type, Annotation[] annotations) {
        JavaType javaType = TypeFactory.defaultInstance().constructType(type);
        if (javaType.isEnumType()) {
            return this.generateDescription(SwaggerEnum.JDK, javaType.getRawClass(), annotations);
        }
        if (javaType.isTypeOrSubTypeOf(DynamicEnum.class)) {
            return this.generateDescription(SwaggerEnum.DYNAMIC, javaType.getRawClass(), annotations);
        }
        return null;
    }

    private String generateDescription(SwaggerEnum swaggerEnum, Class<?> enumClass, Annotation[] annotations) {
        return swaggerEnum.findPropertyDescription(enumClass, annotations);
    }

    public void processResponseModelDescription(AbstractOperationGenerator operationGenerator) {
        String description = this.generateDescription(operationGenerator.getMethod().getReturnType(), null);
        if (description != null) {
            ((Response)operationGenerator.getOperation().getResponses().get(String.valueOf(Response.Status.OK.getStatusCode()))).getResponseSchema().setDescription(description);
        }
    }
}

