/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.transport.highway;

import io.vertx.core.AbstractVerticle;
import io.vertx.core.Context;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import java.net.InetSocketAddress;
import org.apache.servicecomb.core.Endpoint;
import org.apache.servicecomb.foundation.common.net.URIEndpointObject;
import org.apache.servicecomb.transport.highway.HighwayServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HighwayServerVerticle
extends AbstractVerticle {
    private static final Logger LOGGER = LoggerFactory.getLogger(HighwayServerVerticle.class);
    public static final String SSL_KEY = "highway.provider";
    private Endpoint endpoint;
    private URIEndpointObject endpointObject;

    public void init(Vertx vertx, Context context) {
        super.init(vertx, context);
        this.endpoint = (Endpoint)context.config().getValue("servicecomb.endpoint");
        this.endpointObject = (URIEndpointObject)this.endpoint.getAddress();
    }

    public void start(Promise<Void> startPromise) throws Exception {
        try {
            super.start();
            this.startListen(startPromise);
        }
        catch (Throwable e) {
            LOGGER.error("", e);
            throw e;
        }
    }

    protected void startListen(Promise<Void> startPromise) {
        if (this.endpointObject == null) {
            LOGGER.warn("highway listen address is not configured, will not listen.");
            startPromise.complete();
            return;
        }
        HighwayServer server = new HighwayServer(this.endpoint);
        server.init(this.vertx, SSL_KEY, ar -> {
            if (ar.succeeded()) {
                InetSocketAddress socketAddress = (InetSocketAddress)ar.result();
                LOGGER.info("highway listen success. address={}:{}", (Object)socketAddress.getHostString(), (Object)socketAddress.getPort());
                startPromise.complete();
                return;
            }
            LOGGER.error("highway", ar.cause());
            startPromise.fail(ar.cause());
        });
    }
}

