/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.admin.nssummary;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.concurrent.Callable;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.hdds.server.JsonUtils;
import org.apache.hadoop.ozone.admin.nssummary.NSSummaryAdmin;
import org.apache.hadoop.ozone.admin.nssummary.NSSummaryCLIUtils;
import picocli.CommandLine;

@CommandLine.Command(name="summary", description={"Get entity type and object counts for a path request."}, mixinStandardHelpOptions=true, versionProvider=HddsVersionProvider.class)
public class SummarySubCommand
implements Callable<Void> {
    @CommandLine.ParentCommand
    private NSSummaryAdmin parent;
    @CommandLine.Parameters(index="0", arity="0..1", description={"Non-empty path request without any protocol prefix."})
    private String path;
    private static final String ENDPOINT = "/api/v1/namespace/summary";

    @Override
    public Void call() throws Exception {
        if (this.path == null || this.path.isEmpty()) {
            NSSummaryCLIUtils.printEmptyPathRequest();
            return null;
        }
        StringBuilder url = new StringBuilder();
        url.append(this.parent.getReconWebAddress()).append(ENDPOINT);
        NSSummaryCLIUtils.printNewLines(1);
        String response = NSSummaryCLIUtils.makeHttpCall(url, NSSummaryCLIUtils.parseInputPath(this.path), this.parent.isHTTPSEnabled(), this.parent.getOzoneConfig());
        if (response == null) {
            NSSummaryCLIUtils.printNewLines(1);
            return null;
        }
        JsonNode summaryResponse = JsonUtils.readTree((String)response);
        if ("PATH_NOT_FOUND".equals(summaryResponse.path("status").asText())) {
            NSSummaryCLIUtils.printPathNotFound();
        } else {
            NSSummaryCLIUtils.printWithUnderline("Entity Type", false);
            NSSummaryCLIUtils.printKVSeparator();
            System.out.println(summaryResponse.get("type"));
            JsonNode countStatsNode = summaryResponse.path("countStats");
            int numVol = countStatsNode.path("numVolume").asInt(-1);
            int numBucket = countStatsNode.path("numBucket").asInt(-1);
            int numDir = countStatsNode.path("numDir").asInt(-1);
            int numKey = countStatsNode.path("numKey").asInt(-1);
            if (numVol != -1) {
                NSSummaryCLIUtils.printWithUnderline("Volumes", false);
                NSSummaryCLIUtils.printKVSeparator();
                System.out.println(numVol);
            }
            if (numBucket != -1) {
                NSSummaryCLIUtils.printWithUnderline("Buckets", false);
                NSSummaryCLIUtils.printKVSeparator();
                System.out.println(numBucket);
            }
            if (numDir != -1) {
                NSSummaryCLIUtils.printWithUnderline("Directories", false);
                NSSummaryCLIUtils.printKVSeparator();
                System.out.println(numDir);
            }
            if (numKey != -1) {
                NSSummaryCLIUtils.printWithUnderline("Keys", false);
                NSSummaryCLIUtils.printKVSeparator();
                System.out.println(numKey);
            }
        }
        NSSummaryCLIUtils.printNewLines(1);
        return null;
    }
}

