/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.cli.container;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SequenceWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.google.common.base.Strings;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.hdds.client.ReplicationConfig;
import org.apache.hadoop.hdds.client.ReplicationType;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.cli.ScmSubcommand;
import org.apache.hadoop.hdds.scm.client.ScmClient;
import org.apache.hadoop.hdds.scm.container.ContainerInfo;
import org.apache.hadoop.hdds.scm.container.ContainerListResult;
import org.apache.hadoop.hdds.server.JsonUtils;
import picocli.CommandLine;

@CommandLine.Command(name="list", description={"List containers"}, mixinStandardHelpOptions=true, versionProvider=HddsVersionProvider.class)
public class ListSubcommand
extends ScmSubcommand {
    @CommandLine.Option(names={"-s", "--start"}, description={"Container id to start the iteration"})
    private long startId;
    @CommandLine.Option(names={"-c", "--count"}, description={"Maximum number of containers to list."}, defaultValue="20", showDefaultValue=CommandLine.Help.Visibility.ALWAYS)
    private int count;
    @CommandLine.Option(names={"-a", "--all"}, description={"List all containers."}, defaultValue="false")
    private boolean all;
    @CommandLine.Option(names={"--state"}, description={"Container state(OPEN, CLOSING, QUASI_CLOSED, CLOSED, DELETING, DELETED)"})
    private HddsProtos.LifeCycleState state;
    @CommandLine.Option(names={"-t", "--type"}, description={"Replication Type (RATIS, STAND_ALONE or EC)"})
    private HddsProtos.ReplicationType type;
    @CommandLine.Option(names={"-r", "--replication", "--factor"}, description={"Container replication (ONE, THREE for Ratis, rs-6-3-1024k for EC)"})
    private String replication;
    private static final ObjectWriter WRITER;

    @Override
    public void execute(ScmClient scmClient) throws IOException {
        if (!Strings.isNullOrEmpty((String)this.replication) && this.type == null) {
            this.type = HddsProtos.ReplicationType.RATIS;
        }
        ReplicationConfig repConfig = null;
        if (!Strings.isNullOrEmpty((String)this.replication)) {
            repConfig = ReplicationConfig.parse((ReplicationType)ReplicationType.fromProto((HddsProtos.ReplicationType)this.type), (String)this.replication, (ConfigurationSource)new OzoneConfiguration());
        }
        int maxCountAllowed = this.getOzoneConf().getInt("ozone.scm.container.list.max.count", 4096);
        SequenceWriter sequenceWriter = JsonUtils.getStdoutSequenceWriter();
        if (!this.all) {
            if (this.count > maxCountAllowed) {
                System.err.printf("Attempting to list the first %d records of containers. However it exceeds the cluster's current limit of %d. The results will be capped at the maximum allowed count.%n", this.count, maxCountAllowed);
                this.count = maxCountAllowed;
            }
            ContainerListResult containerListResult = scmClient.listContainer(this.startId, this.count, this.state, this.type, repConfig);
            this.writeContainers(sequenceWriter, containerListResult.getContainerInfoList());
            this.closeStream(sequenceWriter);
            if (containerListResult.getTotalCount() > (long)this.count) {
                System.err.printf("Displaying %d out of %d containers. Container list has more containers.%n", this.count, containerListResult.getTotalCount());
            }
        } else {
            int batchSize = this.count > 0 ? this.count : maxCountAllowed;
            this.listAllContainers(scmClient, sequenceWriter, batchSize, repConfig);
            this.closeStream(sequenceWriter);
        }
    }

    private void writeContainers(SequenceWriter writer, List<ContainerInfo> containers) throws IOException {
        for (ContainerInfo container : containers) {
            writer.write((Object)container);
        }
    }

    private void closeStream(SequenceWriter writer) throws IOException {
        writer.flush();
        writer.close();
        System.out.println();
    }

    private void listAllContainers(ScmClient scmClient, SequenceWriter writer, int batchSize, ReplicationConfig repConfig) throws IOException {
        int fetchedCount;
        long currentStartId = this.startId;
        do {
            ContainerListResult result = scmClient.listContainer(currentStartId, batchSize, this.state, this.type, repConfig);
            fetchedCount = result.getContainerInfoList().size();
            this.writeContainers(writer, result.getContainerInfoList());
            if (fetchedCount <= 0) continue;
            currentStartId = ((ContainerInfo)result.getContainerInfoList().get(fetchedCount - 1)).getContainerID() + 1L;
        } while (fetchedCount > 0);
    }

    static {
        ObjectMapper mapper = new ObjectMapper().registerModule((Module)new JavaTimeModule()).configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        mapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
        mapper.setVisibility(PropertyAccessor.GETTER, JsonAutoDetect.Visibility.NONE);
        WRITER = mapper.writerWithDefaultPrettyPrinter();
    }
}

