/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.audit.utils;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.reflect.Field;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DecimalColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.orc.CompressionKind;
import org.apache.orc.OrcFile;
import org.apache.orc.TypeDescription;
import org.apache.orc.Writer;
import org.apache.ranger.audit.model.AuthzAuditEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ORCFileUtil {
    private static final Logger logger = LoggerFactory.getLogger(ORCFileUtil.class);
    private static volatile ORCFileUtil me = null;
    protected CompressionKind defaultCompression = CompressionKind.SNAPPY;
    protected CompressionKind compressionKind = CompressionKind.NONE;
    protected TypeDescription schema = null;
    protected VectorizedRowBatch batch = null;
    protected String auditSchema = null;
    protected String dateFormat = "yyyy-MM-dd HH:mm:ss";
    protected ArrayList<String> schemaFields = new ArrayList();
    protected Map<String, ColumnVector> vectorizedRowBatchMap = new HashMap<String, ColumnVector>();
    protected int orcBufferSize;
    protected long orcStripeSize;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ORCFileUtil getInstance() {
        ORCFileUtil orcFileUtil = me;
        if (orcFileUtil != null) return orcFileUtil;
        Class<ORCFileUtil> clazz = ORCFileUtil.class;
        synchronized (ORCFileUtil.class) {
            orcFileUtil = me;
            if (orcFileUtil != null) return orcFileUtil;
            me = orcFileUtil = new ORCFileUtil();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return orcFileUtil;
        }
    }

    public void init(int orcBufferSize, long orcStripeSize, String compression) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug("==> ORCFileUtil.init()");
        }
        this.orcBufferSize = orcBufferSize;
        this.orcStripeSize = orcStripeSize;
        this.compressionKind = this.getORCCompression(compression);
        this.initORCAuditSchema();
        if (logger.isDebugEnabled()) {
            logger.debug("<== ORCFileUtil.init() : orcBufferSize: " + orcBufferSize + " stripeSize: " + orcStripeSize + " compression: " + compression);
        }
    }

    public Writer createWriter(Configuration conf, FileSystem fs, String path) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug("==> ORCFileUtil.createWriter()");
        }
        Writer ret = null;
        OrcFile.WriterOptions writeOptions = OrcFile.writerOptions((Configuration)conf).fileSystem(fs).setSchema(this.schema).bufferSize(this.orcBufferSize).stripeSize(this.orcStripeSize).compress(this.compressionKind);
        ret = OrcFile.createWriter((Path)new Path(path), (OrcFile.WriterOptions)writeOptions);
        if (logger.isDebugEnabled()) {
            logger.debug("<== ORCFileUtil.createWriter()");
        }
        return ret;
    }

    public void close(Writer writer) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug("==> ORCFileUtil.close()");
        }
        writer.close();
        if (logger.isDebugEnabled()) {
            logger.debug("<== ORCFileUtil.close()");
        }
    }

    public void log(Writer writer, Collection<AuthzAuditEvent> events) throws Exception {
        int eventBatchSize = events.size();
        if (logger.isDebugEnabled()) {
            logger.debug("==> ORCFileUtil.log() : EventSize: " + eventBatchSize + "ORC bufferSize:" + this.orcBufferSize);
        }
        try {
            for (AuthzAuditEvent event : events) {
                ++this.batch.size;
                for (int j = 0; j < this.schemaFields.size(); ++j) {
                    int row;
                    String fieldName = this.schemaFields.get(j);
                    SchemaInfo schemaInfo = this.getFieldValue(event, fieldName);
                    ColumnVector columnVector = this.vectorizedRowBatchMap.get(fieldName);
                    if (columnVector instanceof LongColumnVector) {
                        ((LongColumnVector)columnVector).vector[row] = this.castLongObject(schemaInfo.getValue());
                        continue;
                    }
                    if (!(columnVector instanceof BytesColumnVector)) continue;
                    ((BytesColumnVector)columnVector).setVal(row, this.getBytesValues(this.castStringObject(schemaInfo.getValue())));
                }
                if (this.batch.size != this.orcBufferSize) continue;
                writer.addRowBatch(this.batch);
                this.batch.reset();
            }
            if (this.batch.size != 0) {
                writer.addRowBatch(this.batch);
                this.batch.reset();
            }
        }
        catch (Exception e) {
            this.batch.reset();
            logger.error("Error while writing into ORC File:", (Throwable)e);
            throw e;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("<== ORCFileUtil.log(): EventSize = " + eventBatchSize);
        }
    }

    protected byte[] getBytesValues(String val) {
        byte[] ret = "".getBytes();
        if (val != null) {
            ret = val.getBytes();
        }
        return ret;
    }

    protected String getDateString(Date date) {
        String ret = null;
        SimpleDateFormat formatter = new SimpleDateFormat(this.dateFormat);
        ret = formatter.format((Object)date);
        return ret;
    }

    protected void initORCAuditSchema() throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug("==> ORCWriter.initORCAuditSchema()");
        }
        this.auditSchema = this.getAuditSchema();
        Map<String, String> schemaFieldTypeMap = this.getSchemaFieldTypeMap();
        this.schema = TypeDescription.fromString((String)this.auditSchema);
        this.batch = this.schema.createRowBatch(this.orcBufferSize);
        this.buildVectorRowBatch(schemaFieldTypeMap);
        if (logger.isDebugEnabled()) {
            logger.debug("<== ORCWriter.initORCAuditSchema()");
        }
    }

    protected Map<String, String> getSchemaFieldTypeMap() {
        HashMap<String, String> ret = new HashMap<String, String>();
        int index1 = this.auditSchema.indexOf("<");
        int index2 = this.auditSchema.indexOf(">");
        String subAuditSchema = this.auditSchema.substring(index1 + 1, index2);
        String[] fields = subAuditSchema.split(",");
        this.schemaFields = new ArrayList();
        for (String field : fields) {
            String[] flds = field.split(":");
            this.schemaFields.add(flds[0]);
            ret.put(flds[0], flds[1]);
        }
        return ret;
    }

    protected void buildVectorRowBatch(Map<String, String> schemaFieldTypeMap) throws Exception {
        int i = 0;
        for (i = 0; i < this.schemaFields.size(); ++i) {
            String fld = this.schemaFields.get(i);
            String fieldType = schemaFieldTypeMap.get(fld);
            ColumnVector columnVector = this.getColumnVectorType(fieldType);
            if (columnVector instanceof LongColumnVector) {
                this.vectorizedRowBatchMap.put(fld, (ColumnVector)((LongColumnVector)this.batch.cols[i]));
                continue;
            }
            if (columnVector instanceof BytesColumnVector) {
                this.vectorizedRowBatchMap.put(fld, (ColumnVector)((BytesColumnVector)this.batch.cols[i]));
                continue;
            }
            if (!(columnVector instanceof DecimalColumnVector)) continue;
            this.vectorizedRowBatchMap.put(fld, (ColumnVector)((DecimalColumnVector)this.batch.cols[i]));
        }
    }

    protected SchemaInfo getFieldValue(AuthzAuditEvent event, String fieldName) {
        SchemaInfo ret = new SchemaInfo();
        try {
            Class<AuthzAuditEvent> aClass = AuthzAuditEvent.class;
            Field fld = aClass.getDeclaredField(fieldName);
            fld.setAccessible(true);
            Class<?> cls = fld.getType();
            Object value = fld.get(event);
            ret.setField(fieldName);
            ret.setType(cls.getName());
            ret.setValue(value);
        }
        catch (Exception e) {
            logger.error("Error while writing into ORC File:", (Throwable)e);
        }
        return ret;
    }

    protected ColumnVector getColumnVectorType(String fieldType) throws Exception {
        LongColumnVector ret = null;
        switch (fieldType = fieldType.toLowerCase()) {
            case "int": 
            case "bigint": 
            case "date": 
            case "boolean": {
                ret = new LongColumnVector();
                break;
            }
            case "string": 
            case "varchar": 
            case "char": 
            case "binary": {
                ret = new BytesColumnVector();
                break;
            }
            case "decimal": {
                ret = new DecimalColumnVector(10, 5);
                break;
            }
            case "double": 
            case "float": {
                ret = new DoubleColumnVector();
                break;
            }
            case "array": 
            case "map": 
            case "uniontype": 
            case "struct": {
                throw new Exception("Unsuppoted field Type");
            }
        }
        return ret;
    }

    protected Long castLongObject(Object object) {
        Long ret = 0L;
        try {
            if (object instanceof Long) {
                ret = (Long)object;
            } else if (object instanceof Integer) {
                ret = ((Integer)object).longValue();
            } else if (object instanceof String) {
                ret = Long.valueOf((String)object);
            }
        }
        catch (Exception e) {
            logger.error("Error while writing into ORC File:", (Throwable)e);
        }
        return ret;
    }

    protected String castStringObject(Object object) {
        String ret = null;
        try {
            if (object instanceof String) {
                ret = (String)object;
            } else if (object instanceof Date) {
                ret = this.getDateString((Date)object);
            }
        }
        catch (Exception e) {
            logger.error("Error while writing into ORC File:", (Throwable)e);
        }
        return ret;
    }

    protected String getAuditSchema() {
        if (logger.isDebugEnabled()) {
            logger.debug("==> ORCWriter.getAuditSchema()");
        }
        String ret = null;
        String fieldStr = "struct<";
        StringBuilder sb = new StringBuilder(fieldStr);
        Class<AuthzAuditEvent> auditEventClass = AuthzAuditEvent.class;
        for (Field fld : auditEventClass.getDeclaredFields()) {
            if (!fld.isAnnotationPresent(JsonProperty.class)) continue;
            String field = fld.getName();
            String fieldType = this.getShortFieldType(fld.getType().getName());
            if (fieldType == null) continue;
            fieldStr = field + ":" + fieldType + ",";
            sb.append(fieldStr);
        }
        fieldStr = sb.toString();
        if (fieldStr.endsWith(",")) {
            fieldStr = fieldStr.substring(0, fieldStr.length() - 1);
        }
        ret = fieldStr + ">";
        if (logger.isDebugEnabled()) {
            logger.debug("<== ORCWriter.getAuditSchema()  AuditSchema: " + ret);
        }
        return ret;
    }

    protected String getShortFieldType(String type) {
        String ret = null;
        switch (type) {
            case "java.lang.String": {
                ret = "string";
                break;
            }
            case "int": {
                ret = "int";
                break;
            }
            case "short": {
                ret = "string";
                break;
            }
            case "java.util.Date": {
                ret = "string";
                break;
            }
            case "long": {
                ret = "bigint";
                break;
            }
            default: {
                ret = null;
            }
        }
        return ret;
    }

    protected CompressionKind getORCCompression(String compression) {
        CompressionKind ret;
        if (compression == null) {
            compression = this.defaultCompression.name().toLowerCase();
        }
        switch (compression) {
            case "snappy": {
                ret = CompressionKind.SNAPPY;
                break;
            }
            case "lzo": {
                ret = CompressionKind.LZO;
                break;
            }
            case "zlib": {
                ret = CompressionKind.ZLIB;
                break;
            }
            case "none": {
                ret = CompressionKind.NONE;
                break;
            }
            default: {
                ret = this.defaultCompression;
            }
        }
        return ret;
    }

    public static void main(String[] args) throws Exception {
        ORCFileUtil auditOrcFileUtil = new ORCFileUtil();
        auditOrcFileUtil.init(10000, 100000L, "snappy");
        try {
            Configuration conf = new Configuration();
            FileSystem fs = FileSystem.get((Configuration)conf);
            Writer write = auditOrcFileUtil.createWriter(conf, fs, "/tmp/test.orc");
            Collection<AuthzAuditEvent> events = ORCFileUtil.getTestEvent();
            auditOrcFileUtil.log(write, events);
            write.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected static Collection<AuthzAuditEvent> getTestEvent() {
        ArrayList<AuthzAuditEvent> events = new ArrayList<AuthzAuditEvent>();
        for (int idx = 0; idx < 20; ++idx) {
            AuthzAuditEvent event = new AuthzAuditEvent();
            event.setEventId(Integer.toString(idx));
            event.setClientIP("127.0.0.1");
            event.setAccessResult((short)1);
            event.setAclEnforcer("ranger-acl");
            event.setRepositoryName("hdfsdev");
            event.setRepositoryType(1);
            event.setResourcePath("/tmp/test-audit.log" + idx + idx + 1);
            event.setResourceType("file");
            event.setAccessType("read");
            event.setEventTime(new Date());
            event.setResultReason(Integer.toString(1));
            events.add(event);
        }
        return events;
    }

    class SchemaInfo {
        String field = null;
        String type = null;
        Object value = null;

        SchemaInfo() {
        }

        public String getField() {
            return this.field;
        }

        public void setField(String field) {
            this.field = field;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
        }
    }
}

