/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon.tasks;

import java.io.IOException;
import java.util.Map;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.hdds.utils.db.TableIterator;
import org.apache.hadoop.ozone.om.helpers.RepeatedOmKeyInfo;
import org.apache.hadoop.ozone.recon.tasks.OMDBUpdateEvent;
import org.apache.hadoop.ozone.recon.tasks.OmTableHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeletedKeysInsightHandler
implements OmTableHandler {
    private static final Logger LOG = LoggerFactory.getLogger(DeletedKeysInsightHandler.class);

    @Override
    public void handlePutEvent(OMDBUpdateEvent<String, Object> event, String tableName, Map<String, Long> objectCountMap, Map<String, Long> unReplicatedSizeMap, Map<String, Long> replicatedSizeMap) {
        if (event.getValue() != null) {
            RepeatedOmKeyInfo repeatedOmKeyInfo = (RepeatedOmKeyInfo)event.getValue();
            objectCountMap.computeIfPresent(this.getTableCountKeyFromTable(tableName), (k, count) -> count + (long)repeatedOmKeyInfo.getOmKeyInfoList().size());
            ImmutablePair result = repeatedOmKeyInfo.getTotalSize();
            unReplicatedSizeMap.computeIfPresent(this.getUnReplicatedSizeKeyFromTable(tableName), (arg_0, arg_1) -> DeletedKeysInsightHandler.lambda$handlePutEvent$1((Pair)result, arg_0, arg_1));
            replicatedSizeMap.computeIfPresent(this.getReplicatedSizeKeyFromTable(tableName), (arg_0, arg_1) -> DeletedKeysInsightHandler.lambda$handlePutEvent$2((Pair)result, arg_0, arg_1));
        } else {
            LOG.warn("Put event does not have the Key Info for {}.", (Object)event.getKey());
        }
    }

    @Override
    public void handleDeleteEvent(OMDBUpdateEvent<String, Object> event, String tableName, Map<String, Long> objectCountMap, Map<String, Long> unReplicatedSizeMap, Map<String, Long> replicatedSizeMap) {
        if (event.getValue() != null) {
            RepeatedOmKeyInfo repeatedOmKeyInfo = (RepeatedOmKeyInfo)event.getValue();
            objectCountMap.computeIfPresent(this.getTableCountKeyFromTable(tableName), (k, count) -> count > 0L ? count - (long)repeatedOmKeyInfo.getOmKeyInfoList().size() : 0L);
            ImmutablePair result = repeatedOmKeyInfo.getTotalSize();
            unReplicatedSizeMap.computeIfPresent(this.getUnReplicatedSizeKeyFromTable(tableName), (arg_0, arg_1) -> DeletedKeysInsightHandler.lambda$handleDeleteEvent$4((Pair)result, arg_0, arg_1));
            replicatedSizeMap.computeIfPresent(this.getReplicatedSizeKeyFromTable(tableName), (arg_0, arg_1) -> DeletedKeysInsightHandler.lambda$handleDeleteEvent$5((Pair)result, arg_0, arg_1));
        } else {
            LOG.warn("Delete event does not have the Key Info for {}.", (Object)event.getKey());
        }
    }

    @Override
    public void handleUpdateEvent(OMDBUpdateEvent<String, Object> event, String tableName, Map<String, Long> objectCountMap, Map<String, Long> unReplicatedSizeMap, Map<String, Long> replicatedSizeMap) {
    }

    @Override
    public Triple<Long, Long, Long> getTableSizeAndCount(TableIterator<String, ? extends Table.KeyValue<String, ?>> iterator) throws IOException {
        long count = 0L;
        long unReplicatedSize = 0L;
        long replicatedSize = 0L;
        if (iterator != null) {
            while (iterator.hasNext()) {
                Table.KeyValue kv = (Table.KeyValue)iterator.next();
                if (kv == null || kv.getValue() == null) continue;
                RepeatedOmKeyInfo repeatedOmKeyInfo = (RepeatedOmKeyInfo)kv.getValue();
                ImmutablePair result = repeatedOmKeyInfo.getTotalSize();
                unReplicatedSize += ((Long)result.getRight()).longValue();
                replicatedSize += ((Long)result.getLeft()).longValue();
                count += (long)repeatedOmKeyInfo.getOmKeyInfoList().size();
            }
        }
        return Triple.of((Object)count, (Object)unReplicatedSize, (Object)replicatedSize);
    }

    private static /* synthetic */ Long lambda$handleDeleteEvent$5(Pair result, String k, Long size) {
        return size > (Long)result.getRight() ? size - (Long)result.getRight() : 0L;
    }

    private static /* synthetic */ Long lambda$handleDeleteEvent$4(Pair result, String k, Long size) {
        return size > (Long)result.getLeft() ? size - (Long)result.getLeft() : 0L;
    }

    private static /* synthetic */ Long lambda$handlePutEvent$2(Pair result, String k, Long size) {
        return size + (Long)result.getRight();
    }

    private static /* synthetic */ Long lambda$handlePutEvent$1(Pair result, String k, Long size) {
        return size + (Long)result.getLeft();
    }
}

