/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon.scm;

import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.scm.container.ContainerManager;
import org.apache.hadoop.hdds.scm.container.IncrementalContainerReportHandler;
import org.apache.hadoop.hdds.scm.ha.SCMContext;
import org.apache.hadoop.hdds.scm.node.NodeManager;
import org.apache.hadoop.hdds.scm.server.SCMDatanodeHeartbeatDispatcher;
import org.apache.hadoop.hdds.server.events.EventPublisher;
import org.apache.hadoop.ozone.recon.scm.ReconContainerManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReconIncrementalContainerReportHandler
extends IncrementalContainerReportHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ReconIncrementalContainerReportHandler.class);

    ReconIncrementalContainerReportHandler(NodeManager nodeManager, ContainerManager containerManager, SCMContext scmContext) {
        super(nodeManager, containerManager, scmContext);
    }

    protected Logger getLogger() {
        return LOG;
    }

    public void onMessage(SCMDatanodeHeartbeatDispatcher.IncrementalContainerReportFromDatanode report, EventPublisher publisher) {
        DatanodeDetails datanode = this.getDatanodeDetails(report);
        if (datanode == null) {
            return;
        }
        ReconContainerManager containerManager = (ReconContainerManager)this.getContainerManager();
        try {
            containerManager.checkAndAddNewContainerBatch(((StorageContainerDatanodeProtocolProtos.IncrementalContainerReportProto)report.getReport()).getReportList());
        }
        catch (Exception ioEx) {
            LOG.error("Exception while checking and adding new container.", (Throwable)ioEx);
            return;
        }
        this.processICR(report, publisher, datanode);
    }
}

