/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.client;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.hadoop.hdds.client.OzoneQuota;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.scm.client.HddsClientUtils;
import org.apache.hadoop.ozone.OzoneAcl;
import org.apache.hadoop.ozone.client.BucketArgs;
import org.apache.hadoop.ozone.client.OzoneBucket;
import org.apache.hadoop.ozone.client.protocol.ClientProtocol;
import org.apache.hadoop.ozone.om.helpers.WithMetadata;
import org.apache.hadoop.ozone.security.acl.OzoneObj;
import org.apache.hadoop.ozone.security.acl.OzoneObjInfo;

public class OzoneVolume
extends WithMetadata {
    private final ClientProtocol proxy;
    private final String name;
    private String admin;
    private String owner;
    private long quotaInBytes;
    private long quotaInNamespace;
    private long usedNamespace;
    private Instant creationTime;
    private Instant modificationTime;
    private List<OzoneAcl> acls;
    private int listCacheSize;
    private OzoneObj ozoneObj;
    private long refCount;

    protected OzoneVolume(Builder builder) {
        super((WithMetadata.Builder)builder);
        this.proxy = builder.proxy;
        this.name = builder.name;
        this.admin = builder.admin;
        this.owner = builder.owner;
        this.quotaInBytes = builder.quotaInBytes;
        this.quotaInNamespace = builder.quotaInNamespace;
        this.usedNamespace = builder.usedNamespace;
        this.creationTime = Instant.ofEpochMilli(builder.creationTime);
        if (builder.modificationTime != 0L) {
            this.modificationTime = Instant.ofEpochMilli(builder.modificationTime);
        } else {
            this.modificationTime = Instant.now();
            if (this.modificationTime.isBefore(this.creationTime)) {
                this.modificationTime = Instant.ofEpochSecond(this.creationTime.getEpochSecond(), this.creationTime.getNano());
            }
        }
        this.acls = new ArrayList<OzoneAcl>(builder.acls);
        if (builder.conf != null) {
            this.listCacheSize = HddsClientUtils.getListCacheSize((ConfigurationSource)builder.conf);
        }
        this.ozoneObj = OzoneObjInfo.Builder.newBuilder().setVolumeName(this.name).setResType(OzoneObj.ResourceType.VOLUME).setStoreType(OzoneObj.StoreType.OZONE).build();
        this.refCount = builder.refCount;
    }

    public String getName() {
        return this.name;
    }

    public String getAdmin() {
        return this.admin;
    }

    public String getOwner() {
        return this.owner;
    }

    public long getQuotaInBytes() {
        return this.quotaInBytes;
    }

    public long getQuotaInNamespace() {
        return this.quotaInNamespace;
    }

    public Instant getCreationTime() {
        return this.creationTime;
    }

    public Instant getModificationTime() {
        return this.modificationTime;
    }

    public List<OzoneAcl> getAcls() {
        return Collections.unmodifiableList(this.acls);
    }

    public boolean addAcl(OzoneAcl addAcl) throws IOException {
        boolean added = this.proxy.addAcl(this.ozoneObj, addAcl);
        if (added) {
            this.acls.add(addAcl);
        }
        return added;
    }

    public boolean removeAcl(OzoneAcl acl) throws IOException {
        boolean removed = this.proxy.removeAcl(this.ozoneObj, acl);
        if (removed) {
            this.acls.remove(acl);
        }
        return removed;
    }

    public boolean setAcl(List<OzoneAcl> aclList) throws IOException {
        boolean reset = this.proxy.setAcl(this.ozoneObj, aclList);
        if (reset) {
            this.acls.clear();
            this.acls.addAll(aclList);
        }
        return reset;
    }

    public long getUsedNamespace() {
        return this.usedNamespace;
    }

    public boolean setOwner(String userName) throws IOException {
        boolean result = this.proxy.setVolumeOwner(this.name, userName);
        this.owner = userName;
        return result;
    }

    public void clearSpaceQuota() throws IOException {
        OzoneVolume ozoneVolume = this.proxy.getVolumeDetails(this.name);
        this.proxy.setVolumeQuota(this.name, ozoneVolume.getQuotaInNamespace(), -1L);
        this.quotaInBytes = -1L;
        this.quotaInNamespace = ozoneVolume.getQuotaInNamespace();
    }

    public void clearNamespaceQuota() throws IOException {
        OzoneVolume ozoneVolume = this.proxy.getVolumeDetails(this.name);
        this.proxy.setVolumeQuota(this.name, -1L, ozoneVolume.getQuotaInBytes());
        this.quotaInBytes = ozoneVolume.getQuotaInBytes();
        this.quotaInNamespace = -1L;
    }

    public void setQuota(OzoneQuota quota) throws IOException {
        this.proxy.setVolumeQuota(this.name, quota.getQuotaInNamespace(), quota.getQuotaInBytes());
        this.quotaInBytes = quota.getQuotaInBytes();
        this.quotaInNamespace = quota.getQuotaInNamespace();
    }

    public void createBucket(String bucketName) throws IOException {
        this.proxy.createBucket(this.name, bucketName);
    }

    public void createBucket(String bucketName, BucketArgs bucketArgs) throws IOException {
        this.proxy.createBucket(this.name, bucketName, bucketArgs);
    }

    public OzoneBucket getBucket(String bucketName) throws IOException {
        OzoneBucket bucket = this.proxy.getBucketDetails(this.name, bucketName);
        return bucket;
    }

    public Iterator<? extends OzoneBucket> listBuckets(String bucketPrefix) {
        return this.listBuckets(bucketPrefix, null);
    }

    public Iterator<? extends OzoneBucket> listBuckets(String bucketPrefix, String prevBucket) {
        return this.listBuckets(bucketPrefix, prevBucket, false);
    }

    public Iterator<? extends OzoneBucket> listBuckets(String bucketPrefix, String prevBucket, boolean hasSnapshot) {
        return new BucketIterator(bucketPrefix, prevBucket, hasSnapshot);
    }

    public void deleteBucket(String bucketName) throws IOException {
        this.proxy.deleteBucket(this.name, bucketName);
    }

    public long getRefCount() {
        return this.refCount;
    }

    public static Builder newBuilder(ConfigurationSource conf, ClientProtocol proxy) {
        Preconditions.checkNotNull((Object)proxy, (Object)"Client proxy is not set.");
        return new Builder(conf, proxy);
    }

    public static class Builder
    extends WithMetadata.Builder {
        private ConfigurationSource conf;
        private ClientProtocol proxy;
        private String name;
        private String admin;
        private String owner;
        private long quotaInBytes;
        private long quotaInNamespace;
        private long usedNamespace;
        private long creationTime;
        private long modificationTime;
        private List<OzoneAcl> acls;
        private long refCount;

        protected Builder() {
        }

        private Builder(ConfigurationSource conf, ClientProtocol proxy) {
            this.conf = conf;
            this.proxy = proxy;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setAdmin(String admin) {
            this.admin = admin;
            return this;
        }

        public Builder setOwner(String owner) {
            this.owner = owner;
            return this;
        }

        public Builder setQuotaInBytes(long quotaInBytes) {
            this.quotaInBytes = quotaInBytes;
            return this;
        }

        public Builder setQuotaInNamespace(long quotaInNamespace) {
            this.quotaInNamespace = quotaInNamespace;
            return this;
        }

        public Builder setUsedNamespace(long usedNamespace) {
            this.usedNamespace = usedNamespace;
            return this;
        }

        public Builder setCreationTime(long creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public Builder setModificationTime(long modificationTime) {
            this.modificationTime = modificationTime;
            return this;
        }

        public Builder setAcls(List<OzoneAcl> acls) {
            this.acls = acls;
            return this;
        }

        public Builder setRefCount(long refCount) {
            this.refCount = refCount;
            return this;
        }

        public Builder setMetadata(Map<String, String> metadata) {
            super.setMetadata(metadata);
            return this;
        }

        public OzoneVolume build() {
            return new OzoneVolume(this);
        }
    }

    private class BucketIterator
    implements Iterator<OzoneBucket> {
        private String bucketPrefix = null;
        private Iterator<OzoneBucket> currentIterator;
        private OzoneBucket currentValue;
        private boolean hasSnapshot;

        BucketIterator(String bucketPrefix, String prevBucket, boolean hasSnapshot) {
            this.bucketPrefix = bucketPrefix;
            this.currentValue = null;
            this.hasSnapshot = hasSnapshot;
            this.currentIterator = this.getNextListOfBuckets(prevBucket).iterator();
        }

        @Override
        public boolean hasNext() {
            if (!this.currentIterator.hasNext() && this.currentValue != null) {
                this.currentIterator = this.getNextListOfBuckets(this.currentValue.getName()).iterator();
            }
            return this.currentIterator.hasNext();
        }

        @Override
        public OzoneBucket next() {
            if (this.hasNext()) {
                this.currentValue = this.currentIterator.next();
                return this.currentValue;
            }
            throw new NoSuchElementException();
        }

        private List<OzoneBucket> getNextListOfBuckets(String prevBucket) {
            try {
                return OzoneVolume.this.proxy.listBuckets(OzoneVolume.this.name, this.bucketPrefix, prevBucket, OzoneVolume.this.listCacheSize, this.hasSnapshot);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

