/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.common.transport.server.ratis;

import java.util.EnumMap;
import org.apache.hadoop.hdds.annotation.InterfaceAudience;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.MetricsRegistry;
import org.apache.hadoop.metrics2.lib.MutableCounterLong;
import org.apache.hadoop.metrics2.lib.MutableRate;
import org.apache.ratis.protocol.RaftGroupId;

@InterfaceAudience.Private
@Metrics(about="Container State Machine Metrics", context="dfs")
public class CSMMetrics {
    public static final String SOURCE_NAME = CSMMetrics.class.getSimpleName();
    private RaftGroupId gid;
    @Metric
    private MutableCounterLong numWriteStateMachineOps;
    @Metric
    private MutableCounterLong numQueryStateMachineOps;
    @Metric
    private MutableCounterLong numApplyTransactionOps;
    @Metric
    private MutableCounterLong numReadStateMachineOps;
    @Metric
    private MutableCounterLong numBytesWrittenCount;
    @Metric
    private MutableCounterLong numBytesCommittedCount;
    @Metric
    private MutableRate transactionLatencyMs;
    private final EnumMap<ContainerProtos.Type, MutableRate> opsLatencyMs;
    private final EnumMap<ContainerProtos.Type, MutableRate> opsQueueingDelay;
    private MetricsRegistry registry;
    @Metric
    private MutableCounterLong numWriteStateMachineFails;
    @Metric
    private MutableCounterLong numWriteDataFails;
    @Metric
    private MutableCounterLong numQueryStateMachineFails;
    @Metric
    private MutableCounterLong numApplyTransactionFails;
    @Metric
    private MutableCounterLong numReadStateMachineFails;
    @Metric
    private MutableCounterLong numReadStateMachineMissCount;
    @Metric
    private MutableCounterLong numStartTransactionVerifyFailures;
    @Metric
    private MutableCounterLong numContainerNotOpenVerifyFailures;
    @Metric
    private MutableCounterLong numDataCacheMiss;
    @Metric
    private MutableCounterLong numDataCacheHit;
    @Metric
    private MutableCounterLong numEvictedCacheCount;
    @Metric
    private MutableCounterLong pendingApplyTransactions;
    @Metric
    private MutableRate applyTransactionNs;
    @Metric
    private MutableRate writeStateMachineDataNs;
    @Metric
    private MutableRate writeStateMachineQueueingLatencyNs;
    @Metric
    private MutableRate untilApplyTransactionNs;
    @Metric
    private MutableRate startTransactionCompleteNs;

    public CSMMetrics(RaftGroupId gid) {
        this.gid = gid;
        this.opsLatencyMs = new EnumMap(ContainerProtos.Type.class);
        this.opsQueueingDelay = new EnumMap(ContainerProtos.Type.class);
        this.registry = new MetricsRegistry(CSMMetrics.class.getSimpleName());
        for (ContainerProtos.Type type : ContainerProtos.Type.values()) {
            this.opsLatencyMs.put(type, this.registry.newRate(type.toString() + "Ms", type + " op"));
            this.opsQueueingDelay.put(type, this.registry.newRate("queueingDelay" + type.toString() + "Ns", type + " op"));
        }
    }

    public static CSMMetrics create(RaftGroupId gid) {
        MetricsSystem ms = DefaultMetricsSystem.instance();
        return (CSMMetrics)ms.register(SOURCE_NAME + gid.toString(), "Container State Machine", (Object)new CSMMetrics(gid));
    }

    @Metric
    public String getRaftGroupId() {
        return this.gid.toString();
    }

    public void incNumWriteStateMachineOps() {
        this.numWriteStateMachineOps.incr();
    }

    public void incNumQueryStateMachineOps() {
        this.numQueryStateMachineOps.incr();
    }

    public void incNumReadStateMachineOps() {
        this.numReadStateMachineOps.incr();
    }

    public void incNumApplyTransactionsOps() {
        this.numApplyTransactionOps.incr();
    }

    public void incNumWriteStateMachineFails() {
        this.numWriteStateMachineFails.incr();
    }

    public void incNumWriteDataFails() {
        this.numWriteDataFails.incr();
    }

    public void incNumQueryStateMachineFails() {
        this.numQueryStateMachineFails.incr();
    }

    public void incNumBytesWrittenCount(long value) {
        this.numBytesWrittenCount.incr(value);
    }

    public void incNumBytesCommittedCount(long value) {
        this.numBytesCommittedCount.incr(value);
    }

    public void incNumReadStateMachineFails() {
        this.numReadStateMachineFails.incr();
    }

    public void incNumReadStateMachineMissCount() {
        this.numReadStateMachineMissCount.incr();
    }

    public void incNumApplyTransactionsFails() {
        this.numApplyTransactionFails.incr();
    }

    public long getNumWriteStateMachineOps() {
        return this.numWriteStateMachineOps.value();
    }

    public long getNumQueryStateMachineOps() {
        return this.numQueryStateMachineOps.value();
    }

    public long getNumApplyTransactionsOps() {
        return this.numApplyTransactionOps.value();
    }

    public long getNumWriteStateMachineFails() {
        return this.numWriteStateMachineFails.value();
    }

    public long getNumWriteDataFails() {
        return this.numWriteDataFails.value();
    }

    public long getNumQueryStateMachineFails() {
        return this.numQueryStateMachineFails.value();
    }

    public long getNumApplyTransactionsFails() {
        return this.numApplyTransactionFails.value();
    }

    public long getNumReadStateMachineFails() {
        return this.numReadStateMachineFails.value();
    }

    public long getNumReadStateMachineMissCount() {
        return this.numReadStateMachineMissCount.value();
    }

    public long getNumReadStateMachineOps() {
        return this.numReadStateMachineOps.value();
    }

    public long getNumBytesWrittenCount() {
        return this.numBytesWrittenCount.value();
    }

    public long getNumBytesCommittedCount() {
        return this.numBytesCommittedCount.value();
    }

    MutableRate getApplyTransactionLatencyNs() {
        return this.applyTransactionNs;
    }

    public void incPipelineLatencyMs(ContainerProtos.Type type, long latencyMillis) {
        this.opsLatencyMs.get(type).add(latencyMillis);
        this.transactionLatencyMs.add(latencyMillis);
    }

    public void recordQueueingDelay(ContainerProtos.Type type, long latencyNanos) {
        this.opsQueueingDelay.get(type).add(latencyNanos);
    }

    public void incNumStartTransactionVerifyFailures() {
        this.numStartTransactionVerifyFailures.incr();
    }

    public void incNumContainerNotOpenVerifyFailures() {
        this.numContainerNotOpenVerifyFailures.incr();
    }

    public void recordApplyTransactionCompletionNs(long latencyNanos) {
        this.applyTransactionNs.add(latencyNanos);
    }

    public void recordWriteStateMachineCompletionNs(long latencyNanos) {
        this.writeStateMachineDataNs.add(latencyNanos);
    }

    public void recordWriteStateMachineQueueingLatencyNs(long latencyNanos) {
        this.writeStateMachineQueueingLatencyNs.add(latencyNanos);
    }

    public void recordUntilApplyTransactionNs(long latencyNanos) {
        this.untilApplyTransactionNs.add(latencyNanos);
    }

    public void recordStartTransactionCompleteNs(long latencyNanos) {
        this.startTransactionCompleteNs.add(latencyNanos);
    }

    public void incNumDataCacheMiss() {
        this.numDataCacheMiss.incr();
    }

    public void incNumDataCacheHit() {
        this.numDataCacheHit.incr();
    }

    public void incNumEvictedCacheCount() {
        this.numEvictedCacheCount.incr();
    }

    public void incPendingApplyTransactions() {
        this.pendingApplyTransactions.incr();
    }

    public void decPendingApplyTransactions() {
        this.pendingApplyTransactions.incr(-1L);
    }

    public void unRegister() {
        MetricsSystem ms = DefaultMetricsSystem.instance();
        ms.unregisterSource(SOURCE_NAME + this.gid.toString());
    }
}

