/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jooq.DSLContext;
import org.jooq.Explain;
import org.jooq.Query;
import org.jooq.Record;
import org.jooq.Result;

final class ExplainQuery {
    ExplainQuery() {
    }

    static Explain explain(DSLContext ctx, Query query) {
        Result<Record> result = null;
        switch (ctx.family()) {
            case H2: {
                result = ctx.fetch("{explain analyze} {0}", query);
                break;
            }
            default: {
                result = ctx.fetch("{explain} {0}", query);
            }
        }
        double cost = Double.NaN;
        double rows = Double.NaN;
        switch (ctx.family()) {
            case H2: {
                break;
            }
            case MARIADB: 
            case MYSQL: {
                rows = ((Record)result.get(0)).get("rows", Double.TYPE);
                break;
            }
            case POSTGRES: {
                Matcher matcher = Pattern.compile(".*\\bcost=\\d+\\.\\d+\\.\\.(\\d+\\.\\d+)\\s+rows=(\\d+).*").matcher(((Record)result.get(0)).get(0, String.class));
                cost = Double.parseDouble(matcher.replaceAll("$1"));
                rows = Double.parseDouble(matcher.replaceAll("$2"));
                break;
            }
        }
        return new ExplainImpl(rows, cost, result.format());
    }

    private static final class ExplainImpl
    implements Explain {
        private final double rows;
        private final double cost;
        private final String plan;

        ExplainImpl(double rows, double cost, String plan) {
            this.rows = rows;
            this.cost = cost;
            this.plan = plan;
        }

        @Override
        public final double rows() {
            return this.rows;
        }

        @Override
        public final double cost() {
            return this.cost;
        }

        @Override
        public final String plan() {
            return this.plan;
        }

        public String toString() {
            return String.format("Explain [cost=%.2f, rows=%.2f]\n\n", this.cost, this.rows) + this.plan;
        }
    }
}

