/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.pipeline;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hadoop.hdds.client.ReplicationConfig;
import org.apache.hadoop.hdds.client.StandaloneReplicationConfig;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.scm.container.ContainerReplica;
import org.apache.hadoop.hdds.scm.node.NodeManager;
import org.apache.hadoop.hdds.scm.pipeline.InsufficientDatanodesException;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.scm.pipeline.PipelineID;
import org.apache.hadoop.hdds.scm.pipeline.PipelineProvider;
import org.apache.hadoop.hdds.scm.pipeline.PipelineStateManager;

public class SimplePipelineProvider
extends PipelineProvider<StandaloneReplicationConfig> {
    public SimplePipelineProvider(NodeManager nodeManager, PipelineStateManager stateManager) {
        super(nodeManager, stateManager);
    }

    @Override
    public Pipeline create(StandaloneReplicationConfig replicationConfig) throws IOException {
        return this.create(replicationConfig, Collections.emptyList(), Collections.emptyList());
    }

    @Override
    public Pipeline create(StandaloneReplicationConfig replicationConfig, List<DatanodeDetails> excludedNodes, List<DatanodeDetails> favoredNodes) throws IOException {
        int required;
        List<DatanodeDetails> dns = this.pickNodesNotUsed(replicationConfig);
        int available = dns.size();
        if (available < (required = replicationConfig.getRequiredNodes())) {
            String msg = String.format("Cannot create pipeline of factor %d using %d nodes.", required, available);
            throw new InsufficientDatanodesException(required, available, msg);
        }
        Collections.shuffle(dns);
        return Pipeline.newBuilder().setId(PipelineID.randomId()).setState(Pipeline.PipelineState.OPEN).setReplicationConfig((ReplicationConfig)replicationConfig).setNodes(dns.subList(0, replicationConfig.getReplicationFactor().getNumber())).build();
    }

    @Override
    public Pipeline create(StandaloneReplicationConfig replicationConfig, List<DatanodeDetails> nodes) {
        return Pipeline.newBuilder().setId(PipelineID.randomId()).setState(Pipeline.PipelineState.OPEN).setReplicationConfig((ReplicationConfig)replicationConfig).setNodes(nodes).build();
    }

    @Override
    public Pipeline createForRead(StandaloneReplicationConfig replicationConfig, Set<ContainerReplica> replicas) {
        return this.create(replicationConfig, replicas.stream().map(ContainerReplica::getDatanodeDetails).collect(Collectors.toList()));
    }

    @Override
    public void close(Pipeline pipeline) throws IOException {
    }

    @Override
    public void shutdown() {
    }
}

