/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.repair.datanode.schemaupgrade;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.ozone.container.common.volume.HddsVolume;
import org.apache.hadoop.ozone.container.metadata.DatanodeStoreSchemaThreeImpl;
import org.apache.hadoop.ozone.repair.datanode.schemaupgrade.ContainerUpgradeResult;
import org.apache.hadoop.util.Time;

class VolumeUpgradeResult {
    private Map<Long, ContainerUpgradeResult> resultMap;
    private final HddsVolume hddsVolume;
    private final long startTimeMs = Time.monotonicNow();
    private long endTimeMs = 0L;
    private Exception e = null;
    private Status status = Status.FAIL;
    private DatanodeStoreSchemaThreeImpl store;

    VolumeUpgradeResult(HddsVolume hddsVolume) {
        this.hddsVolume = hddsVolume;
    }

    public HddsVolume getHddsVolume() {
        return this.hddsVolume;
    }

    public long getCost() {
        return this.endTimeMs - this.startTimeMs;
    }

    DatanodeStoreSchemaThreeImpl getStore() {
        return this.store;
    }

    void setStore(DatanodeStoreSchemaThreeImpl store) {
        this.store = store;
    }

    public void setResultList(List<ContainerUpgradeResult> resultList) {
        this.resultMap = new HashMap<Long, ContainerUpgradeResult>();
        resultList.forEach(res -> this.resultMap.put(res.getOriginContainerData().getContainerID(), (ContainerUpgradeResult)res));
    }

    public Map<Long, ContainerUpgradeResult> getResultMap() {
        return this.resultMap;
    }

    public boolean isSuccess() {
        return this.status == Status.SUCCESS;
    }

    public void success() {
        this.endTimeMs = Time.monotonicNow();
        this.status = Status.SUCCESS;
    }

    public void fail(Exception exception) {
        this.endTimeMs = Time.monotonicNow();
        this.status = Status.FAIL;
        this.e = exception;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Result:{");
        stringBuilder.append("hddsRootDir=");
        stringBuilder.append(this.getHddsVolume().getHddsRootDir());
        stringBuilder.append(", resultList=");
        AtomicLong total = new AtomicLong(0L);
        if (this.resultMap != null) {
            this.resultMap.forEach((k, r) -> {
                stringBuilder.append(r.toString());
                stringBuilder.append('\n');
                total.addAndGet(r.getTotalRow());
            });
        }
        stringBuilder.append(", totalRow=");
        stringBuilder.append(total.get());
        stringBuilder.append(", costMs=");
        stringBuilder.append(this.getCost());
        stringBuilder.append(", status=");
        stringBuilder.append((Object)this.status);
        if (this.e != null) {
            stringBuilder.append(", Exception=");
            stringBuilder.append(this.e);
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    static enum Status {
        SUCCESS,
        FAIL;

    }
}

