/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.response.snapshot;

import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.util.Collection;
import org.apache.hadoop.hdds.utils.db.BatchOperation;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.helpers.SnapshotInfo;
import org.apache.hadoop.ozone.om.response.CleanupTableInfo;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;

@CleanupTableInfo(cleanupTables={"snapshotInfoTable"})
public class OMSnapshotSetPropertyResponse
extends OMClientResponse {
    private final Collection<SnapshotInfo> updatedSnapInfos;

    public OMSnapshotSetPropertyResponse(@Nonnull OzoneManagerProtocolProtos.OMResponse omResponse, @Nonnull Collection<SnapshotInfo> updatedSnapInfos) {
        super(omResponse);
        this.updatedSnapInfos = updatedSnapInfos;
    }

    public OMSnapshotSetPropertyResponse(@Nonnull OzoneManagerProtocolProtos.OMResponse omResponse) {
        super(omResponse);
        this.checkStatusNotOK();
        this.updatedSnapInfos = null;
    }

    @Override
    protected void addToDBBatch(OMMetadataManager omMetadataManager, BatchOperation batchOperation) throws IOException {
        for (SnapshotInfo updatedSnapInfo : this.updatedSnapInfos) {
            omMetadataManager.getSnapshotInfoTable().putWithBatch(batchOperation, (Object)updatedSnapInfo.getTableKey(), (Object)updatedSnapInfo);
        }
    }
}

