/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.response.s3.security;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import org.apache.hadoop.hdds.utils.db.BatchOperation;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.S3SecretManager;
import org.apache.hadoop.ozone.om.helpers.S3SecretValue;
import org.apache.hadoop.ozone.om.response.CleanupTableInfo;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@CleanupTableInfo(cleanupTables={"s3SecretTable"})
public class OMSetSecretResponse
extends OMClientResponse {
    private static final Logger LOG = LoggerFactory.getLogger(OMSetSecretResponse.class);
    private String accessId;
    private S3SecretValue s3SecretValue;
    private S3SecretManager secretManager;

    public OMSetSecretResponse(@Nullable String accessId, @Nullable S3SecretValue s3SecretValue, @Nonnull S3SecretManager secretManager, @Nonnull OzoneManagerProtocolProtos.OMResponse omResponse) {
        super(omResponse);
        this.accessId = accessId;
        this.s3SecretValue = s3SecretValue;
        this.secretManager = secretManager;
    }

    public OMSetSecretResponse(@Nonnull OzoneManagerProtocolProtos.OMResponse omResponse) {
        super(omResponse);
        this.checkStatusNotOK();
    }

    @Override
    public void addToDBBatch(OMMetadataManager omMetadataManager, BatchOperation batchOperation) throws IOException {
        assert (this.getOMResponse().getStatus() == OzoneManagerProtocolProtos.Status.OK);
        if (this.s3SecretValue != null) {
            LOG.debug("Updating TenantAccessIdTable");
            if (this.secretManager.isBatchSupported()) {
                this.secretManager.batcher().addWithBatch((AutoCloseable)batchOperation, this.accessId, this.s3SecretValue);
            } else {
                this.secretManager.storeSecret(this.accessId, this.s3SecretValue);
            }
        }
    }
}

