/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.s3.tagging;

import java.io.IOException;
import org.apache.hadoop.hdds.utils.db.cache.CacheKey;
import org.apache.hadoop.hdds.utils.db.cache.CacheValue;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OMMetrics;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.execution.flowcontrol.ExecutionContext;
import org.apache.hadoop.ozone.om.helpers.BucketLayout;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OzoneFSUtils;
import org.apache.hadoop.ozone.om.helpers.OzoneFileStatus;
import org.apache.hadoop.ozone.om.lock.IOzoneManagerLock;
import org.apache.hadoop.ozone.om.lock.OzoneManagerLock;
import org.apache.hadoop.ozone.om.request.OMClientRequest;
import org.apache.hadoop.ozone.om.request.file.OMFileRequest;
import org.apache.hadoop.ozone.om.request.s3.tagging.S3DeleteObjectTaggingRequest;
import org.apache.hadoop.ozone.om.request.util.OmResponseUtil;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.s3.tagging.S3DeleteObjectTaggingResponseWithFSO;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3DeleteObjectTaggingRequestWithFSO
extends S3DeleteObjectTaggingRequest {
    private static final Logger LOG = LoggerFactory.getLogger(S3DeleteObjectTaggingRequestWithFSO.class);

    public S3DeleteObjectTaggingRequestWithFSO(OzoneManagerProtocolProtos.OMRequest omRequest, BucketLayout bucketLayout) {
        super(omRequest, bucketLayout);
    }

    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, ExecutionContext context) {
        OMClientRequest.Result result;
        IOException exception;
        OMClientResponse omClientResponse;
        OMMetrics omMetrics;
        String keyName;
        String bucketName;
        String volumeName;
        OzoneManagerProtocolProtos.DeleteObjectTaggingRequest deleteObjectTaggingRequest;
        block17: {
            long trxnLogIndex = context.getIndex();
            deleteObjectTaggingRequest = this.getOmRequest().getDeleteObjectTaggingRequest();
            OzoneManagerProtocolProtos.KeyArgs keyArgs = deleteObjectTaggingRequest.getKeyArgs();
            volumeName = keyArgs.getVolumeName();
            bucketName = keyArgs.getBucketName();
            keyName = keyArgs.getKeyName();
            omMetrics = ozoneManager.getMetrics();
            omMetrics.incNumDeleteObjectTagging();
            this.buildKeyArgsAuditMap(keyArgs);
            OzoneManagerProtocolProtos.OMResponse.Builder omResponse = OmResponseUtil.getOMResponseBuilder(this.getOmRequest());
            OMMetadataManager omMetadataManager = ozoneManager.getMetadataManager();
            boolean acquiredLock = false;
            omClientResponse = null;
            exception = null;
            result = null;
            try {
                try {
                    this.mergeOmLockDetails(omMetadataManager.getLock().acquireWriteLock((IOzoneManagerLock.Resource)OzoneManagerLock.LeveledResource.BUCKET_LOCK, new String[]{volumeName, bucketName}));
                    acquiredLock = this.getOmLockDetails().isLockAcquired();
                    this.validateBucketAndVolume(omMetadataManager, volumeName, bucketName);
                    OzoneFileStatus keyStatus = OMFileRequest.getOMKeyInfoIfExists(omMetadataManager, volumeName, bucketName, keyName, 0L, ozoneManager.getDefaultReplicationConfig());
                    if (keyStatus == null) {
                        throw new OMException("Key not found. Key: " + keyName, OMException.ResultCodes.KEY_NOT_FOUND);
                    }
                    boolean isDirectory = keyStatus.isDirectory();
                    if (isDirectory) {
                        throw new OMException("DeleteObjectTagging is not currently supported for FSO directory", OMException.ResultCodes.NOT_SUPPORTED_OPERATION);
                    }
                    OmKeyInfo omKeyInfo = keyStatus.getKeyInfo();
                    omKeyInfo.setKeyName(OzoneFSUtils.getFileName((String)keyName));
                    long volumeId = omMetadataManager.getVolumeId(volumeName);
                    long bucketId = omMetadataManager.getBucketId(volumeName, bucketName);
                    String dbKey = omMetadataManager.getOzonePathKey(volumeId, bucketId, omKeyInfo.getParentObjectID(), omKeyInfo.getFileName());
                    omKeyInfo.getTags().clear();
                    omKeyInfo.setUpdateID(trxnLogIndex);
                    omMetadataManager.getKeyTable(this.getBucketLayout()).addCacheEntry(new CacheKey((Object)dbKey), CacheValue.get((long)trxnLogIndex, (Object)omKeyInfo));
                    omClientResponse = new S3DeleteObjectTaggingResponseWithFSO(omResponse.setDeleteObjectTaggingResponse(OzoneManagerProtocolProtos.DeleteObjectTaggingResponse.newBuilder()).build(), omKeyInfo, volumeId, bucketId);
                    result = OMClientRequest.Result.SUCCESS;
                }
                catch (IOException ex) {
                    result = OMClientRequest.Result.FAILURE;
                    exception = ex;
                    omClientResponse = new S3DeleteObjectTaggingResponseWithFSO(this.createErrorOMResponse(omResponse, exception), this.getBucketLayout());
                    if (acquiredLock) {
                        this.mergeOmLockDetails(omMetadataManager.getLock().releaseWriteLock((IOzoneManagerLock.Resource)OzoneManagerLock.LeveledResource.BUCKET_LOCK, new String[]{volumeName, bucketName}));
                    }
                    if (omClientResponse != null) {
                        omClientResponse.setOmLockDetails(this.getOmLockDetails());
                    }
                    break block17;
                }
            }
            catch (Throwable throwable) {
                if (acquiredLock) {
                    this.mergeOmLockDetails(omMetadataManager.getLock().releaseWriteLock((IOzoneManagerLock.Resource)OzoneManagerLock.LeveledResource.BUCKET_LOCK, new String[]{volumeName, bucketName}));
                }
                if (omClientResponse != null) {
                    omClientResponse.setOmLockDetails(this.getOmLockDetails());
                }
                throw throwable;
            }
            if (acquiredLock) {
                this.mergeOmLockDetails(omMetadataManager.getLock().releaseWriteLock((IOzoneManagerLock.Resource)OzoneManagerLock.LeveledResource.BUCKET_LOCK, new String[]{volumeName, bucketName}));
            }
            if (omClientResponse != null) {
                omClientResponse.setOmLockDetails(this.getOmLockDetails());
            }
        }
        switch (result) {
            case SUCCESS: {
                LOG.debug("Delete object tagging success. Volume:{}, Bucket:{}, Key:{}.", new Object[]{volumeName, bucketName, keyName});
                break;
            }
            case FAILURE: {
                omMetrics.incNumDeleteObjectTaggingFails();
                LOG.error("Delete object tagging failed. Volume:{}, Bucket:{}, Key:{}.", new Object[]{volumeName, bucketName, keyName, exception});
                break;
            }
            default: {
                LOG.error("Unrecognized Result for S3DeleteObjectTaggingRequest: {}", (Object)deleteObjectTaggingRequest);
            }
        }
        return omClientResponse;
    }
}

