/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import jakarta.annotation.Nonnull;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.recon.ReconConfig;
import org.apache.hadoop.hdds.utils.Archiver;
import org.apache.hadoop.hdds.utils.DBCheckpointServlet;
import org.apache.hadoop.hdds.utils.HddsServerUtil;
import org.apache.hadoop.hdds.utils.db.DBCheckpoint;
import org.apache.hadoop.hdds.utils.db.RDBCheckpointUtils;
import org.apache.hadoop.hdds.utils.db.RDBStore;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.ozone.lock.BootstrapStateHandler;
import org.apache.hadoop.ozone.om.OmMetadataManagerImpl;
import org.apache.hadoop.ozone.om.OmSnapshotManager;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.helpers.SnapshotInfo;
import org.apache.hadoop.ozone.om.snapshot.OMDBCheckpointUtils;
import org.apache.hadoop.ozone.om.snapshot.OmSnapshotUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.Time;
import org.apache.ozone.rocksdiff.RocksDBCheckpointDiffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMDBCheckpointServlet
extends DBCheckpointServlet {
    private static final Logger LOG = LoggerFactory.getLogger(OMDBCheckpointServlet.class);
    private static final long serialVersionUID = 1L;
    private transient BootstrapStateHandler.Lock lock;
    private long maxTotalSstSize = 0L;

    public void init() throws ServletException {
        OzoneManager om = (OzoneManager)this.getServletContext().getAttribute("ozone.om");
        if (om == null) {
            LOG.error("Unable to initialize OMDBCheckpointServlet. OM is null");
            return;
        }
        OzoneConfiguration conf = this.getConf();
        LinkedHashSet<String> allowedUsers = new LinkedHashSet<String>(om.getOmAdminUsernames());
        Collection<String> allowedGroups = om.getOmAdminGroups();
        ReconConfig reconConfig = (ReconConfig)conf.getObject(ReconConfig.class);
        String reconPrincipal = reconConfig.getKerberosPrincipal();
        if (!reconPrincipal.isEmpty()) {
            UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)reconPrincipal);
            allowedUsers.add(ugi.getShortUserName());
        }
        this.initialize(om.getMetadataManager().getStore(), om.getMetrics().getDBCheckpointMetrics(), om.getAclsEnabled(), allowedUsers, allowedGroups, om.isSpnegoEnabled());
        this.lock = new Lock(om);
    }

    public void writeDbDataToStream(DBCheckpoint checkpoint, HttpServletRequest request, OutputStream destination, Set<String> toExcludeList, Path tmpdir) throws IOException, InterruptedException {
        Objects.requireNonNull(toExcludeList);
        HashMap<String, Map<Path, Path>> copyFiles = new HashMap<String, Map<Path, Path>>();
        HashMap<Path, Path> hardLinkFiles = new HashMap<Path, Path>();
        try {
            Throwable throwable = null;
            Object var9_11 = null;
            try (ArchiveOutputStream archiveOutputStream = Archiver.tar((OutputStream)destination);){
                RocksDBCheckpointDiffer differ = this.getDbStore().getRocksDBCheckpointDiffer();
                DirectoryData sstBackupDir = new DirectoryData(tmpdir, differ.getSSTBackupDir());
                DirectoryData compactionLogDir = new DirectoryData(tmpdir, differ.getCompactionLogDir());
                Map<String, Map<Path, Path>> sstFilesToExclude = OMDBCheckpointServlet.normalizeExcludeList(toExcludeList, checkpoint.getCheckpointLocation(), sstBackupDir);
                boolean completed = this.getFilesForArchive(checkpoint, copyFiles, hardLinkFiles, sstFilesToExclude, OMDBCheckpointUtils.includeSnapshotData(request), sstBackupDir, compactionLogDir);
                Map<Path, Path> flatCopyFiles = copyFiles.values().stream().flatMap(map -> map.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
                this.writeFilesToArchive(flatCopyFiles, hardLinkFiles, (ArchiveOutputStream<TarArchiveEntry>)archiveOutputStream, completed, checkpoint.getCheckpointLocation());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            LOG.error("got exception writing to archive " + e);
            throw e;
        }
    }

    @VisibleForTesting
    public static Map<String, Map<Path, Path>> normalizeExcludeList(Collection<String> toExcludeList, Path checkpointLocation, DirectoryData sstBackupDir) {
        HashMap<String, Map<Path, Path>> paths = new HashMap<String, Map<Path, Path>>();
        Path metaDirPath = OMDBCheckpointServlet.getMetaDirPath(checkpointLocation);
        for (String s : toExcludeList) {
            Path fileName = Paths.get(s, new String[0]).getFileName();
            if (fileName == null) continue;
            Path destPath = Paths.get(metaDirPath.toString(), s);
            Map fileMap = paths.computeIfAbsent(fileName.toString(), k -> new HashMap());
            if (destPath.toString().startsWith(sstBackupDir.getOriginalDir().toString())) {
                int truncateLength = sstBackupDir.getOriginalDir().toString().length() + 1;
                Path srcPath = Paths.get(sstBackupDir.getTmpDir().toString(), OmSnapshotUtils.truncateFileName(truncateLength, destPath));
                fileMap.put(srcPath, destPath);
                continue;
            }
            if (!s.startsWith("db.snapshots")) {
                Path fixedPath = Paths.get(checkpointLocation.toString(), s);
                fileMap.put(fixedPath, fixedPath);
                continue;
            }
            fileMap.put(destPath, destPath);
        }
        return paths;
    }

    public DBCheckpoint getCheckpoint(Path tmpdir, boolean flush) throws IOException {
        RocksDBCheckpointDiffer differ = this.getDbStore().getRocksDBCheckpointDiffer();
        DirectoryData sstBackupDir = new DirectoryData(tmpdir, differ.getSSTBackupDir());
        DirectoryData compactionLogDir = new DirectoryData(tmpdir, differ.getCompactionLogDir());
        DBCheckpoint dbCheckpoint = this.getDbStore().getCheckpoint(flush);
        FileUtils.copyDirectory((File)compactionLogDir.getOriginalDir(), (File)compactionLogDir.getTmpDir());
        OmSnapshotUtils.linkFiles(sstBackupDir.getOriginalDir(), sstBackupDir.getTmpDir());
        return dbCheckpoint;
    }

    private boolean getFilesForArchive(DBCheckpoint checkpoint, Map<String, Map<Path, Path>> copyFiles, Map<Path, Path> hardLinkFiles, Map<String, Map<Path, Path>> sstFilesToExclude, boolean includeSnapshotData, DirectoryData sstBackupDir, DirectoryData compactionLogDir) throws IOException {
        Path dir;
        this.maxTotalSstSize = this.getConf().getLong("ozone.om.ratis.snapshot.max.total.sst.size", 100000000L);
        if (!includeSnapshotData) {
            this.maxTotalSstSize = Long.MAX_VALUE;
        }
        AtomicLong copySize = new AtomicLong(0L);
        if (sstFilesToExclude.isEmpty()) {
            this.logEstimatedTarballSize(checkpoint, includeSnapshotData);
        }
        if (!this.processDir(dir = checkpoint.getCheckpointLocation(), copyFiles, hardLinkFiles, sstFilesToExclude, new HashSet<Path>(), copySize, null)) {
            return false;
        }
        if (!includeSnapshotData) {
            return true;
        }
        Set<Path> snapshotPaths = this.getSnapshotDirs(checkpoint, true);
        Path snapshotDir = this.getSnapshotDir();
        if (!this.processDir(snapshotDir, copyFiles, hardLinkFiles, sstFilesToExclude, snapshotPaths, copySize, null)) {
            return false;
        }
        if (!this.processDir(sstBackupDir.getTmpDir().toPath(), copyFiles, hardLinkFiles, sstFilesToExclude, new HashSet<Path>(), copySize, sstBackupDir.getOriginalDir().toPath())) {
            return false;
        }
        return this.processDir(compactionLogDir.getTmpDir().toPath(), copyFiles, hardLinkFiles, sstFilesToExclude, new HashSet<Path>(), copySize, compactionLogDir.getOriginalDir().toPath());
    }

    private void logEstimatedTarballSize(DBCheckpoint checkpoint, boolean includeSnapshotData) throws IOException {
        Set<Path> snapshotPaths = new HashSet<Path>();
        if (includeSnapshotData) {
            snapshotPaths = this.getSnapshotDirs(checkpoint, false);
        }
        OMDBCheckpointUtils.logEstimatedTarballSize(checkpoint.getCheckpointLocation(), snapshotPaths);
    }

    private Set<Path> getSnapshotDirs(DBCheckpoint checkpoint, boolean waitForDir) throws IOException {
        OzoneConfiguration conf = this.getConf();
        HashSet<Path> snapshotPaths = new HashSet<Path>();
        OmMetadataManagerImpl checkpointMetadataManager = OmMetadataManagerImpl.createCheckpointMetadataManager(conf, checkpoint);
        try {
            Throwable throwable = null;
            Object var7_8 = null;
            try (Table.KeyValueIterator iterator = checkpointMetadataManager.getSnapshotInfoTable().iterator();){
                while (iterator.hasNext()) {
                    Table.KeyValue entry = (Table.KeyValue)iterator.next();
                    Path path = Paths.get(OmSnapshotManager.getSnapshotPath(conf, (SnapshotInfo)entry.getValue()), new String[0]);
                    if (waitForDir) {
                        this.waitForDirToExist(path);
                    }
                    snapshotPaths.add(path);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        finally {
            checkpointMetadataManager.stop();
        }
        return snapshotPaths;
    }

    private void waitForDirToExist(Path dir) throws IOException {
        if (!RDBCheckpointUtils.waitForCheckpointDirectoryExist((File)dir.toFile())) {
            throw new IOException("snapshot dir doesn't exist: " + dir);
        }
    }

    /*
     * Unable to fully structure code
     */
    private boolean processDir(Path dir, Map<String, Map<Path, Path>> copyFiles, Map<Path, Path> hardLinkFiles, Map<String, Map<Path, Path>> sstFilesToExclude, Set<Path> snapshotPaths, AtomicLong copySize, Path destDir) throws IOException {
        block18: {
            var8_8 = null;
            var9_10 = null;
            try {
                files = Files.list(dir);
                var12_13 = files.collect(Collectors.toList()).iterator();
lbl8:
                // 1 sources

                file = (Path)var12_13.next();
                f = file.toFile();
                if (!f.isDirectory()) ** break block19
                parent = f.getParent();
                if (parent != null && parent.contains("db.snapshots/checkpointState") && !snapshotPaths.contains(file)) {
                    OMDBCheckpointServlet.LOG.debug("Skipping unneeded file: " + file);
                }
                compactionLogDir = new File(this.getDbStore().getRocksDBCheckpointDiffer().getCompactionLogDir());
                if (f.equals(compactionLogDir)) {
                    OMDBCheckpointServlet.LOG.debug("Skipping compaction log dir");
                }
                sstBackupDir = new File(this.getDbStore().getRocksDBCheckpointDiffer().getSSTBackupDir());
                if (f.equals(sstBackupDir)) {
                    OMDBCheckpointServlet.LOG.debug("Skipping sst backup dir");
                }
                filename = file.getFileName();
                if (filename == null) {
                    throw new IOException("file has no filename:" + file);
                }
                destSubDir = null;
                if (destDir != null) {
                    destSubDir = Paths.get(destDir.toString(), new String[]{filename.toString()});
                }
                if (this.processDir(file, copyFiles, hardLinkFiles, sstFilesToExclude, snapshotPaths, copySize, destSubDir)) break block20;
                return false;
                {
                    block20: {
                        fileSize = OMDBCheckpointServlet.processFile(file, copyFiles, hardLinkFiles, sstFilesToExclude, destDir);
                        if (copySize.get() + fileSize > this.maxTotalSstSize) {
                        }
                        copySize.addAndGet(fileSize);
                    }
                }
                while (files != null) {
                    files.close();
                    break block18;
                }
                break block18;
                finally {
                    if (files == null) ** continue;
                    files.close();
                }
            }
            finally {
                if (var12_13.hasNext()) ** GOTO lbl8
            }
        }
        return true;
    }

    @VisibleForTesting
    public static long processFile(Path file, Map<String, Map<Path, Path>> copyFiles, Map<Path, Path> hardLinkFiles, Map<String, Map<Path, Path>> sstFilesToExclude, Path destDir) throws IOException {
        long fileSize = 0L;
        Path destFile = file;
        Path fileNamePath = file.getFileName();
        if (fileNamePath == null) {
            throw new IOException("file has no filename:" + file);
        }
        String fileName = fileNamePath.toString();
        if (destDir != null) {
            destFile = Paths.get(destDir.toString(), fileName);
        }
        if (!sstFilesToExclude.getOrDefault(fileNamePath.toString(), Collections.emptyMap()).containsKey(file)) {
            if (fileName.endsWith(".sst")) {
                Path linkPath = OMDBCheckpointServlet.findLinkPath(sstFilesToExclude, file);
                if (linkPath != null) {
                    hardLinkFiles.put(destFile, linkPath);
                } else {
                    linkPath = OMDBCheckpointServlet.findLinkPath(copyFiles, file);
                    if (linkPath != null) {
                        hardLinkFiles.put(destFile, linkPath);
                    } else {
                        copyFiles.computeIfAbsent(fileNamePath.toString(), k -> new HashMap()).put(file, destFile);
                        fileSize = Files.size(file);
                    }
                }
            } else {
                copyFiles.computeIfAbsent(fileNamePath.toString(), k -> new HashMap()).put(file, destFile);
            }
        }
        return fileSize;
    }

    private static Path findLinkPath(Map<String, Map<Path, Path>> files, Path file) throws IOException {
        Path fileNamePath = file.getFileName();
        if (fileNamePath == null) {
            throw new IOException("file has no filename:" + file);
        }
        String fileName = fileNamePath.toString();
        for (Map.Entry entry : files.getOrDefault(fileName, Collections.emptyMap()).entrySet()) {
            Path srcPath = (Path)entry.getKey();
            Path destPath = (Path)entry.getValue();
            if (!srcPath.toString().endsWith(fileName) || !srcPath.toFile().exists()) continue;
            if (OmSnapshotUtils.getINode(srcPath).equals(OmSnapshotUtils.getINode(file))) {
                return destPath;
            }
            LOG.info("Found non linked sst files with the same name: {}, {}", (Object)srcPath, (Object)file);
        }
        return null;
    }

    private void writeFilesToArchive(Map<Path, Path> copyFiles, Map<Path, Path> hardLinkFiles, ArchiveOutputStream<TarArchiveEntry> archiveOutputStream, boolean completed, Path checkpointLocation) throws IOException {
        Path metaDirPath = OMDBCheckpointServlet.getMetaDirPath(checkpointLocation);
        int truncateLength = metaDirPath.toString().length() + 1;
        Map<Path, Path> filteredCopyFiles = completed ? copyFiles : copyFiles.entrySet().stream().filter(e -> ((Path)e.getKey()).getFileName().toString().toLowerCase().endsWith(".sst")).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        long bytesWritten = 0L;
        int filesWritten = 0;
        long lastLoggedTime = Time.monotonicNow();
        for (Map.Entry<Path, Path> entry : filteredCopyFiles.entrySet()) {
            File file;
            Path f;
            Path path = entry.getValue();
            if (!path.toString().startsWith(metaDirPath.toString())) {
                throw new IOException("tarball file not in metadata dir: " + path + ": " + metaDirPath);
            }
            String fixedFile = OmSnapshotUtils.truncateFileName(truncateLength, path);
            if (fixedFile.startsWith("db.checkpoints") && (f = Paths.get(fixedFile, new String[0]).getFileName()) != null) {
                fixedFile = f.toString();
            }
            if (!(file = entry.getKey().toFile()).isDirectory()) {
                ++filesWritten;
            }
            bytesWritten += Archiver.includeFile((File)file, (String)fixedFile, archiveOutputStream);
            if (Time.monotonicNow() - lastLoggedTime < 30000L) continue;
            LOG.info("Transferred {} KB, #files {} to checkpoint tarball stream...", (Object)(bytesWritten / 1024L), (Object)filesWritten);
            lastLoggedTime = Time.monotonicNow();
        }
        if (completed) {
            if (!hardLinkFiles.isEmpty()) {
                Path hardLinkFile = null;
                try {
                    hardLinkFile = OmSnapshotUtils.createHardLinkList(truncateLength, hardLinkFiles);
                    Archiver.includeFile((File)hardLinkFile.toFile(), (String)"hardLinkFile", archiveOutputStream);
                }
                finally {
                    if (Objects.nonNull(hardLinkFile)) {
                        try {
                            Files.delete(hardLinkFile);
                        }
                        catch (Exception e2) {
                            LOG.error("Exception during hard link file: {} deletion", (Object)hardLinkFile, (Object)e2);
                        }
                    }
                }
            }
            HddsServerUtil.includeRatisSnapshotCompleteFlag(archiveOutputStream);
        }
        LOG.info("Completed transfer of {} KB, #files {} to checkpoint tarball stream.{}", new Object[]{bytesWritten / 1024L, filesWritten, completed ? " Checkpoint tarball is complete." : ""});
    }

    @Nonnull
    private static Path getMetaDirPath(Path checkpointLocation) {
        Path locationParent = checkpointLocation.getParent();
        if (locationParent == null) {
            throw new RuntimeException("checkpoint location's immediate parent is null.");
        }
        Path parent = locationParent.getParent();
        if (parent == null) {
            throw new RuntimeException("checkpoint location's path is invalid and could not be verified.");
        }
        return parent;
    }

    private OzoneConfiguration getConf() {
        return ((OzoneManager)this.getServletContext().getAttribute("ozone.om")).getConfiguration();
    }

    private Path getSnapshotDir() {
        OzoneManager om = (OzoneManager)this.getServletContext().getAttribute("ozone.om");
        RDBStore store = (RDBStore)om.getMetadataManager().getStore();
        return Paths.get(store.getSnapshotsParentDir(), new String[0]).getParent();
    }

    public BootstrapStateHandler.Lock getBootstrapStateLock() {
        return this.lock;
    }

    static class DirectoryData {
        private final File originalDir;
        private final File tmpDir;

        DirectoryData(Path tmpdir, String dirStr) throws IOException {
            this.originalDir = new File(dirStr);
            this.tmpDir = new File(tmpdir.toString(), this.getOriginalDir().getName());
            if (!this.tmpDir.exists() && !this.tmpDir.mkdirs()) {
                throw new IOException("mkdirs failed: " + this.tmpDir);
            }
        }

        public File getOriginalDir() {
            return this.originalDir;
        }

        public File getTmpDir() {
            return this.tmpDir;
        }
    }

    static class Lock
    extends BootstrapStateHandler.Lock {
        private final List<BootstrapStateHandler.Lock> locks;
        private final OzoneManager om;

        Lock(OzoneManager om) {
            Preconditions.checkNotNull((Object)om);
            Preconditions.checkNotNull((Object)om.getKeyManager());
            Preconditions.checkNotNull((Object)om.getMetadataManager());
            Preconditions.checkNotNull((Object)om.getMetadataManager().getStore());
            this.om = om;
            this.locks = Stream.of(new BootstrapStateHandler[]{om.getKeyManager().getDeletingService(), om.getKeyManager().getDirDeletingService(), om.getKeyManager().getSnapshotSstFilteringService(), om.getKeyManager().getSnapshotDeletingService(), om.getMetadataManager().getStore().getRocksDBCheckpointDiffer()}).filter(Objects::nonNull).map(BootstrapStateHandler::getBootstrapStateLock).collect(Collectors.toList());
        }

        public BootstrapStateHandler.Lock lock() throws InterruptedException {
            for (BootstrapStateHandler.Lock lock : this.locks) {
                lock.lock();
            }
            this.om.awaitDoubleBufferFlush();
            return this;
        }

        public void unlock() {
            this.locks.forEach(BootstrapStateHandler.Lock::unlock);
        }
    }
}

