/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.PrivilegedExceptionAction;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.StorageUnit;
import org.apache.hadoop.crypto.key.KeyProviderCryptoExtension;
import org.apache.hadoop.fs.FileEncryptionInfo;
import org.apache.hadoop.hdds.client.BlockID;
import org.apache.hadoop.hdds.client.ReplicationConfig;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.container.common.helpers.ContainerWithPipeline;
import org.apache.hadoop.hdds.scm.net.InnerNode;
import org.apache.hadoop.hdds.scm.net.Node;
import org.apache.hadoop.hdds.scm.net.NodeImpl;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.scm.storage.BlockLocationInfo;
import org.apache.hadoop.hdds.security.token.OzoneBlockTokenSecretManager;
import org.apache.hadoop.hdds.utils.BackgroundService;
import org.apache.hadoop.hdds.utils.HddsServerUtil;
import org.apache.hadoop.hdds.utils.db.StringCodec;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.hdds.utils.db.TableIterator;
import org.apache.hadoop.hdds.utils.db.cache.CacheKey;
import org.apache.hadoop.hdds.utils.db.cache.CacheValue;
import org.apache.hadoop.metrics2.lib.MutableRate;
import org.apache.hadoop.net.CachedDNSToSwitchMapping;
import org.apache.hadoop.net.DNSToSwitchMapping;
import org.apache.hadoop.net.TableMapping;
import org.apache.hadoop.ozone.OmUtils;
import org.apache.hadoop.ozone.OzoneAcl;
import org.apache.hadoop.ozone.common.BlockGroup;
import org.apache.hadoop.ozone.om.DeleteKeysResult;
import org.apache.hadoop.ozone.om.ExpiredOpenKeys;
import org.apache.hadoop.ozone.om.KeyManager;
import org.apache.hadoop.ozone.om.OMConfigKeys;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OMPerformanceMetrics;
import org.apache.hadoop.ozone.om.OzoneListStatusHelper;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.OzoneManagerUtils;
import org.apache.hadoop.ozone.om.PendingKeysDeletion;
import org.apache.hadoop.ozone.om.ResolvedBucket;
import org.apache.hadoop.ozone.om.ScmClient;
import org.apache.hadoop.ozone.om.SnapshotDefragService;
import org.apache.hadoop.ozone.om.SstFilteringService;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.helpers.BucketEncryptionKeyInfo;
import org.apache.hadoop.ozone.om.helpers.BucketLayout;
import org.apache.hadoop.ozone.om.helpers.ListKeysResult;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.helpers.OmDirectoryInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyArgs;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyLocationInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyLocationInfoGroup;
import org.apache.hadoop.ozone.om.helpers.OmMultipartKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmMultipartUpload;
import org.apache.hadoop.ozone.om.helpers.OmMultipartUploadList;
import org.apache.hadoop.ozone.om.helpers.OmMultipartUploadListParts;
import org.apache.hadoop.ozone.om.helpers.OmPartInfo;
import org.apache.hadoop.ozone.om.helpers.OzoneAclUtil;
import org.apache.hadoop.ozone.om.helpers.OzoneFSUtils;
import org.apache.hadoop.ozone.om.helpers.OzoneFileStatus;
import org.apache.hadoop.ozone.om.helpers.RepeatedOmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.WithParentObjectId;
import org.apache.hadoop.ozone.om.lock.IOzoneManagerLock;
import org.apache.hadoop.ozone.om.lock.OzoneManagerLock;
import org.apache.hadoop.ozone.om.request.OMClientRequest;
import org.apache.hadoop.ozone.om.request.file.OMFileRequest;
import org.apache.hadoop.ozone.om.request.key.OMKeyRequest;
import org.apache.hadoop.ozone.om.request.util.OMMultipartUploadUtils;
import org.apache.hadoop.ozone.om.service.CompactionService;
import org.apache.hadoop.ozone.om.service.DirectoryDeletingService;
import org.apache.hadoop.ozone.om.service.KeyDeletingService;
import org.apache.hadoop.ozone.om.service.MultipartUploadCleanupService;
import org.apache.hadoop.ozone.om.service.OpenKeyCleanupService;
import org.apache.hadoop.ozone.om.service.SnapshotDeletingService;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.security.acl.OzoneObj;
import org.apache.hadoop.ozone.security.acl.RequestContext;
import org.apache.hadoop.ozone.util.MetricUtil;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.Time;
import org.apache.ratis.util.function.CheckedFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyManagerImpl
implements KeyManager {
    private static final Logger LOG = LoggerFactory.getLogger(KeyManagerImpl.class);
    private final OzoneManager ozoneManager;
    private final ScmClient scmClient;
    private final OMMetadataManager metadataManager;
    private final long scmBlockSize;
    private final OzoneBlockTokenSecretManager secretManager;
    private final boolean grpcBlockTokenEnabled;
    private KeyDeletingService keyDeletingService;
    private SstFilteringService snapshotSstFilteringService;
    private SnapshotDefragService snapshotDefragService;
    private SnapshotDeletingService snapshotDeletingService;
    private final KeyProviderCryptoExtension kmsProvider;
    private DirectoryDeletingService dirDeletingService;
    private final OMPerformanceMetrics metrics;
    private BackgroundService openKeyCleanupService;
    private BackgroundService multipartUploadCleanupService;
    private DNSToSwitchMapping dnsToSwitchMapping;
    private CompactionService compactionService;

    public KeyManagerImpl(OzoneManager om, ScmClient scmClient, OzoneConfiguration conf, OMPerformanceMetrics metrics) {
        this(om, scmClient, om.getMetadataManager(), conf, om.getBlockTokenMgr(), om.getKmsProvider(), metrics);
    }

    public KeyManagerImpl(OzoneManager om, ScmClient scmClient, OMMetadataManager metadataManager, OzoneConfiguration conf, OzoneBlockTokenSecretManager secretManager, KeyProviderCryptoExtension kmsProvider, OMPerformanceMetrics metrics) {
        this.scmBlockSize = (long)conf.getStorageSize("ozone.scm.block.size", "256MB", StorageUnit.BYTES);
        this.grpcBlockTokenEnabled = conf.getBoolean("hdds.block.token.enabled", false);
        this.ozoneManager = om;
        this.scmClient = scmClient;
        this.metadataManager = metadataManager;
        this.secretManager = secretManager;
        this.kmsProvider = kmsProvider;
        this.metrics = metrics;
    }

    @Override
    public void start(OzoneConfiguration configuration) {
        Class dnsToSwitchMappingClass;
        DNSToSwitchMapping newInstance;
        long serviceInterval;
        long serviceTimeout;
        boolean isCompactionEnabled = configuration.getBoolean("ozone.om.compaction.service.enabled", false);
        this.startCompactionService(configuration, isCompactionEnabled);
        boolean isSnapshotDeepCleaningEnabled = configuration.getBoolean("ozone.snapshot.deep.cleaning.enabled", false);
        if (this.keyDeletingService == null) {
            long blockDeleteInterval = configuration.getTimeDuration("ozone.block.deleting.service.interval", "60s", TimeUnit.MILLISECONDS);
            serviceTimeout = configuration.getTimeDuration("ozone.block.deleting.service.timeout", "300s", TimeUnit.MILLISECONDS);
            int keyDeletingServiceCorePoolSize = configuration.getInt("ozone.thread.number.key.deletion", 10);
            if (keyDeletingServiceCorePoolSize <= 0) {
                keyDeletingServiceCorePoolSize = 1;
            }
            this.keyDeletingService = new KeyDeletingService(this.ozoneManager, this.scmClient.getBlockClient(), blockDeleteInterval, serviceTimeout, (ConfigurationSource)configuration, keyDeletingServiceCorePoolSize, isSnapshotDeepCleaningEnabled);
            this.keyDeletingService.start();
        }
        if (this.dirDeletingService == null) {
            long dirDeleteInterval = configuration.getTimeDuration("ozone.directory.deleting.service.interval", "60s", TimeUnit.MILLISECONDS);
            serviceTimeout = configuration.getTimeDuration("ozone.block.deleting.service.timeout", "300s", TimeUnit.MILLISECONDS);
            int dirDeletingServiceCorePoolSize = configuration.getInt("ozone.thread.number.dir.deletion", 10);
            if (dirDeletingServiceCorePoolSize <= 0) {
                dirDeletingServiceCorePoolSize = 1;
            }
            this.dirDeletingService = new DirectoryDeletingService(dirDeleteInterval, TimeUnit.MILLISECONDS, serviceTimeout, this.ozoneManager, configuration, dirDeletingServiceCorePoolSize, isSnapshotDeepCleaningEnabled);
            this.dirDeletingService.start();
        }
        if (this.openKeyCleanupService == null) {
            serviceInterval = configuration.getTimeDuration("ozone.om.open.key.cleanup.service.interval", "24h", TimeUnit.MILLISECONDS);
            serviceTimeout = configuration.getTimeDuration("ozone.om.open.key.cleanup.service.timeout", "300s", TimeUnit.MILLISECONDS);
            this.openKeyCleanupService = new OpenKeyCleanupService(serviceInterval, TimeUnit.MILLISECONDS, serviceTimeout, this.ozoneManager, (ConfigurationSource)configuration);
            this.openKeyCleanupService.start();
        }
        if (this.snapshotSstFilteringService == null && this.ozoneManager.isFilesystemSnapshotEnabled()) {
            this.startSnapshotSstFilteringService(configuration);
        }
        if (this.snapshotDefragService == null && this.ozoneManager.isFilesystemSnapshotEnabled()) {
            this.startSnapshotDefragService(configuration);
        }
        if (this.snapshotDeletingService == null && this.ozoneManager.isFilesystemSnapshotEnabled()) {
            long snapshotServiceInterval = configuration.getTimeDuration("ozone.snapshot.deleting.service.interval", "30s", TimeUnit.MILLISECONDS);
            long snapshotServiceTimeout = configuration.getTimeDuration("ozone.snapshot.deleting.service.timeout", "300s", TimeUnit.MILLISECONDS);
            try {
                this.snapshotDeletingService = new SnapshotDeletingService(snapshotServiceInterval, snapshotServiceTimeout, this.ozoneManager);
                this.snapshotDeletingService.start();
            }
            catch (IOException e) {
                LOG.error("Error starting Snapshot Deleting Service", (Throwable)e);
            }
        }
        if (this.multipartUploadCleanupService == null) {
            serviceInterval = configuration.getTimeDuration("ozone.om.open.mpu.cleanup.service.interval", "24h", TimeUnit.MILLISECONDS);
            serviceTimeout = configuration.getTimeDuration("ozone.om.open.mpu.cleanup.service.timeout", "300s", TimeUnit.MILLISECONDS);
            this.multipartUploadCleanupService = new MultipartUploadCleanupService(serviceInterval, TimeUnit.MILLISECONDS, serviceTimeout, this.ozoneManager, (ConfigurationSource)configuration);
            this.multipartUploadCleanupService.start();
        }
        this.dnsToSwitchMapping = (newInstance = (DNSToSwitchMapping)ReflectionUtils.newInstance((Class)(dnsToSwitchMappingClass = configuration.getClass("net.topology.node.switch.mapping.impl", TableMapping.class, DNSToSwitchMapping.class)), (Configuration)configuration)) instanceof CachedDNSToSwitchMapping ? newInstance : new CachedDNSToSwitchMapping(newInstance);
    }

    public void startSnapshotSstFilteringService(OzoneConfiguration conf) {
        if (this.isSstFilteringSvcEnabled()) {
            long serviceInterval = conf.getTimeDuration("ozone.snapshot.filtering.service.interval", "60s", TimeUnit.MILLISECONDS);
            long serviceTimeout = conf.getTimeDuration("ozone.sst.filtering.service.timeout", "300s", TimeUnit.MILLISECONDS);
            this.snapshotSstFilteringService = new SstFilteringService(serviceInterval, TimeUnit.MILLISECONDS, serviceTimeout, this.ozoneManager, conf);
            this.snapshotSstFilteringService.start();
        } else {
            LOG.info("SstFilteringService is disabled.");
        }
    }

    public void stopSnapshotSstFilteringService() {
        if (this.snapshotSstFilteringService != null) {
            this.snapshotSstFilteringService.shutdown();
            this.snapshotSstFilteringService = null;
        } else {
            LOG.info("SstFilteringService is already stopped or not started.");
        }
    }

    public void startSnapshotDefragService(OzoneConfiguration conf) {
        if (this.isDefragSvcEnabled()) {
            long serviceInterval = conf.getTimeDuration("ozone.snapshot.defrag.service.interval", "-1", TimeUnit.MILLISECONDS);
            long serviceTimeout = conf.getTimeDuration("ozone.snapshot.defrag.service.timeout", "300s", TimeUnit.MILLISECONDS);
            this.snapshotDefragService = new SnapshotDefragService(serviceInterval, TimeUnit.MILLISECONDS, serviceTimeout, this.ozoneManager, conf);
            this.snapshotDefragService.start();
        } else {
            LOG.info("SnapshotDefragService is disabled. Snapshot defragmentation will not run periodically.");
        }
    }

    public void stopSnapshotDefragService() {
        if (this.snapshotDefragService != null) {
            this.snapshotDefragService.shutdown();
            this.snapshotDefragService = null;
        } else {
            LOG.info("SnapshotDefragService is already stopped or not started.");
        }
    }

    private void startCompactionService(OzoneConfiguration configuration, boolean isCompactionServiceEnabled) {
        if (this.compactionService == null && isCompactionServiceEnabled) {
            long compactionInterval = configuration.getTimeDuration("ozone.om.compaction.service.run.interval", OMConfigKeys.OZONE_OM_COMPACTION_SERVICE_RUN_INTERVAL_DEFAULT, TimeUnit.MILLISECONDS);
            long serviceTimeout = configuration.getTimeDuration("ozone.om.compaction.service.timeout", "10m", TimeUnit.MILLISECONDS);
            String compactionColumnFamilies = configuration.get("ozone.om.compaction.service.columnfamilies", "keyTable,fileTable,directoryTable,deletedTable,deletedDirectoryTable,multipartInfoTable");
            String[] tables = compactionColumnFamilies.split(",");
            this.compactionService = new CompactionService(this.ozoneManager, TimeUnit.MILLISECONDS, compactionInterval, serviceTimeout, Arrays.asList(tables));
            this.compactionService.start();
        }
    }

    KeyProviderCryptoExtension getKMSProvider() {
        return this.kmsProvider;
    }

    @Override
    public void stop() {
        if (this.keyDeletingService != null) {
            this.keyDeletingService.shutdown();
            this.keyDeletingService = null;
        }
        if (this.dirDeletingService != null) {
            this.dirDeletingService.shutdown();
            this.dirDeletingService = null;
        }
        if (this.openKeyCleanupService != null) {
            this.openKeyCleanupService.shutdown();
            this.openKeyCleanupService = null;
        }
        if (this.snapshotSstFilteringService != null) {
            this.snapshotSstFilteringService.shutdown();
            this.snapshotSstFilteringService = null;
        }
        if (this.snapshotDefragService != null) {
            this.snapshotDefragService.shutdown();
            this.snapshotDefragService = null;
        }
        if (this.snapshotDeletingService != null) {
            this.snapshotDeletingService.shutdown();
            this.snapshotDeletingService = null;
        }
        if (this.multipartUploadCleanupService != null) {
            this.multipartUploadCleanupService.shutdown();
            this.multipartUploadCleanupService = null;
        }
        if (this.compactionService != null) {
            this.compactionService.shutdown();
            this.compactionService = null;
        }
    }

    @Override
    public SnapshotDefragService getSnapshotDefragService() {
        return this.snapshotDefragService;
    }

    private OmBucketInfo getBucketInfo(String volumeName, String bucketName) throws IOException {
        String bucketKey = this.metadataManager.getBucketKey(volumeName, bucketName);
        return (OmBucketInfo)this.metadataManager.getBucketTable().get((Object)bucketKey);
    }

    private KeyProviderCryptoExtension.EncryptedKeyVersion generateEDEK(final String ezKeyName) throws IOException {
        if (ezKeyName == null) {
            return null;
        }
        long generateEDEKStartTime = Time.monotonicNow();
        KeyProviderCryptoExtension.EncryptedKeyVersion edek = (KeyProviderCryptoExtension.EncryptedKeyVersion)SecurityUtil.doAsLoginUser((PrivilegedExceptionAction)new PrivilegedExceptionAction<KeyProviderCryptoExtension.EncryptedKeyVersion>(){

            @Override
            public KeyProviderCryptoExtension.EncryptedKeyVersion run() throws IOException {
                try {
                    return KeyManagerImpl.this.getKMSProvider().generateEncryptedKey(ezKeyName);
                }
                catch (GeneralSecurityException e) {
                    throw new IOException(e);
                }
            }
        });
        long generateEDEKTime = Time.monotonicNow() - generateEDEKStartTime;
        LOG.debug("generateEDEK takes {} ms", (Object)generateEDEKTime);
        Preconditions.checkNotNull((Object)edek);
        return edek;
    }

    @Override
    public OmKeyInfo lookupKey(OmKeyArgs args, ResolvedBucket bucket, String clientAddress) throws IOException {
        Preconditions.checkNotNull((Object)args);
        OmKeyInfo value = (OmKeyInfo)MetricUtil.captureLatencyNs((MutableRate)this.metrics.getLookupReadKeyInfoLatencyNs(), () -> this.readKeyInfo(args, bucket.bucketLayout()));
        if (!args.isHeadOp()) {
            MetricUtil.captureLatencyNs((MutableRate)this.metrics.getLookupGenerateBlockTokenLatencyNs(), () -> this.addBlockToken4Read(value));
            MetricUtil.captureLatencyNs((MutableRate)this.metrics.getLookupRefreshLocationLatencyNs(), () -> this.refresh(value));
            if (args.getSortDatanodes()) {
                this.sortDatanodes(clientAddress, value);
            }
        }
        return value;
    }

    private OmKeyInfo readKeyInfo(OmKeyArgs args, BucketLayout bucketLayout) throws IOException {
        OmKeyLocationInfoGroup latestLocationVersion;
        int partNumberParam;
        String volumeName = args.getVolumeName();
        String bucketName = args.getBucketName();
        String keyName = args.getKeyName();
        OmKeyInfo value = null;
        this.metadataManager.getLock().acquireReadLock((IOzoneManagerLock.Resource)OzoneManagerLock.LeveledResource.BUCKET_LOCK, new String[]{volumeName, bucketName});
        try {
            try {
                keyName = OMClientRequest.validateAndNormalizeKey(this.ozoneManager.getEnableFileSystemPaths(), keyName, bucketLayout);
                if (bucketLayout.isFileSystemOptimized()) {
                    value = this.getOmKeyInfoFSO(volumeName, bucketName, keyName);
                } else {
                    value = this.getOmKeyInfo(volumeName, bucketName, keyName, bucketLayout);
                    if (value != null) {
                        value.setFile(true);
                    }
                }
            }
            catch (IOException ex) {
                if (ex instanceof OMException) {
                    throw ex;
                }
                throw new OMException(String.format("Error reading key metadata: /%s/%s/%s", volumeName, bucketName, keyName), (Throwable)ex, OMException.ResultCodes.INTERNAL_ERROR);
            }
        }
        catch (Throwable throwable) {
            this.metadataManager.getLock().releaseReadLock((IOzoneManagerLock.Resource)OzoneManagerLock.LeveledResource.BUCKET_LOCK, new String[]{volumeName, bucketName});
            throw throwable;
        }
        this.metadataManager.getLock().releaseReadLock((IOzoneManagerLock.Resource)OzoneManagerLock.LeveledResource.BUCKET_LOCK, new String[]{volumeName, bucketName});
        if (value == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("volume:{} bucket:{} Key:{} not found", new Object[]{volumeName, bucketName, keyName});
            }
            throw new OMException("Key:" + keyName + " not found", OMException.ResultCodes.KEY_NOT_FOUND);
        }
        if (args.getLatestVersionLocation()) {
            this.slimLocationVersion(value);
        }
        if ((partNumberParam = args.getMultipartUploadPartNumber()) > 0 && (latestLocationVersion = value.getLatestVersionLocations()) != null && latestLocationVersion.isMultipartKey()) {
            List currentLocations = latestLocationVersion.getBlocksLatestVersionOnly().stream().filter(it -> it.getPartNumber() == partNumberParam).collect(Collectors.toList());
            value.updateLocationInfoList(currentLocations, true, true);
            value.setDataSize(currentLocations.stream().mapToLong(BlockLocationInfo::getLength).sum());
        }
        return value;
    }

    private OmKeyInfo getOmKeyInfo(String volumeName, String bucketName, String keyName, BucketLayout bucketLayout) throws IOException {
        String keyBytes = this.metadataManager.getOzoneKey(volumeName, bucketName, keyName);
        return (OmKeyInfo)this.metadataManager.getKeyTable(bucketLayout).get((Object)keyBytes);
    }

    private OmKeyInfo getOmKeyInfoFSO(String volumeName, String bucketName, String keyName) throws IOException {
        OzoneFileStatus fileStatus = OMFileRequest.getOMKeyInfoIfExists(this.metadataManager, volumeName, bucketName, keyName, this.scmBlockSize, this.ozoneManager.getDefaultReplicationConfig(), false);
        if (fileStatus == null) {
            return null;
        }
        if (fileStatus.isDirectory()) {
            String keyPath = OzoneFSUtils.addTrailingSlashIfNeeded((String)fileStatus.getKeyInfo().getKeyName());
            fileStatus.getKeyInfo().setKeyName(keyPath);
        }
        fileStatus.getKeyInfo().setFile(fileStatus.isFile());
        return fileStatus.getKeyInfo();
    }

    private void addBlockToken4Read(OmKeyInfo value) throws IOException {
        Preconditions.checkNotNull((Object)value, (Object)"OMKeyInfo cannot be null");
        if (this.grpcBlockTokenEnabled) {
            String remoteUser = HddsServerUtil.getRemoteUser().getShortUserName();
            for (OmKeyLocationInfoGroup key : value.getKeyLocationVersions()) {
                key.getLocationList().forEach(k -> k.setToken(this.secretManager.generateToken(remoteUser, k.getBlockID(), EnumSet.of(HddsProtos.BlockTokenSecretProto.AccessModeProto.READ), k.getLength())));
            }
        }
    }

    @VisibleForTesting
    protected void refreshPipeline(List<OmKeyInfo> keyList) throws IOException {
        if (keyList == null || keyList.isEmpty()) {
            return;
        }
        HashSet<Long> containerIDs = new HashSet<Long>();
        for (OmKeyInfo keyInfo : keyList) {
            List locationInfoGroups = keyInfo.getKeyLocationVersions();
            for (OmKeyLocationInfoGroup key : locationInfoGroups) {
                for (List omKeyLocationInfoList : key.getLocationLists()) {
                    for (OmKeyLocationInfo omKeyLocationInfo : omKeyLocationInfoList) {
                        containerIDs.add(omKeyLocationInfo.getContainerID());
                    }
                }
            }
        }
        Map<Long, ContainerWithPipeline> containerWithPipelineMap = this.refreshPipeline(containerIDs);
        for (OmKeyInfo keyInfo : keyList) {
            List locationInfoGroups = keyInfo.getKeyLocationVersions();
            for (OmKeyLocationInfoGroup key : locationInfoGroups) {
                for (List omKeyLocationInfoList : key.getLocationLists()) {
                    for (OmKeyLocationInfo omKeyLocationInfo : omKeyLocationInfoList) {
                        ContainerWithPipeline cp = containerWithPipelineMap.get(omKeyLocationInfo.getContainerID());
                        if (cp == null || cp.getPipeline().equals((Object)omKeyLocationInfo.getPipeline())) continue;
                        omKeyLocationInfo.setPipeline(cp.getPipeline());
                    }
                }
            }
        }
    }

    @VisibleForTesting
    protected Map<Long, ContainerWithPipeline> refreshPipeline(Set<Long> containerIDs) throws IOException {
        if (this.scmClient.getContainerClient() == null || containerIDs == null || containerIDs.isEmpty()) {
            return Collections.EMPTY_MAP;
        }
        HashMap<Long, ContainerWithPipeline> containerWithPipelineMap = new HashMap<Long, ContainerWithPipeline>();
        try {
            List cpList = this.scmClient.getContainerClient().getContainerWithPipelineBatch(new ArrayList<Long>(containerIDs));
            for (ContainerWithPipeline cp : cpList) {
                containerWithPipelineMap.put(cp.getContainerInfo().getContainerID(), cp);
            }
            return containerWithPipelineMap;
        }
        catch (IOException ioEx) {
            LOG.debug("Get containerPipeline failed for {}", containerIDs, (Object)ioEx);
            throw new OMException(ioEx.getMessage(), OMException.ResultCodes.SCM_GET_PIPELINE_EXCEPTION);
        }
    }

    @Override
    public ListKeysResult listKeys(String volumeName, String bucketName, String startKey, String keyPrefix, int maxKeys) throws IOException {
        Preconditions.checkNotNull((Object)volumeName);
        Preconditions.checkNotNull((Object)bucketName);
        OmBucketInfo omBucketInfo = this.getBucketInfo(volumeName, bucketName);
        if (omBucketInfo == null) {
            throw new OMException("Bucket " + bucketName + " not found.", OMException.ResultCodes.BUCKET_NOT_FOUND);
        }
        BucketLayout bucketLayout = omBucketInfo.getBucketLayout();
        if (bucketLayout.shouldNormalizePaths(this.ozoneManager.getEnableFileSystemPaths())) {
            startKey = OmUtils.normalizeKey((String)startKey, (boolean)true);
            keyPrefix = OmUtils.normalizeKey((String)keyPrefix, (boolean)true);
        }
        ListKeysResult listKeysResult = this.metadataManager.listKeys(volumeName, bucketName, startKey, keyPrefix, maxKeys);
        List keyList = listKeysResult.getKeys();
        for (OmKeyInfo omKeyInfo : keyList) {
            this.slimLocationVersion(omKeyInfo);
        }
        return listKeysResult;
    }

    @Override
    public PendingKeysDeletion getPendingDeletionKeys(CheckedFunction<Table.KeyValue<String, OmKeyInfo>, Boolean, IOException> filter, int count) throws IOException {
        return this.getPendingDeletionKeys(null, null, null, filter, count);
    }

    @Override
    public PendingKeysDeletion getPendingDeletionKeys(String volume, String bucket, String startKey, CheckedFunction<Table.KeyValue<String, OmKeyInfo>, Boolean, IOException> filter, int count) throws IOException {
        HashMap purgedKeys = Maps.newHashMap();
        HashMap<String, RepeatedOmKeyInfo> keysToModify = new HashMap<String, RepeatedOmKeyInfo>();
        int notReclaimableKeyCount = 0;
        Optional<String> bucketPrefix = this.getBucketPrefix(volume, bucket, false);
        Throwable throwable = null;
        Object var11_12 = null;
        try (Table.KeyValueIterator delKeyIter = this.metadataManager.getDeletedTable().iterator((Object)bucketPrefix.orElse(""));){
            if (startKey != null) {
                delKeyIter.seek((Object)startKey);
            }
            int currentCount = 0;
            while (delKeyIter.hasNext() && currentCount < count) {
                Table.KeyValue kv = (Table.KeyValue)delKeyIter.next();
                if (kv == null) continue;
                RepeatedOmKeyInfo notReclaimableKeyInfo = new RepeatedOmKeyInfo(((RepeatedOmKeyInfo)kv.getValue()).getBucketId());
                HashMap reclaimableKeys = Maps.newHashMap();
                RepeatedOmKeyInfo infoList = (RepeatedOmKeyInfo)kv.getValue();
                long bucketId = infoList.getBucketId();
                int reclaimableKeyCount = 0;
                for (OmKeyInfo info : infoList.getOmKeyInfoList()) {
                    if (filter == null || ((Boolean)filter.apply((Object)Table.newKeyValue((Object)((String)kv.getKey()), (Object)info))).booleanValue()) {
                        List blockIDS = info.getKeyLocationVersions().stream().flatMap(versionLocations -> versionLocations.getLocationList().stream().map(b -> new BlockID(b.getContainerID(), b.getLocalID()))).collect(Collectors.toList());
                        String blockGroupName = String.valueOf((String)kv.getKey()) + "/" + reclaimableKeyCount++;
                        BlockGroup keyBlocks = BlockGroup.newBuilder().setKeyName(blockGroupName).addAllBlockIDs(blockIDS).build();
                        reclaimableKeys.put(blockGroupName, new PendingKeysDeletion.PurgedKey(info.getVolumeName(), info.getBucketName(), bucketId, keyBlocks, (String)kv.getKey(), OMKeyRequest.sumBlockLengths(info), info.isDeletedKeyCommitted()));
                        ++currentCount;
                        continue;
                    }
                    notReclaimableKeyInfo.addOmKeyInfo(info);
                }
                List notReclaimableKeyInfoList = notReclaimableKeyInfo.getOmKeyInfoList();
                if (!notReclaimableKeyInfoList.isEmpty() && notReclaimableKeyInfoList.size() != infoList.getOmKeyInfoList().size()) {
                    keysToModify.put((String)kv.getKey(), notReclaimableKeyInfo);
                }
                purgedKeys.putAll(reclaimableKeys);
                notReclaimableKeyCount += notReclaimableKeyInfoList.size();
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return new PendingKeysDeletion(purgedKeys, keysToModify, notReclaimableKeyCount);
    }

    private <V, R> List<Table.KeyValue<String, R>> getTableEntries(String startKey, TableIterator<String, ? extends Table.KeyValue<String, V>> tableIterator, Function<V, R> valueFunction, CheckedFunction<Table.KeyValue<String, V>, Boolean, IOException> filter, int size) throws IOException {
        ArrayList<Table.KeyValue<String, R>> entries = new ArrayList<Table.KeyValue<String, R>>();
        if (startKey != null) {
            tableIterator.seek((Object)startKey);
        } else {
            tableIterator.seekToFirst();
        }
        int currentCount = 0;
        while (tableIterator.hasNext() && currentCount < size) {
            Table.KeyValue kv = (Table.KeyValue)tableIterator.next();
            if (kv == null || !((Boolean)filter.apply((Object)kv)).booleanValue()) continue;
            entries.add(Table.newKeyValue((Object)((String)kv.getKey()), valueFunction.apply(kv.getValue())));
            ++currentCount;
        }
        return entries;
    }

    private Optional<String> getBucketPrefix(String volumeName, String bucketName, boolean isFSO) throws IOException {
        if (StringUtils.isEmpty((CharSequence)volumeName) && StringUtils.isEmpty((CharSequence)bucketName)) {
            return Optional.empty();
        }
        if (StringUtils.isEmpty((CharSequence)bucketName) || StringUtils.isEmpty((CharSequence)volumeName)) {
            throw new IOException("One of volume : " + volumeName + ", bucket: " + bucketName + " is empty." + " Either both should be empty or none of the arguments should be empty");
        }
        return isFSO ? Optional.of(this.metadataManager.getBucketKeyPrefixFSO(volumeName, bucketName)) : Optional.of(this.metadataManager.getBucketKeyPrefix(volumeName, bucketName));
    }

    @Override
    public List<Table.KeyValue<String, String>> getRenamesKeyEntries(String volume, String bucket, String startKey, CheckedFunction<Table.KeyValue<String, String>, Boolean, IOException> filter, int size) throws IOException {
        Optional<String> bucketPrefix = this.getBucketPrefix(volume, bucket, false);
        Throwable throwable = null;
        Object var8_9 = null;
        try (Table.KeyValueIterator renamedKeyIter = this.metadataManager.getSnapshotRenamedTable().iterator((Object)bucketPrefix.orElse(""));){
            return this.getTableEntries(startKey, (TableIterator)renamedKeyIter, Function.identity(), (CheckedFunction)filter, size);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public CheckedFunction<KeyManager, OmDirectoryInfo, IOException> getPreviousSnapshotOzoneDirInfo(long volumeId, OmBucketInfo bucketInfo, OmDirectoryInfo keyInfo) throws IOException {
        String currentKeyPath = this.metadataManager.getOzonePathKey(volumeId, bucketInfo.getObjectID(), keyInfo.getParentObjectID(), keyInfo.getName());
        return this.getPreviousSnapshotOzonePathInfo(bucketInfo, keyInfo.getObjectID(), currentKeyPath, km -> km.getMetadataManager().getDirectoryTable());
    }

    @Override
    public CheckedFunction<KeyManager, OmDirectoryInfo, IOException> getPreviousSnapshotOzoneDirInfo(long volumeId, OmBucketInfo bucketInfo, OmKeyInfo keyInfo) throws IOException {
        String currentKeyPath = this.metadataManager.getOzonePathKey(volumeId, bucketInfo.getObjectID(), keyInfo.getParentObjectID(), keyInfo.getFileName());
        return this.getPreviousSnapshotOzonePathInfo(bucketInfo, keyInfo.getObjectID(), currentKeyPath, previousSnapshotKM -> previousSnapshotKM.getMetadataManager().getDirectoryTable());
    }

    @Override
    public CheckedFunction<KeyManager, OmKeyInfo, IOException> getPreviousSnapshotOzoneKeyInfo(long volumeId, OmBucketInfo bucketInfo, OmKeyInfo keyInfo) throws IOException {
        String currentKeyPath = bucketInfo.getBucketLayout().isFileSystemOptimized() ? this.metadataManager.getOzonePathKey(volumeId, bucketInfo.getObjectID(), keyInfo.getParentObjectID(), keyInfo.getFileName()) : this.metadataManager.getOzoneKey(bucketInfo.getVolumeName(), bucketInfo.getBucketName(), keyInfo.getKeyName());
        return this.getPreviousSnapshotOzonePathInfo(bucketInfo, keyInfo.getObjectID(), currentKeyPath, previousSnapshotKM -> previousSnapshotKM.getMetadataManager().getKeyTable(bucketInfo.getBucketLayout()));
    }

    private <T> CheckedFunction<KeyManager, T, IOException> getPreviousSnapshotOzonePathInfo(OmBucketInfo bucketInfo, long objectId, String currentKeyPath, Function<KeyManager, Table<String, T>> table) throws IOException {
        String renameKey = this.metadataManager.getRenameKey(bucketInfo.getVolumeName(), bucketInfo.getBucketName(), objectId);
        String renamedKey = (String)this.metadataManager.getSnapshotRenamedTable().getIfExist((Object)renameKey);
        return previousSnapshotKM -> ((Table)table.apply((KeyManager)previousSnapshotKM)).get((Object)(renamedKey != null ? renamedKey : currentKeyPath));
    }

    @Override
    public List<Table.KeyValue<String, List<OmKeyInfo>>> getDeletedKeyEntries(String volume, String bucket, String startKey, CheckedFunction<Table.KeyValue<String, RepeatedOmKeyInfo>, Boolean, IOException> filter, int size) throws IOException {
        Optional<String> bucketPrefix = this.getBucketPrefix(volume, bucket, false);
        Throwable throwable = null;
        Object var8_9 = null;
        try (Table.KeyValueIterator delKeyIter = this.metadataManager.getDeletedTable().iterator((Object)bucketPrefix.orElse(""));){
            return this.getTableEntries(startKey, (TableIterator)delKeyIter, (Function)RepeatedOmKeyInfo::cloneOmKeyInfoList, (CheckedFunction)filter, size);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public ExpiredOpenKeys getExpiredOpenKeys(Duration expireThreshold, int count, BucketLayout bucketLayout, Duration leaseThreshold) throws IOException {
        return this.metadataManager.getExpiredOpenKeys(expireThreshold, count, bucketLayout, leaseThreshold);
    }

    @Override
    public List<OzoneManagerProtocolProtos.ExpiredMultipartUploadsBucket> getExpiredMultipartUploads(Duration expireThreshold, int maxParts) throws IOException {
        return this.metadataManager.getExpiredMultipartUploads(expireThreshold, maxParts);
    }

    @Override
    public Map<String, String> getObjectTagging(OmKeyArgs args, ResolvedBucket bucket) throws IOException {
        Preconditions.checkNotNull((Object)args);
        OmKeyInfo value = (OmKeyInfo)MetricUtil.captureLatencyNs((MutableRate)this.metrics.getLookupReadKeyInfoLatencyNs(), () -> this.readKeyInfo(args, bucket.bucketLayout()));
        return value.getTags();
    }

    @Override
    public OMMetadataManager getMetadataManager() {
        return this.metadataManager;
    }

    @Override
    public KeyDeletingService getDeletingService() {
        return this.keyDeletingService;
    }

    @Override
    public DirectoryDeletingService getDirDeletingService() {
        return this.dirDeletingService;
    }

    @Override
    public BackgroundService getOpenKeyCleanupService() {
        return this.openKeyCleanupService;
    }

    @Override
    public BackgroundService getMultipartUploadCleanupService() {
        return this.multipartUploadCleanupService;
    }

    @Override
    public SstFilteringService getSnapshotSstFilteringService() {
        return this.snapshotSstFilteringService;
    }

    @Override
    public SnapshotDeletingService getSnapshotDeletingService() {
        return this.snapshotDeletingService;
    }

    @Override
    public CompactionService getCompactionService() {
        return this.compactionService;
    }

    public boolean isSstFilteringSvcEnabled() {
        long serviceInterval = this.ozoneManager.getConfiguration().getTimeDuration("ozone.snapshot.filtering.service.interval", "60s", TimeUnit.MILLISECONDS);
        return serviceInterval > 0L;
    }

    public boolean isDefragSvcEnabled() {
        long serviceInterval = this.ozoneManager.getConfiguration().getTimeDuration("ozone.snapshot.defrag.service.interval", "-1", TimeUnit.MILLISECONDS);
        return serviceInterval > 0L;
    }

    @Override
    public OmMultipartUploadList listMultipartUploads(String volumeName, String bucketName, String prefix, String keyMarker, String uploadIdMarker, int maxUploads, boolean withPagination) throws OMException {
        OmMultipartUploadList omMultipartUploadList;
        Preconditions.checkNotNull((Object)volumeName);
        Preconditions.checkNotNull((Object)bucketName);
        this.metadataManager.getLock().acquireReadLock((IOzoneManagerLock.Resource)OzoneManagerLock.LeveledResource.BUCKET_LOCK, new String[]{volumeName, bucketName});
        try {
            List multipartUploadKeys = this.metadataManager.getMultipartUploadKeys(volumeName, bucketName, prefix, keyMarker, uploadIdMarker, maxUploads, !withPagination);
            OmMultipartUploadList.Builder resultBuilder = OmMultipartUploadList.newBuilder();
            if (withPagination && multipartUploadKeys.size() == maxUploads + 1) {
                multipartUploadKeys.remove(multipartUploadKeys.size() - 1);
                OmMultipartUpload lastReturned = (OmMultipartUpload)multipartUploadKeys.get(multipartUploadKeys.size() - 1);
                resultBuilder.setNextKeyMarker(lastReturned.getKeyName()).setNextUploadIdMarker(lastReturned.getUploadId()).setIsTruncated(true);
            }
            omMultipartUploadList = resultBuilder.setUploads(multipartUploadKeys).build();
        }
        catch (IOException ex) {
            try {
                LOG.error("List Multipart Uploads Failed: volume: " + volumeName + "bucket: " + bucketName + "prefix: " + prefix, (Throwable)ex);
                throw new OMException(ex.getMessage(), OMException.ResultCodes.LIST_MULTIPART_UPLOAD_PARTS_FAILED);
            }
            catch (Throwable throwable) {
                this.metadataManager.getLock().releaseReadLock((IOzoneManagerLock.Resource)OzoneManagerLock.LeveledResource.BUCKET_LOCK, new String[]{volumeName, bucketName});
                throw throwable;
            }
        }
        this.metadataManager.getLock().releaseReadLock((IOzoneManagerLock.Resource)OzoneManagerLock.LeveledResource.BUCKET_LOCK, new String[]{volumeName, bucketName});
        return omMultipartUploadList;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public OmMultipartUploadListParts listParts(String volumeName, String bucketName, String keyName, String uploadID, int partNumberMarker, int maxParts) throws IOException {
        OmMultipartUploadListParts omMultipartUploadListParts;
        Preconditions.checkNotNull((Object)volumeName);
        Preconditions.checkNotNull((Object)bucketName);
        Preconditions.checkNotNull((Object)keyName);
        Preconditions.checkNotNull((Object)uploadID);
        boolean isTruncated = false;
        int nextPartNumberMarker = 0;
        BucketLayout bucketLayout = BucketLayout.DEFAULT;
        String buckKey = this.metadataManager.getBucketKey(volumeName, bucketName);
        OmBucketInfo buckInfo = (OmBucketInfo)this.metadataManager.getBucketTable().get((Object)buckKey);
        bucketLayout = buckInfo.getBucketLayout();
        this.metadataManager.getLock().acquireReadLock((IOzoneManagerLock.Resource)OzoneManagerLock.LeveledResource.BUCKET_LOCK, new String[]{volumeName, bucketName});
        try {
            ArrayList<OmPartInfo> omPartInfoList;
            ReplicationConfig replicationConfig;
            Iterator partKeyInfoMapIterator;
            block12: {
                OmKeyInfo omKeyInfo;
                String multipartKey = this.metadataManager.getMultipartKey(volumeName, bucketName, keyName, uploadID);
                OmMultipartKeyInfo multipartKeyInfo = (OmMultipartKeyInfo)this.metadataManager.getMultipartInfoTable().get((Object)multipartKey);
                if (multipartKeyInfo == null) {
                    throw new OMException("No Such Multipart upload exists for this key.", OMException.ResultCodes.NO_SUCH_MULTIPART_UPLOAD_ERROR);
                }
                partKeyInfoMapIterator = multipartKeyInfo.getPartKeyInfoMap().iterator();
                replicationConfig = null;
                int count = 0;
                omPartInfoList = new ArrayList<OmPartInfo>();
                while (true) {
                    if (count >= maxParts || !partKeyInfoMapIterator.hasNext()) {
                        if (replicationConfig == null) {
                            if (this.isBucketFSOptimized(volumeName, bucketName)) {
                                multipartKey = OMMultipartUploadUtils.getMultipartOpenKey(volumeName, bucketName, keyName, uploadID, this.metadataManager, BucketLayout.FILE_SYSTEM_OPTIMIZED);
                            }
                            if ((omKeyInfo = (OmKeyInfo)this.metadataManager.getOpenKeyTable(bucketLayout).get((Object)multipartKey)) != null) break;
                            throw new IllegalStateException("Open key is missing for multipart upload " + multipartKey);
                        }
                        break block12;
                    }
                    OzoneManagerProtocolProtos.PartKeyInfo partKeyInfo = (OzoneManagerProtocolProtos.PartKeyInfo)partKeyInfoMapIterator.next();
                    nextPartNumberMarker = partKeyInfo.getPartNumber();
                    if (nextPartNumberMarker <= partNumberMarker) continue;
                    String partName = this.getPartName(partKeyInfo, volumeName, bucketName, keyName);
                    Optional<HddsProtos.KeyValue> eTag = partKeyInfo.getPartKeyInfo().getMetadataList().stream().filter(keyValue -> keyValue.getKey().equals("ETag")).findFirst();
                    OmPartInfo omPartInfo = new OmPartInfo(partKeyInfo.getPartNumber(), partName, partKeyInfo.getPartKeyInfo().getModificationTime(), partKeyInfo.getPartKeyInfo().getDataSize(), (String)eTag.map(HddsProtos.KeyValue::getValue).orElse(null));
                    omPartInfoList.add(omPartInfo);
                    replicationConfig = ReplicationConfig.fromProto((HddsProtos.ReplicationType)partKeyInfo.getPartKeyInfo().getType(), (HddsProtos.ReplicationFactor)partKeyInfo.getPartKeyInfo().getFactor(), (HddsProtos.ECReplicationConfig)partKeyInfo.getPartKeyInfo().getEcReplicationConfig());
                    ++count;
                }
                replicationConfig = omKeyInfo.getReplicationConfig();
            }
            Preconditions.checkNotNull(replicationConfig, (Object)"ReplicationConfig can't be identified");
            if (partKeyInfoMapIterator.hasNext()) {
                isTruncated = true;
            } else {
                isTruncated = false;
                nextPartNumberMarker = 0;
            }
            OmMultipartUploadListParts omMultipartUploadListParts2 = new OmMultipartUploadListParts(replicationConfig, nextPartNumberMarker, isTruncated);
            omMultipartUploadListParts2.addPartList(omPartInfoList);
            omMultipartUploadListParts = omMultipartUploadListParts2;
        }
        catch (OMException ex) {
            try {
                throw ex;
                catch (IOException ex2) {
                    LOG.error("List Multipart Upload Parts Failed: volume: {}, bucket: {}, ,key: {} ", new Object[]{volumeName, bucketName, keyName, ex2});
                    throw new OMException(ex2.getMessage(), OMException.ResultCodes.LIST_MULTIPART_UPLOAD_PARTS_FAILED);
                }
            }
            catch (Throwable throwable) {
                this.metadataManager.getLock().releaseReadLock((IOzoneManagerLock.Resource)OzoneManagerLock.LeveledResource.BUCKET_LOCK, new String[]{volumeName, bucketName});
                throw throwable;
            }
        }
        this.metadataManager.getLock().releaseReadLock((IOzoneManagerLock.Resource)OzoneManagerLock.LeveledResource.BUCKET_LOCK, new String[]{volumeName, bucketName});
        return omMultipartUploadListParts;
    }

    private String getPartName(OzoneManagerProtocolProtos.PartKeyInfo partKeyInfo, String volName, String buckName, String keyName) throws IOException {
        String partName = partKeyInfo.getPartName();
        if (this.isBucketFSOptimized(volName, buckName)) {
            String parentDir = OzoneFSUtils.getParentDir((String)keyName);
            String partFileName = OzoneFSUtils.getFileName((String)partKeyInfo.getPartName());
            StringBuilder fullKeyPartName = new StringBuilder();
            fullKeyPartName.append("/");
            fullKeyPartName.append(volName);
            fullKeyPartName.append("/");
            fullKeyPartName.append(buckName);
            if (StringUtils.isNotEmpty((CharSequence)parentDir)) {
                fullKeyPartName.append("/");
                fullKeyPartName.append(parentDir);
            }
            fullKeyPartName.append("/");
            fullKeyPartName.append(partFileName);
            return fullKeyPartName.toString();
        }
        return partName;
    }

    @Override
    public List<OzoneAcl> getAcl(OzoneObj obj) throws IOException {
        List list;
        this.validateOzoneObj(obj);
        ResolvedBucket resolvedBucket = this.ozoneManager.resolveBucketLink((Pair<String, String>)Pair.of((Object)obj.getVolumeName(), (Object)obj.getBucketName()));
        String volume = resolvedBucket.realVolume();
        String bucket = resolvedBucket.realBucket();
        String keyName = obj.getKeyName();
        this.metadataManager.getLock().acquireReadLock((IOzoneManagerLock.Resource)OzoneManagerLock.LeveledResource.BUCKET_LOCK, new String[]{volume, bucket});
        try {
            OMFileRequest.validateBucket(this.metadataManager, volume, bucket);
            String objectKey = this.metadataManager.getOzoneKey(volume, bucket, keyName);
            OmKeyInfo keyInfo = this.isBucketFSOptimized(volume, bucket) ? this.getOmKeyInfoFSO(volume, bucket, keyName) : this.getOmKeyInfo(volume, bucket, keyName, resolvedBucket.bucketLayout());
            if (keyInfo == null) {
                throw new OMException("Key not found. Key:" + objectKey, OMException.ResultCodes.KEY_NOT_FOUND);
            }
            list = keyInfo.getAcls();
        }
        catch (IOException ex) {
            try {
                if (!(ex instanceof OMException)) {
                    LOG.error("Get acl operation failed for key:{}/{}/{}", new Object[]{volume, bucket, keyName, ex});
                }
                throw ex;
            }
            catch (Throwable throwable) {
                this.metadataManager.getLock().releaseReadLock((IOzoneManagerLock.Resource)OzoneManagerLock.LeveledResource.BUCKET_LOCK, new String[]{volume, bucket});
                throw throwable;
            }
        }
        this.metadataManager.getLock().releaseReadLock((IOzoneManagerLock.Resource)OzoneManagerLock.LeveledResource.BUCKET_LOCK, new String[]{volume, bucket});
        return list;
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean checkAccess(OzoneObj ozObject, RequestContext context) throws OMException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [10[CATCHBLOCK], 3[TRYBLOCK]], but top level block is 5[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean checkChildrenAcls(OzoneObj ozObject, RequestContext context) throws IOException {
        OzoneFileStatus ozoneFileStatus = ozObject.getOzonePrefixPathViewer().getOzoneFileStatus();
        OmKeyInfo keyInfo = ozoneFileStatus.getKeyInfo();
        Stack<OzoneFileStatus> directories = new Stack<OzoneFileStatus>();
        boolean hasAccess = OzoneAclUtil.checkAclRights((List)keyInfo.getAcls(), (RequestContext)context);
        if (LOG.isDebugEnabled()) {
            LOG.debug("user:{} has access rights for key:{} :{} ", new Object[]{context.getClientUgi(), ozObject.getKeyName(), hasAccess});
        }
        if (ozoneFileStatus.isDirectory() && hasAccess) {
            directories.add(ozoneFileStatus);
        }
        while (!directories.isEmpty() && hasAccess) {
            ozoneFileStatus = (OzoneFileStatus)directories.pop();
            String keyPath = ozoneFileStatus.getTrimmedName();
            Iterator children = ozObject.getOzonePrefixPathViewer().getChildren(keyPath);
            while (hasAccess && children.hasNext()) {
                ozoneFileStatus = (OzoneFileStatus)children.next();
                keyInfo = ozoneFileStatus.getKeyInfo();
                hasAccess = OzoneAclUtil.checkAclRights((List)keyInfo.getAcls(), (RequestContext)context);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("user:{} has access rights for key:{} :{} ", new Object[]{context.getClientUgi(), keyInfo.getKeyName(), hasAccess});
                }
                if (!hasAccess || !ozoneFileStatus.isDirectory()) continue;
                directories.add(ozoneFileStatus);
            }
        }
        return hasAccess;
    }

    private void validateOzoneObj(OzoneObj obj) throws OMException {
        Objects.requireNonNull(obj);
        if (!obj.getResourceType().equals((Object)OzoneObj.ResourceType.KEY)) {
            throw new IllegalArgumentException("Unexpected argument passed to KeyManager. OzoneObj type:" + obj.getResourceType());
        }
        String volume = obj.getVolumeName();
        String bucket = obj.getBucketName();
        String keyName = obj.getKeyName();
        if (Strings.isNullOrEmpty((String)volume)) {
            throw new OMException("Volume name is required.", OMException.ResultCodes.VOLUME_NOT_FOUND);
        }
        if (Strings.isNullOrEmpty((String)bucket)) {
            throw new OMException("Bucket name is required.", OMException.ResultCodes.BUCKET_NOT_FOUND);
        }
        if (Strings.isNullOrEmpty((String)keyName)) {
            throw new OMException("Key name is required.", OMException.ResultCodes.KEY_NOT_FOUND);
        }
    }

    @Override
    public OzoneFileStatus getFileStatus(OmKeyArgs args) throws IOException {
        Preconditions.checkNotNull((Object)args, (Object)"Key args can not be null");
        return this.getFileStatus(args, null);
    }

    @Override
    public OzoneFileStatus getFileStatus(OmKeyArgs args, String clientAddress) throws IOException {
        Preconditions.checkNotNull((Object)args, (Object)"Key args can not be null");
        String volumeName = args.getVolumeName();
        String bucketName = args.getBucketName();
        if (this.isBucketFSOptimized(volumeName, bucketName)) {
            return this.getOzoneFileStatusFSO(args, clientAddress, false);
        }
        return this.getOzoneFileStatus(args, clientAddress);
    }

    private OzoneFileStatus getOzoneFileStatus(OmKeyArgs args, String clientAddress) throws IOException {
        OmKeyInfo fakeDirKeyInfo;
        OmKeyInfo dirKeyInfo;
        OmKeyInfo fileKeyInfo;
        String keyName;
        String bucketName;
        String volumeName;
        block21: {
            OzoneFileStatus ozoneFileStatus;
            Preconditions.checkNotNull((Object)args, (Object)"Key args can not be null");
            volumeName = args.getVolumeName();
            bucketName = args.getBucketName();
            keyName = args.getKeyName();
            fileKeyInfo = null;
            dirKeyInfo = null;
            fakeDirKeyInfo = null;
            this.metadataManager.getLock().acquireReadLock((IOzoneManagerLock.Resource)OzoneManagerLock.LeveledResource.BUCKET_LOCK, new String[]{volumeName, bucketName});
            try {
                if (!keyName.isEmpty()) break block21;
                OMFileRequest.validateBucket(this.metadataManager, volumeName, bucketName);
                ozoneFileStatus = new OzoneFileStatus();
            }
            catch (Throwable throwable) {
                this.metadataManager.getLock().releaseReadLock((IOzoneManagerLock.Resource)OzoneManagerLock.LeveledResource.BUCKET_LOCK, new String[]{volumeName, bucketName});
                if (fileKeyInfo != null) {
                    if (args.getLatestVersionLocation()) {
                        this.slimLocationVersion(fileKeyInfo);
                    }
                    if (!args.isHeadOp()) {
                        this.refresh(fileKeyInfo);
                        if (args.getSortDatanodes()) {
                            this.sortDatanodes(clientAddress, fileKeyInfo);
                        }
                    }
                }
                throw throwable;
            }
            this.metadataManager.getLock().releaseReadLock((IOzoneManagerLock.Resource)OzoneManagerLock.LeveledResource.BUCKET_LOCK, new String[]{volumeName, bucketName});
            if (fileKeyInfo != null) {
                if (args.getLatestVersionLocation()) {
                    this.slimLocationVersion(fileKeyInfo);
                }
                if (!args.isHeadOp()) {
                    this.refresh(fileKeyInfo);
                    if (args.getSortDatanodes()) {
                        this.sortDatanodes(clientAddress, fileKeyInfo);
                    }
                }
            }
            return ozoneFileStatus;
        }
        String fileKeyBytes = this.metadataManager.getOzoneKey(volumeName, bucketName, keyName);
        BucketLayout layout = OzoneManagerUtils.getBucketLayout(this.metadataManager, volumeName, bucketName);
        fileKeyInfo = (OmKeyInfo)this.metadataManager.getKeyTable(layout).get((Object)fileKeyBytes);
        String dirKey = OzoneFSUtils.addTrailingSlashIfNeeded((String)keyName);
        if (fileKeyInfo == null) {
            String dirKeyBytes = this.metadataManager.getOzoneKey(volumeName, bucketName, dirKey);
            dirKeyInfo = (OmKeyInfo)this.metadataManager.getKeyTable(layout).get((Object)dirKeyBytes);
            if (dirKeyInfo == null) {
                fakeDirKeyInfo = this.createFakeDirIfShould(volumeName, bucketName, keyName, layout);
            }
        }
        this.metadataManager.getLock().releaseReadLock((IOzoneManagerLock.Resource)OzoneManagerLock.LeveledResource.BUCKET_LOCK, new String[]{volumeName, bucketName});
        if (fileKeyInfo != null) {
            if (args.getLatestVersionLocation()) {
                this.slimLocationVersion(fileKeyInfo);
            }
            if (!args.isHeadOp()) {
                this.refresh(fileKeyInfo);
                if (args.getSortDatanodes()) {
                    this.sortDatanodes(clientAddress, fileKeyInfo);
                }
            }
        }
        if (fileKeyInfo != null) {
            return new OzoneFileStatus(fileKeyInfo, this.scmBlockSize, false);
        }
        if (dirKeyInfo != null) {
            return new OzoneFileStatus(dirKeyInfo, this.scmBlockSize, true);
        }
        if (fakeDirKeyInfo != null) {
            return new OzoneFileStatus(fakeDirKeyInfo, this.scmBlockSize, true);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Unable to get file status for the key: volume: {}, bucket: {}, key: {}, with error: No such file exists.", new Object[]{volumeName, bucketName, keyName});
        }
        throw new OMException("Unable to get file status: volume: " + volumeName + " bucket: " + bucketName + " key: " + keyName, OMException.ResultCodes.FILE_NOT_FOUND);
    }

    private OmKeyInfo createFakeDirIfShould(String volume, String bucket, String keyName, BucketLayout layout) throws IOException {
        String dirKey = OzoneFSUtils.addTrailingSlashIfNeeded((String)keyName);
        String targetKey = OzoneFSUtils.addTrailingSlashIfNeeded((String)this.metadataManager.getOzoneKey(volume, bucket, keyName));
        Table keyTable = this.metadataManager.getKeyTable(layout);
        Iterator cacheIterator = keyTable.cacheIterator();
        HashSet<String> deletedKeys = new HashSet<String>();
        while (cacheIterator.hasNext()) {
            boolean exists;
            Map.Entry cacheEntry = (Map.Entry)cacheIterator.next();
            String cacheKey = (String)((CacheKey)cacheEntry.getKey()).getCacheKey();
            CacheValue cacheValue = (CacheValue)cacheEntry.getValue();
            boolean bl = exists = cacheValue != null && cacheValue.getCacheValue() != null;
            if (exists && cacheKey.startsWith(targetKey) && !Objects.equals(cacheKey, targetKey)) {
                LOG.debug("Fake dir {} required for {}", (Object)targetKey, (Object)cacheKey);
                return this.createDirectoryKey((OmKeyInfo)cacheValue.getCacheValue(), dirKey);
            }
            if (exists) continue;
            deletedKeys.add(cacheKey);
        }
        Throwable throwable = null;
        Object var11_12 = null;
        try (Table.KeyValueIterator keyTblItr = keyTable.iterator((Object)targetKey);){
            while (keyTblItr.hasNext()) {
                Table.KeyValue keyValue = (Table.KeyValue)keyTblItr.next();
                if (keyValue == null) continue;
                String key = (String)keyValue.getKey();
                if (key.startsWith(targetKey)) {
                    if (Objects.equals(key, targetKey) || deletedKeys.contains(key)) continue;
                    LOG.debug("Fake dir {} required for {}", (Object)targetKey, (Object)key);
                    return this.createDirectoryKey((OmKeyInfo)keyValue.getValue(), dirKey);
                }
                break;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return null;
    }

    private OzoneFileStatus getOzoneFileStatusFSO(OmKeyArgs args, String clientAddress, boolean skipFileNotFoundError) throws IOException {
        OzoneFileStatus fileStatus;
        String keyName;
        String bucketName;
        String volumeName;
        block10: {
            OzoneFileStatus ozoneFileStatus;
            volumeName = args.getVolumeName();
            bucketName = args.getBucketName();
            keyName = args.getKeyName();
            fileStatus = null;
            this.metadataManager.getLock().acquireReadLock((IOzoneManagerLock.Resource)OzoneManagerLock.LeveledResource.BUCKET_LOCK, new String[]{volumeName, bucketName});
            try {
                if (!keyName.isEmpty()) break block10;
                OMFileRequest.validateBucket(this.metadataManager, volumeName, bucketName);
                ozoneFileStatus = new OzoneFileStatus();
            }
            catch (Throwable throwable) {
                this.metadataManager.getLock().releaseReadLock((IOzoneManagerLock.Resource)OzoneManagerLock.LeveledResource.BUCKET_LOCK, new String[]{volumeName, bucketName});
                throw throwable;
            }
            this.metadataManager.getLock().releaseReadLock((IOzoneManagerLock.Resource)OzoneManagerLock.LeveledResource.BUCKET_LOCK, new String[]{volumeName, bucketName});
            return ozoneFileStatus;
        }
        fileStatus = OMFileRequest.getOMKeyInfoIfExists(this.metadataManager, volumeName, bucketName, keyName, this.scmBlockSize, this.ozoneManager.getDefaultReplicationConfig());
        this.metadataManager.getLock().releaseReadLock((IOzoneManagerLock.Resource)OzoneManagerLock.LeveledResource.BUCKET_LOCK, new String[]{volumeName, bucketName});
        if (fileStatus != null) {
            if (fileStatus.isFile()) {
                OmKeyInfo fileKeyInfo = fileStatus.getKeyInfo();
                if (args.getLatestVersionLocation()) {
                    this.slimLocationVersion(fileKeyInfo);
                }
                if (!args.isHeadOp()) {
                    this.refresh(fileKeyInfo);
                    if (args.getSortDatanodes()) {
                        this.sortDatanodes(clientAddress, fileKeyInfo);
                    }
                }
                return new OzoneFileStatus(fileKeyInfo, this.scmBlockSize, false);
            }
            return fileStatus;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Unable to get file status for the key: volume: {}, bucket: {}, key: {}, with error: No such file exists.", new Object[]{volumeName, bucketName, keyName});
        }
        if (skipFileNotFoundError) {
            return fileStatus;
        }
        throw new OMException("Unable to get file status: volume: " + volumeName + " bucket: " + bucketName + " key: " + keyName, OMException.ResultCodes.FILE_NOT_FOUND);
    }

    private OmKeyInfo createDirectoryKey(OmKeyInfo keyInfo, String keyName) throws IOException {
        OmBucketInfo bucketInfo = this.getBucketInfo(keyInfo.getVolumeName(), keyInfo.getBucketName());
        String dir = OzoneFSUtils.addTrailingSlashIfNeeded((String)keyName);
        FileEncryptionInfo encInfo = this.getFileEncryptionInfo(bucketInfo);
        return new OmKeyInfo.Builder().setVolumeName(keyInfo.getVolumeName()).setBucketName(keyInfo.getBucketName()).setKeyName(dir).setFileName(OzoneFSUtils.getFileName((String)keyName)).setOmKeyLocationInfos(Collections.singletonList(new OmKeyLocationInfoGroup(0L, new ArrayList()))).setCreationTime(Time.now()).setModificationTime(Time.now()).setDataSize(0L).setReplicationConfig(keyInfo.getReplicationConfig()).setFileEncryptionInfo(encInfo).setAcls(keyInfo.getAcls()).setOwnerName(keyInfo.getOwnerName()).build();
    }

    @Override
    public OmKeyInfo lookupFile(OmKeyArgs args, String clientAddress) throws IOException {
        Preconditions.checkNotNull((Object)args, (Object)"Key args can not be null");
        String volumeName = args.getVolumeName();
        String bucketName = args.getBucketName();
        String keyName = args.getKeyName();
        OzoneFileStatus fileStatus = this.isBucketFSOptimized(volumeName, bucketName) ? this.getOzoneFileStatusFSO(args, clientAddress, false) : this.getOzoneFileStatus(args, clientAddress);
        if (fileStatus.isFile()) {
            if (!args.isHeadOp()) {
                this.addBlockToken4Read(fileStatus.getKeyInfo());
            }
            return fileStatus.getKeyInfo();
        }
        throw new OMException("Can not write to directory: " + keyName, OMException.ResultCodes.NOT_A_FILE);
    }

    @Override
    public void refresh(OmKeyInfo key) throws IOException {
        Preconditions.checkNotNull((Object)key, (Object)"Key info can not be null");
        this.refreshPipeline(Collections.singletonList(key));
    }

    private void listStatusFindKeyInTableCache(Iterator<Map.Entry<CacheKey<String>, CacheValue<OmKeyInfo>>> cacheIter, String keyArgs, String startCacheKey, boolean recursive, TreeMap<String, OzoneFileStatus> cacheKeyMap) throws IOException {
        HashMap<String, OmKeyInfo> remainingKeys = new HashMap<String, OmKeyInfo>();
        int volBuckEndIndex = StringUtils.ordinalIndexOf((CharSequence)startCacheKey, (CharSequence)"/", (int)3);
        String volumeBuckPrefix = startCacheKey.substring(0, volBuckEndIndex + 1);
        while (cacheIter.hasNext()) {
            Map.Entry<CacheKey<String>, CacheValue<OmKeyInfo>> entry = cacheIter.next();
            String cacheKey = (String)entry.getKey().getCacheKey();
            if (cacheKey.equals(keyArgs)) continue;
            OmKeyInfo cacheOmKeyInfo = (OmKeyInfo)entry.getValue().getCacheValue();
            if (cacheOmKeyInfo != null && cacheKey.startsWith(keyArgs) && cacheKey.compareTo(startCacheKey) >= 0) {
                String remainingKey;
                if (!recursive && (remainingKey = StringUtils.stripEnd((String)cacheKey.substring(keyArgs.length()), (String)"/")).contains("/")) {
                    remainingKeys.put(cacheKey, cacheOmKeyInfo);
                    continue;
                }
                OzoneFileStatus fileStatus = new OzoneFileStatus(cacheOmKeyInfo, this.scmBlockSize, !OzoneFSUtils.isFile((String)cacheKey));
                cacheKeyMap.putIfAbsent(cacheKey, fileStatus);
                continue;
            }
            if (cacheOmKeyInfo != null || cacheKeyMap.containsKey(cacheKey)) continue;
            cacheKeyMap.put(cacheKey, null);
        }
        if (!recursive) {
            for (Map.Entry entry : remainingKeys.entrySet()) {
                String remainingKey = (String)entry.getKey();
                String immediateChild = OzoneFSUtils.getImmediateChild((String)remainingKey, (String)keyArgs);
                if (cacheKeyMap.containsKey(immediateChild)) continue;
                String immediateChildKeyName = immediateChild.replaceAll(volumeBuckPrefix, "");
                OmKeyInfo fakeDirEntry = this.createDirectoryKey((OmKeyInfo)entry.getValue(), immediateChildKeyName);
                cacheKeyMap.put(immediateChild, new OzoneFileStatus(fakeDirEntry, this.scmBlockSize, true));
            }
        }
    }

    @Override
    public List<OzoneFileStatus> listStatus(OmKeyArgs args, boolean recursive, String startKey, long numEntries) throws IOException {
        return this.listStatus(args, recursive, startKey, numEntries, null);
    }

    @Override
    public List<OzoneFileStatus> listStatus(OmKeyArgs args, boolean recursive, String startKey, long numEntries, String clientAddress) throws IOException {
        return this.listStatus(args, recursive, startKey, numEntries, clientAddress, false);
    }

    @Override
    public List<OzoneFileStatus> listStatus(OmKeyArgs args, boolean recursive, String startKey, long numEntries, String clientAddress, boolean allowPartialPrefixes) throws IOException {
        TableIterator<String, ? extends Table.KeyValue<String, OmKeyInfo>> iterator;
        Table keyTable;
        Preconditions.checkNotNull((Object)args, (Object)"Key args can not be null");
        String volumeName = args.getVolumeName();
        String bucketName = args.getBucketName();
        String keyName = args.getKeyName();
        ArrayList<OzoneFileStatus> fileStatusList = new ArrayList<OzoneFileStatus>();
        if (numEntries <= 0L) {
            return fileStatusList;
        }
        if (this.isBucketFSOptimized(volumeName, bucketName)) {
            Preconditions.checkArgument((!recursive ? 1 : 0) != 0);
            OzoneListStatusHelper statusHelper = new OzoneListStatusHelper(this.metadataManager, this.scmBlockSize, this::getOzoneFileStatusFSO, this.ozoneManager.getDefaultReplicationConfig());
            Collection<OzoneFileStatus> statuses = statusHelper.listStatusFSO(args, startKey, numEntries, clientAddress, allowPartialPrefixes);
            return this.buildFinalStatusList(statuses, args, clientAddress);
        }
        TreeMap<String, OzoneFileStatus> cacheKeyMap = new TreeMap<String, OzoneFileStatus>();
        if (Strings.isNullOrEmpty((String)startKey)) {
            OzoneFileStatus fileStatus = this.getFileStatus(args, clientAddress);
            if (fileStatus.isFile()) {
                return Collections.singletonList(fileStatus);
            }
            startKey = OzoneFSUtils.addTrailingSlashIfNeeded((String)keyName);
        }
        String keyArgs = OzoneFSUtils.addTrailingSlashIfNeeded((String)this.metadataManager.getOzoneKey(volumeName, bucketName, keyName));
        this.metadataManager.getLock().acquireReadLock((IOzoneManagerLock.Resource)OzoneManagerLock.LeveledResource.BUCKET_LOCK, new String[]{volumeName, bucketName});
        try {
            keyTable = this.metadataManager.getKeyTable(OzoneManagerUtils.getBucketLayout(this.metadataManager, volumeName, bucketName));
            iterator = this.getIteratorForKeyInTableCache(recursive, startKey, volumeName, bucketName, cacheKeyMap, keyArgs, (Table<String, OmKeyInfo>)keyTable);
        }
        catch (Throwable throwable) {
            this.metadataManager.getLock().releaseReadLock((IOzoneManagerLock.Resource)OzoneManagerLock.LeveledResource.BUCKET_LOCK, new String[]{volumeName, bucketName});
            throw throwable;
        }
        this.metadataManager.getLock().releaseReadLock((IOzoneManagerLock.Resource)OzoneManagerLock.LeveledResource.BUCKET_LOCK, new String[]{volumeName, bucketName});
        try {
            this.findKeyInDbWithIterator(recursive, startKey, numEntries, volumeName, bucketName, keyName, cacheKeyMap, keyArgs, (Table<String, OmKeyInfo>)keyTable, iterator);
        }
        finally {
            iterator.close();
        }
        int countEntries = 0;
        for (OzoneFileStatus fileStatus : cacheKeyMap.values()) {
            if (fileStatus == null) continue;
            fileStatusList.add(fileStatus);
            if ((long)(++countEntries) >= numEntries) break;
        }
        cacheKeyMap.clear();
        ArrayList<OmKeyInfo> keyInfoList = new ArrayList<OmKeyInfo>(fileStatusList.size());
        fileStatusList.stream().map(OzoneFileStatus::getKeyInfo).forEach(keyInfoList::add);
        if (args.getLatestVersionLocation()) {
            this.slimLocationVersion(keyInfoList.toArray(new OmKeyInfo[0]));
        }
        this.refreshPipelineFromCache(keyInfoList);
        if (args.getSortDatanodes()) {
            this.sortDatanodes(clientAddress, keyInfoList);
        }
        return fileStatusList;
    }

    private TableIterator<String, ? extends Table.KeyValue<String, OmKeyInfo>> getIteratorForKeyInTableCache(boolean recursive, String startKey, String volumeName, String bucketName, TreeMap<String, OzoneFileStatus> cacheKeyMap, String keyArgs, Table<String, OmKeyInfo> keyTable) throws IOException {
        Iterator cacheIter = keyTable.cacheIterator();
        String startCacheKey = this.metadataManager.getOzoneKey(volumeName, bucketName, startKey);
        this.listStatusFindKeyInTableCache(cacheIter, keyArgs, startCacheKey, recursive, cacheKeyMap);
        Table.KeyValueIterator iterator = keyTable.iterator();
        return iterator;
    }

    private void findKeyInDbWithIterator(boolean recursive, String startKey, long numEntries, String volumeName, String bucketName, String keyName, TreeMap<String, OzoneFileStatus> cacheKeyMap, String keyArgs, Table<String, OmKeyInfo> keyTable, TableIterator<String, ? extends Table.KeyValue<String, OmKeyInfo>> iterator) throws IOException {
        String seekKeyInDb = this.metadataManager.getOzoneKey(volumeName, bucketName, startKey);
        Table.KeyValue entry = (Table.KeyValue)iterator.seek((Object)seekKeyInDb);
        int countEntries = 0;
        if (iterator.hasNext()) {
            if (((String)entry.getKey()).equals(keyArgs)) {
                iterator.next();
            }
            while (iterator.hasNext() && numEntries - (long)countEntries > 0L) {
                entry = (Table.KeyValue)iterator.next();
                String entryInDb = (String)entry.getKey();
                OmKeyInfo omKeyInfo = (OmKeyInfo)entry.getValue();
                if (!entryInDb.startsWith(keyArgs)) break;
                String entryKeyName = omKeyInfo.getKeyName();
                if (recursive) {
                    if (cacheKeyMap.containsKey(entryInDb)) continue;
                    cacheKeyMap.put(entryInDb, new OzoneFileStatus(omKeyInfo, this.scmBlockSize, !OzoneFSUtils.isFile((String)entryKeyName)));
                    ++countEntries;
                    continue;
                }
                String immediateChild = OzoneFSUtils.getImmediateChild((String)entryKeyName, (String)keyName);
                boolean isFile = OzoneFSUtils.isFile((String)immediateChild);
                if (isFile) {
                    if (cacheKeyMap.containsKey(entryInDb)) continue;
                    cacheKeyMap.put(entryInDb, new OzoneFileStatus(omKeyInfo, this.scmBlockSize, !isFile));
                    ++countEntries;
                    continue;
                }
                if (!cacheKeyMap.containsKey(entryInDb)) {
                    if (!entryKeyName.equals(immediateChild)) {
                        OmKeyInfo fakeDirEntry = this.createDirectoryKey(omKeyInfo, immediateChild);
                        String fakeDirKey = this.ozoneManager.getMetadataManager().getOzoneKey(fakeDirEntry.getVolumeName(), fakeDirEntry.getBucketName(), fakeDirEntry.getKeyName());
                        cacheKeyMap.put(fakeDirKey, new OzoneFileStatus(fakeDirEntry, this.scmBlockSize, true));
                    } else {
                        cacheKeyMap.put(entryInDb, new OzoneFileStatus(omKeyInfo, 0L, true));
                    }
                    ++countEntries;
                }
                iterator.seek((Object)this.getNextGreaterString(volumeName, bucketName, immediateChild));
            }
        }
    }

    private List<OzoneFileStatus> buildFinalStatusList(Collection<OzoneFileStatus> statusesCollection, OmKeyArgs omKeyArgs, String clientAddress) throws IOException {
        ArrayList<OzoneFileStatus> fileStatusFinalList = new ArrayList<OzoneFileStatus>();
        ArrayList<OmKeyInfo> keyInfoList = new ArrayList<OmKeyInfo>();
        for (OzoneFileStatus fileStatus : statusesCollection) {
            if (fileStatus.isFile()) {
                keyInfoList.add(fileStatus.getKeyInfo());
            }
            fileStatusFinalList.add(fileStatus);
        }
        return this.sortPipelineInfo(fileStatusFinalList, keyInfoList, omKeyArgs, clientAddress);
    }

    private List<OzoneFileStatus> sortPipelineInfo(List<OzoneFileStatus> fileStatusFinalList, List<OmKeyInfo> keyInfoList, OmKeyArgs omKeyArgs, String clientAddress) throws IOException {
        if (omKeyArgs.getLatestVersionLocation()) {
            this.slimLocationVersion(keyInfoList.toArray(new OmKeyInfo[0]));
        }
        this.refreshPipelineFromCache(keyInfoList);
        if (omKeyArgs.getSortDatanodes()) {
            this.sortDatanodes(clientAddress, keyInfoList);
        }
        return fileStatusFinalList;
    }

    private String getNextGreaterString(String volumeName, String bucketName, String keyPrefix) throws IOException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)keyPrefix) ? 1 : 0) != 0, (Object)"Key prefix is null or empty");
        StringCodec codec = StringCodec.get();
        byte[] keyPrefixInBytes = codec.toPersistedFormat(keyPrefix);
        int n = keyPrefixInBytes.length - 1;
        keyPrefixInBytes[n] = (byte)(keyPrefixInBytes[n] + 1);
        return this.metadataManager.getOzoneKey(volumeName, bucketName, codec.fromPersistedFormat(keyPrefixInBytes));
    }

    private FileEncryptionInfo getFileEncryptionInfo(OmBucketInfo bucketInfo) throws IOException {
        FileEncryptionInfo encInfo = null;
        BucketEncryptionKeyInfo ezInfo = bucketInfo.getEncryptionKeyInfo();
        if (ezInfo != null) {
            if (this.getKMSProvider() == null) {
                throw new OMException("Invalid KMS provider, check configuration hadoop.security.key.provider.path", OMException.ResultCodes.INVALID_KMS_PROVIDER);
            }
            String ezKeyName = ezInfo.getKeyName();
            KeyProviderCryptoExtension.EncryptedKeyVersion edek = this.generateEDEK(ezKeyName);
            encInfo = new FileEncryptionInfo(ezInfo.getSuite(), ezInfo.getVersion(), edek.getEncryptedKeyVersion().getMaterial(), edek.getEncryptedKeyIv(), ezKeyName, edek.getEncryptionKeyVersionName());
        }
        return encInfo;
    }

    private void sortDatanodes(String clientMachine, OmKeyInfo keyInfo) {
        this.sortDatanodes(clientMachine, Collections.singletonList(keyInfo));
    }

    private void sortDatanodes(String clientMachine, List<OmKeyInfo> keyInfos) {
        if (keyInfos != null && clientMachine != null) {
            HashMap sortedPipelines = new HashMap();
            for (OmKeyInfo keyInfo : keyInfos) {
                OmKeyLocationInfoGroup key = keyInfo.getLatestVersionLocations();
                if (key == null) {
                    LOG.warn("No location for key {}", (Object)keyInfo);
                    continue;
                }
                for (OmKeyLocationInfo k : key.getLocationList()) {
                    Pipeline pipeline = k.getPipeline();
                    List nodes = pipeline.getNodes();
                    if (nodes.isEmpty()) {
                        LOG.warn("No datanodes in pipeline {}", (Object)pipeline.getId());
                        continue;
                    }
                    Set uuidSet = nodes.stream().map(DatanodeDetails::getUuidString).collect(Collectors.toSet());
                    List<? extends DatanodeDetails> sortedNodes = (List<? extends DatanodeDetails>)sortedPipelines.get(uuidSet);
                    if (sortedNodes == null) {
                        sortedNodes = this.sortDatanodes(nodes, clientMachine);
                        if (sortedNodes != null) {
                            sortedPipelines.put(uuidSet, sortedNodes);
                        }
                    } else if (LOG.isDebugEnabled()) {
                        LOG.debug("Found sorted datanodes for pipeline {} and client {} in cache", (Object)pipeline.getId(), (Object)clientMachine);
                    }
                    if (Objects.equals(pipeline.getNodesInOrder(), sortedNodes)) continue;
                    k.setPipeline(pipeline.copyWithNodesInOrder(sortedNodes));
                }
            }
        }
    }

    @VisibleForTesting
    public List<? extends DatanodeDetails> sortDatanodes(List<? extends DatanodeDetails> nodes, String clientMachine) {
        Node client = this.getClientNode(clientMachine, nodes);
        return this.ozoneManager.getClusterMap().sortByDistanceCost(client, nodes, nodes.size());
    }

    private Node getClientNode(String clientMachine, List<? extends DatanodeDetails> nodes) {
        ArrayList<DatanodeDetails> matchingNodes = new ArrayList<DatanodeDetails>();
        boolean useHostname = this.ozoneManager.getConfiguration().getBoolean("hdds.datanode.use.datanode.hostname", false);
        for (DatanodeDetails datanodeDetails : nodes) {
            if (!(useHostname ? datanodeDetails.getHostName() : datanodeDetails.getIpAddress()).equals(clientMachine)) continue;
            matchingNodes.add(datanodeDetails);
        }
        return !matchingNodes.isEmpty() ? (Node)matchingNodes.get(0) : this.getOtherNode(clientMachine);
    }

    private Node getOtherNode(String clientMachine) {
        try {
            Node rack;
            String clientLocation = this.resolveNodeLocation(clientMachine);
            if (clientLocation != null && (rack = this.ozoneManager.getClusterMap().getNode(clientLocation)) instanceof InnerNode) {
                return new NodeImpl(clientMachine, clientLocation, (InnerNode)rack, rack.getLevel() + 1, 0);
            }
        }
        catch (Exception e) {
            LOG.info("Could not resolve client {}: {}", (Object)clientMachine, (Object)e.getMessage());
        }
        return null;
    }

    private String resolveNodeLocation(String hostname) {
        List<String> hosts = Collections.singletonList(hostname);
        List resolvedHosts = this.dnsToSwitchMapping.resolve(hosts);
        if (resolvedHosts != null && !resolvedHosts.isEmpty()) {
            String location = (String)resolvedHosts.get(0);
            LOG.debug("Node {} resolved to location {}", (Object)hostname, (Object)location);
            return location;
        }
        LOG.debug("Node resolution did not yield any result for {}", (Object)hostname);
        return null;
    }

    private void slimLocationVersion(OmKeyInfo ... keyInfos) {
        if (keyInfos != null) {
            OmKeyInfo[] omKeyInfoArray = keyInfos;
            int n = keyInfos.length;
            int n2 = 0;
            while (n2 < n) {
                OmKeyInfo keyInfo = omKeyInfoArray[n2];
                OmKeyLocationInfoGroup key = keyInfo.getLatestVersionLocations();
                if (key == null) {
                    LOG.warn("No location version for key {}", (Object)keyInfo);
                } else {
                    int keyLocationVersionLength = keyInfo.getKeyLocationVersions().size();
                    if (keyLocationVersionLength > 1) {
                        keyInfo.setKeyLocationVersions(keyInfo.getKeyLocationVersions().subList(keyLocationVersionLength - 1, keyLocationVersionLength));
                    }
                }
                ++n2;
            }
        }
    }

    @Override
    public TableIterator<String, ? extends Table.KeyValue<String, OmKeyInfo>> getDeletedDirEntries(String volume, String bucket) throws IOException {
        Optional<String> bucketPrefix = this.getBucketPrefix(volume, bucket, true);
        return this.metadataManager.getDeletedDirTable().iterator((Object)bucketPrefix.orElse(""));
    }

    @Override
    public DeleteKeysResult getPendingDeletionSubDirs(long volumeId, long bucketId, OmKeyInfo parentInfo, CheckedFunction<Table.KeyValue<String, OmKeyInfo>, Boolean, IOException> filter, int remainingNum) throws IOException {
        return this.gatherSubPathsWithIterator(volumeId, bucketId, parentInfo, this.metadataManager.getDirectoryTable(), kv -> Table.newKeyValue((Object)this.metadataManager.getOzoneDeletePathKey(((OmDirectoryInfo)kv.getValue()).getObjectID(), (String)kv.getKey()), (Object)OMFileRequest.getKeyInfoWithFullPath(parentInfo, (OmDirectoryInfo)kv.getValue())), filter, remainingNum);
    }

    private <T extends WithParentObjectId> DeleteKeysResult gatherSubPathsWithIterator(long volumeId, long bucketId, OmKeyInfo parentInfo, Table<String, T> table, CheckedFunction<Table.KeyValue<String, T>, Table.KeyValue<String, OmKeyInfo>, IOException> deleteKeyTransformer, CheckedFunction<Table.KeyValue<String, OmKeyInfo>, Boolean, IOException> deleteKeyFilter, int remainingNum) throws IOException {
        ArrayList<OmKeyInfo> keyInfos = new ArrayList<OmKeyInfo>();
        String seekFileInDB = this.metadataManager.getOzonePathKey(volumeId, bucketId, parentInfo.getObjectID(), "");
        Throwable throwable = null;
        Object var13_12 = null;
        try (Table.KeyValueIterator iterator = table.iterator((Object)seekFileInDB);){
            while (iterator.hasNext() && remainingNum > 0) {
                Table.KeyValue entry = (Table.KeyValue)iterator.next();
                Table.KeyValue keyInfo = (Table.KeyValue)deleteKeyTransformer.apply((Object)entry);
                if (!((Boolean)deleteKeyFilter.apply((Object)keyInfo)).booleanValue()) continue;
                keyInfos.add((OmKeyInfo)keyInfo.getValue());
                --remainingNum;
            }
            return new DeleteKeysResult(keyInfos, !iterator.hasNext());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public DeleteKeysResult getPendingDeletionSubFiles(long volumeId, long bucketId, OmKeyInfo parentInfo, CheckedFunction<Table.KeyValue<String, OmKeyInfo>, Boolean, IOException> filter, int remainingNum) throws IOException {
        CheckedFunction tranformer = kv -> {
            OmKeyInfo keyInfo = OMFileRequest.getKeyInfoWithFullPath(parentInfo, (OmKeyInfo)kv.getValue());
            String deleteKey = this.metadataManager.getOzoneDeletePathKey(keyInfo.getObjectID(), this.metadataManager.getOzoneKey(keyInfo.getVolumeName(), keyInfo.getBucketName(), keyInfo.getKeyName()));
            return Table.newKeyValue((Object)deleteKey, (Object)keyInfo);
        };
        return this.gatherSubPathsWithIterator(volumeId, bucketId, parentInfo, this.metadataManager.getFileTable(), tranformer, filter, remainingNum);
    }

    public boolean isBucketFSOptimized(String volName, String buckName) throws IOException {
        String buckKey = this.metadataManager.getBucketKey(volName, buckName);
        OmBucketInfo buckInfo = (OmBucketInfo)this.metadataManager.getBucketTable().get((Object)buckKey);
        if (buckInfo != null) {
            return buckInfo.getBucketLayout().isFileSystemOptimized();
        }
        return false;
    }

    @Override
    public OmKeyInfo getKeyInfo(OmKeyArgs args, ResolvedBucket bucket, String clientAddress) throws IOException {
        Preconditions.checkNotNull((Object)args);
        OmKeyInfo value = (OmKeyInfo)MetricUtil.captureLatencyNs((MutableRate)this.metrics.getGetKeyInfoReadKeyInfoLatencyNs(), () -> this.readKeyInfo(args, bucket.bucketLayout()));
        if (!args.isHeadOp()) {
            MetricUtil.captureLatencyNs((MutableRate)this.metrics.getGetKeyInfoGenerateBlockTokenLatencyNs(), () -> this.addBlockToken4Read(value));
            MetricUtil.captureLatencyNs((MutableRate)this.metrics.getGetKeyInfoRefreshLocationLatencyNs(), () -> this.refreshPipelineFromCache(value, args.isForceUpdateContainerCacheFromSCM()));
            if (args.getSortDatanodes()) {
                MetricUtil.captureLatencyNs((MutableRate)this.metrics.getGetKeyInfoSortDatanodesLatencyNs(), () -> this.sortDatanodes(clientAddress, value));
            }
        }
        return value;
    }

    private void refreshPipelineFromCache(Iterable<OmKeyInfo> keyInfos) throws IOException {
        HashSet<Long> containerIds = new HashSet<Long>();
        for (OmKeyInfo keyInfo : keyInfos) {
            this.extractContainerIDs(keyInfo).forEach(containerIds::add);
        }
        Map<Long, Pipeline> containerLocations = this.scmClient.getContainerLocations(containerIds, false);
        for (OmKeyInfo keyInfo : keyInfos) {
            this.setUpdatedContainerLocation(keyInfo, containerLocations);
        }
    }

    protected void refreshPipelineFromCache(OmKeyInfo keyInfo, boolean forceRefresh) throws IOException {
        Set<Long> containerIds = this.extractContainerIDs(keyInfo).collect(Collectors.toSet());
        this.metrics.setForceContainerCacheRefresh(forceRefresh);
        Map<Long, Pipeline> containerLocations = this.scmClient.getContainerLocations(containerIds, forceRefresh);
        this.setUpdatedContainerLocation(keyInfo, containerLocations);
    }

    private void setUpdatedContainerLocation(OmKeyInfo keyInfo, Map<Long, Pipeline> containerLocations) {
        for (OmKeyLocationInfoGroup key : keyInfo.getKeyLocationVersions()) {
            for (List omKeyLocationInfoList : key.getLocationLists()) {
                for (OmKeyLocationInfo omKeyLocationInfo : omKeyLocationInfoList) {
                    Pipeline pipeline = containerLocations.get(omKeyLocationInfo.getContainerID());
                    if (pipeline == null || pipeline.equals((Object)omKeyLocationInfo.getPipeline())) continue;
                    omKeyLocationInfo.setPipeline(pipeline);
                }
            }
        }
    }

    @Nonnull
    private Stream<Long> extractContainerIDs(OmKeyInfo keyInfo) {
        return keyInfo.getKeyLocationVersions().stream().flatMap(v -> v.getLocationList().stream()).map(BlockLocationInfo::getContainerID);
    }
}

