/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.core;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.olingo.odata2.api.ODataDebugResponseWrapperCallback;
import org.apache.olingo.odata2.api.ODataService;
import org.apache.olingo.odata2.api.ODataServiceFactory;
import org.apache.olingo.odata2.api.ODataServiceVersion;
import org.apache.olingo.odata2.api.commons.HttpStatusCodes;
import org.apache.olingo.odata2.api.commons.ODataHttpMethod;
import org.apache.olingo.odata2.api.edm.EdmConcurrencyMode;
import org.apache.olingo.odata2.api.edm.EdmEntityType;
import org.apache.olingo.odata2.api.edm.EdmException;
import org.apache.olingo.odata2.api.edm.EdmFacets;
import org.apache.olingo.odata2.api.edm.EdmProperty;
import org.apache.olingo.odata2.api.edm.EdmSimpleTypeKind;
import org.apache.olingo.odata2.api.exception.ODataBadRequestException;
import org.apache.olingo.odata2.api.exception.ODataException;
import org.apache.olingo.odata2.api.exception.ODataMethodNotAllowedException;
import org.apache.olingo.odata2.api.exception.ODataPreconditionRequiredException;
import org.apache.olingo.odata2.api.exception.ODataUnsupportedMediaTypeException;
import org.apache.olingo.odata2.api.processor.ODataContext;
import org.apache.olingo.odata2.api.processor.ODataProcessor;
import org.apache.olingo.odata2.api.processor.ODataRequest;
import org.apache.olingo.odata2.api.processor.ODataResponse;
import org.apache.olingo.odata2.api.processor.part.EntityLinkProcessor;
import org.apache.olingo.odata2.api.processor.part.EntityLinksProcessor;
import org.apache.olingo.odata2.api.processor.part.EntityMediaProcessor;
import org.apache.olingo.odata2.api.processor.part.EntityProcessor;
import org.apache.olingo.odata2.api.processor.part.EntitySetProcessor;
import org.apache.olingo.odata2.api.processor.part.EntitySimplePropertyValueProcessor;
import org.apache.olingo.odata2.api.processor.part.FunctionImportProcessor;
import org.apache.olingo.odata2.api.processor.part.FunctionImportValueProcessor;
import org.apache.olingo.odata2.api.uri.UriInfo;
import org.apache.olingo.odata2.core.ContentNegotiator;
import org.apache.olingo.odata2.core.Dispatcher;
import org.apache.olingo.odata2.core.commons.ContentType;
import org.apache.olingo.odata2.core.debug.ODataDebugResponseWrapper;
import org.apache.olingo.odata2.core.exception.ODataRuntimeException;
import org.apache.olingo.odata2.core.rest.ODataExceptionWrapper;
import org.apache.olingo.odata2.core.uri.UriInfoImpl;
import org.apache.olingo.odata2.core.uri.UriParserImpl;
import org.apache.olingo.odata2.core.uri.UriType;

public class ODataRequestHandler {
    private final ODataServiceFactory serviceFactory;
    private final ODataService service;
    private final ODataContext context;

    public ODataRequestHandler(ODataServiceFactory factory, ODataService service, ODataContext context) {
        this.serviceFactory = factory;
        this.service = service;
        this.context = context;
    }

    public ODataResponse handle(ODataRequest request) {
        ODataResponse odataResponse;
        UriInfoImpl uriInfo = null;
        Exception exception = null;
        int timingHandle = this.context.startRuntimeMeasurement("ODataRequestHandler", "handle");
        try {
            UriParserImpl uriParser = new UriParserImpl(this.service.getEntityDataModel());
            Dispatcher dispatcher = new Dispatcher(this.serviceFactory, this.service);
            String serverDataServiceVersion = this.getServerDataServiceVersion();
            String requestDataServiceVersion = this.context.getRequestHeader("DataServiceVersion");
            ODataRequestHandler.validateDataServiceVersion(serverDataServiceVersion, requestDataServiceVersion);
            List pathSegments = this.context.getPathInfo().getODataSegments();
            int timingHandle2 = this.context.startRuntimeMeasurement("UriParserImpl", "parse");
            uriInfo = (UriInfoImpl)uriParser.parseAll(pathSegments, request.getAllQueryParameters());
            this.context.stopRuntimeMeasurement(timingHandle2);
            ODataHttpMethod method = request.getMethod();
            ODataRequestHandler.validateMethodAndUri(method, uriInfo);
            if (method == ODataHttpMethod.POST || method == ODataHttpMethod.PUT || method == ODataHttpMethod.PATCH || method == ODataHttpMethod.MERGE) {
                this.checkRequestContentType(uriInfo, request.getContentType());
            }
            List<String> supportedContentTypes = this.getSupportedContentTypes(uriInfo, method);
            ContentType acceptContentType = new ContentNegotiator().doContentNegotiation(request, uriInfo, supportedContentTypes);
            ODataRequestHandler.checkConditions(method, uriInfo, this.context.getRequestHeader("If-Match"), this.context.getRequestHeader("If-None-Match"), this.context.getRequestHeader("If-Modified-Since"), this.context.getRequestHeader("If-Unmodified-Since"));
            timingHandle2 = this.context.startRuntimeMeasurement("Dispatcher", "dispatch");
            odataResponse = dispatcher.dispatch(method, uriInfo, request.getBody(), request.getContentType(), acceptContentType.toContentTypeString());
            this.context.stopRuntimeMeasurement(timingHandle2);
            ODataResponse.ODataResponseBuilder extendedResponse = ODataResponse.fromResponse((ODataResponse)odataResponse);
            UriType uriType = uriInfo.getUriType();
            String location = method == ODataHttpMethod.POST && (uriType == UriType.URI1 || uriType == UriType.URI6B) ? odataResponse.getIdLiteral() : null;
            HttpStatusCodes s = this.getStatusCode(odataResponse, method, uriType);
            extendedResponse = extendedResponse.idLiteral(location).status(s);
            if (!odataResponse.containsHeader("DataServiceVersion")) {
                extendedResponse = extendedResponse.header("DataServiceVersion", serverDataServiceVersion);
            }
            if (!HttpStatusCodes.NO_CONTENT.equals((Object)s) && !odataResponse.containsHeader("Content-Type")) {
                extendedResponse.header("Content-Type", acceptContentType.toContentTypeString());
            }
            odataResponse = extendedResponse.build();
        }
        catch (Exception e) {
            exception = e;
            odataResponse = new ODataExceptionWrapper(this.context, request.getQueryParameters(), request.getAcceptHeaders()).wrapInExceptionResponse(e);
        }
        this.context.stopRuntimeMeasurement(timingHandle);
        if (this.context.isInDebugMode()) {
            String debugValue = ODataRequestHandler.getQueryDebugValue(request.getQueryParameters());
            if (debugValue == null) {
                ODataDebugResponseWrapperCallback callback = (ODataDebugResponseWrapperCallback)this.context.getServiceFactory().getCallback(ODataDebugResponseWrapperCallback.class);
                return callback == null ? odataResponse : callback.handle(this.context, request, odataResponse, (UriInfo)uriInfo, exception);
            }
            return new ODataDebugResponseWrapper(this.context, odataResponse, uriInfo, exception, debugValue).wrapResponse();
        }
        return odataResponse;
    }

    private HttpStatusCodes getStatusCode(ODataResponse odataResponse, ODataHttpMethod method, UriType uriType) {
        if (odataResponse.getStatus() == null) {
            if (method == ODataHttpMethod.POST) {
                if (uriType == UriType.URI9) {
                    return HttpStatusCodes.OK;
                }
                if (uriType == UriType.URI7B) {
                    return HttpStatusCodes.NO_CONTENT;
                }
                return HttpStatusCodes.CREATED;
            }
            if (method == ODataHttpMethod.PUT || method == ODataHttpMethod.PATCH || method == ODataHttpMethod.MERGE || method == ODataHttpMethod.DELETE) {
                return HttpStatusCodes.NO_CONTENT;
            }
            return HttpStatusCodes.OK;
        }
        return odataResponse.getStatus();
    }

    private String getServerDataServiceVersion() throws ODataException {
        return this.service.getVersion() == null ? "2.0" : this.service.getVersion();
    }

    private static void validateDataServiceVersion(String serverDataServiceVersion, String requestDataServiceVersion) throws ODataException {
        if (requestDataServiceVersion != null) {
            try {
                boolean isValid = ODataServiceVersion.validateDataServiceVersion((String)requestDataServiceVersion);
                if (!isValid || ODataServiceVersion.isBiggerThan((String)requestDataServiceVersion, (String)serverDataServiceVersion)) {
                    throw new ODataBadRequestException(ODataBadRequestException.VERSIONERROR.addContent(new Object[]{requestDataServiceVersion}));
                }
            }
            catch (IllegalArgumentException e) {
                throw new ODataBadRequestException(ODataBadRequestException.PARSEVERSIONERROR.addContent(new Object[]{requestDataServiceVersion}), (Throwable)e);
            }
        }
    }

    private static void validateMethodAndUri(ODataHttpMethod method, UriInfoImpl uriInfo) throws ODataException {
        ODataRequestHandler.validateUriMethod(method, uriInfo);
        ODataRequestHandler.checkFunctionImport(method, uriInfo);
        if (method != ODataHttpMethod.GET) {
            ODataRequestHandler.checkNotGetSystemQueryOptions(method, uriInfo);
            ODataRequestHandler.checkNumberOfNavigationSegments(uriInfo);
            ODataRequestHandler.checkProperty(method, uriInfo);
        }
    }

    private static void validateUriMethod(ODataHttpMethod method, UriInfoImpl uriInfo) throws ODataException {
        switch (uriInfo.getUriType()) {
            case URI0: 
            case URI8: 
            case URI15: 
            case URI16: 
            case URI50A: 
            case URI50B: {
                if (method == ODataHttpMethod.GET) break;
                throw new ODataMethodNotAllowedException(ODataMethodNotAllowedException.DISPATCH);
            }
            case URI1: 
            case URI6B: 
            case URI7B: {
                if (method == ODataHttpMethod.GET || method == ODataHttpMethod.POST) break;
                throw new ODataMethodNotAllowedException(ODataMethodNotAllowedException.DISPATCH);
            }
            case URI2: 
            case URI6A: 
            case URI7A: {
                if (method == ODataHttpMethod.GET || method == ODataHttpMethod.PUT || method == ODataHttpMethod.DELETE || method == ODataHttpMethod.PATCH || method == ODataHttpMethod.MERGE) break;
                throw new ODataMethodNotAllowedException(ODataMethodNotAllowedException.DISPATCH);
            }
            case URI3: {
                if (method == ODataHttpMethod.GET || method == ODataHttpMethod.PUT || method == ODataHttpMethod.PATCH || method == ODataHttpMethod.MERGE) break;
                throw new ODataMethodNotAllowedException(ODataMethodNotAllowedException.DISPATCH);
            }
            case URI4: 
            case URI5: {
                if (method != ODataHttpMethod.GET && method != ODataHttpMethod.PUT && method != ODataHttpMethod.DELETE && method != ODataHttpMethod.PATCH && method != ODataHttpMethod.MERGE) {
                    throw new ODataMethodNotAllowedException(ODataMethodNotAllowedException.DISPATCH);
                }
                if (method != ODataHttpMethod.DELETE || uriInfo.isValue()) break;
                throw new ODataMethodNotAllowedException(ODataMethodNotAllowedException.DISPATCH);
            }
            case URI9: {
                if (method == ODataHttpMethod.POST) break;
                throw new ODataMethodNotAllowedException(ODataMethodNotAllowedException.DISPATCH);
            }
            case URI10: 
            case URI10a: 
            case URI11: 
            case URI12: 
            case URI13: 
            case URI14: {
                break;
            }
            case URI17: {
                if (method != ODataHttpMethod.GET && method != ODataHttpMethod.PUT && method != ODataHttpMethod.DELETE) {
                    throw new ODataMethodNotAllowedException(ODataMethodNotAllowedException.DISPATCH);
                }
                if (uriInfo.getFormat() == null) break;
                throw new ODataBadRequestException(ODataBadRequestException.INVALID_SYNTAX);
            }
            default: {
                throw new ODataRuntimeException("Unknown or not implemented URI type: " + uriInfo.getUriType());
            }
        }
    }

    private static void checkFunctionImport(ODataHttpMethod method, UriInfoImpl uriInfo) throws ODataException {
        if (uriInfo.getFunctionImport() != null && uriInfo.getFunctionImport().getHttpMethod() != null && !uriInfo.getFunctionImport().getHttpMethod().equals(method.toString())) {
            throw new ODataMethodNotAllowedException(ODataMethodNotAllowedException.DISPATCH);
        }
    }

    private static void checkNotGetSystemQueryOptions(ODataHttpMethod method, UriInfoImpl uriInfo) throws ODataException {
        switch (uriInfo.getUriType()) {
            case URI1: 
            case URI6B: {
                if (uriInfo.getFormat() == null && uriInfo.getFilter() == null && uriInfo.getInlineCount() == null && uriInfo.getOrderBy() == null && uriInfo.getSkipToken() == null && uriInfo.getSkip() == null && uriInfo.getTop() == null && uriInfo.getExpand().isEmpty() && uriInfo.getSelect().isEmpty()) break;
                throw new ODataMethodNotAllowedException(ODataMethodNotAllowedException.DISPATCH);
            }
            case URI2: {
                if (uriInfo.getFormat() != null || !uriInfo.getExpand().isEmpty() || !uriInfo.getSelect().isEmpty()) {
                    throw new ODataMethodNotAllowedException(ODataMethodNotAllowedException.DISPATCH);
                }
                if (method != ODataHttpMethod.DELETE || uriInfo.getFilter() == null) break;
                throw new ODataMethodNotAllowedException(ODataMethodNotAllowedException.DISPATCH);
            }
            case URI3: {
                if (uriInfo.getFormat() == null) break;
                throw new ODataMethodNotAllowedException(ODataMethodNotAllowedException.DISPATCH);
            }
            case URI4: 
            case URI5: {
                if (method != ODataHttpMethod.PUT && method != ODataHttpMethod.PATCH && method != ODataHttpMethod.MERGE || uriInfo.isValue() || uriInfo.getFormat() == null) break;
                throw new ODataMethodNotAllowedException(ODataMethodNotAllowedException.DISPATCH);
            }
            case URI7A: {
                if (uriInfo.getFormat() == null && uriInfo.getFilter() == null) break;
                throw new ODataMethodNotAllowedException(ODataMethodNotAllowedException.DISPATCH);
            }
            case URI7B: {
                if (uriInfo.getFormat() == null && uriInfo.getFilter() == null && uriInfo.getInlineCount() == null && uriInfo.getOrderBy() == null && uriInfo.getSkipToken() == null && uriInfo.getSkip() == null && uriInfo.getTop() == null) break;
                throw new ODataMethodNotAllowedException(ODataMethodNotAllowedException.DISPATCH);
            }
            case URI17: {
                if (uriInfo.getFormat() == null && uriInfo.getFilter() == null) break;
                throw new ODataMethodNotAllowedException(ODataMethodNotAllowedException.DISPATCH);
            }
        }
    }

    private static void checkNumberOfNavigationSegments(UriInfoImpl uriInfo) throws ODataException {
        switch (uriInfo.getUriType()) {
            case URI1: 
            case URI6B: 
            case URI7B: 
            case URI7A: {
                if (uriInfo.getNavigationSegments().size() <= 1) break;
                throw new ODataBadRequestException(ODataBadRequestException.NOTSUPPORTED);
            }
            case URI3: 
            case URI4: 
            case URI5: 
            case URI17: {
                if (uriInfo.getNavigationSegments().isEmpty()) break;
                throw new ODataBadRequestException(ODataBadRequestException.NOTSUPPORTED);
            }
        }
    }

    private static void checkProperty(ODataHttpMethod method, UriInfoImpl uriInfo) throws ODataException {
        if ((uriInfo.getUriType() == UriType.URI4 || uriInfo.getUriType() == UriType.URI5) && (ODataRequestHandler.isPropertyKey(uriInfo) || method == ODataHttpMethod.DELETE && !ODataRequestHandler.isPropertyNullable(ODataRequestHandler.getProperty(uriInfo)))) {
            throw new ODataMethodNotAllowedException(ODataMethodNotAllowedException.DISPATCH);
        }
    }

    private static EdmProperty getProperty(UriInfo uriInfo) {
        List propertyPath = uriInfo.getPropertyPath();
        return propertyPath == null || propertyPath.isEmpty() ? null : (EdmProperty)propertyPath.get(propertyPath.size() - 1);
    }

    private static boolean isPropertyKey(UriInfo uriInfo) throws EdmException {
        return uriInfo.getTargetEntitySet().getEntityType().getKeyProperties().contains(ODataRequestHandler.getProperty(uriInfo));
    }

    private static boolean isPropertyNullable(EdmProperty property) throws EdmException {
        return property != null && (property.getFacets() == null || property.getFacets().isNullable() != false);
    }

    private void checkRequestContentType(UriInfoImpl uriInfo, String contentType) throws ODataException {
        List<ContentType> supportedContentTypes;
        Class<? extends ODataProcessor> processorFeature = Dispatcher.mapUriTypeToProcessorFeature(uriInfo);
        if (processorFeature == FunctionImportProcessor.class || processorFeature == FunctionImportValueProcessor.class) {
            return;
        }
        if (processorFeature == EntitySetProcessor.class) {
            processorFeature = uriInfo.getTargetEntitySet().getEntityType().hasStream() ? EntityMediaProcessor.class : EntityProcessor.class;
        } else if (processorFeature == EntityLinksProcessor.class) {
            processorFeature = EntityLinkProcessor.class;
        }
        ContentType parsedContentType = ContentType.parse(contentType);
        if (parsedContentType == null || parsedContentType.hasWildcard()) {
            throw new ODataUnsupportedMediaTypeException(ODataUnsupportedMediaTypeException.NOT_SUPPORTED.addContent(new Object[]{parsedContentType}));
        }
        List<ContentType> list = supportedContentTypes = processorFeature == EntitySimplePropertyValueProcessor.class ? ODataRequestHandler.getSupportedContentTypes(ODataRequestHandler.getProperty(uriInfo)) : this.getSupportedContentTypes(processorFeature);
        if (!ODataRequestHandler.hasMatchingContentType(parsedContentType, supportedContentTypes)) {
            throw new ODataUnsupportedMediaTypeException(ODataUnsupportedMediaTypeException.NOT_SUPPORTED.addContent(new Object[]{parsedContentType}));
        }
    }

    private static boolean hasMatchingContentType(ContentType contentType, List<ContentType> allowedContentTypes) {
        ContentType requested = contentType.receiveWithCharsetParameter("utf-8");
        if (requested.getODataFormat() == ContentType.ODataFormat.CUSTOM || requested.getODataFormat() == ContentType.ODataFormat.MIME) {
            return requested.hasCompatible(allowedContentTypes);
        }
        return requested.hasMatch(allowedContentTypes);
    }

    private static List<ContentType> getSupportedContentTypes(EdmProperty property) throws EdmException {
        if (property != null) {
            return property.getType() == EdmSimpleTypeKind.Binary.getEdmSimpleTypeInstance() ? Collections.singletonList(property.getMimeType() == null ? ContentType.WILDCARD : ContentType.create(property.getMimeType())) : Arrays.asList(ContentType.TEXT_PLAIN, ContentType.TEXT_PLAIN_CS_UTF_8);
        }
        return null;
    }

    private List<String> getSupportedContentTypes(UriInfoImpl uriInfo, ODataHttpMethod method) throws ODataException {
        Class<? extends ODataProcessor> processorFeature = Dispatcher.mapUriTypeToProcessorFeature(uriInfo);
        UriType uriType = uriInfo.getUriType();
        if (uriType == UriType.URI11) {
            processorFeature = EntitySetProcessor.class;
        } else if (uriType == UriType.URI10) {
            processorFeature = EntityProcessor.class;
        } else if (ODataHttpMethod.POST.equals((Object)method) && (uriType == UriType.URI1 || uriType == UriType.URI6B)) {
            processorFeature = EntityProcessor.class;
        }
        return this.service.getSupportedContentTypes(processorFeature);
    }

    private List<ContentType> getSupportedContentTypes(Class<? extends ODataProcessor> processorFeature) throws ODataException {
        return ContentType.createAsCustom(this.service.getSupportedContentTypes(processorFeature));
    }

    private static void checkConditions(ODataHttpMethod method, UriInfoImpl uriInfo, String ifMatch, String ifNoneMatch, String ifModifiedSince, String ifUnmodifiedSince) throws ODataException {
        if ((method == ODataHttpMethod.PUT || method == ODataHttpMethod.PATCH || method == ODataHttpMethod.MERGE || method == ODataHttpMethod.DELETE) && ifMatch == null && ifNoneMatch == null && ifModifiedSince == null && ifUnmodifiedSince == null && ODataRequestHandler.checkUriType(uriInfo.getUriType()) && ODataRequestHandler.hasConcurrencyControl(uriInfo.getTargetEntitySet().getEntityType())) {
            throw new ODataPreconditionRequiredException(ODataPreconditionRequiredException.COMMON);
        }
    }

    private static boolean checkUriType(UriType uriType) {
        return uriType == UriType.URI2 || uriType == UriType.URI6A || uriType == UriType.URI3 || uriType == UriType.URI4 || uriType == UriType.URI5 || uriType == UriType.URI17;
    }

    private static boolean hasConcurrencyControl(EdmEntityType entityType) throws EdmException {
        boolean concurrency = false;
        for (String propertyName : entityType.getPropertyNames()) {
            EdmFacets facets = ((EdmProperty)entityType.getProperty(propertyName)).getFacets();
            if (facets == null || facets.getConcurrencyMode() == null || facets.getConcurrencyMode() != EdmConcurrencyMode.Fixed) continue;
            concurrency = true;
            break;
        }
        return concurrency;
    }

    private static String getQueryDebugValue(Map<String, String> queryParameters) {
        String debugValue = queryParameters.get("odata-debug");
        return "json".equals(debugValue) || "html".equals(debugValue) || "download".equals(debugValue) ? debugValue : null;
    }
}

