/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.scheduling.support;

import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.TimeZone;
import org.jspecify.annotations.Nullable;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.TriggerContext;
import org.springframework.scheduling.support.CronExpression;
import org.springframework.util.Assert;

public class CronTrigger
implements Trigger {
    private final CronExpression expression;
    private final @Nullable ZoneId zoneId;

    public CronTrigger(String expression) {
        this.expression = CronExpression.parse(expression);
        this.zoneId = null;
    }

    public CronTrigger(String expression, TimeZone timeZone) {
        this.expression = CronExpression.parse(expression);
        Assert.notNull((Object)timeZone, (String)"TimeZone must not be null");
        this.zoneId = timeZone.toZoneId();
    }

    public CronTrigger(String expression, ZoneId zoneId) {
        this.expression = CronExpression.parse(expression);
        Assert.notNull((Object)zoneId, (String)"ZoneId must not be null");
        this.zoneId = zoneId;
    }

    public String getExpression() {
        return this.expression.toString();
    }

    @Override
    public @Nullable Instant nextExecution(TriggerContext triggerContext) {
        Instant timestamp = this.determineLatestTimestamp(triggerContext);
        ZoneId zone = this.zoneId != null ? this.zoneId : triggerContext.getClock().getZone();
        ZonedDateTime zonedTimestamp = timestamp.atZone(zone);
        ZonedDateTime nextTimestamp = this.expression.next(zonedTimestamp);
        return nextTimestamp != null ? nextTimestamp.toInstant() : null;
    }

    Instant determineLatestTimestamp(TriggerContext triggerContext) {
        Instant timestamp = triggerContext.lastCompletion();
        if (timestamp != null) {
            Instant scheduled = triggerContext.lastScheduledExecution();
            if (scheduled != null && timestamp.isBefore(scheduled)) {
                timestamp = scheduled;
            }
        } else {
            timestamp = this.determineInitialTimestamp(triggerContext);
        }
        return timestamp;
    }

    Instant determineInitialTimestamp(TriggerContext triggerContext) {
        return triggerContext.getClock().instant();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(@Nullable Object other) {
        if (this == other) return true;
        if (!(other instanceof CronTrigger)) return false;
        CronTrigger that = (CronTrigger)other;
        if (!this.expression.equals(that.expression)) return false;
        return true;
    }

    public int hashCode() {
        return this.expression.hashCode();
    }

    public String toString() {
        return this.expression.toString();
    }

    public static CronTrigger forLenientExecution(String expression) {
        return new CronTrigger(expression);
    }

    public static CronTrigger resumeLenientExecution(String expression, final Instant resumptionTimestamp) {
        return new CronTrigger(expression){

            @Override
            Instant determineInitialTimestamp(TriggerContext triggerContext) {
                return resumptionTimestamp;
            }
        };
    }

    public static CronTrigger forFixedExecution(String expression) {
        return new CronTrigger(expression){

            @Override
            protected Instant determineLatestTimestamp(TriggerContext triggerContext) {
                Instant scheduled = triggerContext.lastScheduledExecution();
                return scheduled != null ? scheduled : super.determineInitialTimestamp(triggerContext);
            }
        };
    }

    public static CronTrigger resumeFixedExecution(String expression, final Instant resumptionTimestamp) {
        return new CronTrigger(expression){

            @Override
            protected Instant determineLatestTimestamp(TriggerContext triggerContext) {
                Instant scheduled = triggerContext.lastScheduledExecution();
                return scheduled != null ? scheduled : super.determineLatestTimestamp(triggerContext);
            }

            @Override
            Instant determineInitialTimestamp(TriggerContext triggerContext) {
                return resumptionTimestamp;
            }
        };
    }
}

