/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.security.ssl;

import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.util.List;
import java.util.Objects;
import org.apache.nifi.security.ssl.BuilderConfigurationException;
import org.apache.nifi.security.ssl.KeyStoreBuilder;
import org.apache.nifi.security.ssl.StandardPemCertificateReader;
import org.apache.nifi.security.ssl.StandardPemPrivateKeyReader;

public class PemPrivateKeyCertificateKeyStoreBuilder
implements KeyStoreBuilder {
    private static final String ALIAS = "private-key-1";
    private static final char[] EMPTY_PROTECTION_PARAMETER = new char[0];
    private InputStream privateKeyInputStream;
    private InputStream certificateInputStream;

    @Override
    public KeyStore build() {
        KeyStore keyStore = this.getInitializedKeyStore();
        if (this.certificateInputStream == null) {
            throw new BuilderConfigurationException("Certificate InputStream not configured");
        }
        if (this.privateKeyInputStream == null) {
            throw new BuilderConfigurationException("Private Key InputStream not configured");
        }
        this.loadKeyStore(keyStore);
        return keyStore;
    }

    public PemPrivateKeyCertificateKeyStoreBuilder certificateInputStream(InputStream certificateInputStream) {
        this.certificateInputStream = Objects.requireNonNull(certificateInputStream, "Certificate InputStream required");
        return this;
    }

    public PemPrivateKeyCertificateKeyStoreBuilder privateKeyInputStream(InputStream privateKeyInputStream) {
        this.privateKeyInputStream = Objects.requireNonNull(privateKeyInputStream, "Private Key InputStream required");
        return this;
    }

    private void loadKeyStore(KeyStore keyStore) {
        StandardPemCertificateReader pemCertificateReader = new StandardPemCertificateReader();
        List<Certificate> certificates = pemCertificateReader.readCertificates(this.certificateInputStream);
        Certificate[] certificateChain = certificates.toArray(new Certificate[0]);
        StandardPemPrivateKeyReader pemPrivateKeyReader = new StandardPemPrivateKeyReader();
        PrivateKey privateKey = pemPrivateKeyReader.readPrivateKey(this.privateKeyInputStream);
        try {
            keyStore.setKeyEntry(ALIAS, privateKey, EMPTY_PROTECTION_PARAMETER, certificateChain);
        }
        catch (KeyStoreException e) {
            throw new BuilderConfigurationException("Set key entry failed", e);
        }
    }

    private KeyStore getInitializedKeyStore() {
        String keyStoreType = KeyStore.getDefaultType();
        try {
            KeyStore keyStore = KeyStore.getInstance(keyStoreType);
            keyStore.load(null);
            return keyStore;
        }
        catch (Exception e) {
            String message = String.format("Key Store Type [%s] initialization failed", keyStoreType);
            throw new BuilderConfigurationException(message, e);
        }
    }
}

