/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.result.nifi;

import java.io.IOException;
import java.io.PrintStream;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.apache.nifi.toolkit.cli.api.ResultType;
import org.apache.nifi.toolkit.cli.impl.result.AbstractWritableResult;
import org.apache.nifi.toolkit.cli.impl.result.writer.DynamicTableWriter;
import org.apache.nifi.toolkit.cli.impl.result.writer.Table;
import org.apache.nifi.web.api.dto.AssetDTO;
import org.apache.nifi.web.api.entity.AssetEntity;
import org.apache.nifi.web.api.entity.AssetsEntity;

public class AssetsResult
extends AbstractWritableResult<AssetsEntity> {
    private final AssetsEntity assetsEntity;

    public AssetsResult(ResultType resultType, AssetsEntity assetsEntity) {
        super(resultType);
        this.assetsEntity = Objects.requireNonNull(assetsEntity);
    }

    @Override
    public AssetsEntity getResult() {
        return this.assetsEntity;
    }

    @Override
    protected void writeSimpleResult(PrintStream output) throws IOException {
        Collection assetEntities = this.assetsEntity.getAssets();
        if (assetEntities == null) {
            return;
        }
        List<AssetDTO> assetDTOS = assetEntities.stream().map(AssetEntity::getAsset).sorted(Comparator.comparing(AssetDTO::getName)).toList();
        Table table = new Table.Builder().column("#", 3, 3, false).column("ID", 36, 36, false).column("Name", 5, 40, false).build();
        for (int i = 0; i < assetDTOS.size(); ++i) {
            AssetDTO assetDTO = assetDTOS.get(i);
            table.addRow(String.valueOf(i + 1), assetDTO.getId(), assetDTO.getName());
        }
        DynamicTableWriter tableWriter = new DynamicTableWriter();
        tableWriter.write(table, output);
    }
}

