/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.components.listen;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.nifi.components.listen.ListenPortDefinition;
import org.apache.nifi.components.listen.TransportProtocol;

public class StandardListenPortDefinition
implements ListenPortDefinition {
    private final TransportProtocol transportProtocol;
    private final List<String> applicationProtocols;

    public StandardListenPortDefinition(TransportProtocol transportProtocol, List<String> applicationProtocols) {
        Objects.requireNonNull(transportProtocol, "Transport protocol is required.");
        Objects.requireNonNull(applicationProtocols, "Application protocols or empty list is required.");
        this.transportProtocol = transportProtocol;
        this.applicationProtocols = applicationProtocols;
    }

    public StandardListenPortDefinition(TransportProtocol transportProtocol) {
        this(transportProtocol, Collections.emptyList());
    }

    @Override
    public TransportProtocol getTransportProtocol() {
        return this.transportProtocol;
    }

    @Override
    public List<String> getApplicationProtocols() {
        return this.applicationProtocols;
    }

    public String toString() {
        return "StandardListenPortDefinition[transportProtocol=%s, applicationProtocols=%s]".formatted(new Object[]{this.transportProtocol, this.applicationProtocols});
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StandardListenPortDefinition that = (StandardListenPortDefinition)o;
        return this.transportProtocol == that.transportProtocol && Objects.equals(this.applicationProtocols, that.applicationProtocols);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.transportProtocol, this.applicationProtocols});
    }
}

