/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.bucket;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import java.util.Objects;
import org.apache.nifi.registry.authorization.Permissions;
import org.apache.nifi.registry.bucket.BucketItemType;
import org.apache.nifi.registry.link.LinkableEntity;

public abstract class BucketItem
extends LinkableEntity {
    @NotBlank
    private String identifier;
    @NotBlank
    private String name;
    private String description;
    @NotBlank
    private String bucketIdentifier;
    private String bucketName;
    @Min(value=1L)
    private @Min(value=1L) long createdTimestamp;
    @Min(value=1L)
    private @Min(value=1L) long modifiedTimestamp;
    @NotNull
    private final BucketItemType type;
    private Permissions permissions;

    public BucketItem(BucketItemType type) {
        this.type = type;
    }

    @Schema(description="An ID to uniquely identify this object.", accessMode=Schema.AccessMode.READ_ONLY)
    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    @Schema(description="The name of the item.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Schema(description="A description of the item.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Schema(description="The identifier of the bucket this items belongs to. This cannot be changed after the item is created.")
    public String getBucketIdentifier() {
        return this.bucketIdentifier;
    }

    public void setBucketIdentifier(String bucketIdentifier) {
        this.bucketIdentifier = bucketIdentifier;
    }

    @Schema(description="The name of the bucket this items belongs to.", accessMode=Schema.AccessMode.READ_ONLY)
    public String getBucketName() {
        return this.bucketName;
    }

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    @Schema(description="The timestamp of when the item was created, as milliseconds since epoch.", accessMode=Schema.AccessMode.READ_ONLY)
    public long getCreatedTimestamp() {
        return this.createdTimestamp;
    }

    public void setCreatedTimestamp(long createdTimestamp) {
        this.createdTimestamp = createdTimestamp;
    }

    @Schema(description="The timestamp of when the item was last modified, as milliseconds since epoch.", accessMode=Schema.AccessMode.READ_ONLY)
    public long getModifiedTimestamp() {
        return this.modifiedTimestamp;
    }

    public void setModifiedTimestamp(long modifiedTimestamp) {
        this.modifiedTimestamp = modifiedTimestamp;
    }

    @Schema(description="The type of item.")
    public BucketItemType getType() {
        return this.type;
    }

    @Schema(description="The access that the current user has to the bucket containing this item.", accessMode=Schema.AccessMode.READ_ONLY)
    public Permissions getPermissions() {
        return this.permissions;
    }

    public void setPermissions(Permissions permissions) {
        this.permissions = permissions;
    }

    public int hashCode() {
        return Objects.hashCode(this.getIdentifier());
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BucketItem other = (BucketItem)obj;
        return Objects.equals(this.getIdentifier(), other.getIdentifier());
    }
}

